//+------------------------------------------------------------------+
//|                                          Arrows and Curves EA.mq4 |
//|                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006"
#property link      "kolas@list.ru"

//    H4 EURUSD
extern double TrailingStop = 30;
extern double TakeProfit   = 30;
extern double StopLoss     = 80;

//     
extern int SSP             = 6;     //   
extern int RISK            = 12;
extern int CountBars       = 50;    //  (  )
extern double SkyCh        = 23.6;

//  MM
extern double Slippage     = 3;
extern bool PropotinalLots = false; // 
extern double MinDepo      = 100;   //  
extern double FixedLots    = 0.1;   //   
extern double PercentLots  = 10;    //  

//  
extern string NameEA       = "Arrows and Curves";
extern int MAGICNUM        = 123;

double Lots;
double Sloss, Tprof;
bool Buy = false, Sell = false;
static int PrevBar = 0;

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init() 
  {return(0);}
  
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit() 
  {return(0);}
  
//+------------------------------------------------------------------+
//|                                |
//+------------------------------------------------------------------+
void Indicators() 
   {                  
      Buy = (iCustom(Symbol(),0,"lukas1   ", SSP, RISK, CountBars, SkyCh, 0, 1) > 0) && (Time[0] != PrevBar);
      Sell = (iCustom(Symbol(),0,"lukas1   ", SSP, RISK, CountBars, SkyCh, 1, 1) > 0) && (Time[0] != PrevBar);
   }
   
//+------------------------------------------------------------------+
//|                               |
//+------------------------------------------------------------------+
void prtAlert(string str = "") 
  {
      Print(str);
      Alert(str);
  }
  
//+------------------------------------------------------------------+
//|                                               |
//+------------------------------------------------------------------+
void LotsSize()
   {
      Lots = FixedLots;
      if (PropotinalLots) Lots = MathCeil(AccountFreeMargin() / 10000 * PercentLots) / 10;
      if (Lots > 10000) Lots = 10000;
   }  
  
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start() 
  {
   //  
   if(Bars < SSP) 
     {
       Print("Not enough bars for this strategy - ", NameEA);
       return(-1);
     }
   //   
   Indicators();
   
   //    
   LotsSize();   

   //   
   int totalOrders = OrdersTotal();
   int numPos = 0;

   for(int i = 0; i < totalOrders; i++) 
     {
       OrderSelect(i, SELECT_BY_POS);    
       if(OrderSymbol() == Symbol() && OrderMagicNumber() == MAGICNUM) 
         {
           numPos++;
           //  
           if(OrderType() == OP_BUY) 
             {
               //   
               if (Sell) 
               {
                  OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), Slippage, Blue); 
                  numPos--;
               }
               else
               //  
               if(TrailingStop > 0) 
                 {
                   if(Bid - OrderOpenPrice() > TrailingStop*Point) 
                     {
                       if(OrderStopLoss() < (Bid - TrailingStop*Point))
                           OrderModify(OrderTicket(), OrderOpenPrice(), 
                                       Bid - TrailingStop*Point, OrderTakeProfit(), 0, Blue);
                     }
                 }
               
             } 
           else 
             //  
             {
               //   
               if (Buy) 
               {
                  OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), Slippage, Red);
                  numPos--;
               }
               else
               //  
               if(TrailingStop > 0) 
                 {
                   if(OrderOpenPrice() - Ask > TrailingStop*Point)
                     {
                       if(OrderStopLoss() == 0 || OrderStopLoss() > Ask + TrailingStop*Point)
                           OrderModify(OrderTicket(), OrderOpenPrice(), 
                                       Ask + TrailingStop*Point, OrderTakeProfit(), 0, Red);
                     }           
                 }
             }
         }
     }
     
   //   
   if(numPos < 1)
     {   
       //    
       if(AccountFreeMargin() < MinDepo)
         {
           Print("Not enough money to trade ", Lots, " lots. Strategy:", NameEA);
           return(0);
         }
       //     
       if (Buy)
         {
           Sloss = Ask - StopLoss * Point;
           Tprof = Bid + TakeProfit * Point;
           PrevBar = Time[0];
            OrderSend(Symbol(), OP_BUY, Lots, Ask, Slippage, Sloss, Tprof, NameEA + CurTime(), 
                     MAGICNUM, 0, Green);
           prtAlert("Buying"); 
         }
       //     
       if (Sell) 
         {
           Sloss = Bid + StopLoss * Point;
           Tprof = Ask - TakeProfit * Point;
           PrevBar = Time[0];
            OrderSend(Symbol(), OP_SELL, Lots, Bid, Slippage, Sloss, Tprof, NameEA + CurTime(), 
                     MAGICNUM, 0, Red);
           prtAlert("Selling"); 
         }
     } 

   return(0);
  }