//+------------------------------------------------------------------+
//|                                              Begin_Trend_v02.mq4 |
//+------------------------------------------------------------------+
#property copyright "Inkov Evgeni ew123@mail.ru"
#property link      "+7-988-140-68-11"
//+------------------------------------------------------------------+
//  
//+------------------------------------------------------------------+
#property version   "1.00"
#property strict
#include <MovingAverages.mqh>
//--- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 4
#property  indicator_color1  clrGreen
#property  indicator_color2  clrRed
#property  indicator_color3  clrGreen
#property  indicator_color4  clrRed
#property  indicator_width1  2
#property  indicator_width2  2
#property indicator_level1   100
#property indicator_level2  -100
#property indicator_level3   50
#property indicator_level4  -50
#property indicator_levelstyle STYLE_SOLID
#property indicator_levelcolor clrBlue
#property indicator_levelwidth 1
//--- indicator parameters
input int Period_Channel=70;
input int Period_Input=48;
//--- indicator buffers
double    BufUP[];
double    BufDW[];
double    BufUP1[];
double    BufDW1[];

//+------------------------------------------------------------------+
int OnInit(void)
  {
   IndicatorDigits(2);
//--- drawing settings
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexStyle(3,DRAW_HISTOGRAM);
//--- indicator buffers mapping
   SetIndexBuffer(0,BufUP);
   SetIndexBuffer(1,BufDW);
   SetIndexBuffer(2,BufUP1);
   SetIndexBuffer(3,BufDW1);

   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
int OnCalculate (const int rates_total,
                 const int prev_calculated,
                 const datetime& time[],
                 const double& open[],
                 const double& high[],
                 const double& low[],
                 const double& close[],
                 const long& tick_volume[],
                 const long& volume[],
                 const int& spread[])
  {
   int i,limit;
//---
   limit=rates_total-prev_calculated;
   if(prev_calculated>0)limit++;
   double n1,n2,n3,d;
   for(i=0; i<limit; i++)
   {
      n1=iMA(NULL,0,Period_Channel,0,MODE_LWMA,PRICE_HIGH,i);
      n2=iMA(NULL,0,Period_Channel,0,MODE_LWMA,PRICE_LOW, i);
      n3=iMA(NULL,0,Period_Input,  0,MODE_SMA,PRICE_CLOSE,i);
      d=MathMax(MathAbs(n1-n2),MathMax(MathAbs(n1-n3),MathAbs(n2-n3)));
      if (d==0)d=1e-10;
      BufUP[i]=(n1-n3)/d*100.0;
      BufDW[i]=(n2-n3)/d*100.0;
      BufUP1[i]=EMPTY_VALUE;
      BufDW1[i]=EMPTY_VALUE;
      if (BufUP[i]<0)BufUP1[i]=BufUP[i];
      if (BufDW[i]>0)BufDW1[i]=BufDW[i];
   }
   return(rates_total);
  }
//+------------------------------------------------------------------+
