//+------------------------------------------------------------------+
//|                                              Begin_Trend_v01.mq4 |
//+------------------------------------------------------------------+
#property copyright "Inkov Evgeni ew123@mail.ru"
#property link      "+7-988-140-68-11"
//+------------------------------------------------------------------+
#property version   "1.00"
#property strict
#include <MovingAverages.mqh>
//--- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 2
#property  indicator_color1  clrGreen
#property  indicator_color2  clrRed
#property  indicator_width1  2
#property  indicator_width2  2
#property indicator_level1    0
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_SOLID
#property indicator_levelwidth 2
//--- indicator parameters
input int Period_Channel=70;
input int Period_Input=48;
//--- indicator buffers
double    BufUP[];
double    BufDW[];

//+------------------------------------------------------------------+
int OnInit(void)
  {
   IndicatorDigits(Digits+1);
//--- drawing settings
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
//--- indicator buffers mapping
   SetIndexBuffer(0,BufUP);
   SetIndexBuffer(1,BufDW);

   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
int OnCalculate (const int rates_total,
                 const int prev_calculated,
                 const datetime& time[],
                 const double& open[],
                 const double& high[],
                 const double& low[],
                 const double& close[],
                 const long& tick_volume[],
                 const long& volume[],
                 const int& spread[])
  {
   int i,limit;
//---
   limit=rates_total-prev_calculated;
   if(prev_calculated>0)limit++;
   for(i=0; i<limit; i++)
   {
      BufUP[i]=iMA(NULL,0,Period_Channel,0,MODE_LWMA,PRICE_HIGH,i)-iMA(NULL,0,Period_Input,0,MODE_SMA,PRICE_CLOSE,i);
      BufDW[i]=iMA(NULL,0,Period_Channel,0,MODE_LWMA,PRICE_LOW, i)-iMA(NULL,0,Period_Input,0,MODE_SMA,PRICE_CLOSE,i);
   }
   return(rates_total);
  }
//+------------------------------------------------------------------+
