//+---------------------------------------------------------------------------------------------+
//|                                                                    FileFunctions.mqh        |
//|                                                                    Copyright  Zhunko       |
//|25.05.2011 - 26.02.2014                                             MF ZHUNKO vadim@zhunko.ru|
//+---------------------------------------------------------------------------------------------+
//|    "FileFunctions.dll"     MetaTrader |
//| ,       ,         |
//|  ,       .               |
//+---------------------------------------------------------------------------------------------+

#ifndef size_t
 #ifdef  TERMINAL_X64
  #define size_t      ulong
 #else
  #define size_t      uint
 #endif
#endif

#ifndef BOOL
 #define BOOL         int
#endif

#ifndef WORD
 #define WORD         ushort
#endif

#ifndef DWORD
 #define DWORD        uint
#endif

//
//    .
#define CREATE_NEW                        1  //   .   ,     .
#define CREATE_ALWAYS                     2  //   .   ,   .
#define OPEN_EXISTING                     3  //  .   ,    .
#define OPEN_ALWAYS                       4  //  ,   .    ,   ,    CREATE_NEW.
#define TRUNCATE_EXISTING                 5  //      ,      .

//       .
#define STANDARD_RIGHTS_READ	    0x00020000  //     READ_CONTROL,            .
                                             //          (SACL).
#define STANDARD_RIGHTS_WRITE	   0x00020000  //     WRITE_CONTROL,         .
                                             //          (SACL).
#define SYNCHRONIZE	             0x00100000  //         .       -  (I/O), 
                                             //      OVERLAPPED,       .
#define FILE_ADD_FILE	               0x0002  //  ,     .
#define FILE_ADD_SUBDIRECTORY        0x0004  //	 ,     .
#define FILE_ALL_ACCESS         (0x000F0000|SYNCHRONIZE|0x1FF) //	     .
#define FILE_APPEND_DATA	            0x0004  //   ,      .   ,   .
#define FILE_CREATE_PIPE_INSTANCE  	 0x0004  //   ,   .
#define FILE_DELETE_CHILD            0x0040  //	 ,         ,     .
#define FILE_EXECUTE	                0x0020  //     ( ),   .   ,
                                             //       ,     .
#define FILE_LIST_DIRECTORY          0x0001  //	 ,    .
#define FILE_READ_ATTRIBUTES         0x0080  //	   .
#define FILE_READ_DATA	              0x0001  //   ,     .   ,     .
#define FILE_READ_EA                 0x0008  //	    .
#define FILE_TRAVERSE                0x0020  //	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,
                                             //     FILE_TRAVERSE.
#define FILE_WRITE_ATTRIBUTES	       0x0100  //     .
#define FILE_WRITE_DATA	             0x0002  //   ,     .   ,     .
#define FILE_WRITE_EA	               0x0010  //      .

//       .
#define GENERIC_ALL              0x10000000
#define GENERIC_EXECUTE          0x20000000
#define GENERIC_WRITE            0x40000000
#define GENERIC_READ             0x80000000

//        .
#define SHARE_DELETE	                     1 //     ,      .   ,      ,
                                            //      .     ,         ,    .
#define SHARE_READ	                       2 //     ,      .   ,      ,
                                            //      .     ,         ,    .
#define SHARE_WRITE                       4 //	    ,      .   ,      ,
                                            //      .     ,         ,    .

//
#import "FileFunctions.dll"
 //
 // 1.     .
 //
 // 1.1.1.    .   ,   TRUE,  - FALSE.    ANSI-.
 BOOL FileCheckA(uchar &szPath[]); // ANSI-  .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 1.1.2.    .   ,   TRUE,  - FALSE.    UNICODE-.
 BOOL FileCheckW(string sPath); // UNICODE-  .
 //======================================================================================================================================================================
 // 1.2.1.    .   ,    .     .
 //           ,   TRUE,  - FALSE.
 //             .    ANSI-.
 BOOL FileCopyA(uchar &szExistingPath[], // ANSI-  .
                uchar &szNewPath[]);     // ANSI-    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 1.2.2.    .   ,    .     .
 //           ,   TRUE,  - FALSE.
 //             .    UNICODE-.
 BOOL FileCopyW(string sExistingPath, // UNICODE-  .
                string sNewPath);     // UNICODE-    .
 //======================================================================================================================================================================
 // 1.3.1.   .   ,   TRUE,  - FALSE.    ANSI-.
 BOOL FileDeleteA(uchar &szPath[]); // ANSI-  .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 1.3.2.   .   ,   TRUE,  - FALSE.    UNICODE-.
 BOOL FileDeleteW(string sPath); // UNICODE-  .
 //======================================================================================================================================================================
 // 1.4.1.       .      .    ANSI-.
 //         
 void FileHardLinkA(uchar &szExistingFile[],  // ANSI-  .
                    uchar &szHardLinkFile[]); // ANSI-    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 1.4.2.       .      .    UNICODE-.
 void FileHardLinkW(string sExistingFile,  // UNICODE-  .
                    string sHardLinkFile); // UNICODE-    .
 //======================================================================================================================================================================
 // 1.5.1.   ()  .   ,      .
 //           ,   TRUE,  - FALSE.
 //             .    ANSI-.
 BOOL FileMoveA(uchar &szExistingPath[], // ANSI-  .
                uchar &szNewPath[]);     // ANSI-  .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 1.5.2.   ()  .   ,      .
 //           ,   TRUE,  - FALSE.
 //             .    UNICODE-.
 BOOL FileMoveW(string sExistingPath, // UNICODE-  .
                string sNewPath);     // UNICODE-  .
 //======================================================================================================================================================================
 // 1.6.1.       .    ,   TRUE,  - FALSE.
 //             .    ANSI-.
 BOOL FileSymbolicLinkA(uchar &szExistingFile[],      // ANSI-  .
                        uchar &szSymbolicLinkFile[]); // ANSI-    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 1.6.2.       .    ,   TRUE,  - FALSE.
 //             .    UNICODE-.
 BOOL FileSymbolicLinkW(string sExistingFile,      // UNICODE-  .
                        string sSymbolicLinkFile); // UNICODE-    .
 //
 // 2.         .
 //
 // 2.1.     .
 void FileClear(int hFile); //   .
 //======================================================================================================================================================================
 // 2.2.     .
 void FileCloseHandle(int hFile); //   .
 //======================================================================================================================================================================
 // 2.3.1.   .   ,    .     .
 //           ,   TRUE,  - FALSE.
 //             ,    .
 //           ANSI-.
 BOOL FileCopyByHandleA(int    hFile,            //   .
                        uchar &szNewFileName[]); // ANSI-  .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 2.3.2.   .   ,    .     .
 //           ,   TRUE,  - FALSE.
 //             ,    .
 //           UNICODE-.
 BOOL FileCopyByHandleW(int    hFile,         //   .
                        string sNewFileName); // UNICODE-  .
 //======================================================================================================================================================================
 // 2.4.   .
 void FileDeleteByHandle(int hFile); //   .
 //======================================================================================================================================================================
 // 2.5.                .
 void FileFlushApply(int hFile); //   .
 //======================================================================================================================================================================
 // 2.6.    .
 ulong FileGetSize(int hFile); //   .
 //======================================================================================================================================================================
 // 2.7.1.       .    ANSI-.
 void FileHardLinkByHandleA(int    hFile,             //   .
                            uchar &szHardLinkName[]); // ANSI-    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 2.7.2.       .    UNICODE-.
 void FileHardLinkByHandleW(int    hFile,          //   .
                            string sHardLinkName); // UNICODE-    .
 //======================================================================================================================================================================
 // 2.8.1.   ()  .   ,      .
 //           ,   TRUE,  - FALSE.
 //             .    ANSI-.
 BOOL FileMoveByHandleA(int    hFile,        //   .
                        uchar &szNewPath[]); // ANSI-  .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 2.8.2.   ()  .   ,      .
 //           ,   TRUE,  - FALSE.
 //             .    UNICODE-.
 BOOL FileMoveByHandleW(int    hFile,     //   .
                        string sNewPath); // UNICODE-  .
 //======================================================================================================================================================================
 // 2.9.    .
 void FileResize(int   hFile,      //   .
                 ulong ulNewSize); //   .
 //======================================================================================================================================================================
 // 2.10.1.       .    ,   TRUE,  - FALSE.
 //            ANSI-.
 BOOL FileSymbolicLinkByHandleA(int    hFile,                 //   .
                                uchar &szSymbolicLinkName[]); // ANSI-    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 2.10.2.       .    ,   TRUE,  - FALSE.
 //            UNICODE-.
 BOOL FileSymbolicLinkByHandleW(int    hFile,              //   .
                                string sSymbolicLinkName); // UNICODE-    .
 //
 // 3.      .
 //
 // 3.1.1.     .   ,   .
 //                ,  - NULL.
 //           ANSI-.
 int FileCreateAlwaysA(uchar &szPathFile[], // ANSI-  .
                       DWORD  dwAccess,     //     (,     ).    ,   
                                            //     ,      ,  
                                            //    .     ,      ,
                                            //    .     ,       ,
                                            //    .     ,       -
                                            //  ,   ,       .      
                                            // ,      ,        .
                                            //   :    	          :
                                            //  FILE_ADD_FILE	                ,     .
                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                            //  FILE_ALL_ACCESS             	     .
                                            //  FILE_APPEND_DATA	              ,      .
                                            //                                 ,   .
                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                            //  FILE_DELETE_CHILD           	 ,         ,   
                                            //                                .
                                            //  FILE_EXECUTE	                    ( ),   .   ,
                                            //                                     ,    
                                            //                               .
                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                            //  FILE_READ_ATTRIBUTES        	   .
                                            //  FILE_READ_DATA	                ,     .
                                            //                                 ,     .
                                            //  FILE_READ_EA                	    .
                                            //  FILE_TRAVERSE               	 ,   .  ,   
                                            //                               BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
                                            //  FILE_WRITE_ATTRIBUTES	           .
                                            //  FILE_WRITE_DATA	               ,     .
                                            //                                 ,     .
                                            //  FILE_WRITE_EA	                    .
                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,     
                                            //                                     .    
                                            //                                    (SACL).
                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,      
                                            //                                 .        
                                            //                                (SACL).
                                            //  SYNCHRONIZE	                         .   
                                            //                                  -  (I/O),     
                                            //                                 OVERLAPPED,       .
                                            //      (generic access rights)    .
                                            //   :              	:
                                            //  0	                                  .
                                            //                                   ,    .
                                            //  GENERIC_ALL                   .
                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA,
                                            //                               STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                       DWORD  dwShareMode); //    (, ,    ).   
                                            // ,       ,      ,
                                            //      .  ,      
                                            //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                            //     ,         ,   
                                            // .        ,   ,  
                                            // ,        ,   
                                            // ,    ,   .    
                                            //      ,     .
                                            //  SHARE_DELETE	       ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
                                            //  SHARE_READ	         ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
                                            //  SHARE_WRITE    	    ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 3.1.2.     .   ,   .
 //                ,  - NULL.
 //           UNICODE-.
 int FileCreateAlwaysW(string sPathFile,    // UNICODE-  .
                       DWORD  dwAccess,     //     (,     ).    ,   
                                            //     ,      ,  
                                            //    .     ,      ,
                                            //    .     ,       ,
                                            //    .     ,       -
                                            //  ,   ,       .      
                                            // ,      ,        .
                                            //   :    	          :
                                            //  FILE_ADD_FILE	                ,     .
                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                            //  FILE_ALL_ACCESS             	     .
                                            //  FILE_APPEND_DATA	              ,      .
                                            //                                 ,   .
                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                            //  FILE_DELETE_CHILD           	 ,         ,   
                                            //                                .
                                            //  FILE_EXECUTE	                    ( ),   .   ,
                                            //                                     ,    
                                            //                               .
                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                            //  FILE_READ_ATTRIBUTES        	   .
                                            //  FILE_READ_DATA	                ,     .
                                            //                                 ,     .
                                            //  FILE_READ_EA                	    .
                                            //  FILE_TRAVERSE               	 ,   .  ,   
                                            //                               BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
                                            //  FILE_WRITE_ATTRIBUTES	           .
                                            //  FILE_WRITE_DATA	               ,     .
                                            //                                 ,     .
                                            //  FILE_WRITE_EA	                    .
                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,     
                                            //                                     .    
                                            //                                    (SACL).
                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,      
                                            //                                 .        
                                            //                                (SACL).
                                            //  SYNCHRONIZE	                         .   
                                            //                                  -  (I/O),     
                                            //                                 OVERLAPPED,       .
                                            //      (generic access rights)    .
                                            //   :              	:
                                            //  0	                                  .
                                            //                                   ,    .
                                            //  GENERIC_ALL                   .
                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA,
                                            //                               STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                       DWORD  dwShareMode); //    (, ,    ).   
                                            // ,       ,      ,
                                            //      .  ,      
                                            //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                            //     ,         ,   
                                            // .        ,   ,  
                                            // ,        ,   
                                            // ,    ,   .    
                                            //      ,     .
                                            //  SHARE_DELETE	       ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
                                            //  SHARE_READ	         ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
                                            //  SHARE_WRITE    	    ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
 //======================================================================================================================================================================
 // 3.2.1.    ,     .
 //                ,  - NULL   .
 //           ANSI-.
 int FileCreateNewA(uchar &szPathFile[], // ANSI-  .
                    DWORD  dwAccess,     //     (,     ).    ,   
                                         //     ,      ,  
                                         //    .     ,      ,
                                         //    .     ,       ,
                                         //    .     ,       -
                                         //  ,   ,       .      
                                         // ,      ,        .
                                         //   :    	          :
                                         //  FILE_ADD_FILE	                ,     .
                                         //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                         //  FILE_ALL_ACCESS             	     .
                                         //  FILE_APPEND_DATA	              ,      .
                                         //                                 ,   .
                                         //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                         //  FILE_DELETE_CHILD           	 ,         ,   
                                         //                                .
                                         //  FILE_EXECUTE	                    ( ),   .   ,
                                         //                                     ,    
                                         //                               .
                                         //  FILE_LIST_DIRECTORY         	 ,    .
                                         //  FILE_READ_ATTRIBUTES        	   .
                                         //  FILE_READ_DATA	                ,     .
                                         //                                 ,     .
                                         //  FILE_READ_EA                	    .
                                         //  FILE_TRAVERSE               	 ,   .  ,   
                                         //                               BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
                                         //  FILE_WRITE_ATTRIBUTES	           .
                                         //  FILE_WRITE_DATA	               ,     .
                                         //                                 ,     .
                                         //  FILE_WRITE_EA	                    .
                                         //  STANDARD_RIGHTS_READ	            READ_CONTROL,     
                                         //                                     .    
                                         //                                    (SACL).
                                         //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,      
                                         //                                 .        
                                         //                                (SACL).
                                         //  SYNCHRONIZE	                         .   
                                         //                                  -  (I/O),     
                                         //                                 OVERLAPPED,       .
                                         //      (generic access rights)    .
                                         //   :              	:
                                         //  0	                                  .
                                         //                                   ,    .
                                         //  GENERIC_ALL                   .
                                         //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                         //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                         //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA,
                                         //                               STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                    DWORD  dwShareMode); //    (, ,    ).   
                                         // ,       ,      ,
                                         //      .  ,      
                                         //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                         //     ,         ,   
                                         // .        ,   ,  
                                         // ,        ,   
                                         // ,    ,   .    
                                         //      ,     .
                                         //  SHARE_DELETE	       ,      .
                                         //                    ,      ,    
                                         //                   .     ,        
                                         //                  ,    .
                                         //  SHARE_READ	         ,      .
                                         //                    ,      ,    
                                         //                   .     ,        
                                         //                  ,    .
                                         //  SHARE_WRITE    	    ,      .
                                         //                    ,      ,    
                                         //                   .     ,        
                                         //                  ,    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 3.2.2.    ,     .
 //                ,  - NULL   .
 //           UNICODE-.
 int FileCreateNewW(string sPathFile,    // UNICODE-  .
                    DWORD  dwAccess,     //     (,     ).    ,   
                                         //     ,      ,  
                                         //    .     ,      ,
                                         //    .     ,       ,
                                         //    .     ,       -
                                         //  ,   ,       .      
                                         // ,      ,        .
                                         //   :    	          :
                                         //  FILE_ADD_FILE	                ,     .
                                         //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                         //  FILE_ALL_ACCESS             	     .
                                         //  FILE_APPEND_DATA	              ,      .
                                         //                                 ,   .
                                         //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                         //  FILE_DELETE_CHILD           	 ,         ,   
                                         //                                .
                                         //  FILE_EXECUTE	                    ( ),   .   ,
                                         //                                     ,    
                                         //                               .
                                         //  FILE_LIST_DIRECTORY         	 ,    .
                                         //  FILE_READ_ATTRIBUTES        	   .
                                         //  FILE_READ_DATA	                ,     .
                                         //                                 ,     .
                                         //  FILE_READ_EA                	    .
                                         //  FILE_TRAVERSE               	 ,   .  ,   
                                         //                               BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
                                         //  FILE_WRITE_ATTRIBUTES	           .
                                         //  FILE_WRITE_DATA	               ,     .
                                         //                                 ,     .
                                         //  FILE_WRITE_EA	                    .
                                         //  STANDARD_RIGHTS_READ	            READ_CONTROL,     
                                         //                                     .    
                                         //                                    (SACL).
                                         //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,      
                                         //                                 .        
                                         //                                (SACL).
                                         //  SYNCHRONIZE	                         .   
                                         //                                  -  (I/O),     
                                         //                                 OVERLAPPED,       .
                                         //      (generic access rights)    .
                                         //   :              	:
                                         //  0	                                  .
                                         //                                   ,    .
                                         //  GENERIC_ALL                   .
                                         //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                         //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                         //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA,
                                         //                               STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                    DWORD  dwShareMode); //    (, ,    ).   
                                         // ,       ,      ,
                                         //      .  ,      
                                         //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                         //     ,         ,   
                                         // .        ,   ,  
                                         // ,        ,   
                                         // ,    ,   .    
                                         //      ,     .
                                         //  SHARE_DELETE	       ,      .
                                         //                    ,      ,    
                                         //                   .     ,        
                                         //                  ,    .
                                         //  SHARE_READ	         ,      .
                                         //                    ,      ,    
                                         //                   .     ,        
                                         //                  ,    .
                                         //  SHARE_WRITE    	    ,      .
                                         //                    ,      ,    
                                         //                   .     ,        
                                         //                  ,    .
 //======================================================================================================================================================================
 // 3.3.1.   ,   .    ,   .
 //                ,  - NULL.
 //           ANSI-.
 int FileOpenAlwaysA(uchar &szPathFile[], // ANSI-  .
                     DWORD  dwAccess,     //     (,     ).    ,   
                                          //     ,      ,  
                                          //    .     ,      ,
                                          //    .     ,       ,
                                          //    .     ,       -
                                          //  ,   ,       .      
                                          // ,      ,        .
                                          //   :    	          :
                                          //  FILE_ADD_FILE	                ,     .
                                          //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                          //  FILE_ALL_ACCESS             	     .
                                          //  FILE_APPEND_DATA	              ,      .
                                          //                                 ,   .
                                          //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                          //  FILE_DELETE_CHILD           	 ,         ,   
                                          //                                .
                                          //  FILE_EXECUTE	                    ( ),   .   ,
                                          //                                     ,    
                                          //                               .
                                          //  FILE_LIST_DIRECTORY         	 ,    .
                                          //  FILE_READ_ATTRIBUTES        	   .
                                          //  FILE_READ_DATA	                ,     .
                                          //                                 ,     .
                                          //  FILE_READ_EA                	    .
                                          //  FILE_TRAVERSE               	 ,   .  ,   
                                          //                               BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
                                          //  FILE_WRITE_ATTRIBUTES	           .
                                          //  FILE_WRITE_DATA	               ,     .
                                          //                                 ,     .
                                          //  FILE_WRITE_EA	                    .
                                          //  STANDARD_RIGHTS_READ	            READ_CONTROL,     
                                          //                                     .    
                                          //                                    (SACL).
                                          //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,      
                                          //                                 .        
                                          //                                (SACL).
                                          //  SYNCHRONIZE	                         .   
                                          //                                  -  (I/O),     
                                          //                                 OVERLAPPED,       .
                                          //      (generic access rights)    .
                                          //   :              	:
                                          //  0	                                  .
                                          //                                   ,    .
                                          //  GENERIC_ALL                   .
                                          //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                          //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                          //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA,
                                          //                               STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                     DWORD  dwShareMode); //    (, ,    ).   
                                          // ,       ,      ,
                                          //      .  ,      
                                          //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                          //     ,         ,   
                                          // .        ,   ,  
                                          // ,        ,   
                                          // ,    ,   .    
                                          //      ,     .
                                          //  SHARE_DELETE	       ,      .
                                          //                    ,      ,    
                                          //                   .     ,        
                                          //                  ,    .
                                          //  SHARE_READ	         ,      .
                                          //                    ,      ,    
                                          //                   .     ,        
                                          //                  ,    .
                                          //  SHARE_WRITE    	    ,      .
                                          //                    ,      ,    
                                          //                   .     ,        
                                          //                  ,    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 3.3.2.   ,   .    ,   .
 //                ,  - NULL.
 //           UNICODE-.
 int FileOpenAlwaysW(string sPathFile,    // UNICODE-  .
                     DWORD  dwAccess,     //     (,     ).    ,   
                                          //     ,      ,  
                                          //    .     ,      ,
                                          //    .     ,       ,
                                          //    .     ,       -
                                          //  ,   ,       .      
                                          // ,      ,        .
                                          //   :    	          :
                                          //  FILE_ADD_FILE	                ,     .
                                          //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                          //  FILE_ALL_ACCESS             	     .
                                          //  FILE_APPEND_DATA	              ,      .
                                          //                                 ,   .
                                          //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                          //  FILE_DELETE_CHILD           	 ,         ,   
                                          //                                .
                                          //  FILE_EXECUTE	                    ( ),   .   ,
                                          //                                     ,    
                                          //                               .
                                          //  FILE_LIST_DIRECTORY         	 ,    .
                                          //  FILE_READ_ATTRIBUTES        	   .
                                          //  FILE_READ_DATA	                ,     .
                                          //                                 ,     .
                                          //  FILE_READ_EA                	    .
                                          //  FILE_TRAVERSE               	 ,   .  ,   
                                          //                               BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
                                          //  FILE_WRITE_ATTRIBUTES	           .
                                          //  FILE_WRITE_DATA	               ,     .
                                          //                                 ,     .
                                          //  FILE_WRITE_EA	                    .
                                          //  STANDARD_RIGHTS_READ	            READ_CONTROL,     
                                          //                                     .    
                                          //                                    (SACL).
                                          //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,      
                                          //                                 .        
                                          //                                (SACL).
                                          //  SYNCHRONIZE	                         .   
                                          //                                  -  (I/O),     
                                          //                                 OVERLAPPED,       .
                                          //      (generic access rights)    .
                                          //   :              	:
                                          //  0	                                  .
                                          //                                   ,    .
                                          //  GENERIC_ALL                   .
                                          //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                          //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                          //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA,
                                          //                               STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                     DWORD  dwShareMode); //    (, ,    ).   
                                          // ,       ,      ,
                                          //      .  ,      
                                          //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                          //     ,         ,   
                                          // .        ,   ,  
                                          // ,        ,   
                                          // ,    ,   .    
                                          //      ,     .
                                          //  SHARE_DELETE	       ,      .
                                          //                    ,      ,    
                                          //                   .     ,        
                                          //                  ,    .
                                          //  SHARE_READ	         ,      .
                                          //                    ,      ,    
                                          //                   .     ,        
                                          //                  ,    .
                                          //  SHARE_WRITE    	    ,      .
                                          //                    ,      ,    
                                          //                   .     ,        
                                          //                  ,    .
 //======================================================================================================================================================================
 // 3.4.1.    ,   .
 //                ,  - NULL.
 //           ANSI-.
 int FileOpenExistingA(uchar &szPathFile[], // ANSI-  .
                       DWORD  dwAccess,     //     (,     ).    ,   
                                            //     ,      ,  
                                            //    .     ,      ,
                                            //    .     ,       ,
                                            //    .     ,       -
                                            //  ,   ,       .      
                                            // ,      ,        .
                                            //   :    	          :
                                            //  FILE_ADD_FILE	                ,     .
                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                            //  FILE_ALL_ACCESS             	     .
                                            //  FILE_APPEND_DATA	              ,      .
                                            //                                 ,   .
                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                            //  FILE_DELETE_CHILD           	 ,         ,   
                                            //                                .
                                            //  FILE_EXECUTE	                    ( ),   .   ,
                                            //                                     ,    
                                            //                               .
                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                            //  FILE_READ_ATTRIBUTES        	   .
                                            //  FILE_READ_DATA	                ,     .
                                            //                                 ,     .
                                            //  FILE_READ_EA                	    .
                                            //  FILE_TRAVERSE               	 ,   .  ,   
                                            //                               BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
                                            //  FILE_WRITE_ATTRIBUTES	           .
                                            //  FILE_WRITE_DATA	               ,     .
                                            //                                 ,     .
                                            //  FILE_WRITE_EA	                    .
                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,     
                                            //                                     .    
                                            //                                    (SACL).
                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,      
                                            //                                 .        
                                            //                                (SACL).
                                            //  SYNCHRONIZE	                         .   
                                            //                                  -  (I/O),     
                                            //                                 OVERLAPPED,       .
                                            //      (generic access rights)    .
                                            //   :              	:
                                            //  0	                                  .
                                            //                                   ,    .
                                            //  GENERIC_ALL                   .
                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA,
                                            //                               STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                       DWORD  dwShareMode); //    (, ,    ).   
                                            // ,       ,      ,
                                            //      .  ,      
                                            //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                            //     ,         ,   
                                            // .        ,   ,  
                                            // ,        ,   
                                            // ,    ,   .    
                                            //      ,     .
                                            //  SHARE_DELETE	       ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
                                            //  SHARE_READ	         ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
                                            //  SHARE_WRITE    	    ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 3.4.2.    ,   .
 //                ,  - NULL.
 //           UNICODE-.
 int FileOpenExistingW(string sPathFile,    // UNICODE-  .
                       DWORD  dwAccess,     //     (,     ).    ,   
                                            //     ,      ,  
                                            //    .     ,      ,
                                            //    .     ,       ,
                                            //    .     ,       -
                                            //  ,   ,       .      
                                            // ,      ,        .
                                            //   :    	          :
                                            //  FILE_ADD_FILE	                ,     .
                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                            //  FILE_ALL_ACCESS             	     .
                                            //  FILE_APPEND_DATA	              ,      .
                                            //                                 ,   .
                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                            //  FILE_DELETE_CHILD           	 ,         ,   
                                            //                                .
                                            //  FILE_EXECUTE	                    ( ),   .   ,
                                            //                                     ,    
                                            //                               .
                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                            //  FILE_READ_ATTRIBUTES        	   .
                                            //  FILE_READ_DATA	                ,     .
                                            //                                 ,     .
                                            //  FILE_READ_EA                	    .
                                            //  FILE_TRAVERSE               	 ,   .  ,   
                                            //                               BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
                                            //  FILE_WRITE_ATTRIBUTES	           .
                                            //  FILE_WRITE_DATA	               ,     .
                                            //                                 ,     .
                                            //  FILE_WRITE_EA	                    .
                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,     
                                            //                                     .    
                                            //                                    (SACL).
                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,      
                                            //                                 .        
                                            //                                (SACL).
                                            //  SYNCHRONIZE	                         .   
                                            //                                  -  (I/O),     
                                            //                                 OVERLAPPED,       .
                                            //      (generic access rights)    .
                                            //   :              	:
                                            //  0	                                  .
                                            //                                   ,    .
                                            //  GENERIC_ALL                   .
                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA,
                                            //                               STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                       DWORD  dwShareMode); //    (, ,    ).   
                                            // ,       ,      ,
                                            //      .  ,      
                                            //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                            //     ,         ,   
                                            // .        ,   ,  
                                            // ,        ,   
                                            // ,    ,   .    
                                            //      ,     .
                                            //  SHARE_DELETE	       ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
                                            //  SHARE_READ	         ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
                                            //  SHARE_WRITE    	    ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
 //======================================================================================================================================================================
 // 3.5.1.       ,      .
 //                ,  - NULL.
 //           ANSI-.
 int FileOpenTruncateA(uchar &szsPathFile[], // ANSI-  .
                        DWORD  dwAccess,     //     (,     ).    ,   
                                             //     ,      ,  
                                             //    .     ,      ,
                                             //    .     ,       ,
                                             //    .     ,       -
                                             //  ,   ,       .      
                                             // ,      ,        .
                                             //   :    	          :
                                             //  FILE_ADD_FILE	                ,     .
                                             //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                             //  FILE_ALL_ACCESS             	     .
                                             //  FILE_APPEND_DATA	              ,      .
                                             //                                 ,   .
                                             //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                             //  FILE_DELETE_CHILD           	 ,         ,   
                                             //                                .
                                             //  FILE_EXECUTE	                    ( ),   .   ,
                                             //                                     ,    
                                             //                               .
                                             //  FILE_LIST_DIRECTORY         	 ,    .
                                             //  FILE_READ_ATTRIBUTES        	   .
                                             //  FILE_READ_DATA	                ,     .
                                             //                                 ,     .
                                             //  FILE_READ_EA                	    .
                                             //  FILE_TRAVERSE               	 ,   .  ,  
                                             //                                BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
                                             //  FILE_WRITE_ATTRIBUTES	           .
                                             //  FILE_WRITE_DATA	               ,     .
                                             //                                 ,     .
                                             //  FILE_WRITE_EA	                    .
                                             //  STANDARD_RIGHTS_READ	            READ_CONTROL,     
                                             //                                     .    
                                             //                                    (SACL).
                                             //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,      
                                             //                                 .        
                                             //                                (SACL).
                                             //  SYNCHRONIZE	                         .   
                                             //                                  -  (I/O),     
                                             //                                 OVERLAPPED,       .
                                             //      (generic access rights)    .
                                             //   :              	:
                                             //  0	                                  .
                                             //                                   ,    .
                                             //  GENERIC_ALL                   .
                                             //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                             //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                             //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA,
                                             //                               STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                        DWORD  dwShareMode); //    (, ,    ).   
                                             // ,       ,      ,
                                             //      .  ,      
                                             //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                             //     ,         ,   
                                             // .        ,   ,  
                                             // ,        ,   
                                             // ,    ,   .    
                                             //      ,     .
                                             //  SHARE_DELETE	       ,      .
                                             //                    ,      ,    
                                             //                   .     ,        
                                             //                  ,    .
                                             //  SHARE_READ	         ,      .
                                             //                    ,      ,    
                                             //                   .     ,        
                                             //                  ,    .
                                             //  SHARE_WRITE    	    ,      .
                                             //                    ,      ,    
                                             //                   .     ,        
                                             //                  ,    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 3.5.2.       ,      .
 //                ,  - NULL.
 //           UNICODE-.
 int FileOpenTruncateW(string sPathFile,    // UNICODE-  .
                       DWORD  dwAccess,     //     (,     ).    ,   
                                            //     ,      ,  
                                            //    .     ,      ,
                                            //    .     ,       ,
                                            //    .     ,       -
                                            //  ,   ,       .      
                                            // ,      ,        .
                                            //   :    	          :
                                            //  FILE_ADD_FILE	                ,     .
                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                            //  FILE_ALL_ACCESS             	     .
                                            //  FILE_APPEND_DATA	              ,      .
                                            //                                 ,   .
                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                            //  FILE_DELETE_CHILD           	 ,         ,   
                                            //                                .
                                            //  FILE_EXECUTE	                    ( ),   .   ,
                                            //                                     ,    
                                            //                               .
                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                            //  FILE_READ_ATTRIBUTES        	   .
                                            //  FILE_READ_DATA	                ,     .
                                            //                                 ,     .
                                            //  FILE_READ_EA                	    .
                                            //  FILE_TRAVERSE               	 ,   .  ,   
                                            //                               BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
                                            //  FILE_WRITE_ATTRIBUTES	           .
                                            //  FILE_WRITE_DATA	               ,     .
                                            //                                 ,     .
                                            //  FILE_WRITE_EA	                    .
                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,     
                                            //                                     .    
                                            //                                    (SACL).
                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,      
                                            //                                 .        
                                            //                                (SACL).
                                            //  SYNCHRONIZE	                         .   
                                            //                                  -  (I/O),     
                                            //                                 OVERLAPPED,       .
                                            //      (generic access rights)    .
                                            //   :              	:
                                            //  0	                                  .
                                            //                                   ,    .
                                            //  GENERIC_ALL                   .
                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA,
                                            //                               STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                       DWORD  dwShareMode); //    (, ,    ).   
                                            // ,       ,      ,
                                            //      .  ,      
                                            //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                            //     ,         ,   
                                            // .        ,   ,  
                                            // ,        ,   
                                            // ,    ,   .    
                                            //      ,     .
                                            //  SHARE_DELETE	       ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
                                            //  SHARE_READ	         ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
                                            //  SHARE_WRITE    	    ,      .
                                            //                    ,      ,    
                                            //                   .     ,        
                                            //                  ,    .
 //
 // 4.      .
 //
 // 4.1.     .          .
 long FileGetPointer(int hFile); //   .
 //======================================================================================================================================================================
 // 4.2.             .
 //               .
 long FileSetPointerBegin(int hFile,            //   .
                          int nDistanceToMove); //    .
 //======================================================================================================================================================================
 // 4.3.               .
 //               .
 long FileSetPointerCurrent(int hFile,            //   .
                            int nDistanceToMove); //    .
 //======================================================================================================================================================================
 // 4.4.             .
 //               .
 long FileSetPointerEnd(int hFile,            //   .
                        int nDistanceToMove); //    .
 //
 // 5.       .
 //
 // 5.1.       BOOL (1 )     .
 //               .
 int FileWriteBoolean(int  hFile,   //   .
                      bool bValue); //   BOOL    .
 //======================================================================================================================================================================
 // 5.2.       CHAR (1 )     .
 //               .
 int FileWriteChar(int  hFile,   //   .
                   char cValue); //   CHAR    .
 //======================================================================================================================================================================
 // 5.3.       UCHAR (1 )     .
 //               .
 int FileWriteUChar(int   hFile,    //   .
                    uchar ucValue); //   UCHAR    .
 //======================================================================================================================================================================
 // 5.4.       SHORT (2 )     .
 //               .
 int FileWriteShort(int   hFile,    //   .
                    short shValue); //   SHORT    .
 //======================================================================================================================================================================
 // 5.5.       USHORT (2 )     .
 //               .
 int FileWriteUShort(int    hFile,     //   .
                     ushort ushValue); //   USHORT    .
 //======================================================================================================================================================================
 // 5.6.       INT (4 )     .
 //               .
 int FileWriteInt(int hFile,   //   .
                  int nValue); //   INT    .
 //======================================================================================================================================================================
 // 5.7.       UINT (4 )     .
 //               .
 int FileWriteUInt(int  hFile,    //   .
                   uint uiValue); //   UINT    .
 //======================================================================================================================================================================
 // 5.8.       INT64 (8 )     .
 //               .
 int FileWriteInt64(int  hFile,   //   .
                    long lValue); //   INT64    .
 //======================================================================================================================================================================
 // 5.9.       UINT64 (8 )     .
 //               .
 int FileWriteUInt64(int   hFile,    //   .
                     ulong ulValue); //   UINT64    .
 //======================================================================================================================================================================
 // 5.10.       FLOAT (4 )     .
 //                .
 int FileWriteFlt(int   hFile,   //   .
                  float fValue); //   FLOAT    .
 //======================================================================================================================================================================
 // 5.11.       DOUBLE (8 )     .
 //                .
 int FileWriteDbl(int    hFile,   //   .
                  double dValue); //   DOUBLE    .
 //======================================================================================================================================================================
 // 5.12.1.     ANSI-     .
 //                  .
 int FileWriteStringA(int    hFile,       //   .
                      uchar &szString[]); // ANSI-    .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 5.12.2.     UNICODE-     .
 //                  .
 int FileWriteStringW(int    hFile,    //   .
                      string sString); // UNICODE-    .
 //
 // 6.     .
 //
 // 6.1.         BOOL (1 )      .
 //              ULONG_MAX.
 ulong FileWriteBoolArray(int    hFile,     //   .
                          bool  &abArray[], //      BOOL    .
                          size_t stSize,    //   (  ).
                          size_t stStart,   //     (   ).
                          size_t stCount);  //   .
 //======================================================================================================================================================================
 // 6.2.         CHAR (1 )      .
 //              ULONG_MAX.
 ulong FileWriteCharArray(int    hFile,     //   .
                          char  &acArray[], //     CHAR    .
                          size_t stSize,    //   (  ).
                          size_t stStart,   //     (   ).
                          size_t stCount);  //   .
 //======================================================================================================================================================================
 // 6.3.         UCHAR (1 )      .
 //              ULONG_MAX.
 ulong FileWriteUCharArray(int    hFile,      //   .
                           uchar &aucArray[], //     UCHAR    .
                           size_t stSize,     //   (  ).
                           size_t stStart,    //     (   ).
                           size_t stCount);   //   .
 //======================================================================================================================================================================
 // 6.4.         SHORT (2 )      .
 //              ULONG_MAX.
 ulong FileWriteShortArray(int    hFile,      //   .
                           short &ashArray[], //     SHORT    .
                           size_t stSize,     //   (  ).
                           size_t stStart,    //     (   ).
                           size_t stCount);   //   .
 //======================================================================================================================================================================
 // 6.5.         USHORT (2 )      .
 //              ULONG_MAX.
 ulong FileWriteUShortArray(int     hFile,       //   .
                            ushort &aushArray[], //     USHORT    .
                            size_t  stSize,      //   (  ).
                            size_t  stStart,     //     (   ).
                            size_t  stCount);    //   .
 //======================================================================================================================================================================
 // 6.6.         INT (4 )      .
 //              ULONG_MAX.
 ulong FileWriteIntArray(int    hFile,     //   .
                         int   &anArray[], //     INT    .
                         size_t stSize,    //   (  ).
                         size_t stStart,   //     (   ).
                         size_t stCount);  //   .
 //======================================================================================================================================================================
 // 6.7.         UINT (4 )      .
 //              ULONG_MAX.
 ulong FileWriteUIntArray(int    hFile,      //   .
                          uint  &auiArray[], //     UINT    .
                          size_t stSize,     //   (  ).
                          size_t stStart,    //     (   ).
                          size_t stCount);   //   .
 //======================================================================================================================================================================
 // 6.8.         INT64 (8 )      .
 //              ULONG_MAX.
 ulong FileWriteLongArray(int    hFile,    //   .
                          long  &lArray[], //     INT64    .
                          size_t stSize,   //   (  ).
                          size_t stStart,  //     (   ).
                          size_t stCount); //   .
 //======================================================================================================================================================================
 // 6.9.         UINT64 (8 )      .
 //              ULONG_MAX.
 ulong FileWriteULongArray(int    hFile,     //   .
                           ulong &ulArray[], //     INT64    .
                           size_t stSize,    //   (  ).
                           size_t stStart,   //     (   ).
                           size_t stCount);  //   .
 //======================================================================================================================================================================
 // 6.10.         FLOAT (4 )      .
 //               ULONG_MAX.
 ulong FileWriteFloatArray(int    hFile,     //   .
                           float &afArray[], //     FLOAT    .
                           size_t stSize,    //   (  ).
                           size_t stStart,   //     (   ).
                           size_t stCount);  //   .
 //======================================================================================================================================================================
 // 6.11.         DOUBLE (8 )      .
 //               ULONG_MAX.
 ulong FileWriteDoubleArray(int     hFile,     //   .
                            double &adArray[], //     DOUBLE    .
                            size_t  stSize,    //   (  ).
                            size_t  stStart,   //     (   ).
                            size_t  stCount);  //   .
 //======================================================================================================================================================================
 // 6.12.1.        MQLSTRA      .
 //           ,            ("\r\n").
 //                 ULONG_MAX.
 ulong FileWriteStrArrayMA(int     hFile,     //   .
                           string &asArray[], //  MQLSTRA-    .
                           size_t  stSize,    //   (   ).
                           size_t  stStart,   //     (   ).
                           size_t  stCount);  //   .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 6.12.2.        MQLSTRW      .
 //           ,            ("\r\n").
 //                 ULONG_MAX.
 ulong FileWriteStrArrayMW(int     hFile,     //   .
                           string &asArray[], //  MQLSTRW-    .
                           size_t  stSize,    //   (   ).
                           size_t  stStart,   //     (   ).
                           size_t  stCount);  //   .
 //
 // 7.       .
 //
 // 7.1.       BOOL (1 )   .         FALSE.
 bool FileReadBoolean(int hFile); //   .
 //======================================================================================================================================================================
 // 7.2.       CHAR (1 )   .         0.
 char FileReadChar(int hFile); //   .
 //======================================================================================================================================================================
 // 7.3.       UCHAR (1 )   .         0.
 uchar FileReadUChar(int hFile); //   .
 //======================================================================================================================================================================
 // 7.4.       SHORT (2 )   .         0.
 short FileReadShort(int hFile); //   .
 //======================================================================================================================================================================
 // 7.5.       USHORT (2 )   .         0.
 ushort FileReadUShort(int hFile); //   .
 //======================================================================================================================================================================
 // 7.6.       INT (4 )   .         0.
 int FileReadInt(int hFile); //   .
 //======================================================================================================================================================================
 // 7.7.       UINT (4 )   .         0.
 uint FileReadUInt(int hFile); //   .
 //======================================================================================================================================================================
 // 7.8.       INT64 (8 )   .         0.
 long FileReadInt64(int hFile); //   .
 //======================================================================================================================================================================
 // 7.9.       UINT64 (8 )   .         0.
 ulong FileReadUInt64(int hFile); //   .
 //======================================================================================================================================================================
 // 7.10.       FLOAT (4 )   .         0.
 float FileReadFlt(int hFile); //   .
 //======================================================================================================================================================================
 // 7.11.       DOUBLE (8 )   .         0.
 double FileReadDbl(int hFile); //   .
 //======================================================================================================================================================================
 // 7.12.1.     ANSI-     .         NULL.
 string FileReadStringA(int    hFile,    //   .
                        size_t stCount); //   .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 7.12.2.     UNICODE-     .         NULL.
 string FileReadStringW(int    hFile,    //   .
                        size_t stCount); //   .
 //
 // 8.     .
 //
 // 8.1.         BOOL (1 )      .
 //              ULONG_MAX.
 ulong FileReadBoolArray(int    hFile,     //   .
                         bool  &abArray[], //        BOOL  .
                         size_t stSize,    //   (  ).
                         size_t stStart,   //     (   ).
                         size_t stCount);  //   .
 //======================================================================================================================================================================
 // 8.2.         CHAR (1 )      .
 //              ULONG_MAX.
 ulong FileReadCharArray(int    hFile,     //   .
                         char  &acArray[], //        CHAR  .
                         size_t stSize,    //   (  ).
                         size_t stStart,   //     (   ).
                         size_t stCount);  //   .
 //======================================================================================================================================================================
 // 8.3.         UCHAR (1 )      .
 //              ULONG_MAX.
 ulong FileReadUCharArray(int    hFile,      //   .
                          uchar &aucArray[], //        UCHAR  .
                          size_t stSize,     //   (  ).
                          size_t stStart,    //     (   ).
                          size_t stCount);   //   .
 //======================================================================================================================================================================
 // 8.4.         SHORT (2 )      .
 //              ULONG_MAX.
 ulong FileReadShortArray(int    hFile,      //   .
                          short &ashArray[], //        SHORT  .
                          size_t stSize,     //   (  ).
                          size_t stStart,    //     (   ).
                          size_t stCount);   //   .
 //======================================================================================================================================================================
 // 8.5.         USHORT (2 )      .
 //              ULONG_MAX.
 ulong FileReadUShortArray(int     hFile,       //   .
                           ushort &aushArray[], //        USHORT  .
                           size_t  stSize,      //   (  ).
                           size_t  stStart,     //     (   ).
                           size_t  stCount);    //   .
 //======================================================================================================================================================================
 // 8.6.         INT (4 )      .
 //              ULONG_MAX.
 ulong FileReadIntArray(int    hFile,     //   .
                        int   &anArray[], //        INT  .
                        size_t stSize,    //   (  ).
                        size_t stStart,   //     (   ).
                        size_t stCount);  //   .
 //======================================================================================================================================================================
 // 8.7.         UINT (4 )      .
 //              ULONG_MAX.
 ulong FileReadUIntArray(int    hFile,      //   .
                         uint  &auiArray[], //        UINT  .
                         size_t stSize,     //   (  ).
                         size_t stStart,    //     (   ).
                         size_t stCount);   //   .
 //======================================================================================================================================================================
 // 8.8.         INT64 (8 )      .
 //              ULONG_MAX.
 ulong FileReadLongArray(int    hFile,     //   .
                         long  &alArray[], //        INT64  .
                         size_t stSize,    //   (  ).
                         size_t stStart,   //     (   ).
                         size_t stCount);  //   .
 //======================================================================================================================================================================
 // 8.9.         UINT64 (8 )      .
 //              ULONG_MAX.
 ulong FileReadULongArray(int    hFile,      //   .
                          ulong &aulArray[], //        UINT64  .
                          size_t stSize,     //   (  ).
                          size_t stStart,    //     (   ).
                          size_t stCount);   //   .
 //======================================================================================================================================================================
 // 8.10.         FLOAT (4 )      .
 //               ULONG_MAX.
 ulong FileReadFloatArray(int    hFile,     //   .
                          float &afArray[], //        FLOAT  .
                          size_t stSize,    //   (  ).
                          size_t stStart,   //     (   ).
                          size_t stCount);  //   .
 //======================================================================================================================================================================
 // 8.11.         DOUBLE (8 )      .
 //               ULONG_MAX.
 ulong FileReadDoubleArray(int     hFile,     //   .
                           double &adArray[], //        DOUBLE  .
                           size_t  stSize,    //   (  ).
                           size_t  stStart,   //     (   ).
                           size_t  stCount);  //   .
 //======================================================================================================================================================================
 // 8.12.1.      MQLSTRA-      .
 //                 ULONG_MAX.
 ulong FileReadStrArrayMA(int     hFile,     //   .
                          string &asArray[], //  MQLSTRA-       CHAR  .
                          size_t  stSize,    //   (  ).
                          size_t  stStart,   //     (   ).
                          size_t  stCount);  //   .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 8.12.2.      MQLSTRW-      .
 //                 ULONG_MAX.
 ulong FileReadStrArrayMW(int     hFile,     //   .
                          string &asArray[], //  MQLSTRW-       WCHAR  .
                          size_t  stSize,    //   (  ).
                          size_t  stStart,   //     (   ).
                          size_t  stCount);  //   .
 //
/* // 9.    /.
 //
 //        ! ,   ,  ,    .
 //         -         .
 //
 // 9.1.1.     ,   ,    ,    .
 //              .      .    ANSI-.
 ulong FileCompletedA(uchar &szPathFile[],         // ANSI-  .
                      ushort wCreationDisposition, //    :
                                                   //   CREATE_NEW	           .   ,     .
                                                   //   CREATE_ALWAYS	        .   ,   .
                                                   //   OPEN_EXISTING	       .   ,    .
                                                   //   OPEN_ALWAYS        	 ,   .    ,
                                                   //                         ,    CREATE_NEW.
                                                   //   TRUNCATE_EXISTING  	     ,      .
                      int    nMoveMethod,          //    : SEEK_CUR -   ,
                                                   //                                      SEEK_SET -  ,
                                                   //                                      SEEK_END -   .
                      long   lDistanceToMove,      //    .
                      WORD   wAccesse,             //   : FILE_WRITE - ; FILE_READ - .
                      DWORD  dwShareMode,          //    (, ,    ).    
                                                   // ,       ,      ,
                                                   //      .  ,      
                                                   //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                                   //     ,         ,   
                                                   // .        ,   ,  
                                                   // ,        ,   
                                                   // ,    ,   .    
                                                   //      ,     .
                                                   //  SHARE_DELETE	       ,      .
                                                   //                    ,      ,    
                                                   //                   .     ,        
                                                   //                  ,    .
                                                   //  SHARE_READ	         ,      .
                                                   //                    ,      ,    
                                                   //                   .     ,        
                                                   //                  ,    .
                                                   //  SHARE_WRITE    	    ,      .
                                                   //                    ,      ,    
                                                   //                   .     ,        
                                                   //                  ,    .
                      LPVOID lpData,               //      /.     ,  .
 //                   int    anData[],             //           .    .
                      long   stBytes);             //          lpData.
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 9.1.2.     ,   ,    ,    .
 //              .      .    UNICODE-.
 ulong FileCompletedW(string sPathFile,            // UNICODE-  .
                      ushort wCreationDisposition, //    :
                                                   //   CREATE_NEW	           .   ,     .
                                                   //   CREATE_ALWAYS	        .   ,   .
                                                   //   OPEN_EXISTING	       .   ,    .
                                                   //   OPEN_ALWAYS        	 ,   .    ,
                                                   //                         ,    CREATE_NEW.
                                                   //   TRUNCATE_EXISTING  	     ,      .
                      int    nMoveMethod,          //    : SEEK_CUR -   ,
                                                   //                                      SEEK_SET -  ,
                                                   //                                      SEEK_END -   .
                      long   lDistanceToMove,      //    .
                      WORD   wAccesse,             //   : FILE_WRITE - ; FILE_READ - .
                      DWORD  dwShareMode,          //    (, ,    ).    
                                                   // ,       ,      ,
                                                   //      .  ,      
                                                   //  (ERROR_SHARING_VIOLATION).     ,  CreateFile  ,
                                                   //     ,         ,   
                                                   // .        ,   ,  
                                                   // ,        ,   
                                                   // ,    ,   .    
                                                   //      ,     .
                                                   //  SHARE_DELETE	       ,      .
                                                   //                    ,      ,    
                                                   //                   .     ,        
                                                   //                  ,    .
                                                   //  SHARE_READ	         ,      .
                                                   //                    ,      ,    
                                                   //                   .     ,        
                                                   //                  ,    .
                                                   //  SHARE_WRITE    	    ,      .
                                                   //                    ,      ,    
                                                   //                   .     ,        
                                                   //                  ,    .
                      LPVOID lpData,               //      /.     ,  .
 //                   int    anData[],             //           .    .
                      long   stBytes);             //          lpData.
 //======================================================================================================================================================================
 // 9.2.               .
 //              ULONG_MAX.
 ulong FileReadVoid(int    hFile,    //   .
                    LPVOID lpData,   //        .     ,  .
 //                 int    anData[], //           .    .
                    size_t stBytes); //       lpData   .
 //----------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // 9.3.               .
 //              ULONG_MAX.
 ulong FileWriteVoid(int     hFile,    //   .
                     LPCVOID lpData,   //        .     ,  .
 //                  int     anData[], //           .    .
                     size_t  stBytes); //       lpData.*/
 //
#import
//