//+------------------------------------------------------------------------------------------+
//| FileFunctions.h:        MetaTrader.|
//| Copyright  2010,   (Zhunko)                                                   |
//| e-mail: vadim@zhunko.ru                                          25.05.2011 - 26.02.2014 |
//+------------------------------------------------------------------------------------------+
//| ,       ,       |
//|   ,       .      |
//+------------------------------------------------------------------------------------------+
#ifndef EXPFUNC
 #define EXPFUNC(type)   __declspec(dllexport) type __stdcall
#endif
//
// 1.     .
//
// 1.1.1.    .   ,   TRUE,  - FALSE.    ANSI-.
EXPFUNC(BOOL) FileCheckA(LPCSTR szPath); // ANSI-  .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.1.2.    .   ,   TRUE,  - FALSE.    UNICODE-.
EXPFUNC(BOOL) FileCheckW(LPCWSTR szPath); // UNICODE-  .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.1.3.    .   ,   TRUE,  - FALSE.       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileCheck  FileCheckW
#else
 #define FileCheck  FileCheckA
#endif
//==============================================================================================================================================================================================================================================================
// 1.2.1.    .   ,    .     .    ,   TRUE,  - FALSE.
//             .    ANSI-.
EXPFUNC(BOOL) FileCopyA(LPCSTR szExistingPath, // ANSI-  .
                        LPCSTR szNewPath);     // ANSI-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.2.2.    .   ,    .     .    ,   TRUE,  - FALSE.
//             .    UNICODE-.
EXPFUNC(BOOL) FileCopyW(LPCWSTR szExistingPath, // UNICODE-  .
                        LPCWSTR szNewPath);     // UNICODE-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.2.3.    .   ,    .     .    ,   TRUE,  - FALSE.
//             .       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileCopy  FileCopyW
#else
 #define FileCopy  FileCopyA
#endif
//==============================================================================================================================================================================================================================================================
// 1.3.1.   .   ,   TRUE,  - FALSE.    ANSI-.
EXPFUNC(BOOL) FileDeleteA(LPCSTR szPath); // ANSI-  .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.3.2.   .   ,   TRUE,  - FALSE.    UNICODE-.
EXPFUNC(BOOL) FileDeleteW(LPCWSTR szPath); // UNICODE-  .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.3.3.   .   ,   TRUE,  - FALSE.       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileDelete  FileDeleteW
#else
 #define FileDelete  FileDeleteA
#endif
//==============================================================================================================================================================================================================================================================
// 1.4.1.       .      .    ANSI-.
EXPFUNC(VOID) FileHardLinkA(LPCSTR szExistingFile,  // ANSI-  .
                            LPCSTR szHardLinkFile); // ANSI-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.4.2.       .      .    UNICODE-.
EXPFUNC(VOID) FileHardLinkW(LPCWSTR szExistingFile,  // UNICODE-  .
                            LPCWSTR szHardLinkFile); // UNICODE-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.4.3.       .      .       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileHardLink  FileHardLinkW
#else
 #define FileHardLink  FileHardLinkA
#endif
//==============================================================================================================================================================================================================================================================
// 1.5.1.   ()  .   ,      .    ,   TRUE,  - FALSE.
//               .    ANSI-.
EXPFUNC(BOOL) FileMoveA(LPCSTR szExistingPath, // ANSI-  .
                              LPCSTR szNewPath);     // ANSI-  .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.5.2.   ()  .   ,      .    ,   TRUE,  - FALSE.
//               .    UNICODE-.
EXPFUNC(BOOL) FileMoveW(LPCWSTR szExistingPath, // UNICODE-  .
                        LPCWSTR szNewPath);     // UNICODE-  .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.5.3.   ()  .   ,      .    ,   TRUE,  - FALSE.
//               .       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileMove  FileMoveW
#else
 #define FileMove  FileMoveA
#endif
//==============================================================================================================================================================================================================================================================
// 1.6.1.       .    ,   TRUE,  - FALSE.      .    ANSI-.
EXPFUNC(BOOL) FileSymbolicLinkA(LPCSTR szExistingFile,      // ANSI-  .
                                LPCSTR szSymbolicLinkFile); // ANSI-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.6.2.       .    ,   TRUE,  - FALSE.      .    UNICODE-.
EXPFUNC(BOOL) FileSymbolicLinkW(LPCWSTR szExistingFile,      // UNICODE-  .
                                LPCWSTR szSymbolicLinkFile); // UNICODE-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 1.6.3.       .    ,   TRUE,  - FALSE.      .       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileSymbolicLink  FileSymbolicLinkW
#else
 #define FileSymbolicLink  FileSymbolicLinkA
#endif
//
// 2.         .
//
// 2.1.     .
EXPFUNC(VOID) FileClear(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 2.2.     .
EXPFUNC(VOID) FileCloseHandle(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 2.3.1.   .   ,    .     .    ,   TRUE,  - FALSE.
//             ,    .    ANSI-.
EXPFUNC(BOOL) FileCopyByHandleA(const HANDLE hFile,          //   .
                                LPCSTR       szNewFileName); // ANSI-  .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 2.3.2.   .   ,    .     .    ,   TRUE,  - FALSE.
//             ,    .    UNICODE-.
EXPFUNC(BOOL) FileCopyByHandleW(const HANDLE hFile,          //   .
                                LPCWSTR      szNewFileName); // UNICODE-  .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 2.3.3.   .   ,    .     .    ,   TRUE,  - FALSE.
//               ,    .       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileCopyByHandle  FileCopyByHandleW
#else
 #define FileCopyByHandle  FileCopyByHandleA
#endif
//==============================================================================================================================================================================================================================================================
// 2.4.   .
EXPFUNC(VOID) FileDeleteByHandle(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 2.5.                .
EXPFUNC(VOID) FileFlushApply(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 2.6.    .
EXPFUNC(UINT64) FileGetSize(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 2.7.1.       .    ANSI-.
EXPFUNC(VOID) FileHardLinkByHandleA(const HANDLE hFile,           //   .
                                    LPCSTR       szHardLinkName); // ANSI-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 2.7.2.       .    UNICODE-.
EXPFUNC(VOID) FileHardLinkByHandleW(const HANDLE hFile,           //   .
                                    LPCWSTR      szHardLinkName); // UNICODE-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 2.7.3.       .       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileHardLinkByHandle  FileHardLinkByHandleW
#else
 #define FileHardLinkByHandle  FileHardLinkByHandleA
#endif
//==============================================================================================================================================================================================================================================================
// 2.8.1.   ()  .   ,      .    ,   TRUE,  - FALSE.
//             .    ANSI-.
EXPFUNC(BOOL) FileMoveByHandleA(const HANDLE hFile,      //   .
                                LPCSTR       szNewPath); // ANSI-  .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 2.8.2.   ()  .   ,      .    ,   TRUE,  - FALSE.
//             .    UNICODE-.
EXPFUNC(BOOL) FileMoveByHandleW(const HANDLE hFile,      //   .
                                LPCWSTR      szNewPath); // UNICODE-  .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 2.8.3.   ()  .   ,      .    ,   TRUE,  - FALSE.
//               .       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileMoveByHandle  FileMoveByHandleW
#else
 #define FileMoveByHandle  FileMoveByHandleA
#endif
//==============================================================================================================================================================================================================================================================
// 2.9.    .
EXPFUNC(VOID) FileResize(const HANDLE hFile,        //   .
                         const UINT64 ui64NewSize); //   .
//==============================================================================================================================================================================================================================================================
// 2.10.1.       .    ,   TRUE,  - FALSE.    ANSI-.
EXPFUNC(BOOL) FileSymbolicLinkByHandleA(const HANDLE hFile,               //   .
                                        LPCSTR       szSymbolicLinkName); // ANSI-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 2.10.2.       .    ,   TRUE,  - FALSE.    UNICODE-.
EXPFUNC(BOOL) FileSymbolicLinkByHandleW(const HANDLE hFile,               //   .
                                        LPCWSTR      szSymbolicLinkName); // UNICODE-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 2.10.3.       .    ,   TRUE,  - FALSE.       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileSymbolicLinkByHandle  FileSymbolicLinkByHandleW
#else
 #define FileSymbolicLinkByHandle  FileSymbolicLinkByHandleA
#endif
//
// 3.      .
//
// 3.1.1.     .   ,   .         ,  - NULL.    ANSI-.
EXPFUNC(HANDLE) FileCreateAlwaysA(LPCSTR      szPathFile,   // ANSI-  .
                                  const DWORD dwAccess,     //     (,     ).    ,        ,
                                                            //      ,      .     ,     
                                                            // ,    .     ,       ,    .
                                                            //     ,       -  ,   ,       .
                                                            //       ,      ,        .
                                                            //   :    	          :
                                                            //  FILE_ADD_FILE	                ,     .
                                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                                            //  FILE_ALL_ACCESS             	     .
                                                            //  FILE_APPEND_DATA	              ,      .   ,   .
                                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                                            //  FILE_DELETE_CHILD           	 ,         ,     .
                                                            //  FILE_EXECUTE	                    ( ),   .   ,       ,
                                                            //                                   .
                                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                                            //  FILE_READ_ATTRIBUTES        	   .
                                                            //  FILE_READ_DATA	                ,     .   ,     .
                                                            //  FILE_READ_EA                	    .
                                                            //  FILE_TRAVERSE               	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,  
                                                            //                                 FILE_TRAVERSE.
                                                            //  FILE_WRITE_ATTRIBUTES	           .
                                                            //  FILE_WRITE_DATA	               ,     .   ,     .
                                                            //  FILE_WRITE_EA	                    .
                                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,            .
                                                            //                                        (SACL).
                                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,         .    
                                                            //                                    (SACL).
                                                            //  SYNCHRONIZE	                         .       -  (I/O),  
                                                            //                                    OVERLAPPED,       .
                                                            //      (generic access rights)    .
                                                            //   :              	:
                                                            //  0	                                  .     ,    .
                                                            //  GENERIC_ALL                   .
                                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA, STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                                  const DWORD dwShareMode); //    (, ,    ).     ,       ,
                                                            //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                            //     ,  CreateFile  ,     ,         ,    .
                                                            //        ,   ,    ,        ,
                                                            //    ,    ,   .          ,     .
                                                            //  FILE_SHARE_DELETE	       ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_READ	         ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_WRITE    	    ,      .   ,      ,
                                                            //                            .     ,         ,    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 3.1.2.     .   ,   .         ,  - NULL.    UNICODE-.
EXPFUNC(HANDLE) FileCreateAlwaysW(LPCWSTR     szPathFile,   // UNICODE-  .
                                  const DWORD dwAccess,     //     (,     ).    ,        ,
                                                            //      ,      .     ,     
                                                            // ,    .     ,       ,    .
                                                            //     ,       -  ,   ,       .
                                                            //       ,      ,        .
                                                            //   :    	          :
                                                            //  FILE_ADD_FILE	                ,     .
                                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                                            //  FILE_ALL_ACCESS             	     .
                                                            //  FILE_APPEND_DATA	              ,      .   ,   .
                                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                                            //  FILE_DELETE_CHILD           	 ,         ,     .
                                                            //  FILE_EXECUTE	                    ( ),   .   ,       ,
                                                            //                                   .
                                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                                            //  FILE_READ_ATTRIBUTES        	   .
                                                            //  FILE_READ_DATA	                ,     .   ,     .
                                                            //  FILE_READ_EA                	    .
                                                            //  FILE_TRAVERSE               	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,  
                                                            //                                 FILE_TRAVERSE.
                                                            //  FILE_WRITE_ATTRIBUTES	           .
                                                            //  FILE_WRITE_DATA	               ,     .   ,     .
                                                            //  FILE_WRITE_EA	                    .
                                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,            .
                                                            //                                        (SACL).
                                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,         .    
                                                            //                                    (SACL).
                                                            //  SYNCHRONIZE	                         .       -  (I/O),  
                                                            //                                    OVERLAPPED,       .
                                                            //      (generic access rights)    .
                                                            //   :              	:
                                                            //  0	                                  .     ,    .
                                                            //  GENERIC_ALL                   .
                                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA, STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                                  const DWORD dwShareMode); //    (, ,    ).     ,       ,
                                                            //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                            //     ,  CreateFile  ,     ,         ,    .
                                                            //        ,   ,    ,        ,
                                                            //    ,    ,   .          ,     .
                                                            //  FILE_SHARE_DELETE	       ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_READ	         ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_WRITE    	    ,      .   ,      ,
                                                            //                            .     ,         ,    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 3.1.3.     .   ,   .         ,  - NULL.       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileCreateAlways  FileCreateAlwaysW
#else
 #define FileCreateAlways  FileCreateAlwaysA
#endif
//==============================================================================================================================================================================================================================================================
// 3.2.1.    ,     .         ,  - NULL   .    ANSI-.
EXPFUNC(HANDLE) FileCreateNewA(LPCSTR      szPathFile,   // ANSI-  .
                               const DWORD dwAccess,     //     (,     ).    ,        ,
                                                         //      ,      .     ,     
                                                         // ,    .     ,       ,    .
                                                         //     ,       -  ,   ,       .
                                                         //       ,      ,        .
                                                         //   :    	          :
                                                         //  FILE_ADD_FILE	                ,     .
                                                         //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                                         //  FILE_ALL_ACCESS             	     .
                                                         //  FILE_APPEND_DATA	              ,      .   ,   .
                                                         //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                                         //  FILE_DELETE_CHILD           	 ,         ,     .
                                                         //  FILE_EXECUTE	                    ( ),   .   ,       ,
                                                         //                                   .
                                                         //  FILE_LIST_DIRECTORY         	 ,    .
                                                         //  FILE_READ_ATTRIBUTES        	   .
                                                         //  FILE_READ_DATA	                ,     .   ,     .
                                                         //  FILE_READ_EA                	    .
                                                         //  FILE_TRAVERSE               	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,  
                                                         //                                 FILE_TRAVERSE.
                                                         //  FILE_WRITE_ATTRIBUTES	           .
                                                         //  FILE_WRITE_DATA	               ,     .   ,     .
                                                         //  FILE_WRITE_EA	                    .
                                                         //  STANDARD_RIGHTS_READ	            READ_CONTROL,            .
                                                         //                                        (SACL).
                                                         //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,         .    
                                                         //                                    (SACL).
                                                         //  SYNCHRONIZE	                         .       -  (I/O),  
                                                         //                                    OVERLAPPED,       .
                                                         //      (generic access rights)    .
                                                         //   :              	:
                                                         //  0	                                  .     ,    .
                                                         //  GENERIC_ALL                   .
                                                         //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                                         //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                                         //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA, STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                               const DWORD dwShareMode); //    (, ,    ).     ,       ,
                                                         //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                         //     ,  CreateFile  ,     ,         ,    .
                                                         //        ,   ,    ,        ,
                                                         //    ,    ,   .          ,     .
                                                         //  FILE_SHARE_DELETE	       ,      .   ,      ,
                                                         //                            .     ,         ,    .
                                                         //  FILE_SHARE_READ	         ,      .   ,      ,
                                                         //                            .     ,         ,    .
                                                         //  FILE_SHARE_WRITE    	    ,      .   ,      ,
                                                         //                            .     ,         ,    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 3.2.2.    ,     .         ,  - NULL   .    UNICODE-.
EXPFUNC(HANDLE) FileCreateNewW(LPCWSTR     szPathFile,   // UNICODE-  .
                               const DWORD dwAccess,     //     (,     ).    ,        ,
                                                         //      ,      .     ,     
                                                         // ,    .     ,       ,    .
                                                         //     ,       -  ,   ,       .
                                                         //       ,      ,        .
                                                         //   :    	          :
                                                         //  FILE_ADD_FILE	                ,     .
                                                         //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                                         //  FILE_ALL_ACCESS             	     .
                                                         //  FILE_APPEND_DATA	              ,      .   ,   .
                                                         //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                                         //  FILE_DELETE_CHILD           	 ,         ,     .
                                                         //  FILE_EXECUTE	                    ( ),   .   ,       ,
                                                         //                                   .
                                                         //  FILE_LIST_DIRECTORY         	 ,    .
                                                         //  FILE_READ_ATTRIBUTES        	   .
                                                         //  FILE_READ_DATA	                ,     .   ,     .
                                                         //  FILE_READ_EA                	    .
                                                         //  FILE_TRAVERSE               	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,  
                                                         //                                 FILE_TRAVERSE.
                                                         //  FILE_WRITE_ATTRIBUTES	           .
                                                         //  FILE_WRITE_DATA	               ,     .   ,     .
                                                         //  FILE_WRITE_EA	                    .
                                                         //  STANDARD_RIGHTS_READ	            READ_CONTROL,            .
                                                         //                                        (SACL).
                                                         //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,         .    
                                                         //                                    (SACL).
                                                         //  SYNCHRONIZE	                         .       -  (I/O),  
                                                         //                                    OVERLAPPED,       .
                                                         //      (generic access rights)    .
                                                         //   :              	:
                                                         //  0	                                  .     ,    .
                                                         //  GENERIC_ALL                   .
                                                         //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                                         //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                                         //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA, STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                               const DWORD dwShareMode); //    (, ,    ).     ,       ,
                                                         //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                         //     ,  CreateFile  ,     ,         ,    .
                                                         //        ,   ,    ,        ,
                                                         //    ,    ,   .          ,     .
                                                         //  FILE_SHARE_DELETE	       ,      .   ,      ,
                                                         //                            .     ,         ,    .
                                                         //  FILE_SHARE_READ	         ,      .   ,      ,
                                                         //                            .     ,         ,    .
                                                         //  FILE_SHARE_WRITE    	    ,      .   ,      ,
                                                         //                            .     ,         ,    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 3.2.3.    ,     .         ,  - NULL   .       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileCreateNew  FileCreateNewW
#else
 #define FileCreateNew  FileCreateNewA
#endif
//==============================================================================================================================================================================================================================================================
// 3.3.1.   ,   .    ,   .         ,  - NULL.    ANSI-.
EXPFUNC(HANDLE) FileOpenAlwaysA(LPCSTR      szPathFile,   // ANSI-  .
                                const DWORD dwAccess,     //     (,     ).    ,        ,
                                                          //      ,      .     ,     
                                                          // ,    .     ,       ,    .
                                                          //     ,       -  ,   ,       .
                                                          //       ,      ,        .
                                                          //   :    	          :
                                                          //  FILE_ADD_FILE	                ,     .
                                                          //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                                          //  FILE_ALL_ACCESS             	     .
                                                          //  FILE_APPEND_DATA	              ,      .   ,   .
                                                          //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                                          //  FILE_DELETE_CHILD           	 ,         ,     .
                                                          //  FILE_EXECUTE	                    ( ),   .   ,       ,
                                                          //                                   .
                                                          //  FILE_LIST_DIRECTORY         	 ,    .
                                                          //  FILE_READ_ATTRIBUTES        	   .
                                                          //  FILE_READ_DATA	                ,     .   ,     .
                                                          //  FILE_READ_EA                	    .
                                                          //  FILE_TRAVERSE               	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,  
                                                          //                                 FILE_TRAVERSE.
                                                          //  FILE_WRITE_ATTRIBUTES	           .
                                                          //  FILE_WRITE_DATA	               ,     .   ,     .
                                                          //  FILE_WRITE_EA	                    .
                                                          //  STANDARD_RIGHTS_READ	            READ_CONTROL,            .
                                                          //                                        (SACL).
                                                          //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,         .    
                                                          //                                    (SACL).
                                                          //  SYNCHRONIZE	                         .       -  (I/O),  
                                                          //                                    OVERLAPPED,       .
                                                          //      (generic access rights)    .
                                                          //   :              	:
                                                          //  0	                                  .     ,    .
                                                          //  GENERIC_ALL                   .
                                                          //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                                          //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                                          //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA, STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                                const DWORD dwShareMode); //    (, ,    ).     ,       ,
                                                          //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                          //     ,  CreateFile  ,     ,         ,    .
                                                          //        ,   ,    ,        ,
                                                          //    ,    ,   .          ,     .
                                                          //  FILE_SHARE_DELETE	       ,      .   ,      ,
                                                          //                            .     ,         ,    .
                                                          //  FILE_SHARE_READ	         ,      .   ,      ,
                                                          //                            .     ,         ,    .
                                                          //  FILE_SHARE_WRITE    	    ,      .   ,      ,
                                                          //                            .     ,         ,    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 3.3.2.   ,   .    ,   .         ,  - NULL.    UNICODE-.
EXPFUNC(HANDLE) FileOpenAlwaysW(LPCWSTR     szPathFile,   // UNICODE-  .
                                const DWORD dwAccess,     //     (,     ).    ,        ,
                                                          //      ,      .     ,     
                                                          // ,    .     ,       ,    .
                                                          //     ,       -  ,   ,       .
                                                          //       ,      ,        .
                                                          //   :    	          :
                                                          //  FILE_ADD_FILE	                ,     .
                                                          //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                                          //  FILE_ALL_ACCESS             	     .
                                                          //  FILE_APPEND_DATA	              ,      .   ,   .
                                                          //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                                          //  FILE_DELETE_CHILD           	 ,         ,     .
                                                          //  FILE_EXECUTE	                    ( ),   .   ,       ,
                                                          //                                   .
                                                          //  FILE_LIST_DIRECTORY         	 ,    .
                                                          //  FILE_READ_ATTRIBUTES        	   .
                                                          //  FILE_READ_DATA	                ,     .   ,     .
                                                          //  FILE_READ_EA                	    .
                                                          //  FILE_TRAVERSE               	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,  
                                                          //                                 FILE_TRAVERSE.
                                                          //  FILE_WRITE_ATTRIBUTES	           .
                                                          //  FILE_WRITE_DATA	               ,     .   ,     .
                                                          //  FILE_WRITE_EA	                    .
                                                          //  STANDARD_RIGHTS_READ	            READ_CONTROL,            .
                                                          //                                        (SACL).
                                                          //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,         .    
                                                          //                                    (SACL).
                                                          //  SYNCHRONIZE	                         .       -  (I/O),  
                                                          //                                    OVERLAPPED,       .
                                                          //      (generic access rights)    .
                                                          //   :              	:
                                                          //  0	                                  .     ,    .
                                                          //  GENERIC_ALL                   .
                                                          //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                                          //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                                          //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA, STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                                const DWORD dwShareMode); //    (, ,    ).     ,       ,
                                                          //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                          //     ,  CreateFile  ,     ,         ,    .
                                                          //        ,   ,    ,        ,
                                                          //    ,    ,   .          ,     .
                                                          //  FILE_SHARE_DELETE	       ,      .   ,      ,
                                                          //                            .     ,         ,    .
                                                          //  FILE_SHARE_READ	         ,      .   ,      ,
                                                          //                            .     ,         ,    .
                                                          //  FILE_SHARE_WRITE    	    ,      .   ,      ,
                                                          //                            .     ,         ,    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 3.3.3.   ,   .    ,   .         ,  - NULL.       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileOpenAlways  FileOpenAlwaysW
#else
 #define FileOpenAlways  FileOpenAlwaysA
#endif
//==============================================================================================================================================================================================================================================================
// 3.4.1.    ,   .         ,  - NULL.    ANSI-.
EXPFUNC(HANDLE) FileOpenExistingA(LPCSTR      szPathFile,   // ANSI-  .
                                  const DWORD dwAccess,     //     (,     ).    ,        ,
                                                            //      ,      .     ,     
                                                            // ,    .     ,       ,    .
                                                            //     ,       -  ,   ,       .
                                                            //       ,      ,        .
                                                            //   :    	          :
                                                            //  FILE_ADD_FILE	                ,     .
                                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                                            //  FILE_ALL_ACCESS             	     .
                                                            //  FILE_APPEND_DATA	              ,      .   ,   .
                                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                                            //  FILE_DELETE_CHILD           	 ,         ,     .
                                                            //  FILE_EXECUTE	                    ( ),   .   ,       ,
                                                            //                                   .
                                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                                            //  FILE_READ_ATTRIBUTES        	   .
                                                            //  FILE_READ_DATA	                ,     .   ,     .
                                                            //  FILE_READ_EA                	    .
                                                            //  FILE_TRAVERSE               	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,  
                                                            //                                 FILE_TRAVERSE.
                                                            //  FILE_WRITE_ATTRIBUTES	           .
                                                            //  FILE_WRITE_DATA	               ,     .   ,     .
                                                            //  FILE_WRITE_EA	                    .
                                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,            .
                                                            //                                        (SACL).
                                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,         .    
                                                            //                                    (SACL).
                                                            //  SYNCHRONIZE	                         .       -  (I/O),  
                                                            //                                    OVERLAPPED,       .
                                                            //      (generic access rights)    .
                                                            //   :              	:
                                                            //  0	                                  .     ,    .
                                                            //  GENERIC_ALL                   .
                                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA, STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                                  const DWORD dwShareMode); //    (, ,    ).     ,       ,
                                                            //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                            //     ,  CreateFile  ,     ,         ,    .
                                                            //        ,   ,    ,        ,
                                                            //    ,    ,   .          ,     .
                                                            //  FILE_SHARE_DELETE	       ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_READ	         ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_WRITE    	    ,      .   ,      ,
                                                            //                            .     ,         ,    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 3.4.2.    ,   .         ,  - NULL.    UNICODE-.
EXPFUNC(HANDLE) FileOpenExistingW(LPCWSTR     szPathFile,   // UNICODE-  .
                                  const DWORD dwAccess,     //     (,     ).    ,        ,
                                                            //      ,      .     ,     
                                                            // ,    .     ,       ,    .
                                                            //     ,       -  ,   ,       .
                                                            //       ,      ,        .
                                                            //   :    	          :
                                                            //  FILE_ADD_FILE	                ,     .
                                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                                            //  FILE_ALL_ACCESS             	     .
                                                            //  FILE_APPEND_DATA	              ,      .   ,   .
                                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                                            //  FILE_DELETE_CHILD           	 ,         ,     .
                                                            //  FILE_EXECUTE	                    ( ),   .   ,       ,
                                                            //                                   .
                                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                                            //  FILE_READ_ATTRIBUTES        	   .
                                                            //  FILE_READ_DATA	                ,     .   ,     .
                                                            //  FILE_READ_EA                	    .
                                                            //  FILE_TRAVERSE               	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,  
                                                            //                                 FILE_TRAVERSE.
                                                            //  FILE_WRITE_ATTRIBUTES	           .
                                                            //  FILE_WRITE_DATA	               ,     .   ,     .
                                                            //  FILE_WRITE_EA	                    .
                                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,            .
                                                            //                                        (SACL).
                                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,         .    
                                                            //                                    (SACL).
                                                            //  SYNCHRONIZE	                         .       -  (I/O),  
                                                            //                                    OVERLAPPED,       .
                                                            //      (generic access rights)    .
                                                            //   :              	:
                                                            //  0	                                  .     ,    .
                                                            //  GENERIC_ALL                   .
                                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA, STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                                  const DWORD dwShareMode); //    (, ,    ).     ,       ,
                                                            //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                            //     ,  CreateFile  ,     ,         ,    .
                                                            //        ,   ,    ,        ,
                                                            //    ,    ,   .          ,     .
                                                            //  FILE_SHARE_DELETE	       ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_READ	         ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_WRITE    	    ,      .   ,      ,
                                                            //                            .     ,         ,    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 3.4.3.    ,   .         ,  - NULL.       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileOpenExisting  FileOpenExistingW
#else
 #define FileOpenExisting  FileOpenExistingA
#endif
//==============================================================================================================================================================================================================================================================
// 3.5.1.       ,      .         ,  - NULL.    ANSI-.
EXPFUNC(HANDLE) FileOpenTruncateA(LPCSTR      szPathFile,   // ANSI-  .
                                  const DWORD dwAccess,     //     (,     ).    ,        ,
                                                            //      ,      .     ,     
                                                            // ,    .     ,       ,    .
                                                            //     ,       -  ,   ,       .
                                                            //       ,      ,        .
                                                            //   :    	          :
                                                            //  FILE_ADD_FILE	                ,     .
                                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                                            //  FILE_ALL_ACCESS             	     .
                                                            //  FILE_APPEND_DATA	              ,      .   ,   .
                                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                                            //  FILE_DELETE_CHILD           	 ,         ,     .
                                                            //  FILE_EXECUTE	                    ( ),   .   ,       ,
                                                            //                                   .
                                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                                            //  FILE_READ_ATTRIBUTES        	   .
                                                            //  FILE_READ_DATA	                ,     .   ,     .
                                                            //  FILE_READ_EA                	    .
                                                            //  FILE_TRAVERSE               	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,  
                                                            //                                 FILE_TRAVERSE.
                                                            //  FILE_WRITE_ATTRIBUTES	           .
                                                            //  FILE_WRITE_DATA	               ,     .   ,     .
                                                            //  FILE_WRITE_EA	                    .
                                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,            .
                                                            //                                        (SACL).
                                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,         .    
                                                            //                                    (SACL).
                                                            //  SYNCHRONIZE	                         .       -  (I/O),  
                                                            //                                    OVERLAPPED,       .
                                                            //      (generic access rights)    .
                                                            //   :              	:
                                                            //  0	                                  .     ,    .
                                                            //  GENERIC_ALL                   .
                                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA, STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                                  const DWORD dwShareMode); //    (, ,    ).     ,       ,
                                                            //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                            //     ,  CreateFile  ,     ,         ,    .
                                                            //        ,   ,    ,        ,
                                                            //    ,    ,   .          ,     .
                                                            //  FILE_SHARE_DELETE	       ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_READ	         ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_WRITE    	    ,      .   ,      ,
                                                            //                            .     ,         ,    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 3.5.2.       ,      .         ,  - NULL.    UNICODE-.
EXPFUNC(HANDLE) FileOpenTruncateW(LPCWSTR     szPathFile,   // UNICODE-  .
                                  const DWORD dwAccess,     //     (,     ).    ,        ,
                                                            //      ,      .     ,     
                                                            // ,    .     ,       ,    .
                                                            //     ,       -  ,   ,       .
                                                            //       ,      ,        .
                                                            //   :    	          :
                                                            //  FILE_ADD_FILE	                ,     .
                                                            //  FILE_ADD_SUBDIRECTORY       	 ,     .
                                                            //  FILE_ALL_ACCESS             	     .
                                                            //  FILE_APPEND_DATA	              ,      .   ,   .
                                                            //  FILE_CREATE_PIPE_INSTANCE	     ,   .
                                                            //  FILE_DELETE_CHILD           	 ,         ,     .
                                                            //  FILE_EXECUTE	                    ( ),   .   ,       ,
                                                            //                                   .
                                                            //  FILE_LIST_DIRECTORY         	 ,    .
                                                            //  FILE_READ_ATTRIBUTES        	   .
                                                            //  FILE_READ_DATA	                ,     .   ,     .
                                                            //  FILE_READ_EA                	    .
                                                            //  FILE_TRAVERSE               	 ,   .  ,    BYPASS_TRAVERSE_CHECKING,  
                                                            //                                 FILE_TRAVERSE.
                                                            //  FILE_WRITE_ATTRIBUTES	           .
                                                            //  FILE_WRITE_DATA	               ,     .   ,     .
                                                            //  FILE_WRITE_EA	                    .
                                                            //  STANDARD_RIGHTS_READ	            READ_CONTROL,            .
                                                            //                                        (SACL).
                                                            //  STANDARD_RIGHTS_WRITE	           WRITE_CONTROL,         .    
                                                            //                                    (SACL).
                                                            //  SYNCHRONIZE	                         .       -  (I/O),  
                                                            //                                    OVERLAPPED,       .
                                                            //      (generic access rights)    .
                                                            //   :              	:
                                                            //  0	                                  .     ,    .
                                                            //  GENERIC_ALL                   .
                                                            //  GENERIC_EXECUTE             	FILE_READ_ATTRIBUTES, STANDARD_RIGHTS_EXECUTE, SYNCHRONIZE.
                                                            //  GENERIC_READ                	FILE_READ_ATTRIBUTES, FILE_READ_DATA, FILE_READ_EA, STANDARD_RIGHTS_READ, SYNCHRONIZE.
                                                            //  GENERIC_WRITE	               FILE_APPEND_DATA, FILE_WRITE_ATTRIBUTES, FILE_WRITE_DATA, FILE_WRITE_EA, STANDARD_RIGHTS_WRITE, SYNCHRONIZE.
                                  const DWORD dwShareMode); //    (, ,    ).     ,       ,
                                                            //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                            //     ,  CreateFile  ,     ,         ,    .
                                                            //        ,   ,    ,        ,
                                                            //    ,    ,   .          ,     .
                                                            //  FILE_SHARE_DELETE	       ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_READ	         ,      .   ,      ,
                                                            //                            .     ,         ,    .
                                                            //  FILE_SHARE_WRITE    	    ,      .   ,      ,
                                                            //                            .     ,         ,    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 3.5.3.       ,      .         ,  - NULL.       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileOpenTruncate  FileOpenTruncateW
#else
 #define FileOpenTruncate  FileOpenTruncateA
#endif
//
// 4.      .
//
// 4.1.     .          .
EXPFUNC(INT64) FileGetPointer(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 4.2.             .          .
EXPFUNC(INT64) FileSetPointerBegin(const HANDLE hFile,            //   .
                                   const int    nDistanceToMove); //    .
//==============================================================================================================================================================================================================================================================
// 4.3.               .          .
EXPFUNC(INT64) FileSetPointerCurrent(const HANDLE hFile,            //   .
                                     const int    nDistanceToMove); //    .
//==============================================================================================================================================================================================================================================================
// 4.4.             .          .
EXPFUNC(INT64) FileSetPointerEnd(const HANDLE hFile,            //   .
                                 const int    nDistanceToMove); //    .
//
// 5.        .
//
// 5.1.       BOOL (1 )     .          .
EXPFUNC(INT) FileWriteBoolean(const HANDLE hFile,   //   .
                              const bool   bValue); //   BOOL    .
//==============================================================================================================================================================================================================================================================
// 5.2.       CHAR (1 )     .          .
EXPFUNC(INT) FileWriteChar(const HANDLE hFile,   //   .
                           const CHAR   cValue); //   CHAR    .
//==============================================================================================================================================================================================================================================================
// 5.3.       UCHAR (1 )     .          .
EXPFUNC(INT) FileWriteUChar(const HANDLE hFile,    //   .
                            const UCHAR  ucValue); //   UCHAR    .
//==============================================================================================================================================================================================================================================================
// 5.4.       SHORT (2 )     .          .
EXPFUNC(INT) FileWriteShort(const HANDLE hFile,    //   .
                            const SHORT  shValue); //   SHORT    .
//==============================================================================================================================================================================================================================================================
// 5.5.       USHORT (2 )     .          .
EXPFUNC(INT) FileWriteUShort(const HANDLE hFile,     //   .
                             const USHORT ushValue); //   USHORT    .
//==============================================================================================================================================================================================================================================================
// 5.6.       INT (4 )     .          .
EXPFUNC(INT) FileWriteInt(const HANDLE hFile,   //   .
                          const INT    nValue); //   INT    .
//==============================================================================================================================================================================================================================================================
// 5.7.       UINT (4 )     .          .
EXPFUNC(INT) FileWriteUInt(const HANDLE hFile,    //   .
                           const UINT   uiValue); //   UINT    .
//==============================================================================================================================================================================================================================================================
// 5.8.       INT64 (8 )     .          .
EXPFUNC(INT) FileWriteInt64(const HANDLE hFile,     //   .
                            const INT64  i64Value); //   INT64    .
//==============================================================================================================================================================================================================================================================
// 5.9.       UINT64 (8 )     .          .
EXPFUNC(INT) FileWriteUInt64(const HANDLE hFile,      //   .
                             const UINT64 ui64Value); //   UINT64    .
//==============================================================================================================================================================================================================================================================
// 5.10.       FLOAT (4 )     .          .
EXPFUNC(INT) FileWriteFlt(const HANDLE hFile,   //   .
                          const float  fValue); //   FLOAT    .
//==============================================================================================================================================================================================================================================================
// 5.11.       DOUBLE (8 )     .          .
EXPFUNC(INT) FileWriteDbl(const HANDLE hFile,   //   .
                          const double dValue); //   DOUBLE    .
//==============================================================================================================================================================================================================================================================
// 5.12.1.     ANSI-     .          .
EXPFUNC(INT) FileWriteStringA(const HANDLE hFile,     //   .
                              LPCSTR       szString); // ANSI-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 5.12.2.     UNICODE-     .          .
EXPFUNC(INT) FileWriteStringW(const HANDLE hFile,     //   .
                              LPCWSTR      szString); // UNICODE-    .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 5.12.3.             .          .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileWriteString  FileWriteStringW
#else
 #define FileWriteString  FileWriteStringA
#endif
//
// 6.      .
//
// 6.1.         BOOL (1 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteBoolArray(const HANDLE hFile,    //   .
                                   const pbool  pabArray, //        BOOL    .
                                   const SIZE_T stSize,   //   (  ).
                                   const SIZE_T stStart,  //     (   ).
                                         SIZE_T stCount); //   .
//==============================================================================================================================================================================================================================================================
// 6.2.         CHAR (1 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteCharArray(const HANDLE hFile,    //   .
                                   const PCHAR  pacArray, //       CHAR    .
                                   const SIZE_T stSize,   //   (  ).
                                   const SIZE_T stStart,  //     (   ).
                                         SIZE_T stCount); //   .
//==============================================================================================================================================================================================================================================================
// 6.3.         UCHAR (1 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteUCharArray(const HANDLE hFile,     //   .
                                    const PUCHAR paucArray, //       UCHAR    .
                                    const SIZE_T stSize,    //   (  ).
                                    const SIZE_T stStart,   //     (   ).
                                          SIZE_T stCount);  //   .
//==============================================================================================================================================================================================================================================================
// 6.4.         SHORT (2 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteShortArray(const HANDLE hFile,     //   .
                                    const PSHORT pashArray, //       SHORT    .
                                    const SIZE_T stSize,    //   (  ).
                                    const SIZE_T stStart,   //     (   ).
                                          SIZE_T stCount);  //   .
//==============================================================================================================================================================================================================================================================
// 6.5.         USHORT (2 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteUShortArray(const HANDLE  hFile,      //   .
                                     const PUSHORT paushArray, //       USHORT    .
                                     const SIZE_T  stSize,     //   (  ).
                                     const SIZE_T  stStart,    //     (   ).
                                           SIZE_T  stCount);   //   .
//==============================================================================================================================================================================================================================================================
// 6.6.         INT (4 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteIntArray(const HANDLE hFile,    //   .
                                  const PINT   panArray, //       INT    .
                                  const SIZE_T stSize,   //   (  ).
                                  const SIZE_T stStart,  //     (   ).
                                        SIZE_T stCount); //   .
//==============================================================================================================================================================================================================================================================
// 6.7.         UINT (4 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteUIntArray(const HANDLE hFile,     //   .
                                   const PUINT  pauiArray, //       UINT    .
                                   const SIZE_T stSize,    //   (  ).
                                   const SIZE_T stStart,   //     (   ).
                                         SIZE_T stCount);  //   .
//==============================================================================================================================================================================================================================================================
// 6.8.         INT64 (8 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteLongArray(const HANDLE hFile,      //   .
                                   const PINT64 pai64Array, //       INT64    .
                                   const SIZE_T stSize,     //   (  ).
                                   const SIZE_T stStart,    //     (   ).
                                         SIZE_T stCount);   //   .
//==============================================================================================================================================================================================================================================================
// 6.9.         UINT64 (8 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteULongArray(const HANDLE  hFile,       //   .
                                    const PUINT64 paui64Array, //       INT64    .
                                    const SIZE_T  stSize,      //   (  ).
                                    const SIZE_T  stStart,     //     (   ).
                                          SIZE_T  stCount);    //   .
//==============================================================================================================================================================================================================================================================
// 6.10.         FLOAT (4 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteFloatArray(const HANDLE hFile,    //   .
                                    PCFLOAT      pafArray, //       FLOAT    .
                                    const SIZE_T stSize,   //   (  ).
                                    const SIZE_T stStart,  //     (   ).
                                          SIZE_T stCount); //   .
//==============================================================================================================================================================================================================================================================
// 6.11.         DOUBLE (8 )      .         MAXUINT64.
EXPFUNC(UINT64) FileWriteDoubleArray(const HANDLE hFile,    //   .
                                     PCDOUBLE     padArray, //       DOUBLE    .
                                     const SIZE_T stSize,   //   (  ).
                                     const SIZE_T stStart,  //     (   ).
                                           SIZE_T stCount); //   .
//==============================================================================================================================================================================================================================================================
// 6.12.1.      ANSI-      .   ,            ("\r\n").
//                 MAXUINT64.
EXPFUNC(UINT64) FileWriteStrArrayA(const HANDLE hFile,     //   .
                                   LPCSTR*      lpszArray, //      ANSI-    .
                                   const SIZE_T stSize,    //   (     ).
                                   const SIZE_T stStart,   //     (   ).
                                         SIZE_T stCount);  //   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 6.12.2.      UNICODE-      .   ,            ("\r\n").
//                 MAXUINT64.
EXPFUNC(UINT64) FileWriteStrArrayW(const HANDLE hFile,     //   .
                                   LPCWSTR*     lpszArray, //      UNICODE-    .
                                   const SIZE_T stSize,    //   (     ).
                                   const SIZE_T stStart,   //     (   ).
                                         SIZE_T stCount);  //   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 6.12.3.               .   ,            ("\r\n").
//                 MAXUINT64.
#if defined(UNICODE) || defined(_UNICODE)
 #define FileWriteStrArray  FileWriteStrArrayW
#else
 #define FileWriteStrArray  FileWriteStrArrayA
#endif
//==============================================================================================================================================================================================================================================================
// 6.13.1.        MQLSTRA      .
//           ,            ("\r\n").
//                 MAXUINT64.
EXPFUNC(UINT64) FileWriteStrArrayMA(const HANDLE       hFile,     //   .
                                    const MT::PMQLSTRA pamsArray, //     MQLSTRA-    .
                                    const SIZE_T       stSize,    //   (  ).
                                    const SIZE_T       stStart,   //     (   ).
                                    const SIZE_T       stCount);  //   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 6.13.2.        MQLSTRW      .
//           ,            ("\r\n").
//                 MAXUINT64.
EXPFUNC(UINT64) FileWriteStrArrayMW(const HANDLE       hFile,     //   .
                                    const MT::PMQLSTRW pamsArray, //     MQLSTRW-    .
                                    const SIZE_T       stSize,    //   (  ).
                                    const SIZE_T       stStart,   //     (   ).
                                    const SIZE_T       stCount);  //   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 6.13.3.        MQLSTR         .
//           ,            ("\r\n").
//                 MAXUINT64.
#if defined(UNICODE) || defined(_UNICODE)
 #define FileWriteStrArrayM  FileWriteStrArrayMW
#else
 #define FileWriteStrArrayM  FileWriteStrArrayMA
#endif
//
// 7.        .
//
// 7.1.       BOOL (1 )   .         FALSE.
EXPFUNC(bool) FileReadBoolean(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.2.       CHAR (1 )   .         0.
EXPFUNC(CHAR) FileReadChar(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.3.       UCHAR (1 )   .         0.
EXPFUNC(UCHAR) FileReadUChar(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.4.       SHORT (2 )   .         0.
EXPFUNC(SHORT) FileReadShort(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.5.       USHORT (2 )   .         0.
EXPFUNC(USHORT) FileReadUShort(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.6.       INT (4 )   .         0.
EXPFUNC(INT) FileReadInt(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.7.       UINT (4 )   .         0.
EXPFUNC(UINT) FileReadUInt(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.8.       INT64 (8 )   .         0.
EXPFUNC(INT64) FileReadInt64(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.9.       UINT64 (8 )   .         0.
EXPFUNC(UINT64) FileReadUInt64(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.10.       FLOAT (4 )   .         0.
EXPFUNC(FLOAT) FileReadFlt(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.11.       DOUBLE (8 )   .         0.
EXPFUNC(double) FileReadDbl(const HANDLE hFile); //   .
//==============================================================================================================================================================================================================================================================
// 7.12.1.     ANSI-     .         NULL.
EXPFUNC(LPSTR) FileReadStringA(const HANDLE hFile,    //   .
                               const SIZE_T stCount); //   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 7.12.2.     UNICODE-     .         NULL.
EXPFUNC(LPWSTR) FileReadStringW(const HANDLE hFile,    //   .
                                const SIZE_T stCount); //   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 7.12.3.             .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileReadString  FileReadStringW
#else
 #define FileReadString  FileReadStringA
#endif
//
// 8.      .
//
// 8.1.         BOOL (1 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadBoolArray(const HANDLE hFile,    //   .
                                        pbool  pabArray, //          BOOL  .
                                  const SIZE_T stSize,   //   (  ).
                                  const SIZE_T stStart,  //     (   ).
                                        SIZE_T stCount); //   .
//==============================================================================================================================================================================================================================================================
// 8.2.         CHAR (1 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadCharArray(const HANDLE hFile,    //   .
                                        PCHAR  pacArray, //          CHAR  .
                                  const SIZE_T stSize,   //   (  ).
                                  const SIZE_T stStart,  //     (   ).
                                        SIZE_T stCount); //   .
//==============================================================================================================================================================================================================================================================
// 8.3.         UCHAR (1 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadUCharArray(const HANDLE hFile,     //   .
                                         PUCHAR paucArray, //          UCHAR  .
                                   const SIZE_T stSize,    //   (  ).
                                   const SIZE_T stStart,   //     (   ).
                                         SIZE_T stCount);  //   .
//==============================================================================================================================================================================================================================================================
// 8.4.         SHORT (2 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadShortArray(const HANDLE hFile,     //   .
                                         PSHORT pashArray, //          SHORT  .
                                   const SIZE_T stSize,    //   (  ).
                                   const SIZE_T stStart,   //     (   ).
                                         SIZE_T stCount);  //   .
//==============================================================================================================================================================================================================================================================
// 8.5.         USHORT (2 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadUShortArray(const HANDLE  hFile,      //   .
                                          PUSHORT paushArray, //          USHORT  .
                                    const SIZE_T  stSize,     //   (  ).
                                    const SIZE_T  stStart,    //     (   ).
                                          SIZE_T  stCount);   //   .
//==============================================================================================================================================================================================================================================================
// 8.6.         INT (4 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadIntArray(const HANDLE hFile,    //   .
                                       PINT   panArray, //          INT  .
                                 const SIZE_T stSize,   //   (  ).
                                 const SIZE_T stStart,  //     (   ).
                                       SIZE_T stCount); //   .
//==============================================================================================================================================================================================================================================================
// 8.7.         UINT (4 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadUIntArray(const HANDLE hFile,     //   .
                                        PUINT  pauiArray, //          UINT  .
                                  const SIZE_T stSize,    //   (  ).
                                  const SIZE_T stStart,   //     (   ).
                                        SIZE_T stCount);  //   .
//==============================================================================================================================================================================================================================================================
// 8.8.         INT64 (8 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadLongArray(const HANDLE hFile,      //   .
                                        PINT64 pai64Array, //          INT64  .
                                  const SIZE_T stSize,     //   (  ).
                                  const SIZE_T stStart,    //     (   ).
                                        SIZE_T stCount);   //   .
//==============================================================================================================================================================================================================================================================
// 8.9.         UINT64 (8 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadULongArray(const HANDLE  hFile,       //   .
                                         PUINT64 paui64Array, //          UINT64  .
                                   const SIZE_T  stSize,      //   (  ).
                                   const SIZE_T  stStart,     //     (   ).
                                         SIZE_T  stCount);    //   .
//==============================================================================================================================================================================================================================================================
// 8.10.         FLOAT (4 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadFloatArray(const HANDLE hFile,    //   .
                                         PFLOAT pafArray, //          FLOAT  .
                                   const SIZE_T stSize,   //   (  ).
                                   const SIZE_T stStart,  //     (   ).
                                         SIZE_T stCount); //   .
//==============================================================================================================================================================================================================================================================
// 8.11.         DOUBLE (8 )      .         MAXUINT64.
EXPFUNC(UINT64) FileReadDoubleArray(const HANDLE  hFile,    //   .
                                          PDOUBLE padArray, //          DOUBLE  .
                                    const SIZE_T  stSize,   //   (  ).
                                    const SIZE_T  stStart,  //     (   ).
                                          SIZE_T  stCount); //   .
//==============================================================================================================================================================================================================================================================
// 8.12.1.      ANSI-      .         MAXUINT64.
EXPFUNC(UINT64) FileReadStrArrayA(const HANDLE hFile,     //   .
                                        LPSTR* lpszArray, //      ANSI-       .
                                  const SIZE_T stSize0,   //   (  ).
                                  const SIZE_T stSize1,   //           .       .
                                  const SIZE_T stStart,   //     (   ).
                                  const SIZE_T stCount);  //   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 8.12.2.      UNICODE-      .         MAXUINT64.
EXPFUNC(UINT64) FileReadStrArrayW(const HANDLE  hFile,     //   .
                                        LPWSTR* lpszArray, //      UNICODE-       .
                                  const SIZE_T  stSize0,   //   (  ).
                                  const SIZE_T  stSize1,   //           .       .
                                  const SIZE_T  stStart,   //     (   ).
                                  const SIZE_T  stCount);  //   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 8.12.3.               .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileReadStrArray  FileReadStrArrayW
#else
 #define FileReadStrArray  FileReadStrArrayA
#endif
//==============================================================================================================================================================================================================================================================
// 8.13.1.      MQLSTRA-      .         MAXUINT64.
EXPFUNC(UINT64) FileReadStrArrayMA(const HANDLE       hFile,     //   .
                                         MT::PMQLSTRA pamsArray, //    MQLSTRA-       CHAR  .
                                   const SIZE_T       stSize,    //   (  ).
                                   const SIZE_T       stStart,   //     (   ).
                                   const SIZE_T       stCount);  //   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 8.13.2.      MQLSTRW-      .         MAXUINT64.
EXPFUNC(UINT64) FileReadStrArrayMW(const HANDLE       hFile,     //   .
                                         MT::PMQLSTRW pamsArray, //    MQLSTRW-       WCHAR  .
                                   const SIZE_T       stSize,    //   (  ).
                                   const SIZE_T       stStart,   //     (   ).
                                   const SIZE_T       stCount);  //   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 8.13.3.      MQLSTR-         .         MAXUINT64.
#if defined(UNICODE) || defined(_UNICODE)
 #define FileReadStrArrayM  FileReadStrArrayMW
#else
 #define FileReadStrArrayM  FileReadStrArrayMA
#endif
//
// 9.    /.
//
//        ! ,   ,  ,    .
//
// 9.1.1.     ,   ,    ,    .
//               .      .    ANSI-.
EXPFUNC(UINT64) FileCompletedA(LPCSTR       szPathFile,           // ANSI-  .
                               const WORD   wCreationDisposition, //    :
                                                                  //   CREATE_NEW	           .   ,     .
                                                                  //   CREATE_ALWAYS	        .   ,   .
                                                                  //   OPEN_EXISTING	       .   ,    .
                                                                  //   OPEN_ALWAYS        	 ,   .    ,   ,    dwCreationDisposition   CREATE_NEW.
                                                                  //   TRUNCATE_EXISTING  	     ,      .
                               const int    nMoveMethod,          //    : SEEK_CUR -   ,
                                                                  //                                      SEEK_SET -  ,
                                                                  //                                      SEEK_END -   .
                               const INT64  i64DistanceToMove,    //    .
                               const WORD   wAccesse,             //   : FILE_WRITE - ; FILE_READ - .
                               const DWORD dwShareMode,           //    (, ,    ).     ,       ,
                                                                  //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                                  //     ,  CreateFile  ,     ,         ,    .
                                                                  //        ,   ,    ,        ,
                                                                  //    ,    ,   .          ,     .
                                                                  //  SHARE_DELETE	       ,      .   ,      ,
                                                                  //                       .     ,         ,    .
                                                                  //  SHARE_READ	         ,      .   ,      ,
                                                                  //                       .     ,         ,    .
                                                                  //  SHARE_WRITE    	    ,      .   ,      ,
                                                                  //                       .     ,         ,    .
                                     LPVOID lpData,               //      /.
                               const SIZE_T stBytes);             //          lpData.
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 9.1.2.     ,   ,    ,    .
//               .      .    UNICODE-.
EXPFUNC(UINT64) FileCompletedW(LPCWSTR      szPathFile,           // UNICODE-  .
                               const WORD   wCreationDisposition, //    :
                                                                  //   CREATE_NEW	           .   ,     .
                                                                  //   CREATE_ALWAYS	        .   ,   .
                                                                  //   OPEN_EXISTING	       .   ,    .
                                                                  //   OPEN_ALWAYS        	 ,   .    ,   ,    dwCreationDisposition   CREATE_NEW.
                                                                  //   TRUNCATE_EXISTING  	     ,      .
                               const INT    nMoveMethod,          //    : SEEK_CUR -   ,
                                                                  //                                      SEEK_SET -  ,
                                                                  //                                      SEEK_END -   .
                               const INT64  i64DistanceToMove,    //    .
                               const WORD   wAccesse,             //   : FILE_WRITE - ; FILE_READ - .
                               const DWORD dwShareMode,           //    (, ,    ).     ,       ,
                                                                  //      ,      .  ,        (ERROR_SHARING_VIOLATION).
                                                                  //     ,  CreateFile  ,     ,         ,    .
                                                                  //        ,   ,    ,        ,
                                                                  //    ,    ,   .          ,     .
                                                                  //  SHARE_DELETE	       ,      .   ,      ,
                                                                  //                       .     ,         ,    .
                                                                  //  SHARE_READ	         ,      .   ,      ,
                                                                  //                       .     ,         ,    .
                                                                  //  SHARE_WRITE    	    ,      .   ,      ,
                                                                  //                       .     ,         ,    .
                                     LPVOID lpData,               //      /.
                               const SIZE_T stBytes);             //          lpData.
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 9.1.3.     ,   ,    ,    .
//               .      .       .
#if defined(UNICODE) || defined(_UNICODE)
 #define FileCompleted  FileCompletedW
#else
 #define FileCompleted  FileCompletedA
#endif
//==============================================================================================================================================================================================================================================================
// 9.2.               .         MAXUINT64.
EXPFUNC(UINT64) FileReadVoid(const HANDLE hFile,    //   .
                                   LPVOID lpData,   //        .
                             const SIZE_T stBytes); //       lpData   .
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// 9.3.               .         MAXUINT64.
EXPFUNC(UINT64) FileWriteVoid(const HANDLE hFile,    //   .
                              LPCVOID      lpData,   //        .
                              const SIZE_T stBytes); //       lpData.
//