//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                                    kosma-2.02.mq4 |
//| pu6ka@mail.ru                                                                                                     |
//+-------------------------------------------------------------------------------------------------------------------+
#property indicator_separate_window
#property indicator_buffers 7
#property indicator_color1 Magenta
#property indicator_color4 Yellow
#property indicator_color5 Yellow
#property indicator_color6 Green
#property indicator_color7 Red

extern int       fast = 12;
extern int       slow = 26;
extern int        sig = 9;
extern int          k = 1;                      // .  OsMA
extern int          n = 2;                      // -  /     /
extern bool drawDivergenceLines = true;         //     ,    
int  history=15000;

double OsMA[];
double bullishDivergence[];
double bearishDivergence[];
double peak[];
double trough[];
double bulliShift[];
double beariShift[];
//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                   |
//+-------------------------------------------------------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE,0,1);
   SetIndexStyle(3,DRAW_ARROW);
   SetIndexStyle(4,DRAW_ARROW);
   SetIndexStyle(5,DRAW_ARROW);
   SetIndexStyle(6,DRAW_ARROW);
//----   
   SetIndexBuffer(0, OsMA);               //     OsMA[]
   SetIndexBuffer(1, bullishDivergence);  //      ""
   SetIndexBuffer(2, bearishDivergence);  //      ""
   SetIndexBuffer(3, peak);               //    
   SetIndexBuffer(4, trough);             //    
   SetIndexBuffer(5, bulliShift);         //      ""  
   SetIndexBuffer(6, beariShift);         //      ""  
//----   
   SetIndexArrow(5, 233);                 //   " "  bullishDivergence 
   SetIndexArrow(6, 234);                 //   " "  bearishDivergence
   SetIndexArrow(3, 116);                 //     
   SetIndexArrow(4, 116);                 //    
//----
   IndicatorDigits(Digits+2);
   IndicatorShortName("kosma-2.02 ("+fast+","+slow+","+sig+")"+" k"+k+" n"+n);
   return(0);
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                   |
//+-------------------------------------------------------------------------------------------------------------------+
int deinit()
  {
   for(int i=ObjectsTotal()-1; i>=0; i--)
     {
      string label=ObjectName(i);
      if(StringSubstr(label,0,14)!="DivergenceLine")
         continue;
      ObjectDelete(label);
     }
   return(0);
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                   |
//+-------------------------------------------------------------------------------------------------------------------+
int start()
  {
   int countedBars = IndicatorCounted();        // -  
   if(countedBars < 0) countedBars = 0;         // ,    0.
   CalculateIndicator(countedBars);
   return(0);
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                   |
//+-------------------------------------------------------------------------------------------------------------------+
void CalculateIndicator(int countedBars)
  {
   int j=Bars-countedBars;                      //    
   if(countedBars==0) j-=2*n+1;
   for(int i=j; i>=0; i--)
     {
      CalculateOsMA(i);
      CatchBullishDivergence(i+n);
      CatchBearishDivergence(i+n);
     }
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|        OsMA[]                                                                 |
//+-------------------------------------------------------------------------------------------------------------------+
void CalculateOsMA(int i)
  {
   OsMA[i]=iOsMA(NULL,0,fast*k,slow*k,sig*k,PRICE_WEIGHTED,i);
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|       ""                                                                        |
//+-------------------------------------------------------------------------------------------------------------------+
void CatchBullishDivergence(int shift) // shift = i+n
  {
   int idTrough=IsIndicatorTrough(shift);                //  ,       
   if(idTrough < 0) return;                              //  
   int currentTrough = shift;                            //  ,   , n-   
   int lastTrough = GetIndicatorLastTrough(idTrough);    //    
                                                         //  .     Low .   Low    -   >
   if(OsMA[currentTrough]>OsMA[lastTrough] && Low[currentTrough]<Low[lastTrough])
     {
      bullishDivergence[currentTrough]=OsMA[currentTrough];  //  .OsMA     
      bulliShift[currentTrough-n]=OsMA[currentTrough];  //  .OsMA     
      if(drawDivergenceLines) DrawArrowOnChart(currentTrough,1);
      //trough[shift] = EMPTY_VALUE;                           //       
      if(drawDivergenceLines==true) //  ,   true  .
        {
         DrawPriceTrendLine(Time[currentTrough],Time[lastTrough],Low[currentTrough],
                            Low[lastTrough],Green,STYLE_SOLID);
         DrawIndicatorTrendLine(Time[currentTrough],Time[lastTrough],OsMA[currentTrough],
                                OsMA[lastTrough],Green,STYLE_SOLID);
        }
     }
//  .     Low .      -    <
   if(OsMA[currentTrough]<OsMA[lastTrough] && Low[currentTrough]>Low[lastTrough])
     {
      bullishDivergence[currentTrough]=OsMA[currentTrough];  //  .OsMA     
      bulliShift[currentTrough-n]=OsMA[currentTrough];  //  .OsMA     
      if(drawDivergenceLines) DrawArrowOnChart(currentTrough,1);
      //trough[shift] = EMPTY_VALUE;                           //       
      if(drawDivergenceLines==true) //  ,   true  .
        {
         DrawPriceTrendLine(Time[currentTrough],Time[lastTrough],Low[currentTrough],
                            Low[lastTrough],Green,STYLE_DOT);
         DrawIndicatorTrendLine(Time[currentTrough],Time[lastTrough],OsMA[currentTrough],
                                OsMA[lastTrough],Green,STYLE_DOT);
        }
     }
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|     ""                                                                           |
//+-------------------------------------------------------------------------------------------------------------------+
void CatchBearishDivergence(int shift) // shift = i+n
  {
   int idPeak=IsIndicatorPeak(shift);                    //  ,       
   if(idPeak<0) return;                                  //  
   int currentPeak = shift;                              //  ,   , n-   
   int lastPeak = GetIndicatorLastPeak(idPeak);          //    
                                                         //  .     .      -   <
   if(lastPeak>=0&&OsMA[currentPeak]<OsMA[lastPeak] && High[currentPeak]>High[lastPeak])
     {
      bearishDivergence[currentPeak]=OsMA[currentPeak];  //     
      beariShift[currentPeak-n]=OsMA[currentPeak];  //     
      if(drawDivergenceLines) DrawArrowOnChart(currentPeak,2);
      //peak[shift] = EMPTY_VALUE;                         //       
      if(drawDivergenceLines==true) //  ,   true  .
        {
         DrawPriceTrendLine(Time[currentPeak],Time[lastPeak],High[currentPeak],
                            High[lastPeak],Red,STYLE_SOLID);
         DrawIndicatorTrendLine(Time[currentPeak],Time[lastPeak],OsMA[currentPeak],
                                OsMA[lastPeak],Red,STYLE_SOLID);
        }
     }
//  .     .      -   >
   if(lastPeak>=0&&OsMA[currentPeak]>OsMA[lastPeak] && High[currentPeak]<High[lastPeak])
     {
      bearishDivergence[currentPeak]=OsMA[currentPeak];  //     
      beariShift[currentPeak-n]=OsMA[currentPeak];  //     
      if(drawDivergenceLines) DrawArrowOnChart(currentPeak,2);
      //peak[shift] = EMPTY_VALUE;                         //       
      if(drawDivergenceLines==true) //  ,   true  .
        {
         DrawPriceTrendLine(Time[currentPeak],Time[lastPeak],High[currentPeak],
                            High[lastPeak],Red,STYLE_DOT);
         DrawIndicatorTrendLine(Time[currentPeak],Time[lastPeak],OsMA[currentPeak],
                                OsMA[lastPeak],Red,STYLE_DOT);
        }
     }
  }
//+-------------------------------------------------------------------------------------------------------------------+
//| -    for -   /\    n-      .  |
//|      ,    (    i-),  n- .       |
//| ,  ,  , ,    .   ,  -   |
//|   ,     .       (-1)         |
//|    for       1 ,   ,     |
//+-------------------------------------------------------------------------------------------------------------------+
int IsIndicatorPeak(int shift) //    shift = i+n
  {
   int i,m=0;
   for(i=0; i<n; i++)
     {                   // 
      if((OsMA[shift+i]>OsMA[shift+i+1] && OsMA[shift-i]>OsMA[shift-i-1]) || 
         (OsMA[shift]>OsMA[shift+i+1] && OsMA[shift]>OsMA[shift-i-1]))
        {
         m++; continue;
        }
      else return(-1);                       //   . "false"
     }
   if(m==n)
     {
      peak[shift] = OsMA[shift];             //     
      for(i = shift + n; i < Bars; i++)      //    OsMA    
         if(OsMA[i] < OsMA[i+1])             // OsMA , .  i+1
            return(i);                       //      -   
     }
   return(-1);                               //   . "false"
  }
//+-------------------------------------------------------------------------------------------------------------------+
//| -    for -   V    n-      .|
//|      ,    (    i-),  n- .       |
//| ,  ,  , ,    .   ,  - |
//|   ,     .       (-1)         |
//|    for       1 ,   ,     |
//+-------------------------------------------------------------------------------------------------------------------+
int IsIndicatorTrough(int shift) //   V  shift = i + n
  {
   int i,m=0;
   for(i=0; i<n; i++)
     {                   // 
      if((OsMA[shift+i]<OsMA[shift+i+1] && OsMA[shift-i]<OsMA[shift-i-1]) || 
         (OsMA[shift]<OsMA[shift+i+1] && OsMA[shift]<OsMA[shift-i-1]))
        {
         m++; continue;
        }
      else return(-1);                       //   . "false"
     }
   if(m==n)
     {
      trough[shift] = OsMA[shift];           //     
      for(i = shift + n; i < Bars-n; i++)      //    OsMA    
        {
         if(OsMA[i] > OsMA[i+1])             // OsMA , .  i+1
            return(i);                       //      -   
        }
     }
   return(-1);                               //   . "false"
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                       |
//| ,                                                          |
//+-------------------------------------------------------------------------------------------------------------------+
int GetIndicatorLastPeak(int idPeak)
  {
   for(int i=idPeak+1; i<Bars; i++) //       
     {
      if(peak[i]!=NULL && peak[i]!=EMPTY_VALUE) //    
         return(i);                                         //   
     }
   return(-1);
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                     |
//|       trough[i]                                                           |
//+-------------------------------------------------------------------------------------------------------------------+
int GetIndicatorLastTrough(int idTrough)
  {
   for(int i= idTrough+1; i<history; i++)
     {                       //       
      if(trough[i] != NULL && trough[i] != EMPTY_VALUE)          //               
         return(i);                                              //   
     }
   return(-1);
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                   |
//+-------------------------------------------------------------------------------------------------------------------+
void DrawPriceTrendLine(datetime x1,datetime x2,double y1,
                        double y2,color lineColor,double style)
  {
   string label="DivergenceLine2.1# "+DoubleToStr(x1,0);
   ObjectDelete(label);
   ObjectCreate(label,OBJ_TREND,0,x1,y1,x2,y2,0,0);
   ObjectSet(label,OBJPROP_RAY,0);
   ObjectSet(label,OBJPROP_COLOR,lineColor);
   ObjectSet(label,OBJPROP_STYLE,style);
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                   |
//+-------------------------------------------------------------------------------------------------------------------+
void DrawIndicatorTrendLine(datetime x1,datetime x2,double y1,
                            double y2,color lineColor,double style)
  {
   int indicatorWindow=WindowFind("kosma-2.02 ("+fast+","+slow+","+sig+")"+" k"+k+" n"+n);
   if(indicatorWindow<0)
      return;
   string label="DivergenceLine2.1$# "+DoubleToStr(x1,0);
   ObjectDelete(label);
   ObjectCreate(label,OBJ_TREND,indicatorWindow,x1,y1,x2,y2,0,0);
   ObjectSet(label,OBJPROP_RAY,0);
   ObjectSet(label,OBJPROP_COLOR,lineColor);
   ObjectSet(label,OBJPROP_STYLE,style);
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                   |
//+-------------------------------------------------------------------------------------------------------------------+
void DrawArrowOnChart(int shift,int updn)
  {
   string label="DivergenceLine2.1# "+DoubleToStr(Time[shift-n]+updn,0);
   ObjectDelete(label);
   if(updn==1)
     {
      ObjectCreate(label,OBJ_ARROW,0,Time[shift-n],Low[shift-n]);
      ObjectSet(label,OBJPROP_ARROWCODE,233);
      ObjectSet(label,OBJPROP_COLOR,Green);
     }
   if(updn==2)
     {
      ObjectCreate(label,OBJ_ARROW,0,Time[shift-n],High[shift-n]);
      ObjectSet(label,OBJPROP_ARROWCODE,234);
      ObjectSet(label,OBJPROP_COLOR,Red);
     }
  }
//+-------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                   |
//+-------------------------------------------------------------------------------------------------------------------+
