//+------------------------------------------------------------------+
//|                                                HL_Bar.mq4        |
//|                                                                  |
//|                                 http://sany000000k.narod2.ru/    |
//+------------------------------------------------------------------+
 
#property link      "http://sany000000k.narod2.ru/"
#property copyright "sanyooooook"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Red
#property indicator_color2 Blue
#property indicator_color3 DodgerBlue
//---- input parameters
extern int Period_ = 5;
extern int TF=1440;
//---- buffers
double UpBuffer[];
double DnBuffer[];
double MdBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   if(TF<Period())TF=Period();
   if(Period_<=0)Period_=1;
   string short_name;
//---- indicator line
   SetIndexStyle(0, DRAW_LINE);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexStyle(2, DRAW_LINE);
   SetIndexBuffer(0, UpBuffer);
   SetIndexBuffer(1, DnBuffer);
   SetIndexBuffer(2, MdBuffer);
//---- name for DataWindow and indicator subwindow label
   short_name="Price Channel("+Period_+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0, "UpCh");
   SetIndexLabel(1, "DownCh");
   SetIndexLabel(2, "MidCh");
//----
   SetIndexDrawBegin(0, Period_);
   SetIndexDrawBegin(1, Period_);
   SetIndexDrawBegin(2, Period_);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Price Channel                                                         |
//+------------------------------------------------------------------+
int start()
  {
   int i, counted_bars = IndicatorCounted();
   int    k;
   double high, low, price;
//----
   if(iBars(NULL,0) <= Period_) 
       return(0);
//---- initial zero
   if(counted_bars < 1)
      for(i = 1;i <= Period_; i++) 
          UpBuffer[iBars(NULL,0)-i] = 0.0;
//----
   i = iBars(NULL,0) - Period_ - 1;
   if(counted_bars >= Period_) 
       i = iBars(NULL,0) - counted_bars - 1;
   while(i >= 0)
   {
       double SredOPMA=0,
       SredHiOp=0,
       SredOpLo=0;
       for(int j=iBarShift(NULL,TF,iTime(NULL,0,i))+1;j<=iBarShift(NULL,TF,iTime(NULL,0,i))+Period_;j++)
       {
          SredOPMA=SredOPMA+MathAbs(iMA(NULL,TF,Period_,0,1,1,j)-iOpen(NULL,TF,j));
          SredHiOp=SredHiOp+MathAbs(iHigh(NULL,TF,j)-iOpen(NULL,TF,j));
          SredOpLo=SredOpLo+MathAbs(iOpen(NULL,TF,j)-iLow(NULL,TF,j));
       }
       SredOPMA=SredOPMA/Period_;
       SredHiOp=SredHiOp/Period_;
       SredOpLo=SredOpLo/Period_;
       UpBuffer[i]=iOpen(NULL,TF,iBarShift(NULL,TF,iTime(NULL,0,i)))+SredHiOp;
       DnBuffer[i]=iOpen(NULL,TF,iBarShift(NULL,TF,iTime(NULL,0,i)))-SredOpLo;
       MdBuffer[i]=iOpen(NULL,TF,iBarShift(NULL,TF,iTime(NULL,0,i)));
       i--;
   }
   return(0);
  }
//+------------------------------------------------------------------+