//+------------------------------------------------------------------+
//|                                                      _Symbol.mq4 |
//|           Copyright  2012. XrustSolution. mail:xrustx@gmail.com |
//|          http://www.youtube.com/user/opmlv http://forexrust.info |
//+------------------------------------------------------------------+
#property copyright "Copyright  2012. XrustSolution. mail:xrustx@gmail.com"
#property link      "http://www.youtube.com/user/opmlv http://forexrust.info"
//+------------------------------------------------------------------+
//| Super Global Variables                                           |
//+------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_buffers 4
#property indicator_width1 0
#property indicator_width2 0
//+------------------------------------------------------------------+
//| Extern Variables                                                 |
//+------------------------------------------------------------------+
extern   color    Chart_Color                             = Teal     ;
extern   string   SYMBOL                                  = "USDCHF" ;
extern   bool     Mirror                                  = false    ; 
extern   bool     Sinshronise_Daily_Weekly                = true     ;
extern   double   Scale_Multyplier                        = 1        ; 
extern   int      Bars_Back                               = 2000     ;   	
//+------------------------------------------------------------------+
//|   Defines & Global variavles                                     |
//+------------------------------------------------------------------+
#define empty  EMPTY_VALUE
//+------------------------------------------------------------------+
string _sy;
int    _per;
//--- buffers
double hi[];
double lo[];
double op[];
double cl[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void init(){_sy = StringUpper(SYMBOL);
   if(StringLen(_sy)<4){_sy = Symbol();}
   IndicatorShortName(_sy);
   IndicatorDigits(MarketInfo(_sy,MODE_DIGITS));
   if(Sinshronise_Daily_Weekly){
      _per = PERIOD_D1;
   }else{
      _per = PERIOD_W1;
   }
   if(Scale_Multyplier==0){
      Scale_Multyplier=1;
   }
   if(Scale_Multyplier > 1000){
      Scale_Multyplier=1000;
   }
	//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM,EMPTY,0,Chart_Color);
   SetIndexBuffer(0,hi);
   SetIndexEmptyValue(0,EMPTY_VALUE);
   SetIndexLabel(0,_sy);
   SetIndexStyle(1,DRAW_HISTOGRAM,EMPTY,0,Chart_Color);
   SetIndexBuffer(1,lo);
   SetIndexEmptyValue(1,EMPTY_VALUE);
   SetIndexLabel(1,_sy);
   SetIndexStyle(2,DRAW_HISTOGRAM,EMPTY,1,Chart_Color);
   SetIndexBuffer(2,op);
   SetIndexEmptyValue(2,EMPTY_VALUE);
   SetIndexLabel(2,_sy);
   SetIndexStyle(3,DRAW_HISTOGRAM,EMPTY,1,Chart_Color);
   SetIndexBuffer(3,cl);
   SetIndexEmptyValue(3,EMPTY_VALUE);
   SetIndexLabel(3,_sy);
	//----
return;}
//+------------------------------------------------------------------+
void deinit(){return;}
//+------------------------------------------------------------------+
void start(){	
	//----    
	static int pretime=0;
	static double prerp = 0;	 
   int i, ii = 0, counted = IndicatorCounted();
   if (counted > 0) counted--;
   int limit = Bars - counted;
   int per   = Period();
   string sy = Symbol();
   string txt="";
   //----    
   double op_1,op_2,_hi,_lo,_op,_cl;
   double ss = iOpen(sy,_per,0)/iOpen(_sy,_per,0);
   if(ss<1){ss=ss*MathPow(10,(Digits-MarketInfo(_sy,MODE_DIGITS)));}
   double sm, mno = (Point/MarketInfo(_sy,MODE_POINT))*ss*Scale_Multyplier;
   if(Bars_Back!=0){limit=Bars_Back;}
   if(limit < 5){limit=5;}
   //----   
	int width = GetChartScale();
	SetIndexStyle(0,DRAW_HISTOGRAM,EMPTY,0);
	SetIndexStyle(1,DRAW_HISTOGRAM,EMPTY,0);
   SetIndexStyle(2,DRAW_HISTOGRAM,EMPTY,width);
   SetIndexStyle(3,DRAW_HISTOGRAM,EMPTY,width);
	//----   
   for(i=0;i<limit;i++){
      //----    ()
      while(iBarShift(_sy,per,iTime(sy,per,ii),true)<0){
         ii++;
         continue;
      }
      //----      
      op_1 = iOpen(sy ,_per,iBarShift(sy ,_per,iTime(sy,per,ii)));
      op_2 = iOpen(_sy,_per,iBarShift(_sy,_per,iTime(_sy,per,i))); 
      sm = op_1 - op_2 * mno;    
      //----     
      _hi = sm + iHigh(_sy,per,i)*mno;
      _lo = sm + iLow(_sy,per,i)*mno;
      _op = sm + iOpen(_sy,per,i)*mno;
      _cl = sm + iClose(_sy,per,i)*mno;
      //----  
      if(Mirror){
         _hi += 2 * (op_1-_hi);
         _lo += 2 * (op_1-_lo); 
         _op += 2 * (op_1-_op); 
         _cl += 2 * (op_1-_cl);       
      }
      //----  
      hi[ii] = _hi;
	   lo[ii] = _lo;
      op[ii] = _op;
   	cl[ii] = _cl;
   	//----  
	   if(op[ii]==lo[ii]){op[ii]+=Point;}
	   ii++;
   }
	//----
return;}
//+------------------------------------------------------------------+
//|   includes                                                       |
//+------------------------------------------------------------------+
#import "user32.dll"
	bool GetWindowRect(int h, int& pos[4]);
#import
//+------------------------------------------------------------------+
//|          Function  : int GetChartScale()[1,2,4,6,13]             |
//|          Copyright  2012, XrustSolution.  mail:xrustx@gmail.com |
//|          http://www.youtube.com/user/opmlv http://forexrust.info |
//+------------------------------------------------------------------+
//|          Description: Return bar width in current chart scale    |
//+------------------------------------------------------------------+
int GetChartScale(){
	int h = WindowHandle(Symbol(), Period());
	int rect[4];
	if(h==0) return(1);
	GetWindowRect(h, rect);
	int wW  = rect[2] - rect[0]; //  
	int bpc = WindowBarsPerChart();
	if(bpc==0) return(1);
	int scale = MathFloor((wW-48)/bpc);
	switch(scale){
		case  1 :	return(0);
		case  2 :	return(1);
		case  4 :	return(2);
		case  8 :	return(4);
		case 16 :	return(7);
		case 32 :	return(14);
		default :   return(1);
	}
	return(1);
}
//+------------------------------------------------------------------+
//|      :   . aka KimIV,  http://www.kimiv.ru         |
//+------------------------------------------------------------------+
//|     : 01.09.2005                                           |
//|   :                      |
//+------------------------------------------------------------------+
string StringUpper(string s) {
  int c, i, k=StringLen(s), n;
  for (i=0; i<k; i++) {
    n=0;
    c=StringGetChar(s, i);
    if (c>96 && c<123) n=c-32;    // a-z -> A-Z
    if (c>223 && c<256) n=c-32;   // - -> -
    if (c==184) n=168;            //    ->  
    if (n>0) s=StringSetChar(s, i, n);
  }
  return(s);
}
//+------------------------------------------------------------------+