//+------------------------------------------------------------------+
//|                                          MTF FractalsChannel.mq4 |
//|           Copyright  2012. XrustSolution. mail:xrustx@gmail.com |
//|          http://www.youtube.com/user/opmlv http://forexrust.info |
//+------------------------------------------------------------------+
#property copyright "Copyright  2012. XrustSolution. mail:xrustx@gmail.com"
#property link      "http://www.youtube.com/user/opmlv http://forexrust.info"
//+------------------------------------------------------------------+
//| Super Global Variables                                           |
//+------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Yellow
#property indicator_width1 2
#property indicator_color2 Red
#property indicator_color3 Blue
//+------------------------------------------------------------------+
//| Extern Variables                                                 |
//+------------------------------------------------------------------+
extern int  Indicator_TimeFrame                               =    60;
extern bool Real_Delay                                        = false;
//+------------------------------------------------------------------+
//|   Includes			                                                |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|   Defines & Global variavles                                     |
//+------------------------------------------------------------------+
#define empty  EMPTY_VALUE
//+------------------------------------------------------------------+

//--- buffers
double ma[];
double fd[];
double fu[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void init()
  {
   Indicator_TimeFrame=PeriodCorrect(Indicator_TimeFrame);
   if(Indicator_TimeFrame==0){Indicator_TimeFrame=Period();}
   if(Indicator_TimeFrame<Period()){Indicator_TimeFrame=Period();}
   IndicatorShortName(tf2txt(Indicator_TimeFrame)+" MTF FractalsChannel");
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ma);
   SetIndexLabel(0,tf2txt(Indicator_TimeFrame)+" FRC Middle");
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,fd);
   SetIndexLabel(1,tf2txt(Indicator_TimeFrame)+" FRC Down");
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,fu);
   SetIndexLabel(2,tf2txt(Indicator_TimeFrame)+" FRC Up");
//----
   return;
  }
//+------------------------------------------------------------------+
void deinit(){return;}
//+------------------------------------------------------------------+
void start()
  {
//----    (   )
   static int  pretime = 0;
   static double prerp = 0;
   int i,ii,x,y,counted= IndicatorCounted();
   int per   = Period();
   string sy = Symbol();
   string txt="";

   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;

//----     
   double fup,fdn;
   int iBar,iShift=0,iMult=Indicator_TimeFrame/Period();
//if(limit<5*iMult){limit=5*iMult;}
   if(Real_Delay){iShift=iMult*3;}

   if(counted_bars==0) limit-=1+1+iShift;
//----  
   for(i=limit;i>=0;i--)
     {
      ii   = i - iShift;
      iBar = iBarShift(sy,Indicator_TimeFrame,Time[i]);
      fup  = iFractals(sy,Indicator_TimeFrame,MODE_UPPER,iBar);
      fdn  = iFractals(sy,Indicator_TimeFrame,MODE_LOWER,iBar);
      if(fup!=0)
        {
         if(fup==iFractals(sy,per,MODE_UPPER,i))
           {
            fu[ii]=fup;
              }else{
            fu[ii]=fu[ii+1];
           }
           }else{
         fu[ii]=fu[ii+1];
        }
      if(fdn!=0)
        {
         if(fdn==iFractals(sy,per,MODE_LOWER,i))
           {
            fd[ii]=fdn;
              }else{
            fd[ii]=fd[ii+1];
           }
           }else{
         fd[ii]=fd[ii+1];
        }
      ma[ii]=fd[ii]+(fu[ii]-fd[ii])/2;
     }
//----
   return;
  }
//+------------------------------------------------------------------+
//|         Function    : string tf2txt(int tf)                      |
//+------------------------------------------------------------------+
//|         Description :      |
//+------------------------------------------------------------------+
string tf2txt(int tf)
  {
   switch(tf)
     {
      case PERIOD_M1 : return(" M1");
      case PERIOD_M5 : return(" M5");
      case PERIOD_M15: return(" M15");
      case PERIOD_M30: return(" M30");
      case PERIOD_H1 : return(" H1");
      case PERIOD_H4 : return(" H4");
      case PERIOD_D1 : return(" D1");
      case PERIOD_W1 : return(" W1");
      case PERIOD_MN1: return(" MN1");
      default        : return(" ");
     }
  }
//+------------------------------------------------------------------+
//|        Function    : int PeriodCorrect(int per)                  |
//+------------------------------------------------------------------+
//|        Description :          |
//+------------------------------------------------------------------+
int PeriodCorrect(int per)
  {
   if(per<5){return(1);}
   if(per>=5     && per<15     ){return(5);}
   if(per>=15    && per<30     ){return(15);}
   if(per>=30    && per<60     ){return(30);}
   if(per>=60    && per<240    ){return(60);}
   if(per>=240   && per<1440   ){return(240);}
   if(per>=1440 && per<10080){return(1440);}
   if(per>=10080   && per<43200){return(10080);}
   if(per>=43200               ){return(43200);}
   return(Period());
  }
//+------------------------------------------------------------------+
