//+------------------------------------------------------------------+
//|                                                WeekendCutter.mq4 |
//|                                                          220Volt |
//|                                                Version 2         |   
//+------------------------------------------------------------------+
#property copyright "220Volt"
#property link      ""
#property show_inputs

#define _OUT_DELIMITER  ','   //    
#define _REPEAT_COUNT   10     //     OHLC,   ,  

extern string srcName;        //    
extern string destName;       // - (   )
extern int delimiter = ',';   //   
extern int skipLine = 0;      //   ,     ,  
extern int digits = 5;        //    ( )
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
datetime vec_bufer[];
int vec_size = 0;
int vec_writePos = -1;
int vec_readPos = -1;

bool vec_push(datetime beginTime, 
               datetime endTime)
{
   vec_writePos ++;
   if(vec_writePos > vec_size - 2)
   {
      if(vec_size == 0)
         vec_size = 50;
      vec_size *= 2;
      if(ArrayResize(vec_bufer, vec_size) == -1)
         return(false);      
   }
   vec_bufer[vec_writePos] = beginTime;
   vec_writePos ++;
   vec_bufer[vec_writePos] = endTime;
   return(true);
}

void vec_pop(datetime &beginTime, 
            datetime &endTime)
{
   vec_readPos ++;
   if(vec_readPos > vec_writePos)
   {
      beginTime = -1;
      endTime = -1;
      return;
   }
   beginTime = vec_bufer[vec_readPos];
   vec_readPos ++;
   endTime = vec_bufer[vec_readPos];
   return;
}
//+-----------------------------------------------

int src_handle = 0;

bool src_Init()
{
   src_handle = FileOpen(srcName, FILE_CSV|FILE_READ, delimiter);
   if( src_handle == -1)
      return(false); 
   for(int count = skipLine;  count > 0;  count --)
   {
      while(true)
      {
         FileReadString(src_handle);
         if(FileIsLineEnding(src_handle))
            break;
      }
   }
   return(true);
}

void src_Deinit()
{
   if(src_handle > 0)
      FileClose(src_handle);
}

bool src_Seek()
{
   if( ! FileSeek(src_handle, SEEK_SET, 0) )
      return(false);
   for(int count = skipLine;  count > 0;  count --)
   {
      while(true)
      {
         FileReadString(src_handle);
         if(FileIsLineEnding(src_handle))
            break;
      }
   }
   return(true);
}

bool src_GetData(datetime &time,
               double &open, 
               double &high, 
               double &low, 
               double &close, 
               double &volume)
{
   time = StrToTime( FileReadString(src_handle) );
   if(FileIsEnding(src_handle))
      return(false);
   open = 0;
   high = 0;
   low = 0;
   close = 0;
   volume = 0;
   if(FileIsLineEnding(src_handle))
      return(true);
   open = FileReadNumber(src_handle);   if(FileIsLineEnding(src_handle))  return(true);
   high = FileReadNumber(src_handle);   if(FileIsLineEnding(src_handle))  return(true);
   low = FileReadNumber(src_handle);    if(FileIsLineEnding(src_handle))  return(true);
   close = FileReadNumber(src_handle);  if(FileIsLineEnding(src_handle))  return(true);
   volume = FileReadNumber(src_handle);
   return(true);
}
//+-----------------------------------------------

int dest_handle = 0;

bool dest_Init()
{
   dest_handle = FileOpen(destName, FILE_CSV|FILE_WRITE, delimiter);
   if( dest_handle == -1)
      return(false); 
   return(true);
}

void dest_Deinit()
{
   if(dest_handle > 0)
      FileClose(dest_handle);
}

bool dest_PutData(datetime time,
               double open, 
               double high, 
               double low, 
               double close, 
               double volume)
{
   if( FileWrite( dest_handle, 
            TimeToStr(time, TIME_DATE|TIME_SECONDS), 
            DoubleToStr(open, digits), 
            DoubleToStr(high, digits), 
            DoubleToStr(low, digits), 
            DoubleToStr(close, digits), 
            DoubleToStr(volume, digits) ) < 0)
      return(false);
   return(true);
}
//+------------------------------------------------------------------+
//| script program start function                                    |
//+------------------------------------------------------------------+
int start()
  {
//----
      if( ! src_Init()  ||  ! dest_Init() )
      {
         Alert("Error");
         src_Deinit();
         dest_Deinit();
         return(1);
      }
      
      int time;
      double open, high, low, close, volume;
      
      //begin//
         int fixSTime, fixETime, repeat = 1;
         double fixSOpen, fixSHigh, fixSLow, fixSClose;
         if( ! src_GetData(fixSTime, fixSOpen, fixSHigh, fixSLow, fixSClose, volume) )
         {
            src_Deinit();
            dest_Deinit();
            return(0);
         }
         while( src_GetData(time, open, high, low, close, volume) )
         {
            if(open == fixSOpen  &&  high == fixSHigh  &&  low == fixSLow  &&  close == fixSClose)
            {
               repeat ++;
               fixETime = time;
            }
            else
            {
               if(repeat >= _REPEAT_COUNT)
               {
                  if( ! vec_push(fixSTime, fixETime) )
                  {
                     Alert("Error");
                     src_Deinit();
                     dest_Deinit();
                     return(1);
                  }
               }
               repeat = 1;
               fixSTime = time; 
               fixETime = time;
               fixSOpen = open; 
               fixSHigh = high; 
               fixSLow = low; 
               fixSClose = close;
            }   
         }
         if(repeat >= _REPEAT_COUNT)
         {
            if( ! vec_push(fixSTime, fixETime) )
            {
               Alert("Error");
               src_Deinit();
               dest_Deinit();
               return(1);
            }
         }
      //end//
      
      //begin//
         datetime startLock, stopLock;
         vec_pop(startLock, stopLock);
         
         if( ! src_Seek() )
         {
            Alert("Error");
            src_Deinit();
            dest_Deinit();
            return(1);
         }
     
         while( src_GetData(time, open, high, low, close, volume) )
         {
            if(time > stopLock  &&  stopLock != -1)
               vec_pop(startLock, stopLock);
               
            if(time >= startLock  &&  time <= stopLock)
              continue;
            if( ! dest_PutData(time, open, high, low, close, volume) )
            {
               Alert("Error");
               src_Deinit();
               dest_Deinit();
               return(1);
            }
         }
      //end//
      
      src_Deinit();
      dest_Deinit();
//----
   return(0);
  }
//+------------------------------------------------------------------+