//+------------------------------------------------------------------+
//|                                                SetGridOrders.mq4 |
//|                                                          Pozitif |
//|                                              mail: alex-w-@bk.ru |
//+------------------------------------------------------------------+
#property copyright "Pozitif"
#property link      "mail: alex-w-@bk.ru"
#property show_inputs

//+------------------------------------------------------------------+
//|     ,        |
//|    .                                        |
//+------------------------------------------------------------------+

// ------------------    ---------------------+

extern double  Price          = 0;                       //  ,  0 -          .
extern double  Lot            = 0.01;                    //     .
extern int     SetOrders      = 3;                       //  .
extern int     Step           = 10;                      //     .
extern int     StopLoss       = 160;
extern bool    GeneralStop    = true;                    //         ,             .
extern int     TakeProfit     = 160;
extern bool    GeneralProfit  = true;                    //               .
extern bool    UseSound       = True;                    //   
extern int     MagicNumber    = 526;

//----------------------   ----------------------+
string         NameFileSound  = "news.wav";              //   
int            NumberOfTry    = 3;                       //    

//---------------------   ---------------------+
#include       <stdlib.mqh>                       //   4
#include       <WinUser32.mqh>

//+------------------------------------------------------------------+
//| ##############---  script start function ---#################### |
//+------------------------------------------------------------------+
int start()
{
//----------------- Variable Initialization -------------------------+
   double pt, pr_ask, pr_bid, well_lots, open_lots, price_dp, order_sl, order_tp, price_extreme, open_pr;
   int dg, min_sl, flags, answer, orders_type;
   string symbl, str_box, title_box;
   bool interrupt = true;
//----
   
   symbl=Symbol();
   dg=MarketInfo(symbl, MODE_DIGITS);
   pt=MarketInfo(symbl, MODE_POINT);
   pr_ask=NormalizeDouble(MarketInfo(symbl, MODE_ASK), dg);
   pr_bid=NormalizeDouble(MarketInfo(symbl, MODE_BID), dg);
   min_sl=MarketInfo(symbl,MODE_STOPLEVEL);                                                              //    -/-  
   well_lots=NormalizeDouble(AccountFreeMargin()/MarketInfo(Symbol(),MODE_MARGINREQUIRED), 2);        //  ,        .
   open_lots=NormalizeDouble(Lot, 2);
   price_dp=NormalizeDouble(WindowPriceOnDropped(), dg);
   
   if(Price != 0)price_dp = Price;
   
   //=========       ,    =========
   if(price_dp == 0){
      Alert("     ,         !");
      interrupt = false;
   }
   //===================      =======================
   if((interrupt == true)&&(pr_ask < price_dp)){
      str_box = " . \n  - BuyStop /  - SellLimit /  -  ";
      title_box = "  .";
      flags = MB_YESNOCANCEL|MB_ICONEXCLAMATION;
      answer = MessageBox(str_box, title_box, flags);
      if(answer == IDCANCEL)interrupt = false;
      else {
         if(answer == IDYES)orders_type = OP_BUYSTOP;
         if(answer == IDNO)orders_type = OP_SELLLIMIT;
      }
   }
   if((interrupt == true)&&(pr_bid > price_dp)){
      str_box = " . \n  - SellStop /  - BuyLimit /  -  ";
      title_box = "  .";
      flags = MB_YESNOCANCEL|MB_ICONEXCLAMATION;
      answer = MessageBox(str_box, title_box, flags);
      if(answer == IDCANCEL)interrupt = false;
      else {
         if(answer == IDYES)orders_type = OP_SELLSTOP;
         if(answer == IDNO)orders_type = OP_BUYLIMIT;
      }
   }
   //=========         =============
   if((open_lots > well_lots)&&(interrupt==true)){
      str_box = " !        .   : "+well_lots+". "+"  ?";
      title_box = " .";
      flags = MB_YESNO|MB_ICONEXCLAMATION;
      answer = MessageBox(str_box, title_box, flags);
      if(answer == IDNO)interrupt = false;
   }
   //============================    =============================
   if(interrupt){
      if(orders_type ==OP_BUYSTOP){
         if(GeneralStop){
            if(price_dp - StopLoss*pt <= price_dp - min_sl*pt)order_sl = price_dp - StopLoss*pt;
            else order_sl = price_dp - (StopLoss+min_sl)*pt;
         }
         if(GeneralProfit){
            price_extreme = price_dp;
            for(int b = 0; b <= SetOrders; b++)price_extreme += Step*pt;
            if(price_extreme + TakeProfit*pt >= price_extreme + min_sl*pt)order_tp = price_extreme + TakeProfit*pt;
            else order_tp = price_extreme + (TakeProfit+min_sl)*pt;
         }
      }
      if(orders_type ==OP_SELLSTOP){
         if(GeneralStop){
            if(price_dp + StopLoss*pt >= price_dp + min_sl*pt)order_sl = price_dp + StopLoss*pt;
            else order_sl = price_dp + (StopLoss+min_sl)*pt;
         }
         if(GeneralProfit){
            price_extreme = price_dp;
            for(int ss = 0; ss <= SetOrders; ss++)price_extreme -= Step*pt;
            if(price_extreme - TakeProfit*pt <= price_extreme - min_sl*pt)order_tp = price_extreme - TakeProfit*pt;
            else order_tp = price_extreme - (TakeProfit+min_sl)*pt;
         }
      }
      if(orders_type ==OP_BUYLIMIT){
         if(GeneralStop){
            price_extreme = price_dp;
            for(int i = 0; i <= SetOrders; i++)price_extreme -= Step*pt;
            if(price_extreme - StopLoss*pt <= price_extreme - min_sl*pt)order_sl = price_extreme - StopLoss*pt;
            else order_sl = price_extreme - (StopLoss+min_sl)*pt;
         }
         if(GeneralProfit){
            if(price_dp + TakeProfit*pt >= price_dp + min_sl*pt)order_tp = price_dp + TakeProfit*pt;
            else order_tp = price_dp + (TakeProfit+min_sl)*pt;
         }
      }
      if(orders_type ==OP_SELLLIMIT){
         if(GeneralStop){
            price_extreme = price_dp;
            for(int x = 0; x <= SetOrders; x++)price_extreme += Step*pt;
            if(price_extreme + StopLoss*pt >= price_extreme + min_sl*pt)order_sl = price_extreme + StopLoss*pt;
            else order_sl = price_extreme + (StopLoss+min_sl)*pt;
         }
         if(GeneralProfit){
            if(price_dp - TakeProfit*pt <= price_dp - min_sl*pt)order_tp = price_dp - TakeProfit*pt;
            else order_tp = price_dp - (TakeProfit+min_sl)*pt;
         }
      }
      
      for(int cx = 0; cx <= SetOrders; cx++){
         
         if(orders_type ==OP_BUYSTOP){
            if(cx == 1){
               open_pr = price_dp;
               if(open_pr < pr_ask + min_sl*pt)open_pr = pr_ask + min_sl*pt;
            }
            else open_pr += Step*pt;
            if(GeneralStop == false){
               order_sl = open_pr - StopLoss*pt;
               if(order_sl > open_pr - min_sl*pt)order_sl = open_pr - min_sl*pt;
            }
            if(GeneralProfit == false){
               order_tp = open_pr + TakeProfit*pt;
               if(order_tp < open_pr + min_sl*pt)open_pr = open_pr + min_sl*pt;
            }
         }
         if(orders_type ==OP_SELLSTOP){
            if(cx == 1){
               open_pr = price_dp;
               if(open_pr > pr_bid - min_sl*pt)open_pr = pr_bid - min_sl*pt;
            }
            else open_pr -= Step*pt;
            if(GeneralStop == false){
               order_sl = open_pr + StopLoss*pt;
               if(order_sl < open_pr + min_sl*pt)order_sl = open_pr + min_sl*pt;
            }
            if(GeneralProfit == false){
               order_tp = open_pr - TakeProfit*pt;
               if(order_tp > open_pr - min_sl*pt)open_pr = open_pr - min_sl*pt;
            }
         }
         if(orders_type ==OP_BUYLIMIT){
            if(cx == 1){
               open_pr = price_dp;
               if(open_pr > pr_bid - min_sl*pt)open_pr = pr_bid - min_sl*pt;
            }
            else open_pr -= Step*pt;
            if(GeneralStop == false){
               order_sl = open_pr - StopLoss*pt;
               if(order_sl > open_pr - min_sl*pt)order_sl = open_pr - min_sl*pt;
            }
            if(GeneralProfit == false){
               order_tp = open_pr + TakeProfit*pt;
               if(order_tp < open_pr + min_sl*pt)open_pr = open_pr + min_sl*pt;
            }
         }
         if(orders_type ==OP_SELLLIMIT){
            if(cx == 1){
               open_pr = price_dp;
               if(open_pr < pr_ask + min_sl*pt)open_pr = pr_ask + min_sl*pt;
            }
            else open_pr += Step*pt;
            if(GeneralStop == false){
               order_sl = open_pr + StopLoss*pt;
               if(order_sl < open_pr + min_sl*pt)order_sl = open_pr + min_sl*pt;
            }
            if(GeneralProfit == false){
               order_tp = open_pr - TakeProfit*pt;
               if(order_tp > open_pr - min_sl*pt)open_pr = open_pr - min_sl*pt;
            }
         }

         SetOrder("", orders_type, open_lots, open_pr, order_sl, order_tp, MagicNumber, 0);
         
         
      }
   }



//----
   return(0);
}
  
//+------------------------------------------------------------------+


void SetOrder(string sy, int op, double ll, double pp, double sl=0, double tp=0, int mn=0, datetime ex=0) 
{
   int err, dg, ticket=0;
   
//---------------
   if (sy=="" || sy=="0") sy=Symbol();
   
   for (int it=1; it<=NumberOfTry; it++) {

      while (!IsTradeAllowed()) Sleep(5000);
      
      dg=MarketInfo(sy, MODE_DIGITS);
      pp=NormalizeDouble(pp, dg);
      
      ticket=OrderSend(sy, op, ll, pp, 0, sl, tp, NULL, mn, 0, CLR_NONE);
      
      if (ticket>0) {
         if (UseSound) PlaySound(NameFileSound); break;
      } 
      else {
         err=GetLastError();
         //    
         Print("Error(",err,") opening position: ",ErrorDescription(err),", try ",it);

         if (err==4 || err==131 || err==132) Sleep(1000*300); break;
         if (err==128 || err==142 || err==143) Sleep(1000*66.666);
         if (err==140 || err==148 || err==4110 || err==4111) break;
         if (err==141) Sleep(1000*100);
         if (err==145) Sleep(1000*17);
         if (err==146) while (IsTradeContextBusy()) Sleep(1000*11);
         if (err!=135) Sleep(1000*7.7);
      }
   }
  return(ticket);
}

//+----------------------------------------------------------------------------+