//+------------------------------------------------------------------+
//|                                   Copyright  2012, Ivan Kornilov|
//|                                                       BrakeMa.mq4|
//+------------------------------------------------------------------+
#property copyright "Copyright  2012, Ivan Kornilov. All rights reserved."
#property link "excelf@gmail.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color2 Red
#property indicator_color1 Green

extern int    ma   = 34;
extern double speed   = 0.00;
extern int    maType  = 3;

extern bool isLine = false;


double upValue[];
double downValue[];
double maValue[];

int init() {
   IndicatorShortName("BrakeMa (" + ma + "," + maType + " )");
   SetIndexBuffer(0, upValue);
   SetIndexLabel(0, "Up Value");
   
   SetIndexBuffer(1, downValue);
   SetIndexLabel(1, "Down Value");
   
   SetIndexBuffer(2, maValue);
   IndicatorBuffers(3);
   
   if(isLine) {
      SetIndexStyle(0, DRAW_LINE, EMPTY, 2);
      SetIndexStyle(1, DRAW_LINE, EMPTY, 2);
   } else {
      SetIndexStyle(0, DRAW_ARROW, EMPTY, 2);
      SetIndexArrow(0, 159);
      SetIndexStyle(1, DRAW_ARROW, EMPTY, 2);
      SetIndexArrow(1, 159);
   }
   
   IndicatorDigits(Digits);   
}

double   last_beginPrice = -1;
datetime last_beginTime  = 0;
bool     last_isLong     = true;
double maxPrice = -999;
double minPrice = 999;

int start() {
   int indicatorCounted = IndicatorCounted();
   if (indicatorCounted < 0) { 
        return (-1);
   }
   if (indicatorCounted > 0) {
        indicatorCounted--;
   }
   
   int limit = Bars - indicatorCounted - 2;

   
   for (int i = limit; i >= 0; i--) {
      if(last_beginPrice == -1) {
         last_beginPrice = Low[i];
         last_beginTime = Time[i];
         last_isLong = true;
      }
      
      if(maxPrice < High[i]) {
         maxPrice = High[i];
      }
      if(minPrice > Low[i]) {
         minPrice = Low[i];
      }
      double value;
      int beginBar = iBarShift(NULL, 0, last_beginTime, false);
      double maShift = iMA(NULL, 0, ma, 0, maType, 0, beginBar) - last_beginPrice; 
      
      maValue[i] = iMA(NULL, 0, ma, 0, maType, 0, i);
      if(last_isLong) {
        if(maValue[i + 1] > maValue[i]) {
            double move = (maValue[i + 1] - maValue[i]) * speed;
            value = maValue[i+1] + move - maShift;
            last_beginPrice = last_beginPrice + move; 
            maValue[i] = maValue[i + 1];
        } else {
            value = maValue[i] - maShift ;
        }
      } else {
        if(maValue[i + 1] < maValue[i]) {
            move = (maValue[i] - maValue[i + 1]) * speed;
            value = maValue[i+1] - move - maShift;
            last_beginPrice = last_beginPrice - move; 
            maValue[i] = maValue[i + 1];
        } else {
            value = maValue[i] - maShift ;
        }
      }
      
      
      
      if(last_isLong && value > Low[i]) { 
         last_isLong = false;
         last_beginPrice = maxPrice;
         value = last_beginPrice;
         last_beginTime = Time[i];
         
         maxPrice = -999;
         minPrice = 999;  
         
      } else if(!last_isLong && value < High[i]) {
         last_isLong = true;
         last_beginPrice = minPrice;
         value = last_beginPrice;
         last_beginTime = Time[i];
         
         maxPrice = -999;
         minPrice = 999;
      }
      if(last_isLong) {
         upValue[i] = value;
         downValue[i] = EMPTY_VALUE;
      } else {
         upValue[i] = EMPTY_VALUE;
         downValue[i] = value;
      }
   }
}

//double getNormValue(int period, int shift) {
//   return(iCustom(NULL, 0, "ATRNorm", period, 1, "", 0, 1, shift));
//}

