//+------------------------------------------------------------------+
//|                                           SendOrderMultiLock.mq4 |
//|                                                           Kordan |
//|    http://www.leprecontrading.com/client/register.php?ref=103264 |
//+------------------------------------------------------------------+

#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link      "http://www.leprecontrading.com/client/register.php?ref=103264" //  
#property show_inputs

/*
 1.  30.01.2012
       .
     .      ,     
 Symbol_1  Symbol_2,     BUY  .        , 
   Buy  Symbol_1 .
    .
 
 2. 04.02.2012 .         .
*/

//--------------------------------------------------------------------

extern string  Symbol_1    = "EURUSD",    //  1
               Symbol_2    = "GBPUSD";    //  2                    
extern double  Lot         =      0.1;    //  
extern int     StopLoss    =       40,    //   SL,  0,  SL  
               TakeProfit  =       10;    //   TP,  0,  TP             
extern int     Slippage    =        3,    //       
               MagicNumber =        0;    //   

//--------------------------------------------------------------------

int      Dig_BUY, Dig_SELL;
double   SL_BUY, TP_BUY, TP_SELL, SL_SELL, point_BUY, point_SELL;
string   Symb_BUY, Symb_SELL;  

//--------------------------------------------------------------------

int start()
{

//--------------------------------------------------------------------

int      Dig_1 = MarketInfo(Symbol_1,MODE_DIGITS);
int      Dig_2 = MarketInfo(Symbol_2,MODE_DIGITS);
double point_1 = MarketInfo(Symbol_1,MODE_POINT) ;
double point_2 = MarketInfo(Symbol_2,MODE_POINT) ;
   if (Dig_1 == 5 || Dig_2 == 3 || Dig_2 == 5 || Dig_1 == 3)
      {
      StopLoss   *= 10;
      TakeProfit *= 10;
      Slippage   *= 10;
      }
   
//--------------------------------------------------------------------

if (Symbol_2 == Symbol())
   {
   Symb_BUY   = Symbol_2;
   Symb_SELL  = Symbol_1;
   Dig_BUY    = Dig_2   ;
   Dig_SELL   = Dig_1   ;
   point_BUY  = point_2 ;
   point_SELL = point_1 ;
   }
      else
   {
   Symb_BUY   = Symbol_1;
   Symb_SELL  = Symbol_2;
   Dig_BUY    = Dig_1   ;
   Dig_SELL   = Dig_2   ;
   point_BUY  = point_1 ;
   point_SELL = point_2 ;
   }   

//--------------------------------------------------------------------

while(!IsTradeAllowed()) Sleep(100); RefreshRates()    ;
   double ASK_BUY  = MarketInfo(Symb_BUY, MODE_ASK)    ;
   double ASK      = NormalizeDouble(ASK_BUY, Dig_BUY );
      TP_BUY  = IIFd(TakeProfit == 0, 0, NormalizeDouble(ASK_BUY  + TakeProfit*point_BUY,  Dig_BUY ));
      SL_BUY  = IIFd(StopLoss   == 0, 0, NormalizeDouble(ASK_BUY  - StopLoss  *point_BUY,  Dig_BUY )); 
         Print("  BUY" ); OPENORDER ("Buy", ASK, TP_BUY, SL_BUY)                       ;
         
while(!IsTradeAllowed()) Sleep(100); RefreshRates()    ;
   double BID_SELL = MarketInfo(Symb_SELL,MODE_BID)    ;
   double BID      = NormalizeDouble(BID_SELL,Dig_SELL);
      TP_SELL = IIFd(TakeProfit == 0, 0, NormalizeDouble(BID_SELL - TakeProfit*point_SELL, Dig_SELL));
      SL_SELL = IIFd(StopLoss   == 0, 0, NormalizeDouble(BID_SELL + StopLoss  *point_SELL, Dig_SELL));
         Print("  SELL"); OPENORDER ("Sell", BID, TP_SELL, SL_SELL)                    ;
         
//--------------------------------------------------------------------
         
return(0);
}

//--------------------------------------------------------------------

void OPENORDER(string ord, double price, double tp, double sl)
{
int errorBuy=0, errorSell=0, err;
   while (true)
      {  
      if (ord=="Buy" ) errorBuy =OrderSend(Symb_BUY , OP_BUY , Lot, price, Slippage, sl, tp, "Script BUY" , MagicNumber, 0,Blue);
      if (ord=="Sell") errorSell=OrderSend(Symb_SELL, OP_SELL, Lot, price, Slippage, sl, tp, "Script SELL", MagicNumber, 0, Red);     
         if (errorBuy ==-1) { Print("  Buy" ); ShowERROR(Symb_BUY ); }         
         if (errorSell==-1) { Print("  SELL"); ShowERROR(Symb_SELL); }
            err++; Sleep(2000); RefreshRates();          
         if (errorBuy || errorSell || err > 10) 
      return;
      }
return;
}     

//--------------------------------------------------------------------

void ShowERROR(string symb)
   {
   int err=GetLastError();
   switch (err)
      {    
      case 1   :                                                      return;
      case 2   :  Alert("  "                         )   ; return;
      case 3   :  Alert("  "        ,  symb)   ; return;
      case 4   :  Alert("   "                )   ; return;
      case 6   :  Alert("    "         )   ; return;
      case 129 :  Alert("  "             ,  symb)   ; return;
      case 130 :  Alert("   "                ,  symb)   ; return;
      case 131 :  Alert("  "            ,  symb)   ; return;
      case 132 :  Alert("  "                         )   ; return;
      case 133 :  Alert("  "                   )   ; return;
      case 134 :  Alert("    "                 )   ; return;
      case 135 :  Alert("  "               ,  symb)   ; return;
      case 136 :  Alert("  "                       ,  symb)   ; return;
      case 137 :  Alert("  "                         )   ; return;
      case 138 :  Alert(" ,  "            ,  symb)   ; return;
      case 146 :  Alert("   "           )   ; return;  
      default  :  Alert("  " ,err," "              ,  symb)   ; return;
      }
   }

//--------------------------------------------------------------------

double IIFd(bool condition, double ifTrue, double ifFalse) 
{ if (condition) return(ifTrue); else return(ifFalse); }

