//+------------------------------------------------------------------+
//|                                                  MAStoch_101.mq4 |
//|                                     Copyright  2011, Igoroksold |
//|                                                 igoroksold@bk.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Igoroksold"
#property link      "igoroksold@bk.ru"

extern string _1.0 = " ";

extern double dLot = 1;
extern double dK = 2;

extern double dTP = 20;
extern double dSL = 20;
extern int iUse_close_MA = 0;
extern int iUse_close_Stoch = 0;
extern int iMax_trades = 10;
extern double dDelta = 10;
extern int iSlippage = 3;
extern int iMagicNumber = 206206;

extern string _1.1 = " ";
extern int iPeriod_MA = 12;
extern int iShift_MA = 0;

extern string _1.2 = " Stochastic";
extern int iKPeriod=20;
extern int iDPeriod=30;
extern int iSlowing=3;
extern double dZona_perekup = 80;
extern double dZona_pereprod = 20;

int iDigitLot;
datetime dtTime;
double dLotBuy, dLotSell;
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   iDigitLot = Info.DigitLot();
   
   if(dTP>0) Info.ChangeToDigit(dTP);
   if(dSL>0) Info.ChangeToDigit(dSL);
   
   iShift_MA *= Point;
   dDelta *= Point;
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
   int iCntOrders, iTick, l_dType;
   double l_dLot, l_dPrice, l_dSL, dMA1, dStoch1, dStoch2;
//----   
   if(iUse_close_MA == 1){
      dMA1 = iMA(NULL, 0, iPeriod_MA, iShift_MA, MODE_SMA, PRICE_CLOSE, 1);
      if(Open[0] >= dMA1 && Bid <= dMA1){
         Orders.Close(0, iMagicNumber, true, Symbol());
      }else{
         if(Open[0] <= dMA1 && Ask >= dMA1){
            Orders.Close(2, iMagicNumber, true, Symbol());
         }
      }
   }else{
      if(iUse_close_Stoch == 1){
         dStoch1 = iStochastic(NULL, 0, iKPeriod, iDPeriod, iSlowing, MODE_SMA, 1, MODE_MAIN, 1);
         if(dStoch1 > dZona_perekup){
            Orders.Close(0, iMagicNumber, true, Symbol());
         }else{
            if(dStoch1 < dZona_pereprod){
               Orders.Close(2, iMagicNumber, true, Symbol());
            }
         }
      }
   }  
//----
   if(dtTime!=Time[0]){      
     dtTime=Time[0];
     dMA1 = iMA(NULL, 0, iPeriod_MA, iShift_MA, MODE_SMA, PRICE_CLOSE, 1);
     dStoch1 = iStochastic(NULL, 0, iKPeriod, iDPeriod, iSlowing, MODE_SMA, 1, MODE_MAIN, 1);
     dStoch2 = iStochastic(NULL, 0, iKPeriod, iDPeriod, iSlowing, MODE_SMA, 1, MODE_MAIN, 2);         
                  
     if(dMA1 < Ask && dStoch1 < dZona_pereprod && dStoch2 >= dZona_pereprod){            
       iCntOrders = Orders.Count(0, iMagicNumber);
       if(iCntOrders==0){
         if(iMax_trades==1){ l_dSL = dSL; }else{ l_dSL = 0; }
         Orders.Open(1, Orders.LotPersent(dLot, iDigitLot), Ask, Symbol(), "", l_dSL, dTP, iDigitLot, iSlippage, iMagicNumber, iTick);
       }
     }else{
       if(dMA1 > Bid && dStoch1 > dZona_perekup && dStoch2 <= dZona_perekup){                              
         iCntOrders = Orders.Count(1, iMagicNumber);
         if(iCntOrders==0){
           if(iMax_trades==1){ l_dSL = dSL; }else{ l_dSL = 0; }
           Orders.Open(2, Orders.LotPersent(dLot, iDigitLot), Bid, Symbol(), "", l_dSL, dTP, iDigitLot, iSlippage, iMagicNumber, iTick);
         }
       }
     }
   }
//----
   iCntOrders = Orders.Count(0, iMagicNumber);
   if(iCntOrders > 0){
      fReturnPriceLastOrder(0, l_dPrice, l_dType, l_dLot);
      
      if(iCntOrders < iMax_trades-1){        
        if(l_dPrice-Ask >= dDelta){                  
          if(dK>0){ l_dLot = fMultiLot(l_dLot, dK); }else{ l_dLot = dLot; }
          Orders.Open(1, l_dLot, Ask, Symbol(), "", 0, dTP, iDigitLot, iSlippage, iMagicNumber, iTick);
        }
      }else{ 
         if(iCntOrders == iMax_trades-1){
            if(l_dPrice-Ask >= dDelta){                  
               if(dK>0){ l_dLot = fMultiLot(l_dLot, dK); }else{ l_dLot = dLot; }
               Orders.Open(1, l_dLot, Ask, Symbol(), "", 0, dTP, iDigitLot, iSlippage, iMagicNumber, iTick);
               
               fSetSLs(iTick);
            }
         }
      }
   }
   
   iCntOrders = Orders.Count(1, iMagicNumber);
   if(iCntOrders > 0){
      fReturnPriceLastOrder(1, l_dPrice, l_dType, l_dLot);
      
      if(iCntOrders < iMax_trades-1){        
        if(Bid-l_dPrice >= dDelta){                  
          if(dK>0){ l_dLot = fMultiLot(l_dLot, dK); }else{ l_dLot = dLot; }
          Orders.Open(2, l_dLot, Bid, Symbol(), "", 0, dTP, iDigitLot, iSlippage, iMagicNumber, iTick);
        }
      }else{ 
         if(iCntOrders == iMax_trades-1){
            if(Bid-l_dPrice >= dDelta){                  
               if(dK>0){ l_dLot = fMultiLot(l_dLot, dK); }else{ l_dLot = dLot; }
               Orders.Open(2, l_dLot, Bid, Symbol(), "", 0, dTP, iDigitLot, iSlippage, iMagicNumber, iTick);
               
               fSetSLs(iTick);
            }
         }
      }
   } 
//----
   return(0);
  }
//+------------------------------------------------------------------+
//        
void fSetSLs(int _iTick){
   if(_iTick==0) return;
   double dNewSL; int i;
   if(OrderSelect(_iTick, SELECT_BY_TICKET)){
      if(OrderType()==0){      
         dNewSL = NormalizeDouble(OrderOpenPrice()-dSL, Digits);
         
         for(i=OrdersTotal()-1;i>=0;i--){
            if(OrderSelect(i,SELECT_BY_POS) && OrderSymbol()==Symbol() && OrderMagicNumber()==iMagicNumber){
               OrderModify(OrderTicket(),OrderOpenPrice(), dNewSL, OrderTakeProfit(), OrderExpiration()); 
            }
         }
      }else{
         if(OrderType()==1){
            dNewSL = NormalizeDouble(OrderOpenPrice()+dSL, Digits);
            
            for(i=OrdersTotal()-1;i>=0;i--){
               if(OrderSelect(i,SELECT_BY_POS) && OrderSymbol()==Symbol() && OrderMagicNumber()==iMagicNumber){
                  OrderModify(OrderTicket(),OrderOpenPrice(), dNewSL, OrderTakeProfit(), OrderExpiration()); 
               }
            }
         }
      }
   }
}
//+------------------------------------------------------------------+
//     
void fReturnPriceLastOrder(int _t, double& d, int& t, double& l){
   for(int a1=OrdersTotal()-1;a1>=0;a1--){
      if(OrderSelect(a1,SELECT_BY_POS) && OrderSymbol()==Symbol() && OrderMagicNumber()==iMagicNumber && OrderType()==_t){
         d=OrderOpenPrice(); t=OrderType(); l=OrderLots(); return;
      }
   }
}
//+------------------------------------------------------------------+
//    
double fMultiLot(double lastLot, double _k){double l = NormalizeDouble(_k*lastLot,iDigitLot);return(l);}
//+------------------------------------------------------------------+
//  -    (  )   
//0-buy, 1-sell, 2-buylimit, 3-selllimit,4-buystop,5-sellstop, 6-all, 7-buy and sell, 8-buylimit and selllimit, 9-buy stop and sellstop
int Orders.Count(int _t, int _m){ int iCount=0; if(OrdersTotal()<=0)return(0); for(int a1=OrdersTotal()-1;a1>=0;a1--){ if(OrderSelect(a1,SELECT_BY_POS)){ if(OrderMagicNumber()==_m){ if(OrderType()==0 && (_t==0 || _t==6 ||  _t==7)){iCount++;} if(OrderType()==1 && (_t==1 || _t==6 ||  _t==7)){iCount++;} if(OrderType()==2 && (_t==2 || _t==6 ||  _t==8)){iCount++;} if(OrderType()==3 && (_t==3 || _t==6 ||  _t==8)){iCount++;} if(OrderType()==4 && (_t==4 || _t==6 ||  _t==9)){iCount++;} if(OrderType()==5 && (_t==5 || _t==6 ||  _t==7)){iCount++;} } } } return(iCount); }
//+------------------------------------------------------------------+
//        -   
void Info.ChangeToDigit(double& v) { if(v<MarketInfo(Symbol(),MODE_STOPLEVEL)){v = MarketInfo(Symbol(),MODE_STOPLEVEL);} v *= MarketInfo(Symbol(),MODE_TICKSIZE); return; }
//+------------------------------------------------------------------+
//    
int Info.DigitLot(){ int gd_240; switch (MarketInfo(Symbol(), MODE_MINLOT)) { case 0.001: gd_240 = 3;break; case 0.01:  gd_240 = 2;break; case 0.1:   gd_240 = 1;break; case 1.0:   gd_240 = 0; } return(gd_240); }
//+------------------------------------------------------------------+
//   
void Orders.Open(int type_order, double Lot, double price, string SymbolSend, string Comm, double SL, double TP, int dlot, int slip, int mag, int& tick)
{int l_error_64, l_error_130=0; double takeprofit, stoplosse;
switch(type_order){
  case 1 :
      while(true){
       if(IsTradeAllowed())
       {RefreshRates();          
          tick = OrderSend(SymbolSend,OP_BUY,NormalizeDouble(Lot,dlot),NormalizeDouble(MarketInfo(SymbolSend,MODE_ASK),MarketInfo(SymbolSend,MODE_DIGITS)),slip,0,0,Comm,mag);
          if(tick==-1) { if(Error.Check(GetLastError(),l_error_130)) return; }else{ break; }
          continue;
      } }
      if(tick!=-1 && (SL!=0 || TP!=0)){  
          while(true){
            if(IsTradeAllowed()){
              RefreshRates();
               if(OrderSelect(tick,SELECT_BY_TICKET)){                  
                  if(SL==0) { stoplosse = 0; }else{ stoplosse = OrderOpenPrice()-SL; }
                  if(TP==0) { takeprofit = 0;}else{ takeprofit= OrderOpenPrice()+TP; }
                 if(OrderModify(OrderTicket(),OrderOpenPrice(),NormalizeDouble(stoplosse,MarketInfo(SymbolSend,MODE_DIGITS)),NormalizeDouble(takeprofit,MarketInfo(SymbolSend,MODE_DIGITS)),0)) break;
                 if(Error.Check(GetLastError(),l_error_130)) break;
                 continue;                 
               }else{ Print("OrderSelectError "+GetLastError()); }
      } } }        
      break;
  case 2 :
      while(true){   
       if(IsTradeAllowed()){
          RefreshRates();
          tick = OrderSend(SymbolSend,OP_SELL,NormalizeDouble(Lot,dlot),NormalizeDouble(MarketInfo(SymbolSend,MODE_BID),MarketInfo(SymbolSend,MODE_DIGITS)),slip,0,0,Comm,mag);
          if(tick==-1) { if(Error.Check(GetLastError(),l_error_130)) return(-1); }else{ break; }
          continue;
      } }
      if(tick!=-1 && (SL!=0 || TP!=0)){  
          while(true){
            if(IsTradeAllowed()){
               RefreshRates();
               if(OrderSelect(tick,SELECT_BY_TICKET)){                  
                  if(SL==0) { stoplosse = 0; }else{ stoplosse = OrderOpenPrice()+SL; }
                  if(TP==0) { takeprofit = 0;}else{ takeprofit= OrderOpenPrice()-TP; }
                 if(OrderModify(OrderTicket(),OrderOpenPrice(),NormalizeDouble(stoplosse,MarketInfo(SymbolSend,MODE_DIGITS)),NormalizeDouble(takeprofit,MarketInfo(SymbolSend,MODE_DIGITS)),0)) break;
                 if(Error.Check(GetLastError(),l_error_130)) break;
                 continue;                 
               }else{ Print("OrderSelectError "+GetLastError()); }
      } } }        
     break;  
  case 3 :
      while(true){   
       if(IsTradeAllowed()){
          RefreshRates();
          if(SL==0) { stoplosse = 0; }else{ stoplosse = price-SL;}
          if(TP==0) { takeprofit = 0;}else{ takeprofit= price+TP;}
          tick = OrderSend(SymbolSend,OP_BUYSTOP,NormalizeDouble(Lot,dlot),NormalizeDouble(price,MarketInfo(SymbolSend,MODE_DIGITS)),slip,NormalizeDouble(stoplosse,MarketInfo(SymbolSend,MODE_DIGITS)),NormalizeDouble(takeprofit,MarketInfo(SymbolSend,MODE_DIGITS)),Comm,mag);
          if(tick==-1){if(Error.Check(GetLastError(),l_error_130)) break;}else{ break; }
          continue;   
      } }                
      break;
  case 4 :
      while(true){   
         if(IsTradeAllowed()){
            RefreshRates();             
             if(SL==0) { stoplosse = 0; }else{ stoplosse = price+SL;}
             if(TP==0) { takeprofit = 0;}else{ takeprofit= price-TP;}
             tick = OrderSend(SymbolSend,OP_SELLSTOP,NormalizeDouble(Lot,dlot),NormalizeDouble(price,MarketInfo(SymbolSend,MODE_DIGITS)),slip,NormalizeDouble(stoplosse,MarketInfo(SymbolSend,MODE_DIGITS)),NormalizeDouble(takeprofit,MarketInfo(SymbolSend,MODE_DIGITS)),Comm,mag);
             if(tick==-1){if(Error.Check(GetLastError(),l_error_130)) break;}else{ break; }
             continue;    
      } }   
     break; 
  case 5 :
      while(true){   
         if(IsTradeAllowed()){
            RefreshRates();             
             if(SL==0) { stoplosse = 0; }else{ stoplosse = price-SL;}
             if(TP==0) { takeprofit = 0;}else{ takeprofit= price+TP;}
             tick = OrderSend(SymbolSend,OP_BUYLIMIT,NormalizeDouble(Lot,dlot),NormalizeDouble(price,MarketInfo(SymbolSend,MODE_DIGITS)),slip,NormalizeDouble(stoplosse,MarketInfo(SymbolSend,MODE_DIGITS)),NormalizeDouble(takeprofit,MarketInfo(SymbolSend,MODE_DIGITS)),Comm,mag);
             if(tick==-1){if(Error.Check(GetLastError(),l_error_130)) break;}else{ break; }
             continue;    
      } }   
     break;
  case 6 :
      while(true){   
         if(IsTradeAllowed()){
            RefreshRates();             
             if(SL==0) { stoplosse = 0; }else{ stoplosse = price+SL;}
             if(TP==0) { takeprofit = 0;}else{ takeprofit= price-TP;}
             tick = OrderSend(SymbolSend,OP_SELLLIMIT,NormalizeDouble(Lot,dlot),NormalizeDouble(price,MarketInfo(SymbolSend,MODE_DIGITS)),slip,NormalizeDouble(stoplosse,MarketInfo(SymbolSend,MODE_DIGITS)),NormalizeDouble(takeprofit,MarketInfo(SymbolSend,MODE_DIGITS)),Comm,mag);
             if(tick==-1){if(Error.Check(GetLastError(),l_error_130)) break;}else{ break; }
             continue;    
      } }   
     break;
} }
//+------------------------------------------------------------------+
//   
//33 - all, 0 - buy, 2 - sell, 11 - buystop and buylimit, 21 - sellstop and selllimit, 31 - selllimit and buylimit, 41 - buystop and sellstop
//   
bool Orders.Close(int type, int _mag, bool _isMagic, string _sSymbol){
   if(OrdersTotal()<1) return(true);
   int ordertype, ticket, l_error_130;
   for(int a1=OrdersTotal()-1;a1>=0;a1--){
      if(OrderSelect(a1,SELECT_BY_POS) && ((_isMagic && OrderMagicNumber()==_mag) || (!_isMagic && OrderTicket()==_mag) || _mag==-1 )
                                       && ((_sSymbol!="" && OrderSymbol()==_sSymbol) || _sSymbol=="") ){  
         ordertype = OrderType();         
         if((type==33 || type==0) && ordertype==OP_BUY) {
            while(true) {
               RefreshRates();                   
               if(IsTradeAllowed()) { if(OrderClose(OrderTicket(),OrderLots(),Bid,0)) break; }
               if(Error.Check(GetLastError(),l_error_130)) break;
         }   }                      
         if((type==33 || type==11 || type==41) && ordertype==OP_BUYSTOP) {
            while(true) {
               RefreshRates();                                  
               if(IsTradeAllowed()) { if(OrderDelete( OrderTicket())) break; }
               if(Error.Check(GetLastError(),l_error_130)) break;
         }   }                 
         if((type==33 || type==11 || type==31) && ordertype==OP_BUYLIMIT) {
            while(true) {
               RefreshRates();                                  
               if(IsTradeAllowed()) { if(OrderDelete( OrderTicket())) break; }
               if(Error.Check(GetLastError(),l_error_130)) break;
         }   }        
         if((type==33 || type==2) && ordertype==OP_SELL) {
            while(true) {
               RefreshRates();                   
               if(IsTradeAllowed()) { if(OrderClose(OrderTicket(),OrderLots(),Ask,0)) break; }
               if(Error.Check(GetLastError(),l_error_130)) break;
         }    }         
         if((type==33 || type==21 || type==41) && ordertype==OP_SELLSTOP) {
            while(true) {
               RefreshRates();                   
               if(IsTradeAllowed()) { if(OrderDelete(OrderTicket())) break; }
               if(Error.Check(GetLastError(),l_error_130)) break;
         }    }         
         if((type==33 || type==21 || type==11) && ordertype==OP_SELLLIMIT) {
            while(true) {
               RefreshRates();                   
               if(IsTradeAllowed()) { if(OrderDelete(OrderTicket())) break; }
               if(Error.Check(GetLastError(),l_error_130)) break;
   } } } } return(true); }
   
//+------------------------------------------------------------------+
//                                                                   |
//                                             |
//                                                                   |
//+------------------------------------------------------------------+
//   
bool Error.Check(int l_error_64, int& error_130){   
   if(l_error_64==0) return(true);
   switch(l_error_64){
      case 4:  Print("  .  500 ...");       Sleep(500); return(false);
      case 135:Print(" .   ..");                      return(false);   
      case 136:Print(" .   ..");                   Sleep(1);   return(false);
      case 137:Print(" .  500 ...");                Sleep(500); return(false);
      case 138:Print(" . .");                                    return(false);                                  
      case 146:Print("  .  ..");   Sleep(500); return(false);     
      case 130: if(error_130==0) {Print(" .   ...");Sleep(1000);error_130++;return(false); }else{ Print("   ."); return(true);}
      default: Print("   "+l_error_64);                        return(true);
   }         
   return(true);
}

//+------------------------------------------------------------------+
//           
double Orders.LotPersent(double _dLot, int _iDigitLot){
   double dL=0; 
   // 1 
   double One_Lot =MarketInfo(Symbol(),MODE_MARGINREQUIRED);
   // 
   double Free=AccountFreeMargin();
      
   dL = NormalizeDouble(Free*_dLot/100/One_Lot,_iDigitLot);
   
   if(dL<MarketInfo(Symbol(),MODE_MINLOT)){Print(" ("+dL+")  ("+MarketInfo(Symbol(),MODE_MINLOT)+").    .");}
   if(dL>MarketInfo(Symbol(),MODE_MAXLOT)){Print(" ("+dL+")  ("+MarketInfo(Symbol(),MODE_MAXLOT)+").    .");}
   return(dL);
}
//+------------------------------------------------------------------+