//+------------------------------------------------------------------+
//| 100%    MA           |
//|        Search_Max|
//+------------------------------------------------------------------+
#define NAME_EXPERT "SpeedMA"
#define VER "V1"                                     
#define RELIZE "GS_2011_07_18"                        
#define AUTOR "valenok2003@mail.ru"
#define URL "http://bluedream.ucoz.ru"

#property indicator_separate_window
#property indicator_maximum 100
#property indicator_minimum -100

#property indicator_buffers 2       //  
#property indicator_level1 0
#property indicator_levelcolor Gray

extern int
TF_Indicator=0;
extern
int
MA_Period = 25,
MA_Method = 0,
MA_Price  = 1,
Smooth=25;
extern
bool SHOW_0=true;
int
Bars_For_Search=1000,
z;
//---- buffers
double
Buff_0_Speed[],//  MA
Buff_1_Smooth[];   //  
string
Name_Window,
ex_Name=NAME_EXPERT;
int Style_Speed_Line=DRAW_LINE;//STYLE_DOT;
int Style_Smooth_Line=STYLE_DOT;
double Max_MA;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   if(TF_Indicator==0) TF_Indicator=Period();
   if(TF_Indicator<Period())
     {
      TF_Indicator=Period();
      //Alert("TF    !"); 
     }
//---- indicators ----------------------------------------------------
   SetIndexBuffer(0,Buff_0_Speed);
   SetIndexStyle(0,DRAW_LINE);
//----
   SetIndexBuffer(1,Buff_1_Smooth);
   SetIndexStyle(1,DRAW_LINE);
//---- name for indicator window
   Name_Window=ex_Name+"("+txt_TF(TF_Indicator)+",MA_Period("+MA_Period+"),"+"Smooth("+Smooth+")"+")";
   IndicatorShortName(Name_Window);
//--------------------------------------------------------------------
   switch(TF_Indicator)
     {
      case PERIOD_M1:
         SetIndexBuffer(0,Buff_0_Speed); SetIndexStyle(0,0,Style_Speed_Line,0,Red);           SetIndexLabel(0,"MA_M1");
         SetIndexBuffer(1,Buff_1_Smooth); SetIndexStyle(1,0,Style_Smooth_Line,0,Red);           SetIndexLabel(1,"MA_M1");
         break;
      case PERIOD_M5:
         SetIndexBuffer(0,Buff_0_Speed); SetIndexStyle(0,0,Style_Speed_Line,0,DarkOrange);    SetIndexLabel(0,"MA_M5");
         SetIndexBuffer(1,Buff_1_Smooth); SetIndexStyle(1,0,Style_Smooth_Line,0,DarkOrange);    SetIndexLabel(1,"MA_M5");
         break;
      case PERIOD_M15:
         SetIndexBuffer(0,Buff_0_Speed); SetIndexStyle(0,0,Style_Speed_Line,0,Yellow);          SetIndexLabel(0,"MA_M15");
         SetIndexBuffer(1,Buff_1_Smooth); SetIndexStyle(1,0,Style_Smooth_Line,0,Yellow);        SetIndexLabel(1,"MA_M15");
         break;
      case PERIOD_M30:
         SetIndexBuffer(0,Buff_0_Speed); SetIndexStyle(0,0,Style_Speed_Line,0,LimeGreen);       SetIndexLabel(0,"MA_M30");
         SetIndexBuffer(1,Buff_1_Smooth); SetIndexStyle(1,0,Style_Smooth_Line,0,LimeGreen);     SetIndexLabel(1,"MA_M30");
         break;
      case PERIOD_H1:
         SetIndexBuffer(0,Buff_0_Speed); SetIndexStyle(0,0,Style_Speed_Line,0,SkyBlue);         SetIndexLabel(0,"MA_H1");
         SetIndexBuffer(1,Buff_1_Smooth); SetIndexStyle(1,0,Style_Smooth_Line,0,SkyBlue);       SetIndexLabel(1,"MA_H1");
         break;
      case PERIOD_H4:
         SetIndexBuffer(0,Buff_0_Speed); SetIndexStyle(0,0,Style_Speed_Line,0,Blue);            SetIndexLabel(0,"MA_H4");
         SetIndexBuffer(1,Buff_1_Smooth); SetIndexStyle(1,0,Style_Smooth_Line,0,Blue);          SetIndexLabel(1,"MA_H4");
         break;
      case PERIOD_D1:
         SetIndexBuffer(0,Buff_0_Speed); SetIndexStyle(0,0,Style_Speed_Line,0,Violet);          SetIndexLabel(0,"MA_D1");
         SetIndexBuffer(1,Buff_1_Smooth); SetIndexStyle(1,0,Style_Smooth_Line,0,Violet);        SetIndexLabel(1,"MA_D1");
         break;
      case PERIOD_W1:
         SetIndexBuffer(0,Buff_0_Speed); SetIndexStyle(0,0,Style_Speed_Line,0,BlueViolet);      SetIndexLabel(0,"MA_W1");
         SetIndexBuffer(1,Buff_1_Smooth); SetIndexStyle(1,0,Style_Smooth_Line,0,BlueViolet);    SetIndexLabel(1,"MA_W1");
         break;
      case PERIOD_MN1:
         SetIndexBuffer(0,Buff_0_Speed); SetIndexStyle(0,0,Style_Speed_Line,0,Red);             SetIndexLabel(0,"MA_MN1");
         SetIndexBuffer(1,Buff_1_Smooth); SetIndexStyle(1,0,Style_Smooth_Line,0,Red);           SetIndexLabel(1,"MA_MN1");
         break;
      default: break;
     }
   if(!SHOW_0)SetIndexStyle(0,DRAW_NONE);
//        100 
   Max_MA=search_max_value(MA_Period,Bars_For_Search);

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   Comment("");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//--------------------------------------------------------------------
//-------------      --------
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   int i=Bars-counted_bars;
   if(counted_bars==0) i-=1+Smooth*MathRound(TF_Indicator/Period());

   while(i>=0) //    
     {
      value_speed(MA_Period,Max_MA,i);
      i--;
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+
//+-------
//+-------
//+------------------------------------------------------------------+
//|       1 
//+------------------------------------------------------------------+
double search_max_value(int _Period_MA,int _Bars_For_Search)
  {
   double
   _Max_MA=0;
   int _Div=MathRound(TF_Indicator/Period());
   _Period_MA= _Period_MA*_Div;
   for(int _i=0;_i<_Bars_For_Search;_i++)
     {
      double _MA_0=iMA(NULL,Period(),_Period_MA,0,MA_Method,MA_Price,_i);
      double _MA_1= iMA(NULL,Period(),_Period_MA,0,MA_Method,MA_Price,_i+_Div);
      double _Dif_MA=_MA_0-_MA_1;
      if(_Max_MA<_Dif_MA) _Max_MA=_Dif_MA;
     }
   return(_Max_MA);
  }
//+------------------------------------------------------------------+
//+-------
//+-------
//+------------------------------------------------------------------+
void value_speed(int _Period_MA,double _Max_MA,int _i)
  {
   int _Div=MathRound(TF_Indicator/Period());
   _Period_MA=_Period_MA*_Div;
   int _Period_Average=Smooth*_Div;
   double _MA_0  = iMA(NULL,0,_Period_MA,0,MA_Method,MA_Price,_i);
   double _MA_1  = iMA(NULL,0,_Period_MA,0,MA_Method,MA_Price,_i+_Div);
   Buff_0_Speed[_i]=((_MA_0-_MA_1)/(0.01*_Max_MA));
   double Tmp_Sum=0;
   for(int n=0; n<_Period_Average; n++)
     {
      Tmp_Sum=Tmp_Sum+Buff_0_Speed[_i+n];
     }
   Buff_1_Smooth[_i]=Tmp_Sum/_Period_Average;
  }
//+------------------------------------------------------------------+
//+-------
//+-------
//+------------------------------------------------------------------+
//|                   2011.04.19 
//+------------------------------------------------------------------+
string txt_TF(int _TF)
  {
   string _Txt_TF;
   switch(_TF)
     {
      case PERIOD_M1:  _Txt_TF = "M1";  break;
      case PERIOD_M5:  _Txt_TF = "M5";  break;
      case PERIOD_M15: _Txt_TF = "M15"; break;
      case PERIOD_M30: _Txt_TF = "M30"; break;
      case PERIOD_H1:  _Txt_TF = "H1";  break;
      case PERIOD_H4:  _Txt_TF = "H4";  break;
      case PERIOD_D1:  _Txt_TF = "D1";  break;
      case PERIOD_W1:  _Txt_TF = "W1";  break;
      case PERIOD_MN1: _Txt_TF = "MN1"; break;
      default: Alert("   "+_TF); break;
     }
   return(_Txt_TF);
  }
//+------------------------------------------------------------------+
//+-------
