//+------------------------------------------------------------------+
//|                                         iAccelerateMA_for_ex.mq4 |
//|  100%    Speed MA              |
//|                |
//|   Search_Max                                             |
//+------------------------------------------------------------------+
#define NAME_EXPERT "AccelerateMA"
#define VER "V1"                                     
#define RELIZE "GS_2011_08_08"                        
#define AUTOR "valenok2003@mail.ru"
#define URL "http://bluedream.ucoz.ru"

#property indicator_separate_window
#property indicator_maximum 100
#property indicator_minimum -100

#property indicator_buffers 2       //  
#property indicator_level1 0
#property indicator_levelcolor Gray

extern int TF_Indicator=0;
extern int MA_Period = 25;
extern int MA_Method = 0;
extern int MA_Price  = 1;
extern int MA_Smooth = 25;
extern int Acs_Smooth= 25;
extern bool SHOW_ACS=true;
int Bars_For_Search=1000;
//---- buffers
double Buff_0_Acs[];       //  MA
double Buff_1_Smooth[];    //  
string Name_Window,ex_Name=NAME_EXPERT;
int Style_Acs_Line=DRAW_LINE;
int Style_Smooth_Line=STYLE_DOT;
double Max_MAcs;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   if(TF_Indicator==0) TF_Indicator=Period();
   if(TF_Indicator<Period()) TF_Indicator=Period();
//---- name for indicator window
   Name_Window=ex_Name+"("+txt_TF(TF_Indicator)+",MA_Period("+MA_Period+"),"+"MA_Smooth("+MA_Smooth+")"+")";
   IndicatorShortName(Name_Window);
//--------------------------------------------------------------------
//---- indicators ----------------------------------------------------
   SetIndexBuffer(0,Buff_0_Acs);
   SetIndexBuffer(1,Buff_1_Smooth);
   switch(TF_Indicator)
     {
      case PERIOD_M1:
         SetIndexStyle(0,0,Style_Acs_Line,0,Red);
         SetIndexLabel(0,"MAcs_M1");
         SetIndexStyle(1,0,Style_Smooth_Line,0,Red);
         SetIndexLabel(1,"MAcs_M1");
         break;
      case PERIOD_M5:
         SetIndexStyle(0,0,Style_Acs_Line,0,DarkOrange);
         SetIndexLabel(0,"MAcs_M5");
         SetIndexStyle(1,0,Style_Smooth_Line,0,DarkOrange);
         SetIndexLabel(1,"MAcs_M5");
         break;
      case PERIOD_M15:
         SetIndexStyle(0,0,Style_Acs_Line,0,Yellow);
         SetIndexLabel(0,"MAcs_M15");
         SetIndexStyle(1,0,Style_Smooth_Line,0,Yellow);
         SetIndexLabel(1,"MAcs_M15");
         break;
      case PERIOD_M30:
         SetIndexStyle(0,0,Style_Acs_Line,0,LimeGreen);
         SetIndexLabel(0,"MAcs_M30");
         SetIndexStyle(1,0,Style_Smooth_Line,0,LimeGreen);
         SetIndexLabel(1,"MAcs_M30");
         break;
      case PERIOD_H1:
         SetIndexStyle(0,0,Style_Acs_Line,0,SkyBlue);
         SetIndexLabel(0,"MAcs_H1");
         SetIndexStyle(1,0,Style_Smooth_Line,0,SkyBlue);
         SetIndexLabel(1,"MAcs_H1");
         break;
      case PERIOD_H4:
         SetIndexStyle(0,0,Style_Acs_Line,0,Blue);
         SetIndexLabel(0,"MAcs_H4");
         SetIndexStyle(1,0,Style_Smooth_Line,0,Blue);
         SetIndexLabel(1,"MAcs_H4");
         break;
      case PERIOD_D1:
         SetIndexStyle(0,0,Style_Acs_Line,0,Violet);
         SetIndexLabel(0,"MAcs_D1");
         SetIndexStyle(1,0,Style_Smooth_Line,0,Violet);
         SetIndexLabel(1,"MAcs_D1");
         break;
      case PERIOD_W1:
         SetIndexStyle(0,0,Style_Acs_Line,0,BlueViolet);
         SetIndexLabel(0,"MAcs_W1");
         SetIndexStyle(1,0,Style_Smooth_Line,0,BlueViolet);
         SetIndexLabel(1,"MAcs_W1");
         break;
      case PERIOD_MN1:
         SetIndexStyle(0,0,Style_Acs_Line,0,Red);
         SetIndexLabel(0,"MAcs_MN1");
         SetIndexStyle(1,0,Style_Smooth_Line,0,Red);
         SetIndexLabel(1,"MAcs_MN1");
         break;
      default: break;
     }
   if(!SHOW_ACS)SetIndexStyle(0,DRAW_NONE);
//        100 
   Max_MAcs=search_max_value(Bars_For_Search);

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   Comment("");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//--------------------------------------------------------------------
//-------------      --------
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   int i=Bars-counted_bars;
   if(counted_bars==0) i-=1+Max_MAcs+1+Acs_Smooth;

   while(i>=0) //    
     {
      value_acselerate(Max_MAcs,i);
      i--;
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+
//+-------
//+-------
//+------------------------------------------------------------------+
//|       1 
//+------------------------------------------------------------------+
double search_max_value(int _Bars_For_Search)
  {
   double
   _Max_MAcs=0;
   for(int _i=0;_i<_Bars_For_Search;_i++)
     {
      double _MAcs_0=iCustom(NULL,0,"iSpeedMA_for_exV2",TF_Indicator,MA_Period,MA_Method,MA_Price,MA_Smooth,false,1,_i);
      double _MAcs_1= iCustom(NULL,0,"iSpeedMA_for_exV2",TF_Indicator,MA_Period,MA_Method,MA_Price,MA_Smooth,false,1,_i+1);
      double _Dif_MAcs=MathAbs(_MAcs_0-_MAcs_1);
      if(_Max_MAcs<_Dif_MAcs) _Max_MAcs=_Dif_MAcs;
     }
   return(_Max_MAcs);
  }
//+------------------------------------------------------------------+
//+-------
//+-------
//+------------------------------------------------------------------+
void value_acselerate(double _Max_MAcs,int _i)
  {
   int _Period_Average=Acs_Smooth;
   double _MAcs_0  = iCustom(NULL,0,"iSpeedMA_for_exV2",TF_Indicator,MA_Period,MA_Method,MA_Price,MA_Smooth,false,1,_i);
   double _MAcs_1  = iCustom(NULL,0,"iSpeedMA_for_exV2",TF_Indicator,MA_Period,MA_Method,MA_Price,MA_Smooth,false,1,_i+1);
   if(_Max_MAcs!=0) Buff_0_Acs[_i]=((_MAcs_0-_MAcs_1)/(0.01*_Max_MAcs));
   double Tmp_Sum=0;
   for(int n=0; n<_Period_Average; n++)
     {
      Tmp_Sum=Tmp_Sum+Buff_0_Acs[_i+n];
     }
   Buff_1_Smooth[_i]=Tmp_Sum/_Period_Average;
  }
//+------------------------------------------------------------------+
//+-------
//+-------
//+------------------------------------------------------------------+
//|                   2011.04.19 
//+------------------------------------------------------------------+
string txt_TF(int _TF)
  {
   string _Txt_TF;
   switch(_TF)
     {
      case PERIOD_M1:  _Txt_TF = "M1";  break;
      case PERIOD_M5:  _Txt_TF = "M5";  break;
      case PERIOD_M15: _Txt_TF = "M15"; break;
      case PERIOD_M30: _Txt_TF = "M30"; break;
      case PERIOD_H1:  _Txt_TF = "H1";  break;
      case PERIOD_H4:  _Txt_TF = "H4";  break;
      case PERIOD_D1:  _Txt_TF = "D1";  break;
      case PERIOD_W1:  _Txt_TF = "W1";  break;
      case PERIOD_MN1: _Txt_TF = "MN1"; break;
      default: Alert("   "+_TF); break;
     }
   return(_Txt_TF);
  }
//+------------------------------------------------------------------+
//+-------
