/*---------------------------------------------------+                                     
 |                      Predictive indicator WmiFor  |
 |        Author: Murad Ismailov (18/07/2011 10:17)  |
 |                 http://codebase.mql4.com/ru/7718  |             
 +---------------------------------------------------*/
 
#property indicator_chart_window
#property indicator_buffers 4
#property indicator_style1 STYLE_SOLID
#property indicator_color1 Magenta
#property indicator_width1 2
#property indicator_style2 STYLE_SOLID
#property indicator_color2 DarkBlue
#property indicator_width2 2
#property indicator_style3 STYLE_SOLID
#property indicator_color3 DarkBlue
#property indicator_width3 1
#property indicator_style4 STYLE_SOLID
#property indicator_color4 DarkBlue
#property indicator_width4 1

#include <WinUser32.mqh>

//  

extern int    PastBars     = 36; //    ,     [3..100]
extern int    ForBars      = 24; //       [3..]
extern int    PeriodMA     = 3; //    EMA
extern bool   IsExactTime  = true; //      (   )
//-----
       int    XCorner      = 10; //  .     
       int    YCorner      = 10; //  .     
       color  FontColor    = Aqua; //   .
       string FontName     = "Tahoma"; //   .
       int    FontSize     = 12; //    .

//  

string IndicatorName = "Future";
string IndicatorVersion = "1.0";
double ForSource[];
double ForMain[];
double ForHistogramHigh[];
double ForHistogramLow[];
int PrevTime;

//+------------------------------------------------------------------+
//|                                                     |
//+------------------------------------------------------------------+

int init()
{
   if (!IsDllsAllowed())
   {
      Alert("For working ", IndicatorName, " it has to be allow a DLL");
      return (0);
   }
   
   ArrayInitialize(ForSource, EMPTY_VALUE);
   SetIndexBuffer(0, ForSource);
   SetIndexShift(0, 0);
   
   ArrayInitialize(ForMain, EMPTY_VALUE);
   SetIndexBuffer(1, ForMain);
   SetIndexShift(1, ForBars);
   
   ArrayInitialize(ForHistogramHigh, EMPTY_VALUE);
   SetIndexBuffer(2, ForHistogramHigh);
   SetIndexStyle(2, DRAW_HISTOGRAM); 
   SetIndexShift(2, ForBars);   
   
   ArrayInitialize(ForHistogramLow, EMPTY_VALUE);
   SetIndexBuffer(3, ForHistogramLow);
   SetIndexStyle(3, DRAW_HISTOGRAM); 
   SetIndexShift(3, ForBars);
      
   int windowHandle = WindowHandle(Symbol(), Period());
   if (windowHandle != 0) 
   {
      //  ,  
   
      PostMessageA(windowHandle, WM_COMMAND, 33324, 0);
   }
   
   PrevTime = 0;
   
   if (PastBars < 3)
   {
      PastBars = 3;
   }
   else
   {
      if (PastBars > 100)
      {
         PastBars = 100;
      }
   }
   
   if (ForBars < 3)
   {
      ForBars = 3;
   }
   
   return (0);
}

//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+

int deinit()
{
   //    
   
   for (int index = 0; index < ObjectsTotal(); index++) 
   {
      if (StringFind(ObjectName(index), IndicatorName) == 0) 
      {
         ObjectDelete(ObjectName(index));
         index--;
      }
   }   

   return (0);
}

//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+

int start()
{
   int counted_bars = IndicatorCounted();
   if (IsNewBar())
   {
      ReCalculate();
   }
      
   return (0);
}

//+------------------------------------------------------------------+
//|   ?                                              |
//+------------------------------------------------------------------+

bool IsNewBar()
{
   int currentTime = iTime(NULL, 0, 0);
   if (PrevTime == currentTime)
   {
      return (false);
   }

   PrevTime = currentTime;
   return (true);
}

//+------------------------------------------------------------------+
//|                                                          |
//+------------------------------------------------------------------+

void ReCalculate()
{
   /*
   int handleLog;
   handleLog = FileOpen(IndicatorName + ".log", FILE_WRITE);
   if (handleLog < 1)
   {
      Print ("handleLog = ", handleLog, ", error = ", GetLastError());
   }

   FileWrite(handleLog, "Recalculate...");
   */
      
   //      
   
   int baseHour = TimeHour(Time[1]);
   int baseMinute = TimeMinute(Time[1]);
   /*
   FileWrite(handleLog, "baseHour", baseHour, "baseMinute", baseMinute);
   */
   
   double x[100];
   double xmaBase = iMA(NULL, 0, PeriodMA, 0, MODE_EMA, PRICE_CLOSE, 1);
   for (int indexBar = 0; indexBar < PastBars; indexBar++)
   {
      x[indexBar] = iMA(NULL, 0, PeriodMA, 0, MODE_EMA, PRICE_CLOSE, indexBar + 1);
      /*FileWrite(handleLog, "indexBar", indexBar + 1, "x", x[indexBar]);*/
   }  
   
   // 
   
   int xpi;
   double xp[100];
   double xlevelmin = -1000000.0;
   for (int pass = 0; pass < PastBars; pass++)
   {
      int ixmin = -1;
      double xmin = -1000000.0;
      for (int ix = 0; ix < PastBars; ix++)
      {
         if (x[ix] <= xlevelmin)
         {
            continue;
         }
      
         if (ixmin == -1)
         {
            ixmin = ix;
            xmin = x[ix];
         }
         else
         {
            if (x[ix] < xmin)
            {
               ixmin = ix;
               xmin = x[ix];
            }
         }
      }
      
      xpi++;
      xp[ixmin] = xpi;
      xlevelmin = xmin;
   }
   
   /*
   for (indexBar = 0; indexBar < PastBars; indexBar++)
   {
      FileWrite(handleLog, "indexBar", indexBar, "xp", xp[indexBar]);
   }
   */
   
   //     
   
   int iMain = 0;
   double kMain = -1000000.0;
   
   int ypi;
   for (int indexShift = 2; indexShift < Bars; indexShift++)
   {
      if (IsExactTime)
      {
         int currentHour = TimeHour(Time[indexShift]);
         if (currentHour != baseHour)
         {
            continue;
         }

         int currentMinute = TimeMinute(Time[indexShift]);
         if (currentMinute != baseMinute)
         {
            continue;
         }
      }
   
      if ((indexShift + PastBars + 1) >= Bars)
      {
         break;
      }
      
      //      
   
      double y[100];      
      double ymaBase = iMA(NULL, 0, PeriodMA, 0, MODE_EMA, PRICE_CLOSE, indexShift + 1);
      for (indexBar = 0; indexBar < PastBars; indexBar++)
      {
         y[indexBar] = iMA(NULL, 0, PeriodMA, 0, MODE_EMA, PRICE_CLOSE, indexShift + indexBar + 1);
         /* FileWrite(handleLog, "indexBar", indexShift + indexBar + 1, "y", y[indexBar]); */
      }
      
      // 
   
      ypi = 0;         
      double yp[100];
      double ylevelmin = -1000000.0;
      for (pass = 0; pass < PastBars; pass++)
      {
         int iymin = -1;
         double ymin = -1000000.0;
         for (int iy = 0; iy < PastBars; iy++)
         {
            if (y[iy] <= ylevelmin)
            {
               continue;
            }
      
            if (iymin == -1)
            {
               iymin = iy;
               ymin = y[iy];
            }
            else
            {
               if (y[iy] < ymin)
               {
                  iymin = iy;
                  ymin = y[iy];
               }
            }
         }
      
         ypi++;
         yp[iymin] = ypi;
         ylevelmin = ymin;
      }
   
      /*
      for (indexBar = 0; indexBar < PastBars; indexBar++)
      {
         FileWrite(handleLog, "indexBar", indexBar, "yp", yp[indexBar]);
      }
      */
      
      //  
      
      double k = 0.0;
      for (indexBar = 0; indexBar < PastBars; indexBar++)
      {
         k += (xp[indexBar] - yp[indexBar]) * (xp[indexBar] - yp[indexBar]);
      }
      
      k = 1.0 - ((6.0 * k) / ((PastBars * PastBars * PastBars) - PastBars));
      /*
      FileWrite(handleLog, TimeToStr(Time[indexShift]), handleLog, "k", k);
      */
      
      // 
      
      if (kMain < -1.0)
      {
         kMain = k;
         iMain = indexShift; 
      }
      else
      {
         if (k > kMain)
         {
            kMain = k;
            iMain = indexShift; 
         }
      }  
   }
   
   /*
   FileWrite(handleLog, "iMain", iMain, "kMain", kMain);
   */
   
   //  
   
   ArrayInitialize(ForSource, EMPTY_VALUE);
   for (indexBar = 0; indexBar < PastBars; indexBar++)
   {
      ForSource[indexBar] = iMA(NULL, 0, PeriodMA, 0, MODE_EMA, PRICE_CLOSE, indexBar + 1);
   }
   
   double price;
   ymaBase = iMA(NULL, 0, PeriodMA, 0, MODE_EMA, PRICE_CLOSE, iMain + 1);
   ArrayInitialize(ForMain, EMPTY_VALUE);
   for (indexBar = 0; indexBar < (PastBars + ForBars); indexBar++)
   {
      price = xmaBase + iMA(NULL, 0, PeriodMA, 0, MODE_EMA, PRICE_CLOSE, iMain - ForBars + indexBar + 1) - ymaBase;
      ForMain[indexBar] = price;
   }
   
   for (indexBar = 0; indexBar < (PastBars + ForBars); indexBar++)
   {
      price = xmaBase + iMA(NULL, 0, PeriodMA, 0, MODE_EMA, PRICE_CLOSE, iMain - ForBars + indexBar + 1) - ymaBase;
      ForMain[indexBar] = price;
   }

   ArrayInitialize(ForHistogramHigh, 0.0);
   ArrayInitialize(ForHistogramLow, 0.0);   
   for (indexBar = 0; indexBar < ForBars; indexBar++)
   {
      price = xmaBase + High[iMain - ForBars + indexBar + 1] - ymaBase;
      ForHistogramHigh[indexBar] = price;
      
      price = xmaBase + Low[iMain - ForBars + indexBar + 1] - ymaBase;
      ForHistogramLow[indexBar] = price;
   }   
   //Comment(ForHistogramHigh[18], "  ", ForHistogramLow[18], "  ", (ForHistogramHigh[18] + ForHistogramLow[18]) / 2);
   //   
   
   DrawLabel("Source", "Initial Bars: " + PastBars + "  " + TimeToStr(Time[1]), 0, 5);
   DrawLabel("Main", "Found Template: " + TimeToStr(Time[iMain]), 0, 25);
   DrawLabel("Proc", "Probability: " + DoubleToStr(100.0 * kMain, 1) + "%", 0, 45);
      
   /*
   FileClose(handleLog);
   */
}

//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+

void DrawLabel(string label, string text, int x, int y)
{
   string labelIndicator = IndicatorName + "Label" + label;   
   if (ObjectFind(labelIndicator) == -1)
   {
      ObjectCreate(labelIndicator, OBJ_LABEL, 0, 0, 0);
      ObjectSet(labelIndicator, OBJPROP_CORNER, 1);
   }
   
   ObjectSet(labelIndicator, OBJPROP_XDISTANCE, XCorner + x);
   ObjectSet(labelIndicator, OBJPROP_YDISTANCE, YCorner + y);
   ObjectSetText(labelIndicator, text, FontSize, FontName, FontColor);
}

/*
void FillTestData()
{
   int indexBar;
   
   for (indexBar = 0; indexBar < PastBars; indexBar++)
   {
      ForSource[indexBar] = iMA(NULL, 0, PeriodMA, 0, MODE_EMA, PRICE_CLOSE, indexBar + 1);
   }   

   for (indexBar = 0; indexBar < (PastBars + ForBars); indexBar++)
   {
      ForMain[indexBar] = iMA(NULL, 0, PeriodMA, 0, MODE_EMA, PRICE_CLOSE, indexBar + 1);
   }
   
   for (indexBar = 0; indexBar < (PastBars + ForBars); indexBar++)
   {
      ForStrong[indexBar] = iMA(NULL, 0, 11, 0, MODE_EMA, PRICE_CLOSE, indexBar + 1);
   }
   
   for (indexBar = 0; indexBar < (PastBars + ForBars); indexBar++)
   {
      ForWeak[indexBar] = iMA(NULL, 0, 23, 0, MODE_EMA, PRICE_CLOSE, indexBar + 1);
   }      
}
*/