/*------------------------------------------------------------------+
 |                                               EA_Future_001a.mq4 |
 |                                                 Copyright  2011 |
 |                      Based on the Predictive Indicator:   WmiFor |
 |                        Author: Murad Ismailov (18/07/2011 10:17) |
 +------------------------------------------------------------------*/
#property copyright "Copyright  2011, basisforex@gmail.com"
#property link      "basisforex@gmail.com"
//-----  
#define MagicNum 10001
//-----
extern int      PastBars            = 34;
extern int      ForBars             = 24;
extern int      PeriodMA            = 12;
extern bool     IsExactTime         = true;
extern int      nFutBar             = 22;// Should be less than ForBars
extern int      nPoints             = 13;
//-----
extern int      TP                  = 39;
extern int      SL                  = 39;
//-----
extern bool     UseMM               = false;
extern int      PercentMM           = 10;
extern double   Lots                = 0.1;
//+------------------------------------------------------------------+
double GetLots()
 { 
   if (UseMM)
    {
      double a, maxLot, minLot;
      a = (PercentMM * AccountFreeMargin() / 100000);
      double LotStep = MarketInfo(Symbol(), MODE_LOTSTEP);
      maxLot  = MarketInfo(Symbol(), MODE_MAXLOT );
      minLot  = MarketInfo(Symbol(), MODE_MINLOT );   
      a =  MathFloor(a / LotStep) * LotStep;
      if (a > maxLot) return(maxLot);
      else if (a < minLot) return(minLot);
      else return(a);
    }    
   else return(Lots);
 }
//+------------------------------------------------------------------+ 
int CalculateCurrentOrders()
 {
   int orderT = OrdersTotal(), buys = 0, sells = 0;
   //----
   for(int i = 0; i < orderT; i++)
    {
      if(OrderSelect(i, SELECT_BY_POS, MODE_TRADES) == false) break;
      if(OrderSymbol() == Symbol() && OrderMagicNumber() == MagicNum)
       {
         if(OrderType() == OP_BUY)  buys++;
         if(OrderType() == OP_SELL) sells++;
       }
    }
   if(buys > 0) return(buys);
   else if(sells > 0) return(-sells);
   else return(0);
 }
//+------------------------------------------------------------------+ 
int Get_Broker_Digit()
 {  
   if(Digits == 5 || Digits == 3)
    { 
       return(10);
    } 
   else
    {    
       return(1); 
    }   
 }
//+------------------------------------------------------------------+  
int start()
 {
   int cnt, ticket, total;
   int digitKoeff = Get_Broker_Digit();
   //-----
   if(CalculateCurrentOrders() == 0) 
    {      
      double fHi = iCustom(NULL, 0, "Future", PastBars, ForBars, PeriodMA, IsExactTime, 0, nFutBar);
      double fLo = iCustom(NULL, 0, "Future", PastBars, ForBars, PeriodMA, IsExactTime, 1, nFutBar);      
      double bTP = (fHi + fLo) / 2;
      //-------------------------------------------------------  
      if(fHi > (Close[0] + nPoints * Point) && fLo > (Close[0] + nPoints * Point))
       {     
         ticket = OrderSend(Symbol(), OP_BUY, GetLots(), Ask, 3 * digitKoeff, Ask - SL * Point * digitKoeff, bTP, "future", MagicNum, 0, Green);
         if(ticket > 0)
          {            
            PlaySound("news.wav"); 
            return(0);
          }
       }     
      if(fHi < (Close[0] - nPoints * Point)  && fLo < (Close[0] - nPoints * Point) )
       {
         ticket = OrderSend(Symbol(), OP_SELL, GetLots(), Bid, 3 * digitKoeff, Bid + SL * Point * digitKoeff, bTP, "future", MagicNum, 0, Red);
         if(ticket > 0)
          {
            PlaySound("news.wav"); 
            return(0); 
          }  
       }            
    }
   return(0); 
 }