//+------------------------------------------------------------------+
//|                                           SultonovPrediction.mq4 |
//|                             Copyright  2011,   |
//| Realisation :             Goshkov Vladyslav 2011. 4vg AT mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011,  "
#property link      ""

#property indicator_chart_window

#include <stdlib.mqh>
#include <stderror.mqh>

extern string prf = "sp_P";

#define MXSIZE_KYPC   151
#define MXSIZE_P      201
extern string   s00 = "    ";
extern string   s01 = "MAX = 150";
extern int      HistoryBarsCount  =  30;
extern string   s02 = "+----------------------------+";
extern string   s03 = " ,    ,";
extern string   s04 = "   ";
extern int      FROM =  0;
extern string   s10 = "+============================+";
extern string   s11 = "   ";
extern string   s12 = "     ";
extern string   s13 = "   200";
extern int      PredictionBarsCount =  30;
int SIZE_KYPC = 20;
int SIZE_P    = 60;
#define KYPC_DIGITS  6
double KYPC[MXSIZE_KYPC];/* = {1.3635, 1.3630, 1.3625, 1.3620, 1.3615, 
                          1.3612, 1.3610, 1.3608, 1.3606, 1.3602,
                          1.3603
                         };
                         */
double P1[MXSIZE_P],P2[MXSIZE_P],P3[MXSIZE_P];
bool New_Bar=false;                              //    
static datetime New_Time;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
//---- indicators
    SIZE_KYPC = HistoryBarsCount;
    SIZE_P    = SIZE_KYPC + PredictionBarsCount;
//----
   return(0);
  }
///      prefix
int deleteObjectsByPrefix(string prefix, bool onlyPrefix = true)
{
	int obj_total = ObjectsTotal();
	string name="";
	int err = GetLastError();
	int Delcount = 0;
	int Objcount = 0;
	for (int i = obj_total - 1; i >= 0; i--)
	{
		name = ObjectName(i);
		bool condition = false;
		if(onlyPrefix)
		    condition = (StringFind(name, prefix,0) == 0);
		else 
		    condition = (StringFind(name, prefix) != -1);
		if (condition)
		{
		   Objcount++;
			if(ObjectDelete(name))Delcount++;
			else
			{
			    err = GetLastError();
			    Print("Error(",err,") ",ErrorDescription(err)); 
			}
		}			
	}
	return(Delcount-Objcount);
}  
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   deleteObjectsByPrefix(prf);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
/*
double GAMMADIST(double X, double Alfa, double betta, bool IsIntegral)
{
    if(betta==1)
        return(StdGAMMADIST());
    if(IsIntegral)
        return();
}

int P1Prediction(double Prc[])
{
int rez = 0;
int PrcCnt = ArraySize(Prc); 
    return(rez);
}

int P2Prediction(double Prc[])
{
int rez = 0;
int PrcCnt = ArraySize(Prc); 
    return(rez);
}

int P3Prediction(double Prc[])
{
int rez = 0;
int PrcCnt = ArraySize(Prc); 
    return(rez);
}

int SultonovPrediction(double Prc[])
{
int res = P1Prediction(Prc)+P2Prediction(Prc)+P3Prediction(Prc);    
    if(MathAbs(res)==3)
        return(res);
    return(0);
}
*/

int SultonovPrediction(int NP, double &P1[], double &P2[], double &P3[], int NK, double K[])
{
int i=0;
int SzK = NK;
    //ArraySize(K);
    //Print("SzK = ",SzK );
double tt[];    
    ArrayResize(tt,NP);
double tr[];    
    ArrayResize(tr,NP);
    for(i=0;i<NP;i++)
    {
        tt[i] = i;
        tr[i] = i;
    }
    
double SumK = 0.0;    
    for(i=0;i<SzK;i++)
    {
        SumK = SumK + K[i];
    }
    
double SumJ = 0.0;    
    for(i=0;i<SzK;i++)
    {
        SumJ = SumJ + tt[i];
    }
    
double k = -0.5+ MathSqrt(0.25+2.0*SumJ);//-0,5+(0,25+2*SUM(J$1:J$1048576))^0,5
    //Print("SumJ = ",SumJ," k = ",k );
/*
    for(i=0;i<SzK;i++)
    {
        Print("K[",i,"] = ",DoubleToStr(K[i],KYPC_DIGITS) );
    }
*/    
double Cy[];    // dK = K[i+1]-K[i];
    ArrayResize(Cy,NP);
    Cy[0] = 0.0;
    for(i=1;i<SzK;i++)
    {
        Cy[i] = K[i]-K[i-1];
    }
    for(;i<NP;i++)
    {
        Cy[i] = 0;
    }
    /*
    for(i=1;i<SzK;i++)
    {
        Print("Cy[",i,"] = ",DoubleToStr(Cy[i],KYPC_DIGITS) );
    }
    */
double xy[];    //tt[i]*Cy[i]
    ArrayResize(xy,SzK);
    for(i=1;i<SzK;i++)
    {
        xy[i] = tt[i]*Cy[i];
    }
    
    /*    
    for(i=1;i<SzK;i++)
    {
        Print("xy[",i,"] = ",DoubleToStr(xy[i],KYPC_DIGITS) );
    }
    */
double SumA = 0.0;    
    for(i=0;i<SzK;i++)
    {
        SumA = SumA + xy[i];
    }
    
    //Print("SumA = ",SumA );
double SumM = 0.0;    
    for(i=0;i<SzK;i++)
    {
        SumM = SumM + Cy[i];
    }
    //Print("SumM = ",SumM );
    
//(H2*SUM(A$1:A$1048576)-SUM(J$1:J$1048576)*SUM(M$1:M$1048576))/((H2*(H3*(H3+1)*(2*H3+1)/6)-SUM(J$1:J$1048576)^2))
//(H2*SUM(A$1:A$1048576)-SUM(J$1:J$1048576)*SUM(M$1:M$1048576))
//((H2*(H3*(H3+1)*(2*H3+1)/6)-SUM(J$1:J$1048576)^2))

double b1 = (k*SumA-SumJ*SumM);
double b2 = (k*(k*(k+1)*(2*k+1)/6.)-SumJ*SumJ);
double b  = b1/b2;
    //Print("b = ",DoubleToStr(b,10) );
//(SUM(M$1:M$1048576)*(H3*(H3+1)*(2*H3+1)/6)-SUM(J$1:J$1048576)*SUM(A$1:A$1048576))/(H2*(H3*(H3+1)*(2*H3+1)/6)-SUM(J$1:J$1048576)^2)+B2*I2    
double k1Yr = (SumM*(k*(k+1)*(2*k+1)/6.)-SumJ*SumA)/(k*(k*(k+1)*(2*k+1)/6.)-SumJ*SumJ);
    //Print("k1Yr = ",DoubleToStr(k1Yr,10) );
double Yr[];
    ArrayResize(Yr,NP);
    for(i=0;i<NP;i++)
    {
        Yr[i] = k1Yr  + b*tr[i];
    }
/*    
    for(i=0;i<NP;i++)
    {
        Print("Yr[",i,"] = ",DoubleToStr(Yr[i],14) );
    }
*/
int Trend1[], Trend2[],Trend3[];
    ArrayResize(Trend1,NP);
    ArrayResize(Trend2,NP);
    ArrayResize(Trend3,NP);
    for(i=0;i<NP;i++)
    {
        if(SumA>0) 
            Trend1[i] = 1;
        else
        {
            if(SumA<0)
                Trend1[i] = -1;
            else 
                Trend1[i] =  0;

        }
        if(b>0) 
            Trend2[i] = 1;
        else
        {
            if(b<0)
                Trend2[i] = -1;
            else 
                Trend2[i] =  0;

        }
        if(Yr[i]>0) 
            Trend3[i] = 1;
        else
        {
            if(Yr[i]<0)
                Trend3[i] = -1;
            else 
                Trend3[i] =  0;

        }
        
    }
/*
    for(i=0;i<NP;i++)
    {
        Print("TYrends[",i,"] => ", Trend1[i], " ", Trend2[i], " ", Trend3[i]);
    }
*/
//IF(J3>0;IF(K3-K2<0;LN(-(K3-K2)/(J3+J2)*2);LN((K3-K2)/(J3+J2)*2))*IF(J3=0;0;1);0)
double LnC_t[];
    ArrayResize(LnC_t,NP);
    LnC_t[0] = 0;
    for(i=1;i<SzK;i++)
    {
        if(tt[i]>0)
        {
            if( Cy[i]<0 )
            {
                LnC_t[i] = MathLog(-Cy[i]/(tt[i]+tt[i-1])*2);
            }
            else
            {
                if( Cy[i]>0 )
                {
                    LnC_t[i] = MathLog(Cy[i]/(tt[i]+tt[i-1])*2);
                }
                else 
                    LnC_t[i] = 0;
            }
        }
        else LnC_t[i] = 0;
    }
/*
    for(i=0;i<SzK;i++)
    {
        Print("LnC_t[",i,"] => ", LnC_t[i]);
    }
*/
    
//IF(J3>0;(J3+J2)/2*N3;0)
double tLnC_t[];
    ArrayResize(tLnC_t,SzK);
    tLnC_t[0] = 0;
    for(i=1;i<SzK;i++)
    {
        if(tt[i]>0)
        {
             tLnC_t[i] = (tt[i]+tt[i-1])/2.*LnC_t[i];
        }
        else tLnC_t[i] = 0;
    }
    
/*
    for(i=0;i<SzK;i++)
    {
        Print("tLnC_t[",i,"] => ", tLnC_t[i]);
    }
*/
double SumN = 0.0;
    for(i=0;i<SzK;i++)
    {
        SumN = SumN + LnC_t[i];
    }
    
double SumO = 0.0;
    for(i=0;i<SzK;i++)
    {
        SumO = SumO + tLnC_t[i];
    }
    //Print("SumN = ",SumN," SumO = ",SumO );
    
//(H3*(H3*(H3+1)*(2*H3+1)/6-(H3/2+0,25)*H3)-(H3*(H3+1)/2-H3/2)^2)/((H3*(H3+1)/2-H3/2)*SUM(N$1:N$1048576)-H3*SUM(O$1:O$1048576))
double T = (k*(k*(k+1)*(2*k+1)/6.-(k/2.+0.25)*k)-(k*(k+1)/2.-k/2)*(k*(k+1)/2.-k/2))/((k*(k+1)/2.-k/2.)*SumN-k*SumO);   
    //Print("T = ",T );
//P3^2/EXP((SUM(N$1:N$1048576)*(H3*(H3+1)*(2*H3+1)/6-(H3/2+0,25)*H3)-(H3*(H3+1)/2-H3/2)*SUM(O$1:O$1048576))/(H3*(H3*(H3+1)*(2*H3+1)/6-(H3/2+0,25)*H3)-(H3*(H3+1)/2-H3/2)^2))    
double D = (T*T)/MathExp(  (SumN*(k*(k+1)*(2*k+1)/6.-(k/2.+0.25)*k)-(k*(k+1)/2.-k/2.)*SumO)/(k*(k*(k+1)*(2*k+1)/6.-(k/2.+0.25)*k)-(k*(k+1)/2.-k/2)*(k*(k+1)/2.-k/2)) );
    //Print("D = ",D );
double P0 = K[0]+0.00000001;//(K2+0,00000001)*IF(K3=0;0;1)
    if( K[1]==0 ) P0=0.0;
// IF(E3>0;1;-1)*(1-(1+I3/P3)*EXP(-I3/P3))*Q3    
double PrE[];
    ArrayResize(PrE,SzK);
    PrE[0] = 0;
    for(i=1;i<SzK;i++)
    {
        PrE[i] = Trend1[i]*(1-(1+tr[i]/T)*MathExp(-tr[i]/T))*D;
    }
    
/*
    for(i=0;i<SzK;i++)
    {
        Print("PrE[",i,"] => ", PrE[i]);
    }
*/
double SumT = 0.0;
    for(i=0;i<SzK;i++)
    {
        SumT = SumT + PrE[i];
    }
    //Print("SumT = ",SumT );
//ABS((SUM(K$1:K$1048576)-(H3+1)*L3)/SUM(S$1:S$1048576))*P3^2/EXP((SUM(N$1:N$1048576)*(H3*(H3+1)*(2*H3+1)/6-(H3/2+0,25)*H3)-(H3*(H3+1)/2-H3/2)*SUM(O$1:O$1048576))/(H3*(H2*(H2+1)*(2*H2+1)/6-(H2/2+0,25)*H2)-(H3*(H3+1)/2-H3/2)^2))    
double DCorr = MathAbs((SumK-(k+1)*P0)/SumT)*(T*T)/MathExp((SumN*(k*(k+1)*(2*k+1)/6.-(k/2.+0.25)*k)-(k*(k+1)/2.-k/2)*SumO)/(k*(k*(k+1)*(2*k+1)/6.-(k/2.+0.25)*k)-(k*(k+1)/2.-k/2.)*(k*(k+1)/2.-k/2.)));//
    //Print("DCorr = ",DCorr );
    //(SUM(K$1:K$1048576)-L2-ABS((SUM(K$1:K$1048576)-(H3+1)*L3))*IF(E3<0;-1;1))/H3+(1-(1+I3/P3)*EXP(-I3/P3))*R3*IF(E3<0;-1;1)
    P1[0] = K[0];
    for(i=1;i<NP;i++)
    {
        P1[i] = (SumK-P0-MathAbs((SumK-(k+1)*P0))*Trend1[i])/k+(1-(1+tr[i]/T)*MathExp(-tr[i]/T))*DCorr*Trend1[i];
    }
    //(SUM(K$1:K$1048576)-L2-ABS((SUM(K$1:K$1048576)-(H3+1)*L3))*IF(F3<0;-1;1))/H3+(1-(1+I3/P3)*EXP(-I3/P3))*R3*IF(F3<0;-1;1)
    P2[0] = K[0];
    for(i=1;i<NP;i++)
    {
        P2[i] = (SumK-P0-MathAbs((SumK-(k+1)*P0))*Trend2[i])/k+(1-(1+tr[i]/T)*MathExp(-tr[i]/T))*DCorr*Trend2[i];
    }
    //(SUM(K$1:K$1048576)-L2-ABS((SUM(K$1:K$1048576)-(H3+1)*L3))*IF(G3<0;-1;1))/H3+(1-(1+I3/P3)*EXP(-I3/P3))*R3*IF(G3<0;-1;1)
    P3[0] = K[0];
    for(i=1;i<NP;i++)
    {
        P3[i] = (SumK-P0-MathAbs((SumK-(k+1)*P0))*Trend3[i])/k+(1-(1+tr[i]/T)*MathExp(-tr[i]/T))*DCorr*Trend3[i];
    }
/*
    for(i=0;i<NP;i++)
    {
        Print("P1[",i,"] => ", DoubleToStr(P1[i],8)," P2[",i,"] => ", DoubleToStr(P2[i],8)," P3[",i,"] => ", DoubleToStr(P3[i],8) );
    }
*/
    int CurBarNumber = NK-1;
    int rez = Trend1[CurBarNumber]+Trend2[CurBarNumber]+Trend3[CurBarNumber];
    //>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    ArrayResize(PrE   ,0);
    ArrayResize(tLnC_t,0);
    ArrayResize(LnC_t ,0);
    ArrayResize(Trend3,0);
    ArrayResize(Trend2,0);
    ArrayResize(Trend1,0);
    ArrayResize(Yr,0);
    ArrayResize(xy,0);
    ArrayResize(Cy,0);
    ArrayResize(tr,0);
    ArrayResize(tt,0);
    if(MathAbs(rez)==3)
        return(rez);
    return(0);
}//int SultonovPrediction(double &P1[], double &P2[], double &P3[], int N, double K[])


bool IsNewChartTFBar()
{
static int nB=-1,nT=-1,nP=-1;
    if((nB==Bars)&&(nT==Time[0])&&(nP==Period())) return(false);
    nB = Bars;
    nT = Time[0];
    nP = Period();
    return(true);
}//IsNewChartTFBar()

datetime GetTimeByBarNumber(string SMBL, int periodInMin, int barNumber )
{
    if (periodInMin == 0)
        periodInMin = Period();

    if (barNumber >= 0)
        return(iTime(SMBL, periodInMin, barNumber));
    else
        return(iTime(SMBL, periodInMin, 0) - barNumber*periodInMin*60);
}

string GetDateByBarTime(datetime bTm)
{
    return(
        StringConcatenate(
                          "Y:",TimeYear(bTm)," M:",TimeMonth(bTm)," D:",TimeDay(bTm)," H:",TimeHour(bTm)," Min:",TimeMinute(bTm)," Sec:",TimeSeconds(bTm)
                          )
        );
}

int CheckSltPrdSignal(int &rezTrend, int _NP, double &_P1[], double &_P2[], double &_P3[], double _K[], int BarsCnt=30, int from=0, bool draw =  true)
{
    int j = 0;
    int i = 0;
    int _NK = BarsCnt + from;
    if(BarsCnt>=MXSIZE_KYPC) return(- 1);
    if(_NP>=MXSIZE_P)        return(-10);
    for(i=_NK-1;i>=from;i--,j++)
    {
        KYPC[i] = Open[j];
        //Print("KYPC[",i,"] = ",KYPC[i]);
    }
    
    //Print("Call SP() !");
    rezTrend = SultonovPrediction(_NP, _P1, _P2, _P3, _NK, KYPC);
    //Print("Call SP() Ok!");
    int j0=1, j1=2;
    int i0=1, i1=2;
    //Print("SIZE_P = ", SIZE_P," SIZE_KYPC = ",SIZE_KYPC );
    if(!draw)
        return(0);
    for(;i1<_NP;i0++,i1++)
    {
        j0 = _NK-i0;
        j1 = _NK-i1;
        datetime Point1Time  = GetTimeByBarNumber(Symbol(), Period(), j0+from ), Point2Time  = GetTimeByBarNumber(Symbol(), Period(), j1+from );
        //double   Point1Price = P1[i0], Point2Price = P1[i1];
        string LnNm = prf+i0;
        //Print(LnNm," Point1Time = ",GetDateByBarTime(Point1Time), " Point1Price = ", Point1Price," Point2Time = ",GetDateByBarTime(Point2Time), " Point2Price = ", Point2Price );
        draw_line(prf+"1"+i0, Point1Time, P3[i0], Point2Time, P3[i1], Yellow, DRAW_LINE,  5);
        draw_line(prf+"2"+i0, Point1Time, P2[i0], Point2Time, P2[i1], Blue,   DRAW_LINE,  3);
        draw_line(prf+"3"+i0, Point1Time, P1[i0], Point2Time, P1[i1], Red,    STYLE_DASH, 0);
    }
    return(0);
}
//+------------------------------------------------------------------+
void Fun_New_Bar()                              // -   
  {                                             
   New_Bar=false;                               //   
   if(New_Time!=Time[0])                        //  
     {
      New_Time=Time[0];                         //   
      New_Bar=true;                             //     
     }
  }


int start()
{
   Fun_New_Bar();
   if (New_Bar) {
      SIZE_KYPC++;
      SIZE_P++;
   }
    if(!IsNewChartTFBar()) return(0);   
int    counted_bars=IndicatorCounted();
    //----
int trend=0;
int err = CheckSltPrdSignal(trend, SIZE_P, P1, P2, P3, KYPC, SIZE_KYPC, FROM,  true);
    // ----
    return(0);
}

int draw_line(string lnName, int TimeFrom, double PriceFrom, int TimeTo, double PriceTo, color c, int type, int width)
{
int     err = GetLastError();
string  buff_str = lnName;
    err = 0;
    if(ObjectFind(buff_str)!=-1) ObjectDelete(buff_str);
    if(!ObjectCreate(buff_str, OBJ_TREND, 0, TimeFrom, PriceFrom, TimeTo, PriceTo))
    {
        err = GetLastError();
        Print("Can't create object #", buff_str, "# Error(",err,"):", ErrorDescription(err));
        return(err);
    }
    ObjectSet(buff_str, OBJPROP_RAY  , 0 );
    ObjectSet(buff_str, OBJPROP_COLOR, c    );
    ObjectSet(buff_str, OBJPROP_WIDTH, width);
    ObjectSet(buff_str, OBJPROP_STYLE, type );
    //ObjectMove(buff_str,0,TimeFrom, PriceFrom);
    //ObjectMove(buff_str,1,TimeTo, PriceTo);
    return(0);
}//


//+------------------------------------------------------------------+