//+------------------------------------------------------------------+
//|                                                        iS_04.mq5 |
//|                                 (c) 2010.02.09, Vladimir Gomonov |
//|                                            MetaDriver@rambler.ru |
//+------------------------------------------------------------------+
#property copyright "(c) 2011.02.09, Vladimir Gomonov"
#property link      "MetaDriver@rambler.ru"
#property version   "1.04"
#property indicator_chart_window
#property indicator_buffers 8
#property indicator_plots   4
//--- plot P1
#property indicator_label1  "P1"
#property indicator_type1   DRAW_COLOR_LINE
#property indicator_color1  LightBlue, CLR_NONE
#property indicator_style1  STYLE_SOLID
#property indicator_width1  5
//--- plot P2
#property indicator_label2  "P2"
#property indicator_type2   DRAW_COLOR_LINE
#property indicator_color2  Pink, CLR_NONE
#property indicator_style2  STYLE_SOLID  // STYLE_DOT
#property indicator_width2  3
//--- plot P3
#property indicator_label3  "P3"
#property indicator_type3   DRAW_COLOR_LINE
#property indicator_color3  Purple, CLR_NONE
#property indicator_style3  STYLE_DASH
#property indicator_width3  1
//--- plot Pf
#property indicator_label4  "Pf"
#property indicator_type4   DRAW_COLOR_LINE
#property indicator_color4  DodgerBlue, CLR_NONE
#property indicator_style4  STYLE_SOLID
#property indicator_width4  2

#include <Math\gammaDF.mqh>
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum eiModes
  {
   eGammaMode,  //  -
   eExpMode,    //  
  };
//--- input parameters
input int      HistoryShift=1;  //     ( )
input int      HistoryLen=20;   //    ( )
input int      FutureLen=64;    //   ( )
input eiModes  Mode=eGammaMode; //  
//--- indicator buffers
double         P1Buffer[];
double         P1Colors[];
double         P2Buffer[];
double         P2Colors[];
double         P3Buffer[];
double         P3Colors[];
double         PfBuffer[];
double         PfColors[];
int            k;            // = HistoryLen-1;
int            FullLen;      // = HistoryLen + FutureLen
int            Sk;           //   k 
int            Sk2;          //   k^2 
int            ControlShift=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,P1Buffer,INDICATOR_DATA);
   SetIndexBuffer(1,P1Colors,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(2,P2Buffer,INDICATOR_DATA);
   SetIndexBuffer(3,P2Colors,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(4,P3Buffer,INDICATOR_DATA);
   SetIndexBuffer(5,P3Colors,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(6,PfBuffer,INDICATOR_DATA);
   SetIndexBuffer(7,PfColors,INDICATOR_COLOR_INDEX);
   PlotIndexSetInteger(0,PLOT_SHIFT,FutureLen);
   PlotIndexSetInteger(1,PLOT_SHIFT,FutureLen);
   PlotIndexSetInteger(2,PLOT_SHIFT,FutureLen);
   ArraySetAsSeries(P1Buffer,true);
   ArraySetAsSeries(P1Colors,true);
   ArraySetAsSeries(P2Buffer,true);
   ArraySetAsSeries(P2Colors,true);
   ArraySetAsSeries(P3Buffer,true);
   ArraySetAsSeries(P3Colors,true);
   ArraySetAsSeries(PfBuffer,true);
   ArraySetAsSeries(PfColors,true);
//--- ,   
   k=HistoryLen-1;
   FullLen = HistoryLen + FutureLen;      //    
   Sk=k*(k+1)/2;
   Sk2=k*(k+1)*(k*2+1)/6;
   if(HistoryShift<0) CreatControlLine();
//---
   return(0);
  }  // OnInit();
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
  ObjectDelete(0,"iS2_tControl");
}
//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+
void ReCalculate()
  {
   ArrayInitialize(P1Colors,1); //  
   ArrayInitialize(P2Colors,1); //  
   ArrayInitialize(P3Colors,1); //  
   ArrayInitialize(PfColors,1); //  
   int shift= iShift();
   for(int i=0;i<k;i++)
     {
      PfColors[i+shift]=0;    //    
     }
   for(int i=0;i<k+FutureLen-1;i++)
     {
      P1Colors[i+shift]=0;    //    
      P2Colors[i+shift]=0;    //    
      P3Colors[i+shift]=0;    //    
     }
   double         Pf0=PfBuffer[k+shift]+0.0000001;
   VerivicationPfBuffer(shift);
   double         Returns[];    // = PfBuffer[i] - PfBuffer[i+1];  
   ArrayResize(Returns,k);
   double SYr=0;                       
   for(int i=0;i<k;i++)
     {
      double R=PfBuffer[i+shift]-PfBuffer[i+shift+1];
      Returns[i]=R;           
      SYr+=R*(k-i);           
     }
   double RET=PfBuffer[shift]-PfBuffer[k+shift]; 
   double b=(k*SYr-Sk*RET)/(k*Sk2-Sk*Sk);
   double Yr[]; ArrayResize(Yr,FullLen);
   for(int i=0; i<FullLen; i++) Yr[i]=(RET*Sk2-Sk*SYr)/(Sk2-Sk*Sk)+b*(FullLen-i-1);
   double Trend1 = (SYr>0 ? 1 : -1);
   double Trend2 = (b>0 ? 1 : -1);
   double Trend3[]; ArrayResize(Trend3,FullLen);
   for(int i=0; i<FullLen; i++) Trend3[i]=(Yr[i]>0 ? 1 : -1);

   double L[],LT[],SL=0,SLT=0;   ArrayResize(L,k);   ArrayResize(LT,k);
   for(int i=0;i<k;i++)
     {
      L[i]=MathLog(MathAbs(Returns[i])/(1.0*(k-i)-0.5));
      SL+=L[i]; 
      LT[i]=(1.0*k-i-0.5)*L[i];
      SLT+=LT[i];  
     }
   double T=(1.0*k*(Sk2-(1.0*k/2+0.25)*k)-1.0*k*k*k*k/4)/((1.0*k*k/2)*SL-k*SLT);
   double D=T*T/MathExp((SL*(Sk2-(k/2+0.25)*k)-(k*k/2)*SLT)/(k*(Sk2-(k/2+0.25)*k)-k*k*k*k/4));
   double SumKK=0; for(int i=0; i<HistoryLen; i++) SumKK+=PfBuffer[i+shift];
   double SPr=0,Pr[]; ArrayResize(Pr,k);
   for(int i=0;i<k;i++)
     {
      Pr[i]=Trend1*ExcelGammaDistr(k-i,2,T)*D;
      SPr+=Pr[i];   
     }
   double Dcorr= fabs((SumKK-(k+1)*Pf0)/SPr)*T*T/MathExp((SL*(Sk2-(1.0*k/2+0.25)*k)-(1.0*k*k/2)*SLT)/(k*(Sk2-(1.0*k/2+0.25)*k)-1.0*k*k*k*k/4));
   switch(Mode)
     {
      case eGammaMode:
        {
         for(int i=0;i<k+FutureLen;i++)
           {
            P1Buffer[i+shift]=(SumKK-Pf0-fabs(SumKK-(k+1)*Pf0)*Trend1 )/k+ExcelGammaDistr(k+FutureLen-i,2,T)*Dcorr*Trend1;            
            P2Buffer[i+shift]=(SumKK-Pf0-fabs(SumKK-(k+1)*Pf0)*Trend2 )/k+ExcelGammaDistr(k+FutureLen-i,2,T)*Dcorr*Trend2;
            P3Buffer[i+shift]=(SumKK-Pf0-fabs(SumKK-(k+1)*Pf0)*Trend3[i] )/k+ExcelGammaDistr(k+FutureLen-i,2,T)*Dcorr*Trend3[i];
           }
         break;
        }
      case eExpMode:
        {
         for(int i=0;i<k+FutureLen;i++)
           {
            P1Buffer[i+shift]=(SumKK-Pf0-fabs(SumKK-(k+1)*Pf0)*Trend1 )/k+(1-(1+(k+FutureLen-i)/T)*MathExp(-(k+FutureLen-i)/T))*Dcorr*Trend1;            
            P2Buffer[i+shift]=(SumKK-Pf0-fabs(SumKK-(k+1)*Pf0)*Trend2 )/k+(1-(1+(k+FutureLen-i)/T)*MathExp(-(k+FutureLen-i)/T))*Dcorr*Trend2;
            P3Buffer[i+shift]=(SumKK-Pf0-fabs(SumKK-(k+1)*Pf0)*Trend3[i] )/k+(1-(1+(k+FutureLen-i)/T)*MathExp(-(k+FutureLen-i)/T))*Dcorr*Trend3[i];
           }
         break;
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void VerivicationPfBuffer(int shift)
{
  for (int i=shift; i<shift+k; i++) if (fabs(PfBuffer[i]-PfBuffer[i+1])<0.00000001) PfBuffer[i+1]+=0.000001;
}
//+------------------------------------------------------------------+
//|                                         |
//+------------------------------------------------------------------+
int iShift()
  {
   if(HistoryShift>=0) return HistoryShift;
   else
     {
      return ControlShift;  
     }
  }
void CreatControlLine()
{
  ObjectCreate(0,"iS2_tControl",OBJ_VLINE,0,TimeCurrent(),0);
  ObjectSetInteger(0,"iS2_tControl",OBJPROP_COLOR,DodgerBlue);
  ObjectSetInteger(0,"iS2_tControl",OBJPROP_SELECTABLE,true);
  ObjectSetInteger(0,"iS2_tControl",OBJPROP_WIDTH,1);
}
void OnChartEvent(const int id,         //    
                  const long& lparam,   //    long
                  const double& dparam, //    double
                  const string& sparam  //    string
  )
{
  if (id==2 && sparam=="iS4_tControl")
  {
    datetime T= datetime(ObjectGetInteger(0,"iS2_tControl",OBJPROP_TIME));
    datetime dT=TimeCurrent()-T;
    if (dT<0) dT=0;
    datetime TA[]; ArrayResize(TA,10000);
    int res=CopyTime(NULL,0,0,10000,TA);
    ArraySetAsSeries(TA,true);
    for (ControlShift=0;TA[ControlShift]>=T;ControlShift++){;}
    ReCalculate();
  }
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//---
   ArraySetAsSeries(price,true);
//         
   int limit=rates_total-prev_calculated;
   if(prev_calculated>0) limit++;
   for(int i=0;i<limit;i++)
     {
      PfBuffer[i]=price[i];
     }
   ReCalculate();
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
