//+------------------------------------------------------------------+
//|                                         VininI_FractalsTrend.mq4 |
//|                     Copyright  2011, Victor Niclolaev aka Vinin |
//|                                                    vinin@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Victor Niclolaev aka Vinin"
#property link      "vinin@mail.ru"

#property indicator_chart_window

#property indicator_buffers 2
#property indicator_color1 Red
//#property indicator_color2 Red

double BufferHigh[];
double BufferLow[];

int PrevTime, dir;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init() {
	SetIndexBuffer(0, BufferHigh); 
	SetIndexStyle(0, DRAW_ZIGZAG); 
	SetIndexLabel(0, "High"); 
	SetIndexBuffer(1, BufferLow); 
	SetIndexLabel(1, "Low"); 
	SetIndexStyle(1, DRAW_ZIGZAG); 

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   Comment("");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {
   int    counted_bars=IndicatorCounted();
   int limit=Bars-counted_bars;
   if (limit>1) {
      limit=Bars-4;
      PrevTime=0;
   }
   for (int i=limit;i>=0;i--) {
      int pos=i+3;

      int PrevPos=iBarShift(Symbol(), 0, PrevTime);
      if (PrevPos<=pos) continue;

      int bFractalsUpper=iFractals(Symbol(), 0, MODE_UPPER,pos)>0;
      int bFractalsLower=iFractals(Symbol(), 0, MODE_LOWER,pos)>0;
      int bFractals=bFractalsUpper*2+bFractalsLower;
      
      switch (bFractals) {
         case 3:
            BufferHigh[pos]=High[pos];
            BufferLow[pos]=Low[pos];
            PrevTime=iTime(Symbol(), 0, pos);
            break;
         case 2:
            if (dir==1) {
               if (High[pos]>High[PrevPos]){
                  BufferHigh[PrevPos]=EMPTY_VALUE;
                  BufferHigh[pos]=High[pos];
                  PrevTime=iTime(Symbol(), 0, pos);
               }
            } else {
               BufferHigh[pos]=High[pos];
               PrevTime=iTime(Symbol(), 0, pos);
               dir=1;
            }
            break;
         case 1:
            if (dir==-1) {
               if (Low[pos]<Low[PrevPos]){
                  BufferLow[PrevPos]=EMPTY_VALUE;
                  BufferLow[pos]=Low[pos];
                  PrevTime=iTime(Symbol(), 0, pos);
               }
            } else {
               BufferLow[pos]=Low[pos];
               PrevTime=iTime(Symbol(), 0, pos);
               dir=-1;
            }
            break;
      }
   }   
   

   return(0);
}
//+------------------------------------------------------------------+



