//+------------------------------------------------------------------+
//|                                                      ProjectName |
//|                                      Copyright 2012, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
/*
  :
iCustom(
   string symbol,    //    (NULL- )
   int timeframe,    // - (0- )
   "iCCI.Gap",       //   
   //
   int CCIperiod     //  
   int Price,        //  :
                        // 0 - PRICE_CLOSE -   
                        // 1 - PRICE_OPEN -  
                        // 2 - PRICE_HIGH - .
                        // 3 - PRICE_LOW - .
                        // 4 - PRICE_MEDIAN -  ,(high+low)/2
                        // 5 - PRICE_TYPICAL -  ,(high+low+close)/3
                        // 6 - PRICE_WEIGHTED -   ,(high+low+close+close)/4
   double Sens,      //    .
   //
   int mode,         // mode -   : 0 - CCI
   int shift         // 
);

==============

iCustom(NULL,0,"iCCI.NR", CCIperiod,Price,Sens, 0,i);
*/

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 LightSeaGreen
#property indicator_maximum  300
#property indicator_minimum -300
#property indicator_level1  100
#property indicator_level2    0
#property indicator_level3 -100

//  
// MA
int MAperiod=1; //   
int MAmethod=0; //   
                // CCI
extern int CCIperiod=10; //  
extern int Price=5; //  
extern double Sens=0; //   .
double sens; //   

             //  .
double Ind[]; // 
double price[]; //  
double Mov[]; //  MA

double mul; //  
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void init()
  {
   mul=0.015/CCIperiod; //  
   sens=Sens*CCIperiod*Point;
   string short_name="CCI("+CCIperiod+")";
// 
   IndicatorBuffers(3);
   SetIndexBuffer(0,Ind); // 
   SetIndexLabel(0,short_name);
   SetIndexBuffer(1,price); //  
   SetIndexBuffer(2,Mov); //  MA
                          //  
   if(Sens>0) short_name=DoubleToStr(Sens,1)+" "+short_name;
   IndicatorShortName(short_name);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void start()
  {
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;
   if(counted_bars==0) limit-=1+CCIperiod;

//    MA
   for(int i=limit; i>=0; i--)
      price[i]=iMA(NULL,0,MAperiod,0,MAmethod,Price,i);
//  MA   price[]
   for(i=limit; i>=0; i--)
      Mov[i]=iMAOnArray(price,0,CCIperiod,0,0,i);
   for(i=limit; i>=0; i--)
     {
      double div=0,dif;
      double ma=Mov[i];
      //   
      for(int j=i+CCIperiod-1;j>=i;j--) div+=MathAbs(price[j]-ma);
      div=mul*MathMax(div,sens); // 
      dif=price[i]-ma; // 
                       //  
      if(div==0) Ind[i]=0;
      else Ind[i]=dif/div;
     }
  }
//+------------------------------------------------------------------+
