//+------------------------------------------------------------------+
//|                                                     ma-stdev.mq4 |
//|                                      Copyright  2011, Serg Deev |
//|                                            http://www.work2it.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Serg Deev"
#property link      "http://www.work2it.ru"

#define MAGICMA  20050610

extern double MaxRisk            = 0.0; //       ( 0 -  )
extern double Lots               = 0.1; //   ( MaxRisk=0)
extern int TakeProfit            = 60; //  
extern int MinProfit             = 30;  //  
extern int ProfitStep            = 10;  //  
extern double MinProfitPercent   = 0.6; //     
extern double ProfitPercent      = 0.1; //    
extern int TrailingStop          = 25;  //    MinProfit
extern int StopLost              = 30;  //    MinProfit

extern int fast_ma_period        = 12;
extern int slow_ma_period        = 30;
extern int ma_method             = 0;
extern int ma_price              = 0;
extern int std_period            = 11;
extern int std_min               = 16;
extern int std_method            = 2;
extern int std_price             = 0;

double MinLot;
double MaxLot;
double StartLots;
double NextProfit;

int slippage = 3;
bool UseAllTicks = false;

//+------------------------------------------------------------------+
int init() {
 MinLot = MarketInfo(Symbol(),MODE_MINLOT);
 MaxLot = MarketInfo(Symbol(),MODE_MAXLOT);
 if (Symbol() == "EURUSD") {
  TakeProfit            = 60;
  MinProfit             = 30;
  ProfitStep            = 10;
  TrailingStop          = 25;
  StopLost              = 30;
  fast_ma_period        = 12;
  slow_ma_period        = 30;
  ma_method             = 0;
  ma_price              = 0;
  std_period            = 11;
  std_min               = 16;
  std_method            = 2;
  std_price             = 0;
 }
 else if (Symbol() == "USDJPY") {
  TakeProfit            = 60;
  MinProfit             = 30;
  ProfitStep            = 30;
  TrailingStop          = 10;
  StopLost              = 30;
  fast_ma_period        = 3;
  slow_ma_period        = 19;
  ma_method             = 1;
  ma_price              = 6;
  std_period            = 10;
  std_min               = 18;
  std_method            = 3;
  std_price             = 4;
 }
 return(0);
}
//+------------------------------------------------------------------+
int deinit() {
   return(0);
}

double LotNormalize(double x) {
   x=MathFloor(x*100)/100;
   if (x > MaxLot) x = MaxLot;
   if (x < MinLot) x = MinLot;
   return(x);
}

//+------------------------------------------------------------------+
double Get_Lots() {
   double lot=Lots;
   if (MaxRisk > 0) {
    double RiskSumm = AccountFreeMargin()*MaxRisk;
    lot=RiskSumm/StopLost/100;
   }
   return(LotNormalize(lot));
}

//+------------------------------------------------------------------+
bool Signal_Stop_Buy() {
   
   return(false);
}

//+------------------------------------------------------------------+
bool Signal_Stop_Sell() {
   
   return(false);
}

//+------------------------------------------------------------------+
bool Signal_Buy() {
   double fast_ma = iMA(NULL,0,fast_ma_period,0,ma_method,ma_price,0);
   double slow_ma = iMA(NULL,0,slow_ma_period,0,ma_method,ma_price,0);
   double std_now = iStdDev(NULL,0,std_period,0,std_method,std_price,0)*10000;
   double std_pre = iStdDev(NULL,0,std_period,0,std_method,std_price,1)*10000;
   if (fast_ma > slow_ma)
   if (Close[1] > Open[1])
   if (Close[1] > slow_ma)
   if (std_now > std_pre)
   if (std_now > std_min)
   return(true);
   
   return(false);
}

//+------------------------------------------------------------------+
bool Signal_Sell() {
   double fast_ma = iMA(NULL,0,fast_ma_period,0,ma_method,ma_price,0);
   double slow_ma = iMA(NULL,0,slow_ma_period,0,ma_method,ma_price,0);
   double std_now = iStdDev(NULL,0,std_period,0,std_method,std_price,0)*10000;
   double std_pre = iStdDev(NULL,0,std_period,0,std_method,std_price,1)*10000;
   Print(fast_ma," ",slow_ma," ",std_now," ",std_pre);
   if (fast_ma < slow_ma)
   if (Close[1] < Open[1])
   if (Close[1] < slow_ma)
   if (std_now > std_pre)
   if (std_now > std_min)
   return(true);
   
   return(false);
}

//+------------------------------------------------------------------+
void CheckForOpen() {
   int res;

   if (Volume[0]>1) return;

   if (Signal_Sell()) {
      StartLots = Get_Lots();
      NextProfit = Bid - MinProfit*Point;
      res=OrderSend(Symbol(),OP_SELL,StartLots,Bid,slippage,0,0,"",MAGICMA,0,Red);
      return;
   }

   if (Signal_Buy()) {
      StartLots = Get_Lots();
      NextProfit = Ask + MinProfit*Point;
      res=OrderSend(Symbol(),OP_BUY,StartLots,Ask,slippage,0,0,"",MAGICMA,0,Blue);
      return;
   }
}
//+------------------------------------------------------------------+
void CheckForClose()
  {
   double SL,TP,lx;
   int profit;

 if ((!UseAllTicks) && (Volume[0]>1)) return;

   for(int i=0;i<OrdersTotal();i++) {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)==false) break;
      if(OrderMagicNumber()!=MAGICMA || OrderSymbol()!=Symbol()) continue;
      //---- check order type 
      if(OrderType()==OP_BUY) {
         if (Signal_Stop_Buy()) OrderClose(OrderTicket(),OrderLots(),Bid,slippage,White);
         else if (OrderStopLoss() == 0.0) {
          SL = NormalizeDouble(Bid - StopLost*Point,Digits);
          TP = NormalizeDouble(Ask + TakeProfit*Point,Digits);
          OrderModify(OrderTicket(),OrderOpenPrice(),SL,TP,0,Blue);
         }
         else {
          if (Bid > NextProfit) {
           if (Bid < (OrderOpenPrice()+(MinProfit+ProfitStep/2)*Point)) lx = LotNormalize(StartLots*MinProfitPercent);
           else lx = LotNormalize(StartLots*ProfitPercent);
           OrderClose(OrderTicket(),lx,Bid,slippage,White);
           NextProfit = Bid + ProfitStep*Point;
          }
          else if (NextProfit > (OrderOpenPrice()+MinProfit*Point)) {
           SL = NormalizeDouble((Bid - TrailingStop*Point),Digits);
           if (OrderStopLoss() < SL) OrderModify(OrderTicket(),OrderOpenPrice(),SL,OrderTakeProfit(),0,Blue);
          }
         }
         break;
      }
      if(OrderType()==OP_SELL) {
         if (Signal_Stop_Sell()) OrderClose(OrderTicket(),OrderLots(),Ask,slippage,White);
         else if (OrderStopLoss() == 0.0) {
          SL = NormalizeDouble(Bid + StopLost*Point,Digits);
          TP = NormalizeDouble(Ask - TakeProfit*Point,Digits);
          OrderModify(OrderTicket(),OrderOpenPrice(),SL,TP,0,Blue);
         }
         else {
          if (Ask < NextProfit) {
           if (Ask > (OrderOpenPrice()-(MinProfit+ProfitStep/2)*Point)) lx = LotNormalize(StartLots*MinProfitPercent);
           else lx = LotNormalize(StartLots*ProfitPercent);
           OrderClose(OrderTicket(),lx,Ask,slippage,White);
           NextProfit = Bid - ProfitStep*Point;
          }
          else if (NextProfit < (OrderOpenPrice()-MinProfit*Point)) {
           SL = NormalizeDouble(Ask + TrailingStop*Point,Digits);
           if (OrderStopLoss() > SL) OrderModify(OrderTicket(),OrderOpenPrice(),SL,OrderTakeProfit(),0,Blue);
          }
         }
         break;
      }
   }
}

//+------------------------------------------------------------------+
int CalculateCurrentOrders(string symbol)
  {
   int buys=0,sells=0;
   for(int i=0;i<OrdersTotal();i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)==false) break;
      if(OrderSymbol()==Symbol() && OrderMagicNumber()==MAGICMA)
        {
         if(OrderType()==OP_BUY)  buys++;
         if(OrderType()==OP_SELL) sells++;
        }
     }
   if(buys>0) return(buys);
   else       return(-sells);
  }

//+------------------------------------------------------------------+
void start()
  {
   if(Bars<100 || IsTradeAllowed()==false) return;
   if(CalculateCurrentOrders(Symbol())==0) CheckForOpen();
   else CheckForClose();
  }
//+------------------------------------------------------------------+