//+------------------------------------------------------------------+
//|                                                     macd-adx.mq4 |
//|                                      Copyright  2011, Serg Deev |
//|                                            http://www.work2it.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Serg Deev"
#property link      "http://www.work2it.ru"

#define MAGICMA  20050610

extern double MaxRisk            = 0.2; //       ( 0 -  )
extern double Lots               = 0.1; //   ( MaxRisk=0)
extern int TakeProfit            = 100; //      MinProfit
extern int MinProfit             = 70;  //  
extern double MinProfitPercent   = 0.9; //     
extern int ProfitStep            = 70;  //  
extern double ProfitPercent      = 0.1; //    
extern int TrailingStop          = 60;  //    MinProfit
extern int StopLost              = 60;  //    MinProfit

extern bool UseAllTicks          = false;

extern int adx_period            = 6;  
extern int adx_open              = 2;  //    adx
extern int adx_min               = 20; 

extern int macd_fast             = 10;
extern int macd_slow             = 26;
extern int macd_signal           = 8;
extern int macd_open             = 4;  //    macd
extern int macd_min              = 30;

double NextProfit = 0;
double StartLots = 0;

double MinLot;
double MaxLot;

//+------------------------------------------------------------------+
int init() {
 MinLot = MarketInfo(Symbol(),MODE_MINLOT);
 MaxLot = MarketInfo(Symbol(),MODE_MAXLOT);
   return(0);
}
//+------------------------------------------------------------------+
int deinit() {
   return(0);
}

//+------------------------------------------------------------------+
double Get_Lots() {
   double lot=Lots;
   if (MaxRisk > 0) {
    double RiskSumm = AccountFreeMargin()*MaxRisk;
    lot=RiskSumm/StopLost/100;
   }
   lot=MathFloor(lot*100)/100;
   if (lot > MaxLot) lot = MaxLot;
   if (lot < MinLot) lot = MinLot;
   return(lot);
}

//+------------------------------------------------------------------+
bool Signal_Stop_Buy() {
 int adx_minus0 = iADX(NULL,0,adx_period,PRICE_OPEN,MODE_MINUSDI,0);
 int adx_minus1 = iADX(NULL,0,adx_period,PRICE_OPEN,MODE_MINUSDI,1);
// if (adx_minus0 > adx_minus1) return(true);
 return(false);
}

//+------------------------------------------------------------------+
bool Signal_Stop_Sell() {
 return(false);
}

//+------------------------------------------------------------------+
bool macd_up(int fast, int slow, int signal, int price, int mode, int num) {
 double y;
 double x = iMACD(NULL,0,fast,slow,signal,price,mode,0)*100000;
 double sum = 0;
 for (int i=1; i<num; i++) {
  y = iMACD(NULL,0,fast,slow,signal,price,mode,i)*100000;
  if (y > x) return(false);
  else x = y;
 }
 return(true);
}

//+------------------------------------------------------------------+
bool macd_down(int fast, int slow, int signal, int price, int mode, int num) {
 double y;
 double x = iMACD(NULL,0,fast,slow,signal,price,mode,0)*100000;
 double sum = 0;
 for (int i=1; i<num; i++) {
  y = iMACD(NULL,0,fast,slow,signal,price,mode,i)*100000;
  if (y < x) return(false);
  else x = y;
 }
 return(true);
}

//+------------------------------------------------------------------+
bool adx_up(int period, int price, int mode, int num) {
 double y;
 double x = iADX(NULL,0,adx_period,PRICE_OPEN,MODE_MAIN,0);
 double sum = 0;
 for (int i=1; i<num; i++) {
  y = iADX(NULL,0,adx_period,PRICE_OPEN,MODE_MAIN,i);
  if (y > x) return(false);
  else x = y;
 }
 return(true);
}

//+------------------------------------------------------------------+
bool Signal_Buy() {
 if (macd_up(macd_fast,macd_slow,macd_signal,PRICE_OPEN,MODE_SIGNAL,macd_open)) 
 if (macd_up(macd_fast,macd_slow,macd_signal,PRICE_OPEN,MODE_MAIN,macd_open)) 
 if (iMACD(NULL,0,macd_fast,macd_slow,macd_signal,PRICE_OPEN,MODE_MAIN,0)*100000 > macd_min)
 if (adx_up(adx_period,PRICE_OPEN,MODE_MAIN,adx_open)) 
 if (iADX(NULL,0,adx_period,PRICE_OPEN,MODE_MAIN,0) > adx_min)
 return(true);
 return(false);
}

//+------------------------------------------------------------------+
bool Signal_Sell() {
 if (macd_down(macd_fast,macd_slow,macd_signal,PRICE_OPEN,MODE_SIGNAL,macd_open)) 
 if (macd_up(macd_fast,macd_slow,macd_signal,PRICE_OPEN,MODE_MAIN,macd_open)) 
 if (iMACD(NULL,0,macd_fast,macd_slow,macd_signal,PRICE_OPEN,MODE_MAIN,0)*100000 < -1*macd_min)
 if (adx_up(adx_period,PRICE_OPEN,MODE_MAIN,adx_open)) 
 if (iADX(NULL,0,adx_period,PRICE_OPEN,MODE_MAIN,0) > adx_min)
 return(true);
 return(false);
 return(false);
}

//+------------------------------------------------------------------+
void CheckForOpen() {
   int res;

//   if ((!UseAllTicks) && (Volume[0]>1)) return;
   if (Volume[0]>1) return;

   if (Signal_Sell()) {
      StartLots = Get_Lots();
      NextProfit = Bid - MinProfit*Point;
      res=OrderSend(Symbol(),OP_SELL,StartLots,Bid,3,0,0,"",MAGICMA,0,Red);
      return;
   }

   if (Signal_Buy()) {
      StartLots = Get_Lots();
      NextProfit = Ask + MinProfit*Point;
      res=OrderSend(Symbol(),OP_BUY,StartLots,Ask,3,0,0,"",MAGICMA,0,Blue);
      return;
   }
}
//+------------------------------------------------------------------+
void CheckForClose()
  {
   double SL,TP,lx;
   int profit;

 if ((!UseAllTicks) && (Volume[0]>1)) return;

   for(int i=0;i<OrdersTotal();i++) {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)==false) break;
      if(OrderMagicNumber()!=MAGICMA || OrderSymbol()!=Symbol()) continue;
      //---- check order type 
      if(OrderType()==OP_BUY) {
         if (Signal_Stop_Buy()) OrderClose(OrderTicket(),OrderLots(),Bid,3,White);
         else if (OrderStopLoss() == 0.0) {
          SL = NormalizeDouble(Bid - StopLost*Point,Digits);
          TP = NormalizeDouble(Ask + TakeProfit*Point,Digits);
          OrderModify(OrderTicket(),OrderOpenPrice(),SL,TP,0,Blue);
         }
         else {
          if (Bid > NextProfit) {
           if (Bid < (OrderOpenPrice()+(MinProfit+ProfitStep/2)*Point)) lx = NormalizeDouble(StartLots*MinProfitPercent,2);
           else lx = NormalizeDouble(StartLots*ProfitPercent,2);
           OrderClose(OrderTicket(),lx,Bid,3,White);
           NextProfit = Bid + ProfitStep*Point;
          }
          else if (NextProfit > (OrderOpenPrice()+MinProfit*Point)) {
           SL = NormalizeDouble((Bid - TrailingStop*Point),Digits);
           TP = NormalizeDouble((Ask + TakeProfit*Point),Digits);
           if (OrderStopLoss() < SL) OrderModify(OrderTicket(),OrderOpenPrice(),SL,TP,0,Blue);
          }
         }
         break;
      }
      if(OrderType()==OP_SELL) {
         if (Signal_Stop_Sell()) OrderClose(OrderTicket(),OrderLots(),Ask,3,White);
         else if (OrderStopLoss() == 0.0) {
          SL = NormalizeDouble(Bid + StopLost*Point,Digits);
          TP = NormalizeDouble(Ask - TakeProfit*Point,Digits);
          OrderModify(OrderTicket(),OrderOpenPrice(),SL,TP,0,Blue);
         }
         else {
          if (Ask < NextProfit) {
           if (Ask > (OrderOpenPrice()-(MinProfit+ProfitStep/2)*Point)) lx = NormalizeDouble(StartLots*MinProfitPercent,2);
           else lx = NormalizeDouble(StartLots*ProfitPercent,2);
           OrderClose(OrderTicket(),lx,Ask,3,White);
           NextProfit = Bid - ProfitStep*Point;
          }
          else if (NextProfit < (OrderOpenPrice()-MinProfit*Point)) {
           SL = NormalizeDouble(Ask + TrailingStop*Point,Digits);
           TP = NormalizeDouble(Bid - TakeProfit*Point,Digits);
           if (OrderStopLoss() > SL) OrderModify(OrderTicket(),OrderOpenPrice(),SL,TP,0,Blue);
          }
         }
         break;
      }
   }
}

//+------------------------------------------------------------------+
int CalculateCurrentOrders(string symbol)
  {
   int buys=0,sells=0;
   for(int i=0;i<OrdersTotal();i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)==false) break;
      if(OrderSymbol()==Symbol() && OrderMagicNumber()==MAGICMA)
        {
         if(OrderType()==OP_BUY)  buys++;
         if(OrderType()==OP_SELL) sells++;
        }
     }
   if(buys>0) return(buys);
   else       return(-sells);
  }

//+------------------------------------------------------------------+
void start()
  {
   if(Bars<100 || IsTradeAllowed()==false) return;
   if(CalculateCurrentOrders(Symbol())==0) CheckForOpen();
   else CheckForClose();
  }
//+------------------------------------------------------------------+