//---------------------------------------------------------------------------------------------------+
// Rabbit v28.01.11                                                                                  |
//  "Martingeil"  14  2011. fx.09@mail.ru                                         |
//   "Rabbit"  "JonKatana"    http://codebase.mql4.com/ru/6231               |
//---------------------------------------------------------------------------------------------------+
#property copyright "Jon Katana"
#property indicator_buffers 2
#property indicator_chart_window
//----------------------------------------------------------------------------------------------------
extern int   Yesterday    = 0,     //(  0-,1- , -1 )
             Levels       = 7;     //( )
extern bool  Comm         = true;  //(. .   )
extern bool  Sublevel     = true;  //(     )
extern color FontColor    = Black,      //(  )
             LineColor    = DeepSkyBlue,//(  )
             MLineColor   = Lime,       //(  )
             Vline_color  = Black,      //(  )
             HL_line      = Lime;       //(    )
extern bool  fon          = true;       //(    )
//----------------------------------------------------------------------------------------------------
int i,z; double H[],L[],S,R,M,range,Ser; datetime time0, time1, time2, ny_time;
//----------------------------------------------------------------------------------------------------
int init(){
SetIndexBuffer(0,H); SetIndexStyle(0,DRAW_NONE);
SetIndexBuffer(1,L); SetIndexStyle(1,DRAW_NONE);
return(0);}
//----------------------------------------------------------------------------------------------------
int deinit(){for(z=0;z<Levels*2;z++){ObjectDelete("HiLo"); ObjectDelete("VL"); ObjectDelete("VL2"); 
ObjectDelete("R"+z); ObjectDelete("Rp"+z); ObjectDelete("M Line"+z); ObjectDelete("Rm"+z);} return(0);}
//----------------------------------------------------------------------------------------------------
int start(){

ny_time  = iTime(NULL,PERIOD_D1,0) + (0-Period()/60.0)*3600;
time1 = ny_time + Period()*60; time2 = ny_time + 24*3600+Period()*60 ; time0 = ny_time + Period()*30;

H[i]=iHigh(NULL,PERIOD_D1,Yesterday+1); L[i]=iLow(NULL,PERIOD_D1,Yesterday+1);
range= H[0]-L[0]; S=(H[0]-L[0])*0.236; Ser=H[0]-range/2-S/2;

PlotVLine("VL", time1, Vline_color); PlotVLine("VL2", time2, Vline_color);
HiLouD1("HiLo",H[0],L[0],HL_line);
 
for(z=0;z<Levels*2;z++) {R=L[0]+(H[0]-L[0])*(0.618-Levels*0.236)+S*z;
PlotLine("R"+z,R,R,0,0,LineColor);
PlotPrice("Rp"+z, R,FontColor);}

if (Sublevel==true){
for(z=0;z<(Levels*2-1);z++){M=L[0]+(H[0]-L[0])*(0.618-Levels*0.236)+S*z+S*0.5;
PlotLine("M Line"+z,M,M,0,2,MLineColor); 
PlotPrice("Rm"+z,M,FontColor); }}

if(Comm){
Comment("\n"," Today  =  " + TimeToStr(TimeCurrent()),".","\n"," Step = ",DoubleToStr(S,Digits));}

return(0);}
//----------------------------------------------------------------------------------------------------
void HiLouD1(string name,double value,double value1,double line_color){
double valueN=NormalizeDouble(value,Digits); double valueN1=NormalizeDouble(value1,Digits);
bool res = ObjectCreate(name,OBJ_RECTANGLE,0,time0,valueN,time1,valueN1);
ObjectSet(name, OBJPROP_STYLE,STYLE_SOLID); ObjectSet(name, OBJPROP_BACK, true);
ObjectSet(name, OBJPROP_COLOR, line_color);}  
//----------------------------------------------------------------------------------------------------
void PlotPrice(string name, double value, double line_color){
double valueN=NormalizeDouble(value,Digits);
bool res = ObjectCreate(name, OBJ_ARROW, 0, time2,valueN);
ObjectSet(name, OBJPROP_COLOR, line_color); ObjectSet(name, OBJPROP_WIDTH, 1);
ObjectSet(name, OBJPROP_ARROWCODE, SYMBOL_RIGHTPRICE);}       
//----------------------------------------------------------------------------------------------------
void PlotLine(string name,double value,double value1,int widnh,int style,double line_color){
double valueN=NormalizeDouble(value,Digits); double valueN1=NormalizeDouble(value1,Digits);
bool res = ObjectCreate(name,OBJ_TREND,0,time1,valueN,time2,valueN1);
ObjectSet(name, OBJPROP_WIDTH, widnh);
ObjectSet(name, OBJPROP_STYLE, style); ObjectSet(name, OBJPROP_RAY, false);
ObjectSet(name, OBJPROP_BACK, true); ObjectSet(name, OBJPROP_COLOR, line_color);}   
//----------------------------------------------------------------------------------------------------
void PlotVLine(string name, double tm, double line_color){
bool res = ObjectCreate(name,OBJ_VLINE,0,tm,0);
ObjectSet(name, OBJPROP_WIDTH, 0); ObjectSet(name, OBJPROP_STYLE, 0);
ObjectSet(name, OBJPROP_COLOR, line_color); ObjectSet(name, OBJPROP_BACK,  fon);}
//----------------------------------------------------------------------------------------------------  