//+------------------------------------------------------------------+
//|                                             PivotStrategy v2.mq4 |
//|                                                    |
//|                                               seolink@list.ru    |
//+------------------------------------------------------------------+
#property copyright " "
#property link      "seolink@list.ru"

extern string s1                = " ";
extern int    Magic             = 13022011;
extern double Lot               = 0.0;
extern double Klot              = 2.0;
extern double LotProcentClose   = 50.0;
extern double Risk              = 1.0;
extern int    Slip              = 3;

extern string s2                = " Moving Average";
extern int    ma_period         = 4;
extern int    ma_method         = MODE_SMA;
extern int    ma_price          = PRICE_CLOSE;

extern string s3                = " MACD BUY";
extern int    macd1_fast_period = 8;
extern int    macd1_slow_period = 17;

extern string s4                = " MACD SELL";
extern int    macd2_fast_period = 12;
extern int    macd2_slow_period = 26;

extern string s5                = " Pivot";
extern int    FiltrPivot        = 25;


double PivotD1;
double PivotD2;
double MA;
int flet;
int Signal = -1;
double R1;
double R2;
double S1;
double S2;
bool flagNewSeries=true;
bool flagProcent = false;
bool flagModify = false;
datetime LastBar;
double OpenPrice;
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
//----
   Signal=GetSignal();
   
   Comment(" = ",flet,"\n = ",Signal,"\n 1 = ",PivotD1,"\n 2 = ",PivotD2,"\nR1 = ",R1,"\nR2 = ",R2,"\nS1 = ",S1,"\nS2 = ",S2);
   datetime NewBar = iTime(Symbol(),PERIOD_D1,0);
   if(NewBar!=LastBar)
   {
    ClosePosition();
    LastBar=NewBar; 
    flagNewSeries=true;  
   }
   if(flagNewSeries)OpenPosition(Signal);
   if(!flagNewSeries)
   {
   if(flagProcent)ClosePositionProcent();
   if(flagModify)ModifyOrder();
   }
//----
   return(0);
  }
//+------------------------------------------------------------------+
int GetSignal()
{
 double LastHigh = iHigh(Symbol(),PERIOD_D1,1);
 double LastLow = iLow(Symbol(),PERIOD_D1,1);
 double LastClose = iClose(Symbol(),PERIOD_D1,1);
 
 double LastHigh2 = iHigh(Symbol(),PERIOD_D1,2);
 double LastLow2 = iLow(Symbol(),PERIOD_D1,2);
 double LastClose2 = iClose(Symbol(),PERIOD_D1,2);
 
 PivotD1 = (LastHigh+LastLow+LastClose)/3.0;
 PivotD2 = (LastHigh2+LastLow2+LastClose2)/3.0;
 
 R1 = (2.0*PivotD1)-LastLow;
 R2 = PivotD1+(LastHigh - LastLow);
 
 S1 = (2.0*PivotD1)-LastHigh;
 S2 = PivotD1-(LastHigh - LastLow);
 
 MA = iMA(Symbol(),0,ma_period,0,ma_method,ma_price,1);
 
 double MACD1 = iMACD(Symbol(),0,macd1_fast_period,macd1_slow_period,9,PRICE_CLOSE,MODE_MAIN,0); 
 double MACD2 = iMACD(Symbol(),0,macd1_fast_period,macd1_slow_period,9,PRICE_CLOSE,MODE_MAIN,1); 
 
 double MACD3 = iMACD(Symbol(),0,macd2_fast_period,macd2_slow_period,9,PRICE_CLOSE,MODE_MAIN,0); 
 double MACD4 = iMACD(Symbol(),0,macd2_fast_period,macd2_slow_period,9,PRICE_CLOSE,MODE_MAIN,1); 
 
 flet = MathAbs((PivotD1-PivotD2)/Point);
 
 if(flet>=FiltrPivot&&Close[0]>PivotD1&&MA>PivotD1&&MACD1>MACD2)return(OP_BUY);
 if(flet>=FiltrPivot&&Close[0]<PivotD1&&MA<PivotD1&&MACD3<MACD4)return(OP_SELL);
 return(-1);
}
void OpenPosition(int type)
{
int t=-1;
    double price;
   double sl;
   double tp;
 double lot = NormalizeDouble(Klot*LotPercent(Risk),Okr());
 if(type==-1)return;
 if(type==OP_BUY)
 {
  RefreshRates();
  price=NormalizeDouble(Ask,Digits);
  sl=NormalizeDouble(S1,Digits);
  tp=NormalizeDouble(R2,Digits);
  if(((price-sl)>((MarketInfo(Symbol(),MODE_STOPLEVEL))*Point))&&((tp-price)>((MarketInfo(Symbol(),MODE_STOPLEVEL))*Point))) t=OrderSend(Symbol(),type,lot,price,Slip,sl,tp,NULL,Magic);
 }
 if(type==OP_SELL)
 {
  RefreshRates();
  price=NormalizeDouble(Bid,Digits);
  sl=NormalizeDouble(R1,Digits);
  tp=NormalizeDouble(S2,Digits);
  if(((sl-price)>((MarketInfo(Symbol(),MODE_STOPLEVEL))*Point))&&((price-tp)>((MarketInfo(Symbol(),MODE_STOPLEVEL))*Point))) t=OrderSend(Symbol(),type,lot,price,Slip,sl,tp,NULL,Magic);
 }
 //t=OrderSend(Symbol(),type,lot,price,Slip,sl,tp,NULL,Magic);
 if(t<0)ErrorBlock(GetLastError());
 else {flagNewSeries=false;flagProcent=true;}
}
void ClosePosition()
{
 int total=OrdersTotal();
 bool res;
 for(int i=total-1; i>=0; i--)
 {
  if(OrderSelect(i,SELECT_BY_POS))
  {
   if(OrderSymbol()==Symbol() && OrderMagicNumber()==Magic)
   {
    if(OrderType()==OP_BUY)
    {   
     RefreshRates();        
     res=OrderClose(OrderTicket(),OrderLots(),NormalizeDouble(Bid,Digits),Slip);
     if(!res)ErrorBlock(GetLastError());
     
    }
     if(OrderType()==OP_SELL)
    {   
     RefreshRates();        
     res=OrderClose(OrderTicket(),OrderLots(),NormalizeDouble(Ask,Digits),Slip);
     if(!res)ErrorBlock(GetLastError());
    }
   }
  }
 }
}
void ClosePositionProcent()
{
 double lots;
 int total=OrdersTotal();
 bool res;
 for(int i=total-1; i>=0; i--)
 {
  if(OrderSelect(i,SELECT_BY_POS))
  {
   if(OrderSymbol()==Symbol() && OrderMagicNumber()==Magic)
   {
    OpenPrice=OrderOpenPrice();
    if(OrderType()==OP_BUY)
    { 
     if(Bid>=R1)
     { 
     lots = NormalizeDouble((OrderLots()/100.0)*LotProcentClose,Okr());
     RefreshRates();        
     res=OrderClose(OrderTicket(),lots,NormalizeDouble(Bid,Digits),Slip);
     if(!res)ErrorBlock(GetLastError());
     else {flagProcent=false;flagModify=true;}
     }
    }
     if(OrderType()==OP_SELL)
    { 
     if(Ask<=S1)
     {  
     lots = NormalizeDouble((OrderLots()/100.0)*LotProcentClose,Okr());
     RefreshRates();        
     res=OrderClose(OrderTicket(),lots,NormalizeDouble(Ask,Digits),Slip);
     if(!res)ErrorBlock(GetLastError());
     else {flagProcent=false;flagModify=true;}
     }
    }
   }
  }
 }
}
void ModifyOrder()
{
   bool res;
  int total=OrdersTotal();
  
  for(int i=total-1; i>=0; i--)
  {
   if(OrderSelect(i,SELECT_BY_POS))
   {
    if(OrderSymbol()==Symbol() && OrderMagicNumber()==Magic)
    {
     if(OrderType()==OP_BUY)
     {
      if((OpenPrice!=OrderStopLoss())&&((Bid-OpenPrice)>((MarketInfo(Symbol(),MODE_STOPLEVEL))*Point)))    
      {
       res = OrderModify(OrderTicket(),NormalizeDouble(OrderOpenPrice(),Digits),NormalizeDouble(OpenPrice,Digits),NormalizeDouble(OrderTakeProfit(),Digits),0);
       if(!res)ErrorBlock(GetLastError());
       else {flagModify=false;}
      }
     }
          if(OrderType()==OP_SELL)
     {
      if((OpenPrice!=OrderStopLoss())&&((OpenPrice-Ask)>((MarketInfo(Symbol(),MODE_STOPLEVEL))*Point))) 
      {
       res = OrderModify(OrderTicket(),NormalizeDouble(OrderOpenPrice(),Digits),NormalizeDouble(OpenPrice,Digits),NormalizeDouble(OrderTakeProfit(),Digits),0);
       if(!res)ErrorBlock(GetLastError());
       else {flagModify=false;}
      }
     }
    }
   }
  }
}
double LotPercent(double risk)
  {
   double vol=0.0;
   double MinLot = MarketInfo(Symbol(),MODE_MINLOT);
   double MaxLot = MarketInfo(Symbol(),MODE_MAXLOT);

   if(Lot==0.0)vol=(AccountFreeMargin()*risk)/(MarketInfo(Symbol(),MODE_MARGINREQUIRED)*100.0);
   else vol=Lot;

   if(vol<MinLot)vol=MinLot;
   if(vol>MaxLot)vol=MaxLot;
   
   return(vol);
  }
  int Okr()
  {
   double LotsStep=MarketInfo(Symbol(),MODE_LOTSTEP);
   if(LotsStep==0.01)return(2);
   if(LotsStep==0.1)return(1);
   if(LotsStep==1.0)return(0);
   return(0);
  }
  int ErrorBlock(int error)
  {
   switch(error)
     {
      case    0: return(0);
      case    1: {Print(": 1 -        ");return(2);}
      case    2: {Print(": 2 -  .        ");return(3);}
      case    3: {Print(": 3 -       ");return(3);}
      case    4: {Print(": 4 -   ");return(1);}
      case    5: {Print(": 5 -    ");return(3);}
      case    6: {Print(": 6 -     ");return(2);}
      case    7: {Print(": 7 -  ");return(3);}
      case    8: {Print(": 8 -   ");return(2);}
      case    9: {Print(": 9 -     ");return(3);}
      case   64: {Print(": 64 -  .      ");return(3);}
      case   65: {Print(": 65 -   .      ");return(3);}
      case  128: {Print(": 128 -     ");return(1);}
      case  129: {Print(": 129 -   bid  ask, ,  ");return(1);}
      case  130: {Print(": 130 -            (     )");return(1);}
      case  131: {Print(": 131 -  ,    ");return(3);}
      case  132: {Print(": 132 -  ");return(2);}
      case  133: {Print(": 133 -  ");return(3);}
      case  134: {Print(": 134 -     ");return(3);}
      case  135: {Print(": 135 -  ");return(1);}
      case  136: {Print(": 136 -  ");return(1);}
      case  137: {Print(": 137 -  ");return(1);}
      case  138: {Print(": 138 -   ,   bid  ask");return(1);}
      case  139: {Print(": 139 -     ");return(2);}
      case  140: {Print(": 140 -   .   SELL ");return(2);}
      case  141: {Print(": 141 -   ");return(2);}
      case  142: {Print(": 142 -    ");return(2);}
      case  143: {Print(": 143 -     ");return(2);}
      case  144: {Print(": 144 -        ");return(2);}
      case  145: {Print(": 145 -  ,          -   ");return(2);}
      case  146: {Print(": 146 -   .     ,   IsTradeContextBusy  FALSE.");return(1);}
      case  147: {Print(": 147 -      ");return(2);}
      case  148: {Print(": 148 -       ,  ");return(2);}
      case  149: {Print(": 149 -         ,   ");return(2);}
      case 4000: return(0);
      case 4001: {Print(": 4001 -   ");return(3);}
      case 4002: {Print(": 4002 -   -  ");return(3);}
      case 4003: {Print(": 4003 -     ");return(3);}
      case 4004: {Print(": 4004 -     ");return(3);}
      case 4005: {Print(": 4005 -       ");return(3);}
      case 4006: {Print(": 4006 -     ");return(3);}
      case 4007: {Print(": 4007 -     ");return(3);}
      case 4008: {Print(": 4008 -  ");return(3);}
      case 4009: {Print(": 4009 -    ");return(3);}
      case 4010: {Print(": 4010 -     ");return(3);}
      case 4011: {Print(": 4011 -   ");return(3);}
      case 4012: {Print(": 4012 -     ");return(3);}
      case 4013: {Print(": 4013 -   ");return(3);}
      case 4014: {Print(": 4014 -  ");return(3);}
      case 4015: {Print(": 4015 -  ");return(3);}
      case 4016: {Print(": 4016 -  ");return(3);}
      case 4017: {Print(": 4017 -  DLL  ");return(3);}
      case 4018: {Print(": 4018 -   ");return(3);}
      case 4019: {Print(": 4019 -   ");return(3);}
      case 4020: {Print(": 4020 -      ");return(3);}
      case 4021: {Print(": 4021 -    ,   ");return(3);}
      case 4022: {Print(": 4022 -  ");return(3);}
      case 4050: {Print(": 4050 -    ");return(3);}
      case 4051: {Print(": 4051 -    ");return(3);}
      case 4052: {Print(": 4052 -    ");return(3);}
      case 4053: {Print(": 4053 -  ");return(3);}
      case 4054: {Print(": 4054 -   -");return(3);}
      case 4055: {Print(": 4055 -   ");return(3);}
      case 4056: {Print(": 4056 -  ");return(3);}
      case 4057: {Print(": 4057 -    ");return(3);}
      case 4058: {Print(": 4058 -    ");return(3);}
      case 4059: {Print(": 4059 -      ");return(3);}
      case 4060: {Print(": 4060 -   ");return(3);}
      case 4061: {Print(": 4061 -   ");return(3);}
      case 4062: {Print(": 4062 -    string");return(3);}
      case 4063: {Print(": 4063 -    integer");return(3);}
      case 4064: {Print(": 4064 -    double");return(3);}
      case 4065: {Print(": 4065 -     ");return(3);}
      case 4066: {Print(": 4066 -      ");return(3);}
      case 4067: {Print(": 4067 -     ");return(3);}
      case 4099: {Print(": 4099 -  ");return(3);}
      case 4100: {Print(": 4100 -     ");return(3);}
      case 4101: {Print(": 4101 -   ");return(3);}
      case 4102: {Print(": 4102 -    ");return(3);}
      case 4103: {Print(": 4103 -   ");return(3);}
      case 4104: {Print(": 4104 -     ");return(3);}
      case 4105: {Print(": 4105 -     ");return(3);}
      case 4106: {Print(": 4106 -  ");return(3);}
      case 4107: {Print(": 4107 -      ");return(2);}
      case 4108: {Print(": 4108 -   ");return(2);}
      case 4109: {Print(": 4109 -   .         ");return(3);}
      case 4110: {Print(": 4110 -    .    ");return(2);}
      case 4111: {Print(": 4111 -    .    ");return(2);}
      case 4200: {Print(": 4200 -   ");return(3);}
      case 4201: {Print(": 4201 -    ");return(3);}
      case 4202: {Print(": 4202 -   ");return(2);}
      case 4203: {Print(": 4203 -   ");return(3);}
      case 4204: {Print(": 4204 -   ");return(3);}
      case 4205: {Print(": 4205 -   ");return(3);}
      case 4206: {Print(": 4206 -    ");return(3);}
      case 4207: {Print(": 4207 -     ");return(3);}
      default:   {Print(" : ",error);return(3);}
     }
  }