//+------------------------------------------------------------------+
//|                                             TEST_Probability.mq4 |
//|                                                          Strator |
//|                                                  k-v-p@yandex.ru |
//+------------------------------------------------------------------+
#property copyright "Strator"
#property link      "k-v-p@yandex.ru"
#include <probability.mqh>

void prn(string S, double D) { Print(S+" "+DoubleToStr(D,8)); }

int start()
   {
   double da, db, dc;
   int ia, ib, ic;

   //Binomial distribution
   ia=50; ib=100; da=0.5;
   double y=bdtr(ia,ib,da); //bdtr(50,100,0.5)=(50;100;0.5;1)=0.539794619
   prn("Binomial distribution: bdtr("+ia+","+ib+","+da+")=",y);

   //Beta distribution
   da=3; db=7; dc=0.5;
   y=btdtr(da,db,dc); //btdtr(3,7,0.5)=(0.5;3;7)=0.91015625
   prn("Beta distribution: btdtr("+da+","+db+","+dc+")=",y);

   //Chi-square distribution
   da=10; db=5;
   y=1-chdtr(da, db); //1-chdtr(10,5)=2(5;10)=0.89117802
   prn("Chi-square distribution: chdtr("+da+","+db+")=",y);
   
   //F distribution
   ia=5; ib=10; da=0.5;
   y=1-fdtr(ia, ib, da); //1-fdtr(5,10,0.5)=F(0.5;5;10)=0.770024881
   prn("F distribution: fdtr("+ia+","+ib+","+da+")=",y);

   //Gamma distribution
   da=3; db=2; dc=1;
   y=gdtr(da, db, dc); //gdtr(3,2,1)=(3;2;1;1)=0.800851727
   prn("Gamma distribution: gdtr("+da+","+db+","+dc+")=",y);

   //Normal distribution
   da=0.5;
   y=ndtr(da); //ndtr(0.5)=(0.5)=0.691462461
   prn("Normal distribution: ndtr("+da+")=",y);

   //Poisson distribution
   ia=100; da=90;
   y=pdtr(ia, da); //pdtr(100,90)=(100;90;1)=0.865099836
   prn("Poisson distribution: pdtr("+ia+","+da+")=",y);

   //Student's t distribution
   ia=100; da=0.5;
   y=1-stdtr(ia, da); //1-stdtr(100,0.5)=(0.5;100;1)=0.309086783
   prn("Student T distribution: stdtr("+ia+","+da+")=",y);

   return(0);
   }
//+------------------------------------------------------------------+