//+------------------------------------------------------------------+
//|                                                Modify-ParSar.mq4 |
//+------------------------------------------------------------------+
//| HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH |
//| H\    \               http://wsforex.ru/                /    / H |
//| H )----)-----------------------------------------------(----(  H |
//| H/    /        : wsforex.ru   \    \ H |
//| HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH |
//+------------------------------------------------------------------+

#property copyright "wsforex@list.ru"
#property link      "http://wsforex.ru/"
//+------------------------------------------------------------------+
//|        :    -   -  "http://wsforex.ru/"        |
//+------------------------------------------------------------------+
extern double    Step = 0.007;
extern double    Maximum = 0.2;
extern int       Bar = 1;
//+------------------------------------------------------------------+
//|        :    -   -  "http://wsforex.ru/"        |
//+------------------------------------------------------------------+
int start()
  {
   bool   result;
   double stop_loss,point;
   int    cmd,total,error;
//----
   total=OrdersTotal();
   point=MarketInfo(Symbol(),MODE_POINT);
   stop_loss = iSAR(NULL, 0, Step, Maximum, Bar);
//----
   for(int i=0; i<total; i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)) {
         OrderPrint();
         cmd=OrderType();
         if(cmd==OP_BUY || cmd==OP_SELL)
           {
            while(true)
              {
               if(cmd==OP_BUY && stop_loss > Close[0])break;
               if(cmd==OP_SELL && stop_loss < Close[0])break;
               result=OrderModify(OrderTicket(),OrderOpenPrice(),NormalizeDouble(stop_loss,Digits),OrderTakeProfit(),0,CLR_NONE);
               if(result!=TRUE) { error=GetLastError(); Print("LastError = ",error); }
               else error=0;
               if(error==135) RefreshRates();
               else break;
              }
             OrderPrint();
             break;
           }
        }
      else { Print( "Error when order select ", GetLastError()); break; }
     }
     Comment("  ");
     Sleep(3000);
     Comment("");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//|        :    -   -  "http://wsforex.ru/"        |
//+------------------------------------------------------------------+