//+------------------------------------------------------------------+
//|                                              Modify-Fractals.mq4 |
//+------------------------------------------------------------------+
//| HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH |
//| H\    \               http://wsforex.ru/                /    / H |
//| H )----)-----------------------------------------------(----(  H |
//| H/    /        : wsforex.ru   \    \ H |
//| HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH |
//+------------------------------------------------------------------+

#property copyright "wsforex@list.ru"
#property link      "http://wsforex.ru/"
//+------------------------------------------------------------------+
//|        :    -   -  "http://wsforex.ru/"        |
//+------------------------------------------------------------------+
extern int       Bar = 30; //      
//+------------------------------------------------------------------+
//|        :    -   -  "http://wsforex.ru/"        |
//+------------------------------------------------------------------+
int start()
  {
   bool   result;
   double stop_loss,point;
   int    cmd,total,error;
//----
   total=OrdersTotal();
   point=MarketInfo(Symbol(),MODE_POINT);
//----
   for(int i=0; i<total; i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
        {
         //---- print selected order
         OrderPrint();
         cmd=OrderType();
         //---- buy or sell orders are considered
         if(cmd==OP_BUY || cmd==OP_SELL)
           {
            //---- modify first market order
            while(true)
              {
               if(cmd==OP_BUY)  stop_loss=FractalsDw();
               else  stop_loss=FractalsUp();
               result=OrderModify(OrderTicket(),OrderOpenPrice(),NormalizeDouble(stop_loss,Digits),OrderTakeProfit(),0,CLR_NONE);
               if(result!=TRUE) { error=GetLastError(); Print("LastError = ",error); }
               else error=0;
               if(error==135) RefreshRates();
               else break;
              }
             //---- print modified order (it still selected after modify)
             OrderPrint();
             break;
           }
        }
      else { Print( "Error when order select ", GetLastError()); break; }
     }
     Comment("  ");
     Sleep(3000);
     Comment("");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
double FractalsDw(){
    for (int i=0; i<Bar; i++) {
    double fr = iFractals(Symbol(), 0, MODE_LOWER, i);
    if(fr==iLow(Symbol(),0,i))return (NormalizeDouble(fr,Digits));
    }
  return (0);
}
//+-----------------------------------------------------------------+
//|        :    -   -  "http://wsforex.ru/"       |
//+-----------------------------------------------------------------+
double FractalsUp(){
    for (int i=0; i<Bar; i++) {
    double fr = iFractals(Symbol(), 0, MODE_UPPER, i);
    if(fr==iHigh(Symbol(),0,i))return (NormalizeDouble(fr,Digits));
    }
  return (0);
}
//+-----------------------------------------------------------------+
//|        :    -   -  "http://wsforex.ru/"       |
//+-----------------------------------------------------------------+




