//+------------------------------------------------------------------+
//|                                                   LR_Channel.mq5 |
//|                        Copyright 2009, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "2009, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_chart_window

#include <Charts\Chart.mqh>
#include <ChartObjects\ChartObjectsChannels.mqh>

#import "dll_mql5.dll"
int CalcLRChannel(double &rates[][2],int len,double &A,double &B,double &max);
#import

input int period=75;

CChart               *chart;
CChartObjectChannel  *line_up,*line_dn,*line_md;
double                arr[][2]; //      ALGLIB
//+------------------------------------------------------------------+
int OnInit()
//+------------------------------------------------------------------+
  {

   if((chart=new CChart)==NULL)
     {printf("Chart not created"); return(false);}

   chart.Attach();
   if(chart.ChartId()==0)
     {printf("Chart not opened");return(false);}

   if((line_up=new CChartObjectChannel)==NULL)
     {printf("Channel not created"); return(false);}

   if((line_dn=new CChartObjectChannel)==NULL)
     {printf("Channel not created"); return(false);}

   if((line_md=new CChartObjectChannel)==NULL)
     {printf("Channel not created"); return(false);}

   return(0);
  }
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
//+------------------------------------------------------------------+
  {

   double a,b, //   
         max;  //     
               //   

   static double save_max;
   int len=period;

   ArrayResize(arr,len);

//     
   int j=0;
   for(int i=rates_total-1; i>=rates_total-len; i--)
     {
      arr[j][0] = j;
      arr[j][1] = close[i];
      j++;
     }

//   
   CalcLRChannel(arr,len,a,b,max);

//    
   if(max!=save_max)
     {
      save_max=max;

      //  
      line_md.Delete();
      line_up.Delete();
      line_dn.Delete();

      //     
      line_md.Create(chart.ChartId(), "LR_Md_Line", 0, time[rates_total-1],       a, time[rates_total-len], a + b*(len-1)       );
      line_up.Create(chart.ChartId(), "LR_Up_Line", 0, time[rates_total-1], a + max, time[rates_total-len], a + b*(len-1) + max );
      line_dn.Create(chart.ChartId(), "LR_Dn_Line", 0, time[rates_total-1], a - max, time[rates_total-len], a + b*(len-1) - max );

      //         
      line_up.Color(RoyalBlue);
      line_dn.Color(RoyalBlue);
      line_md.Color(RoyalBlue);

      //   
      line_up.Width(2);
      line_dn.Width(2);
      line_md.Width(2);
     }

   return(len);
  }
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
//+------------------------------------------------------------------+
  {
//   
   chart.Detach();

   delete line_dn;
   delete line_up;
   delete line_md;
   delete chart;
  }
//+------------------------------------------------------------------+
