class Feed
{
  public:
    virtual bool feed(const int dump) = 0;
};

class Filer
{
  protected:
    int dump;
    
  public:
    Filer()
    {
      dump = INVALID_HANDLE;
    }

    virtual ~Filer()
    {
      if(dump != INVALID_HANDLE)
      {
        FileClose(dump);
      }
    }

    virtual bool isReady() const
    {
      return dump != INVALID_HANDLE;
    }
    
    virtual bool read(Feed &pass) = 0;
};


class FileReader: public Filer
{
  public:
    FileReader(const string name, const int flags = 0)
    {
      dump = FileOpen(name, FILE_READ | FILE_CSV | FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_ANSI | flags, ',');
    }
    
    virtual bool read(Feed &pass) override
    {
      if(!isReady()) return false;
      
      while(!FileIsEnding(dump))
      {
        if(!pass.feed(dump))
        {
          return false;
        }
      }
      return true;
    }
    
};

class FileUtils
{
  public:
    template<typename T>
    static bool contains(const T &a[], const T v)
    {
      for(int i = 0; i < ArraySize(a); i++)
      {
        if(a[i] == v) return true;
      }
      return false;
    }
  
    static string escape(const string s)
    {
      uchar a[];
      uchar forbidden[] = {'<', '>', '/', '\\', '"', ':', '|', '*', '?', ';'};
      int n = StringToCharArray(s, a);
      for(int i = 0; i < n - 1; i++)
      {
        if(a[i] < 32 || contains(forbidden, a[i]))
        {
          a[i] = '_';
        }
      }
      return CharArrayToString(a);
    }
};