//+------------------------------------------------------------------+
//|                                                  TesterStats.mqh |
//|                                    Copyright (c) 2020, Marketeer |
//|                          https://www.mql5.com/en/users/marketeer |
//+------------------------------------------------------------------+

#include "VariableTable.mqh"

void EmbedTesterStats(VariableTable &t)
{
  for(int i = STAT_INITIAL_DEPOSIT; i <= STAT_LOSSTRADES_AVGCON; i++)
  {
    ENUM_STATISTICS e = (ENUM_STATISTICS)i;
    string name = EnumToString(e);
    StringReplace(name, "_", "");
    const string x = StringSubstr(name, 4);
    const double v = ::TesterStatistics(e);
    #ifdef TESTER_STATS_VERBOSE
    Print(x, "=", v);
    #endif
    t.set(x, v);
  }
}
