//+------------------------------------------------------------------+
//|                                                    TestClone.mq5 |
//|                                           Copyright 2019, denkir |
//|                             https://www.mql5.com/ru/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2019, denkir"
#property link      "https://www.mql5.com/ru/users/denkir"
#property version   "1.00"
#property script_show_inputs
//---
#include "CiCustomSymbol.mqh"
//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
input string InpBaseSymbol="EURUSD";       // Base symbol
input string InpCustomSymbol="EURUSD_1";   // Symbol name
input string InpCustomGroup="EURUSD_TEST"; // Group name
input datetime InpFromTime=D'02.09.2019';  // From
input datetime InpToTime=D'07.09.2019';    // To
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   CiCustomSymbol custom_symbol_1;
//--- 1) create
   int code=custom_symbol_1.Create(InpCustomSymbol,InpCustomGroup,InpBaseSymbol);
   if(code<0)
      return;
//--- 2) clone
   ulong from,to;
   from=(ulong)(1e3*InpFromTime);
   to=(ulong)(1e3*InpToTime);
   if(custom_symbol_1.Clone(InpBaseSymbol,from,to))
      PrintFormat("A base symbol \"%s\" has been successfully cloned.",InpBaseSymbol);
  }
//+------------------------------------------------------------------+
