//+------------------------------------------------------------------+
//|                                             TestChangeSpread.mq5 |
//|                                           Copyright 2019, denkir |
//|                             https://www.mql5.com/ru/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2019, denkir"
#property link      "https://www.mql5.com/ru/users/denkir"
#property version   "1.00"
//---
#property script_show_inputs
#include "CiCustomSymbol.mqh"
//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
input string InpBaseSymbol="EURUSD_1";                    // Base symbol
input string InpCustomSymbol="EURUSD_25";                 // Symbol name
input string InpCustomGroup="EURUSD_TEST";                // Group name
input uint InpFixedSpread=25;                             // Fixed spread, pips
input uint InpSpreadMarkup=12;                            // Spread markup, pips
input ENUM_SPREAD_BASE InpSpreadBase=SPREAD_BASE_AVERAGE; // Spread base
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   CiCustomSymbol custom_symbol_2;
//--- 1) create
   int code=custom_symbol_2.Create(InpCustomSymbol,InpCustomGroup,InpBaseSymbol);
   if(code<0)
      return;
//--- 2) clone
   ulong from_msc,to_msc;
   from_msc=(ulong)1e3*D'01.01.2019';
   to_msc=(ulong)1e3*D'01.10.2019';
   if(!custom_symbol_2.Clone(InpBaseSymbol,from_msc,to_msc))
     {
      PrintFormat("Failed to clone the base symbol \"%s\"!",InpBaseSymbol);
      return;
     }
//--- 3) change a spread
   if(!custom_symbol_2.ChangeSpread(InpFixedSpread,InpSpreadMarkup,InpSpreadBase))
      Print("Failed to change the spread!");
  }
//+------------------------------------------------------------------+
