//+------------------------------------------------------------------+
//|                                           CiUnrollDoubleNode.mqh |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, denkir"
#property link      "https://login.mql5.com/en/users/denkir"

#include "CDoubleNode.mqh"
//+------------------------------------------------------------------+
//| CiUnrollDoubleNode class                                         |
//+------------------------------------------------------------------+
class CiUnrollDoubleNode : public CDoubleNode
  {
private:
   int               m_arr_val[]; // data array

public:
   void              CiUnrollDoubleNode(void);               // default constructor 
   void              CiUnrollDoubleNode(int &_node_arr[]);   // parameterized constructor
   void             ~CiUnrollDoubleNode(void);               // destructor
   bool              GetArrVal(int &_dest_arr_val[])const;   // get-method for data array
   bool              SetArrVal(const int &_node_arr_val[]);  // set-method for data array
  };
//+------------------------------------------------------------------+
//| Default constructor                                              |
//+------------------------------------------------------------------+
void CiUnrollDoubleNode::CiUnrollDoubleNode(void)
  {
   TRACE_CALL(_t_flag)

  }
//+------------------------------------------------------------------+
//| Parameterized constructor                                        |
//+------------------------------------------------------------------+
void CiUnrollDoubleNode::CiUnrollDoubleNode(int &_node_arr[])
   : CDoubleNode(ArraySize(_node_arr))
  {
   ArrayCopy(this.m_arr_val,_node_arr);
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
void CiUnrollDoubleNode::~CiUnrollDoubleNode(void)
  {
   ArrayFree(this.m_arr_val);
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+
//| Get-method for data array                                        |
//+------------------------------------------------------------------+
bool CiUnrollDoubleNode::GetArrVal(int &_dest_arr_val[])const
  {
   TRACE_CALL(_t_flag)
   if(ArrayCopy(_dest_arr_val,this.m_arr_val)<this.m_val)
      return false;
   return true;
  }
//+------------------------------------------------------------------+
//| Set-method for data array                                        |
//+------------------------------------------------------------------+
bool CiUnrollDoubleNode::SetArrVal(const int &_node_arr_val[])
  {
   TRACE_CALL(_t_flag)
   int _arrSize=ArraySize(_node_arr_val);
   if(ArrayCopy(this.m_arr_val,_node_arr_val)<_arrSize)
      return false;
   //CiSingleNode *_ptr_snode_cur=GetPointer(this);
   //_ptr_snode_cur.SetVal(_arrSize);
   this.SetVal(_arrSize);
   return true;
  }
//+------------------------------------------------------------------+
