//+------------------------------------------------------------------+
//|                                           CiUnrollDoubleList.mqh |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, denkir"
#property link      "https://login.mql5.com/en/users/denkir"

#include "CDoubleList.mqh"
#include "CiUnrollDoubleNode.mqh"
//+------------------------------------------------------------------+
//| CiUnrollDoubleList class                                         |
//+------------------------------------------------------------------+
class CiUnrollDoubleList : public CDoubleList
  {
public:
   void              CiUnrollDoubleList(void);                      // default constructor    
   void              CiUnrollDoubleList(int &_node_arr[]);          // parameterized constructor   
   void             ~CiUnrollDoubleList(void){TRACE_CALL(_t_flag)}; // destructor                  
   //---
   virtual void      AddFront(int &_node_arr[]);                    // add a new node to the beginning of the list
   virtual void      AddRear(int &_node_arr[]);                     // add a new node to the end of the list
   virtual bool      CopyByValue(const CiSingleList &_udList);      // copy by values
   virtual void      PrintList(string _caption=NULL);               // print the list
   virtual void      BubbleSort(void);                              // bubble sorting

protected:
   virtual bool      AddToEmpty(int &_node_arr[]);                  // add a node to an empty list
   virtual void      addFront(int &_node_arr[]);                    // add a new "native" node to the beginning of the list
   virtual void      addRear(int &_node_arr[]);                     // add a new "native" node to the end of the list 
   virtual int       removeFront(void);                             // delete the "native" node from the beginning of the list
   virtual int       removeRear(void);                              // delete the "native" node from the end of the list 
   virtual void      deleteNodeByIndex(const uint _idx);            // delete the "native" ith node from the list
   virtual CiSingleNode *newNode(int &_node_arr[]);                 // new "native" node
  };
//+------------------------------------------------------------------+
//| Default constructor (empty list)                                 |
//+------------------------------------------------------------------+
void CiUnrollDoubleList::CiUnrollDoubleList()
  {
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+ 
//| Parameterized constructor (single-node list)                     |
//+------------------------------------------------------------------+
void CiUnrollDoubleList::CiUnrollDoubleList(int &_node_arr[])
  {
   TRACE_CALL(_t_flag)
   this.m_head=this.m_tail=NULL;   // empty nodes
   if(!this.AddToEmpty(_node_arr)) // add a new node
     {
      this.m_head=this.m_tail=NULL;  // zero out nodes
      Alert("Failed to add a new node!");
     }
  }
//+------------------------------------------------------------------+
//| New node to the beginning of the list                            |
//+------------------------------------------------------------------+
void CiUnrollDoubleList::AddFront(int &_node_arr[])
  {
   TRACE_CALL(_t_flag)
   if(this.IsEmpty())             // if the list is empty
      this.AddToEmpty(_node_arr); // add a new node to the empty list
   else
      this.addFront(_node_arr);   // add a new node to the beginning of the list
  }
//+------------------------------------------------------------------+
//| New node to the end of the list                                  |
//+------------------------------------------------------------------+
void CiUnrollDoubleList::AddRear(int &_node_arr[])
  {
   TRACE_CALL(_t_flag)
   if(this.IsEmpty())             // if the list is empty
      this.AddToEmpty(_node_arr); // add a new node to the empty list
   else
      this.addRear(_node_arr);    // add a new node to the end of the list    
  }
//+------------------------------------------------------------------+
//| Copying by values                                                |
//+------------------------------------------------------------------+
bool CiUnrollDoubleList::CopyByValue(const CiSingleList &_udList)
  {
   TRACE_CALL(_t_flag)
   bool IsCopied=true;
//--- zero out the current list if it is not empty
   if(!this.IsEmpty()) // checking empty list
     {
      //--- pass through the list
      while(!this.IsEmpty())
         this.RemoveFront(); // delete the head node        
     }
   if(!this.IsEmpty()) // if failed to empty the list
      IsCopied=false;

   if(IsCopied && !_udList.IsEmpty())
     {
      CiSingleNode *offNode=NULL;
      //--- pass through the source list
      for(CiUnrollDoubleNode *udL=_udList.GetHeadNode();udL!=offNode;udL=udL.GetNextNode())
        {
         int _arr_to_add[];
         udL.GetArrVal(_arr_to_add);
         this.AddRear(_arr_to_add);  // new node with data        
        }
     }
   return IsCopied;
  }
//+------------------------------------------------------------------+
//| Printing the list                                                |
//+------------------------------------------------------------------+
void CiUnrollDoubleList::PrintList(string _caption=NULL)
  {
   TRACE_CALL(_t_flag)
   uint list_size=this.Size();        // list size
//--- checking the list size   
   if(list_size==0)
      Print("The list is empty.");
   else
     {
      uint start_idx=0;
      if(_caption!=NULL)
         Print(_caption);
      //--- pass through the list
      while(start_idx<list_size)
        {
         int _arr_to_print[];
         CiUnrollDoubleNode *cur_node=this.GetNodeByIndex(start_idx); // get the node by index start_idx
         if(cur_node.GetArrVal(_arr_to_print))// get the data array of the current node 
           {
            string _arr_str=NULL;
            for(int i=0;i<ArraySize(_arr_to_print);i++)
               _arr_str+=IntegerToString(_arr_to_print[i])+", ";
            _arr_str=StringSubstr(_arr_str,0,StringLen(_arr_str)-2);
            PrintFormat("List node #%d, array: "+_arr_str,1+start_idx++);
           }
        }
      Print("\n");
     }
  }
//+------------------------------------------------------------------+
//| Bubble sorting                                                   |
//+------------------------------------------------------------------+
void CiUnrollDoubleList::BubbleSort(void)
  {
   TRACE_CALL(_t_flag)
   uint _list_size=this.Size();                               // list size
   for(uint passes=0;passes<_list_size-1;passes++)
      for(uint j=0;j<_list_size-passes-1;j++)
        {
         CiUnrollDoubleNode *_node1=this.GetNodeByIndex(j);   // node by index j
         CiUnrollDoubleNode *_node2=this.GetNodeByIndex(j+1); // node by index j+1
         if(_node1.GetVal()>_node2.GetVal())                  // compare the values
           {
            int _node2_arr[];
            _node2.GetArrVal(_node2_arr);                     // data array of the node by index j+1
            CiUnrollDoubleNode  *_temp_node=this.newNode(_node2_arr); // temporary node
            this.SetNodeByIndex(_temp_node,j);                // insert the new jth node in the list
            this.DeleteNodeByIndex(j+2);                      // delete the node by index j+2
           }
        }
  }
//+------------------------------------------------------------------+
//| Adding a node to an empty list                                   |
//+------------------------------------------------------------------+
bool CiUnrollDoubleList::AddToEmpty(int &_node_arr[])
  {
   TRACE_CALL(_t_flag)
   if(!this.IsEmpty()) // if the list is not empty
      return false;
   CiSingleNode *node_to_add=new CiUnrollDoubleNode(_node_arr); // new node with data
   this.m_head=node_to_add;                              // new head node
   this.m_tail=this.m_head;                              // head node is equal to tail node
   return true;
  }
//+------------------------------------------------------------------+
//| New "native" node to the beginning of the list                   |
//+------------------------------------------------------------------+
void CiUnrollDoubleList::addFront(int &_node_arr[])
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *node_to_add=new CiUnrollDoubleNode(_node_arr); // new node with data
   node_to_add.SetNextNode(this.m_head);                 // link from the new node to the head node
   this.m_head.SetPrevNode(node_to_add);                 // link from the head to the new node
   this.m_head=node_to_add;                              // new head node
  }
//+------------------------------------------------------------------+
//| New "native" node to the end of the list                         |
//+------------------------------------------------------------------+
void CiUnrollDoubleList::addRear(int &_node_arr[])
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *node_to_add=new CiUnrollDoubleNode(_node_arr); // new node with data
   this.m_tail.SetNextNode(node_to_add);                 // link from the tail to the new node
   node_to_add.SetPrevNode(this.m_tail);                 // link from the new node to the tail
   this.m_tail=node_to_add;                              // new head node
  }
//+------------------------------------------------------------------+
//| Deleting the "native" head node                                  |
//+------------------------------------------------------------------+
int CiUnrollDoubleList::removeFront(void)
  {
   TRACE_CALL(_t_flag)
   int return_val=CDoubleList::removeFront(); // delete the head node
   return return_val;                         // return data
  }
//+------------------------------------------------------------------+
//| Deleting the "native" node from the end of the list              |
//+------------------------------------------------------------------+
int CiUnrollDoubleList::removeRear(void)
  {
   int return_val=CDoubleList::removeRear();  // delete the tail node
   return return_val;                         // return data
  }
//+------------------------------------------------------------------+
//| Deleting the "native" ith node from the list                     |
//+------------------------------------------------------------------+
void CiUnrollDoubleList::deleteNodeByIndex(const uint _idx)
  {
   CDoubleList::deleteNodeByIndex(_idx);
  }
//+------------------------------------------------------------------+
//| New "native" node                                                |
//+------------------------------------------------------------------+
CiSingleNode *CiUnrollDoubleList::newNode(int &_node_arr[])
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *_temp_node=new CiUnrollDoubleNode(_node_arr);
   return _temp_node;
  }
//+------------------------------------------------------------------+
