//+------------------------------------------------------------------+
//|                                                 CiSingleNode.mqh |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, denkir"
#property link      "https://login.mql5.com/en/users/denkir"

#define TRACE_CALL(f) if(f) Print("Calling: "+__FUNCSIG__);

extern bool _t_flag=false; // trace call flag
//+------------------------------------------------------------------+
//| CiSingleNode class                                               |
//+------------------------------------------------------------------+
class CiSingleNode
  {
protected:
   int               m_val;   // data
   CiSingleNode     *m_next;  // pointer to the next node
public:
   void              CiSingleNode(void);                             // default constructor
   void              CiSingleNode(int _node_val);                    // parameterized constructor
   void             ~CiSingleNode(void);                             // destructor
   void              SetVal(int _node_val);                          // set-method for data
   void              SetNextNode(CiSingleNode *_ptr_next);           // set-method for the next node
   virtual void      SetPrevNode(CiSingleNode *_ptr_prev){};         // set-method for the previous node
   virtual CiSingleNode *GetPrevNode(void) const {return NULL;};     // get-method for the previous node
   CiSingleNode     *GetNextNode(void) const;                        // get-method for the next node 
   int               GetVal(void){TRACE_CALL(_t_flag) return m_val;} // get-method for data 
  };
//+------------------------------------------------------------------+
//| Default constructor                                              |
//+------------------------------------------------------------------+
void CiSingleNode::CiSingleNode(void)
  {
   this.m_val=NULL;
   this.m_next=NULL;
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+
//| Parameterized constructor                                        |
//+------------------------------------------------------------------+
void CiSingleNode::CiSingleNode(int _node_val)
   : m_val(_node_val)
  {
   this.m_next=NULL;
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
void CiSingleNode::~CiSingleNode(void)
  {
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+
//| Set-method for data                                              |
//+------------------------------------------------------------------+
void CiSingleNode::SetVal(int _node_val)
  {
   this.m_val=_node_val;
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+
//| Get-method for the next node                                     |
//+------------------------------------------------------------------+
CiSingleNode *CiSingleNode::GetNextNode(void) const
  {
   TRACE_CALL(_t_flag)
   return this.m_next;
  }
//+------------------------------------------------------------------+
//| Set-method for the next node                                     |
//+------------------------------------------------------------------+
void CiSingleNode::SetNextNode(CiSingleNode *_ptr_next)
  {
   this.m_next=_ptr_next;
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+
