//+------------------------------------------------------------------+
//|                                                     CNodeInt.mqh |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, denkir"
#property link      "https://login.mql5.com/en/users/denkir"


#include <Object.mqh>
//+------------------------------------------------------------------+
//| CNodeInt class                                                   |
//+------------------------------------------------------------------+
class  CNodeInt : public CObject
  {
private:
   int               m_val;                // node data

public:
   void              CNodeInt(void){this.m_val=WRONG_VALUE;}; // default constructor
   void              CNodeInt(int _val);                      // parameterized constructor
   void             ~CNodeInt(void){};                        // destructor
   int               GetVal(void){return this.m_val;};        // get-method for node data
   void              SetVal(int _val){this.m_val=_val;};      // set-method for node data
   //---
   virtual bool      Save(const int file_handle);             // save node data to the file
   virtual bool      Load(const int file_handle);             // load node data from the file

  };
//+------------------------------------------------------------------+
//| Parameterized constructor                                        |
//+------------------------------------------------------------------+
void CNodeInt::CNodeInt(int _val):m_val(_val)
  {

  };
//+------------------------------------------------------------------+
//| Saving node data to the file                                     |
//+------------------------------------------------------------------+
bool CNodeInt::Save(const int file_handle)
  {
   bool IsSaved=false;
//--- save to the file
   if(file_handle!=INVALID_HANDLE)
     {
      uint  bytes_written=FileWriteInteger(file_handle,this.m_val);
      if(bytes_written==INT_VALUE)
         IsSaved=true;
     }
   else
      PrintFormat("Error while saving node: %d",GetLastError());
   return IsSaved;
  };
//+------------------------------------------------------------------+
//| Loading node data from the file                                  |
//+------------------------------------------------------------------+
bool CNodeInt::Load(const int file_handle)
  {
   bool IsLoaded=false;
//--- read from the file
   if(file_handle!=INVALID_HANDLE)
     {
      int  read_val=FileReadInteger(file_handle);
      this.m_val=read_val;
      IsLoaded=true;
     }
   else
      PrintFormat("Error while reading node: %d",GetLastError()); 
   return IsLoaded;
  };
//+------------------------------------------------------------------+
