//+------------------------------------------------------------------+
//|                                                  CDoubleNode.mqh |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, denkir"
#property link      "https://login.mql5.com/en/users/denkir"

#include "CiSingleNode.mqh"
//+------------------------------------------------------------------+
//| CDoubleNode class                                                |
//+------------------------------------------------------------------+
class CDoubleNode : public CiSingleNode
  {
protected:
   CiSingleNode     *m_prev;  // pointer to the previous node 

public:
   void              CDoubleNode(void);                     // default constructor
   void              CDoubleNode(int node_val);             // parameterized constructor
   void             ~CDoubleNode(void){TRACE_CALL(_t_flag)};// destructor
   virtual void      SetPrevNode(CiSingleNode *_ptr_prev);  // set-method for the previous node
   virtual CiSingleNode *GetPrevNode(void) const;           // get-method for the previous node CDoubleNode
  };
//+------------------------------------------------------------------+
//| Default constructor                                              |
//+------------------------------------------------------------------+
void CDoubleNode::CDoubleNode(void)
  {
   this.m_prev=NULL;
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+
//| Parameterized constructor                                        |
//+------------------------------------------------------------------+
void CDoubleNode::CDoubleNode(int node_val)
   : CiSingleNode(node_val)
  {
   this.m_prev=NULL;
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+
//| Get-method for the previous node                                 |
//+------------------------------------------------------------------+
CiSingleNode *CDoubleNode::GetPrevNode(void) const
  {
   TRACE_CALL(_t_flag)
   return this.m_prev;
  }
//+------------------------------------------------------------------+
//| Set-method for the previous node                                 |
//+------------------------------------------------------------------+
void CDoubleNode::SetPrevNode(CiSingleNode *_ptr_prev)  
  {
   this.m_prev=_ptr_prev;
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+
