//+---------------------------------------------------------------------+
//|                                                        multiweb.mqh |
//|                                       Copyright (c) 2018, Marketeer |
//|                             https://www.mql5.com/en/users/marketeer |
//| Asynchronous Non-Blocking WebRequest Implemenation on Helper Charts |
//|                               https://www.mql5.com/ru/articles/5337 |
//+---------------------------------------------------------------------+
#property copyright   "Copyright (c) 2018, Marketeer"
#property link        "https://www.mql5.com/en/users/marketeer"
#property description "WebRequest pool demo\n"


sinput string Method = "GET";
sinput string URL = "https://google.com/,https://ya.ru,https://www.startpage.com/";
sinput string Headers = "User-Agent: n/a";
sinput int Timeout = 5000;
sinput bool TestSyncRequests = true;

#include <multiweb.mqh>

int urlsnum;
int doneCount;
string urls[];
uint asyncStart;

class MyClientWebWorker : public ClientWebWorker
{
  public:
    MyClientWebWorker(const long id, const string p = "WRP_"): ClientWebWorker(id, p)
    {
    }
    
    virtual void onResult(const long code, const uchar &headers[], const uchar &text[]) override
    {
      Print(getMethod(), " ", getURL(), "\nReceived ", ArraySize(headers), " bytes in header, ", ArraySize(text), " bytes in document");
      Comment(getMethod(), " ", getURL(), "\nReceived ", ArraySize(headers), " bytes in header, ", ArraySize(text), " bytes in document");
      // uncommenting this leads to potentially bulky logs
      // Print(CharArrayToString(headers));
      // Print(CharArrayToString(text));
      
      if(++doneCount == urlsnum)
      {
        Print("> > > Async WebRequest workers [", pool.getManagerPoolSize(), "] finished ", urlsnum, " tasks in ", GetTickCount() - asyncStart, "ms");
      }
    }
    virtual void onError(const long code) override
    {
      Print("WebRequest error code ", code);
    }
};

ClientWebWorkersPool<MyClientWebWorker> *pool = NULL;

void OnInit()
{
  // wait for manager negotiation for 5 seconds maximum
  EventSetTimer(5);
  // get URLs for test requests
  urlsnum = StringSplit(URL, ',', urls);
  pool = new ClientWebWorkersPool<MyClientWebWorker>(urlsnum, _Symbol + "_" + EnumToString(_Period) + "_");
  doneCount = 0;
  Comment("Click the chart to start downloads");
}

void OnDeinit(const int reason)
{
  delete pool;
  Comment("");
}

void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam) 
{
  if(id == CHARTEVENT_CLICK) // initiate test requests by simple user action
  {
    if(pool.isManagerBound())
    {
      uchar Body[];
      uchar Result[];
      string ResultHeaders;

      // first, measure timing of successive synchronous requests
      if(TestSyncRequests)
      {
        uint nativeStart = GetTickCount();
        for(int i = 0; i < urlsnum; i++)
        {
          WebRequest(Method, urls[i], Headers, Timeout, Body, Result, ResultHeaders);
          // results are skipped here as unimportant, this is just a test for timing
        }
        Print("> > > Standard WebRequest ", urlsnum, " calls finished in ", GetTickCount() - nativeStart, "ms");
      }
      
      // second, measure timing of parallel asynchronous requests
      doneCount = 0;
      asyncStart = GetTickCount();
      for(int i = 0; i < urlsnum; i++)
      {
        // check if a worker is not already busy with a pending request/response,
        // there's a shorthand:
        // pool.WebRequestAsync(Method, urls[i], Headers, Timeout, Body);
        // which is more or less equivalent of
        if(!pool[i].isBusy())
        {
          pool[i].request(Method, urls[i], Headers, Timeout, Body, pool.getManagerID());
        }
      }
      
    }
    else
    {
      Alert("Manager not found");
    }
  }
  else
  {
    // this handler manages all important messaging behind the scene
    pool.onChartEvent(id, lparam, dparam, sparam);
  }
}

void OnTimer()
{
  // if the manager did not respond during 5 seconds, it seems missing
  EventKillTimer();
  if(!pool.isManagerBound())
  {
    Alert("WebRequest Pool Manager (multiweb) is not running");
  }
}

