//+------------------------------------------------------------------+
//|                                                      ProjectName |
//|                                      Copyright 2012, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
#include "Trade.mqh"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
C_Trade::C_Trade(double maxLot)
  {
   this.maxLot=maxLot;
   step=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_STEP);
   lot = SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void C_Trade::deal(Direction direction)
  {
   bool isPosition=PositionSelect(_Symbol);
   double _lot=lot;
   if(isPosition)
     {
      double lotMin=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);
      double lotCurrent=_lot;

      if(PositionGetDouble(POSITION_PROFIT)<0)
         _lot=((_lot+step)<=maxLot ?(_lot+step) : maxLot);
      else
         _lot=((_lot-step)>=lotMin ?(_lot-step) : lotMin);

      lot = _lot;
      _lot=_lot+lotCurrent;
     }

   if(direction==_Long) trade.Buy(_lot);
   else trade.Sell(_lot);
  }
//+------------------------------------------------------------------+
