//+------------------------------------------------------------------+
//|                                                      ProjectName |
//|                                      Copyright 2012, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
#include "Robot.mqh"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CRobot::CRobot(InputData &data)
  {
   this.data=data;
   open_cond();
   last_cond=direction;
   trade=new C_Trade(data.maxLot);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CRobot::MA(double &price[])
  {
   double ans=0;
   for(int i=0;i<ArraySize(price);i++)
     {
      ans+=price[i];
     }
   return ans/ArraySize(price);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CRobot::open_cond(void)
  {
   double price[];
   CopyClose(_Symbol,PERIOD_CURRENT,0,data.Fast,price);

   double fast=MA(price);

   ArrayFree(price);
   CopyClose(_Symbol,PERIOD_CURRENT,0,data.Slow,price);
   double slow=MA(price);

   direction=(fast>=slow ? _Long : _Short);

   if(direction!=last_cond)
     {
      last_cond=direction;
      return true;
     }
   else
      return false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CRobot::RobotCall(void)
  {
   bool isOpen=open_cond();
   if(PositionSelect(_Symbol))
     {
      if(isOpen)
         trade.deal(direction);
     }
   else
     {
      if(isOpen)
         trade.deal(direction);
     }
  }
//+------------------------------------------------------------------+
