//---------------------------------------------------------------------------
//  : "   MetaTrader 5 & MATLAB      |
//                                                                          |
//  :    , nav_soft@mail.ru, 2010|
//  :     BORLAND C++ BUILDER 6                              |
//  METATRADER:    5.0.0.257                                          |
//  DLL:           0.0.1.0 (  DLL)                       |
//   IBM PC:  PENTIUM IV, CELERON M; RAM 256 Mb                  |
//   :      MATLAB R2007, MetaTrader 5                         |
//                                                                          |
//                                                          MatlabEngineLib |
//                                Copyright 2010, MetaQuotes Software Corp. |
//                                                   http://www.mql5.com/ru |
//---------------------------------------------------------------------------
//  DLL:
//===========================================================================
//|                |                                    |
//===========================================================================
//|  mlxOpen()               |     MATLAB    |
//---------------------------------------------------------------------------
//|  mlxClose()              |     MATLAB   |
//---------------------------------------------------------------------------
//|  mlxInputChar()          |     char            |
//---------------------------------------------------------------------------
//|  mlxInputDouble()        |     double          |
//---------------------------------------------------------------------------
//|  mlxInputInt()           |     int             |
//---------------------------------------------------------------------------
//|  mlxInputLogical()       |     logical         |
//---------------------------------------------------------------------------
//|  mlxGetDouble()          |     double         |
//---------------------------------------------------------------------------
//|  mlxGetInt()             |     int            |
//---------------------------------------------------------------------------
//|  mlxGetLogical()         |     logical        |
//---------------------------------------------------------------------------
//|  mlxGetSizeOfName()      |           |
/*---------------------------------------------------------------------------
**  (= *.lib + *.def):
** libeng.lib  ( : <MATLAB>\extern\lib\win32\borland\)
** libmx.lib   ( : <MATLAB>\extern\lib\win32\borland\)
** DllUnit.def
** engine.h    ( : <MATLAB>\extern\include\)
---------------------------------------------------------------------------*/
#define WIN32_LEAN_AND_MEAN
#define  BUFSIZE 256
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <conio.h>
#include "engine.h"
/*---------------------------------------------------------------------------
**   DLL()
*/
extern "C" __declspec(dllexport) bool __stdcall mlxOpen(void);
extern "C" __declspec(dllexport) void __stdcall mlxClose(void);
extern "C" __declspec(dllexport) bool __stdcall mlxInputChar(char *CharArray);
extern "C" __declspec(dllexport) bool __stdcall mlxInputDouble(double *dArray
                                                               , int sizeArray
                                                               , char *CharNameArray);
extern "C" __declspec(dllexport) bool __stdcall mlxInputInt(double *dArray
                                                            , int sizeArray
                                                            , char *CharNameArray);
extern "C" __declspec(dllexport) bool __stdcall mlxInputLogical(double *dArray
                                                                , int sizeArray
                                                                , char *CharNameArray);
extern "C" __declspec(dllexport) int __stdcall mlxGetDouble(double *dArray
                                                            , int sizeArray
                                                            , char *CharNameArray);
extern "C" __declspec(dllexport) int __stdcall mlxGetInt(double *dArray
                                                         , int sizeArray
                                                         , char *CharNameArray);
extern "C" __declspec(dllexport) int __stdcall mlxGetLogical(double *dArray
                                                             , int sizeArray
                                                             , char *CharNameArray);
extern "C" __declspec(dllexport) int __stdcall mlxGetSizeOfName(char *CharNameArray);
/*---------------------------------------------------------------------------
**   DLL()
*/
void DestrBuffer(void);
void MakeBufferIn(int nSizeIn);
/*---------------------------------------------------------------------------
**  
*/
Engine  *pEng;
mxArray *mxVectorIn;
mxArray *mxVectorOut;
int      nSizeVectorIn;

//---------------------------------------------------------------------------
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{//: 100%.
    /*
    **   
    */
    switch(reason)
    {
        case DLL_PROCESS_ATTACH:
            /*
            **   
            **  / MatLab engine
	    */
            pEng = NULL;
            mlxOpen();
            break;
        case DLL_PROCESS_DETACH:
            /*
            **  
            **  / MatLab engine
            */
            mlxClose();
            break;
    }
    return 1;
}
//---------------------------------------------------------------------------
bool __stdcall mlxOpen(void)
{//: 100%.  /
 /*
 **   /
 */
 if(pEng != NULL) return true;
 /*
 **  /
 */
 if ((pEng = engOpen(NULL)) == NULL)
 {
  MessageBoxA(NULL, (LPSTR)"Can't start MATLAB engine!",
     	      (LPSTR) "MatLab Engine: ERROR!", MB_OK|MB_ICONSTOP);
  return false;                 //   /
 };
 mxVectorIn    =  NULL;
 mxVectorOut   =  NULL;
 nSizeVectorIn =     0;

 return true;
}
//---------------------------------------------------------------------------
void __stdcall mlxClose(void)
{//: 100%.  /
 /*
 **  /
 */
 if(pEng != NULL)
 {
  engClose((Engine *)pEng);
  pEng    = NULL;
 };
 /*
 **   /
 */
 DestrBuffer();
 return;
}
//---------------------------------------------------------------------------
void DestrBuffer(void)
{//: 100%.    
 if(mxVectorIn != NULL)
 {//     
  mxDestroyArray((mxArray *)mxVectorIn);
  mxVectorIn     = NULL;
  nSizeVectorIn  = 0;
 };
 mxVectorOut     = NULL;
 return;
}
//---------------------------------------------------------------------------
void MakeBufferIn(int nSizeIn)
{//: 100%.    
 /*
 **   
 */
 if(mxVectorIn != NULL)
 {
  mxDestroyArray((mxArray *)mxVectorIn);
  mxVectorIn     = NULL;
  nSizeVectorIn  = 0;
 };
 /*
 **  
 */
 mxVectorIn  = mxCreateDoubleMatrix(1, nSizeIn, mxREAL);
 nSizeVectorIn  = nSizeIn;                     //    o
 return;
}
//---------------------------------------------------------------------------
bool __stdcall mlxInputChar(char *CharArray)
{//: 100%.      //
 /*
 **   /    
 */
 if((pEng == NULL)&&(strlen(CharArray)<1)) return false;
 /*
 **      MATLAB
 */
 engEvalString((Engine *)pEng, CharArray);
 return true;
}
//---------------------------------------------------------------------------
bool __stdcall mlxInputDouble(double *dArray, int sizeArray, char *CharNameArray)
{//: 100%.        double
 /*
 **   /
 */
 if(pEng == NULL) return false;
 /*
 **  
 */
 MakeBufferIn(sizeArray);
 /*
 **    
 **      MATLAB
 */
 memcpy((char *)mxGetPr(mxVectorIn), (char *)dArray, (sizeArray)*8);
 engPutVariable((Engine *)pEng, (char *)CharNameArray, (mxArray *)mxVectorIn);
 return true;
}
//---------------------------------------------------------------------------
bool __stdcall mlxInputInt(double *dArray, int sizeArray, char *CharNameArray)
{//: 100%.        int
 /*
 **  
 */
 char szString[BUFSIZE];//  
 ZeroMemory(szString, BUFSIZE);
 strcat(szString, CharNameArray);
 strcat(szString, (char *)"=int32(");
 strcat(szString, CharNameArray);
 strcat(szString, (char *)");");
 /*
 **    double
 */
 if(mlxInputDouble((double *)dArray, sizeArray, (char *)CharNameArray) == false)
   return false;
 /*
 **     
 */
 return(mlxInputChar((char *)szString));
}
//---------------------------------------------------------------------------
bool __stdcall mlxInputLogical(double *dArray, int sizeArray, char *CharNameArray)
{//: 100%.        logical
 /*
 **  
 */
 char szString[BUFSIZE];//  
 ZeroMemory(szString, BUFSIZE);
 strcat(szString, CharNameArray);
 strcat(szString, (char *)"=logical(");
 strcat(szString, CharNameArray);
 strcat(szString, (char *)");");
 /*
 **    double
 */
 if(mlxInputDouble((double *)dArray, sizeArray, (char *)CharNameArray) == false)
   return false;
 /*
 **     
 */
 return(mlxInputChar((char *)szString));
}
//---------------------------------------------------------------------------
int __stdcall mlxGetDouble(double *dArray, int sizeArray, char *CharNameArray)
{//: 100%.        double
 /*
 **   /
 */
 if(pEng == NULL) return 0;
 /*
 **      MATLAB
 **     /
 */
 if(((mxArray *)mxVectorOut = engGetVariable((Engine *)pEng, CharNameArray))== NULL)
   return 0;
 memcpy((char *)dArray, (char *)mxGetPr(mxVectorOut), (sizeArray)*8);
 return sizeArray;
}
//---------------------------------------------------------------------------
int __stdcall mlxGetInt(double *dArray, int sizeArray, char *CharNameArray)
{//: 100%.        int
 /*
 **  
 */
 char szString1[BUFSIZE];//   1
 char szString2[BUFSIZE];//   2
 ZeroMemory(szString1, BUFSIZE);
 ZeroMemory(szString2, BUFSIZE);
 strcat(szString1, CharNameArray);
 strcat(szString1, (char *)"=double(");
 strcat(szString1, CharNameArray);
 strcat(szString1, (char *)");");
 strcat(szString2, CharNameArray);
 strcat(szString2, (char *)"=int32(");
 strcat(szString2, CharNameArray);
 strcat(szString2, (char *)");");
 /*
 **     
 */
 if(mlxInputChar((char *)szString1) == false) return 0;
 /*
 **      MATLAB
 */
 if(mlxGetDouble((double *)dArray, sizeArray, (char *)CharNameArray) < 1)
 {
  mlxInputChar((char *)szString2);
  return 0;
 };
 /*
 **     
 */
 if(mlxInputChar((char *)szString2) == false) return 0;
 return sizeArray;
}
//---------------------------------------------------------------------------
int __stdcall mlxGetLogical(double *dArray, int sizeArray, char *CharNameArray)
{//: 100%.        logical
 /*
 **  
 */
 char szString1[BUFSIZE];//    1
 char szString2[BUFSIZE];//    2
 ZeroMemory(szString1, BUFSIZE);
 ZeroMemory(szString2, BUFSIZE);
 strcat(szString1, CharNameArray);
 strcat(szString1, (char *)"=double(");
 strcat(szString1, CharNameArray);
 strcat(szString1, (char *)");");
 strcat(szString2, CharNameArray);
 strcat(szString2, (char *)"=logical(");
 strcat(szString2, CharNameArray);
 strcat(szString2, (char *)");");
 /*
 **     
 */
 if(mlxInputChar((char *)szString1) == false) return 0;
 /*
 **      MATLAB
 */
 if(mlxGetDouble((double *)dArray, sizeArray, (char *)CharNameArray) < 1)
 {
  mlxInputChar((char *)szString2);
  return 0;
 };
 /*
 **     
 */
 if(mlxInputChar((char *)szString2) == false) return 0;
 return sizeArray;
}
//---------------------------------------------------------------------------
int __stdcall mlxGetSizeOfName(char *CharNameArray)
{//: 100%.    .
 /*
 **  
 */
 char szString1[BUFSIZE];//  
 char szString2[BUFSIZE];//     
 double dArray[2];
 int iSize = 0;
 /*
 **   /
 */
 if(pEng == NULL) return 0;
 /*
 **  
 */
 dArray[0] = 0;
 dArray[1] = 0;
 ZeroMemory(szString1, BUFSIZE);
 ZeroMemory(szString2, BUFSIZE);
 strcat(szString1, (char *)"nSize = length(");
 strcat(szString1, CharNameArray);
 strcat(szString1, (char *)");");//  SizeOfName = double(SizeOfName);
 strcat(szString2, (char *)"nSize");
 /*
 **  
 */
 if(mlxInputChar((char *)szString1) == false) return 0;
 /*
 **      MATLAB
 */
 if(mlxGetDouble((double *)dArray, 1, (char *)szString2) < 1) return 0;
 iSize = dArray[0];
 return(iSize);
}
//---------------------------------------------------------------------------
