//---------------------------------------------------------------------------
//  : Dll-,   Dll-MATLAB  MetaTrader 5         |
//                                                                          |
//  :    , nav_soft@mail.ru, 2010|
//  :     BORLAND C++ BUILDER 6                              |
//  METATRADER:    5.0.0.257                                          |
//  DLL:           0.0.1.0 (  DLL)                       |
//   IBM PC:  PENTIUM IV, CELERON M; RAM 256 Mb                  |
//   :      MATLAB R2007, MetaTrader 5                         |
//                                                                          |
//                                                         MatlabReducerLib |
//                                Copyright 2010, MetaQuotes Software Corp. |
//                                                   http://www.mql5.com/ru |
//---------------------------------------------------------------------------
/*---------------------------------------------------------------------------
**  + *.lib + *.def:
** libmx.lib
** mclmcr.lib
** NEOSMA.lib
** nSMA.def
*/
#include <stdio.h>
#include <windows.h>
/*    MCR    */
#include "mclmcr.h"
#include "NEOSMA.h"
/*---------------------------------------------------------------------------
**   DLL()
*/
extern "C" __declspec(dllexport) bool __stdcall IsStartSMA(void);
extern "C" __declspec(dllexport) bool __stdcall nSMA(double  *pY, int  nSizeY,
                                                     double *pIn, int nSizeIn, 
                                                     double   dN, double dAd);
/*---------------------------------------------------------------------------
**  
*/
mxArray *TempY;
mxArray *TempIn;
mxArray *TempN;
mxArray *TempAd;
bool bIsNeoStart;
//---------------------------------------------------------------------------
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{
    switch(reason)
    {
        case DLL_PROCESS_ATTACH:
         bIsNeoStart = false;
         TempY  = NULL;   //   
         TempN  = NULL;
         TempIn = NULL;
         TempAd = NULL;
         break;
        case DLL_PROCESS_DETACH:
         NEOSMATerminate();
         //  ,    Dll
         if(TempY  != NULL) mxDestroyArray(TempY);
         if(TempN  != NULL) mxDestroyArray(TempN);
         if(TempIn != NULL) mxDestroyArray(TempIn);
         if(TempAd != NULL) mxDestroyArray(TempAd);
         mclTerminateApplication();
    }
    return 1;
}
//---------------------------------------------------------------------------
bool __stdcall IsStartSMA(void)
{
 if(bIsNeoStart == false)
 {
  if(!mclInitializeApplication(NULL,0) )
  {
   MessageBoxA(NULL, (LPSTR)"Can't start MATLAB MCR!",
               (LPSTR) "MATLAB DLL: ERROR!", MB_OK|MB_ICONSTOP);
   return false;
  }else
   {
    bIsNeoStart = NEOSMAInitialize();
   };
 };
 return bIsNeoStart;
}
//---------------------------------------------------------------------------
bool __stdcall nSMA(double *pY, int nSizeY, double *pIn, int nSizeIn, double dN
                    , double dAd)
{
   /*
   **  
   */
   if(TempN == NULL){ TempN = mxCreateDoubleMatrix(1, 1, mxREAL);}
   else
   {
     mxDestroyArray(TempN);
     TempN= mxCreateDoubleMatrix(1, 1, mxREAL);
   };
   if(TempIn == NULL){ TempIn = mxCreateDoubleMatrix(1, nSizeIn, mxREAL);}
   else
   {
     mxDestroyArray(TempIn);
     TempIn= mxCreateDoubleMatrix(1, nSizeIn, mxREAL);
   };
   if(TempAd == NULL){ TempAd = mxCreateDoubleMatrix(1, 1, mxREAL);}
   else
   {
     mxDestroyArray(TempAd);
     TempAd= mxCreateDoubleMatrix(1, 1, mxREAL);
   };
   /*
   **    
   */
   memcpy((char *)mxGetPr(TempIn), (char *) pIn, (nSizeIn)*8);
   memcpy((char *)mxGetPr(TempN), (char *) &dN, 8);
   memcpy((char *)mxGetPr(TempAd), (char *) &dAd, 8);
   /*
   **      m-
   */
   if(mlfNeoSMA(1, (mxArray **)TempY, (mxArray *)TempIn, (mxArray *)TempN
      , (mxArray *)TempAd) == false) return false;
   /*
   **     m-,  
   */
   memcpy((char *) pY, (char *)mxGetPr(TempY), (nSizeY)*8);
   mxDestroyArray((mxArray *)TempY);  TempY  = 0;
   mxDestroyArray((mxArray *)TempN);  TempN  = 0;
   mxDestroyArray((mxArray *)TempIn); TempIn = 0;
   mxDestroyArray((mxArray *)TempAd); TempAd = 0;
   return true;
}
//---------------------------------------------------------------------------
