%--------------------------------------------------------------------------
% SMA c GRNN 
% () 2010 ,   .
%  0.0.0.1
%----------------------!!!!  !!!!----------------------------
%   y = GRNNFilter(z, Ad)                          -  !
%--------------------------------------------------------------------------
%     ( SMA ""):
%
% 1.   .     ,   
%            3:
%    TP = (HIGH + LOW + CLOSE) / 3 
% 2.  n-     :
%    SMA (TP, N) = SUM (TP, N) / N 
%
% :
%  HIGH     ;
%  LOW      ;
%  CLOSE   ;
%  SMA      ;
%  SUM    ;
%  N       ,   .
%--------------------------------------------------------------------------
% function y = NeoSMA(in, n, Ad)
%--------------------------------------------------------------------------
%      |                  |  
%----------|----------------------------|----------------------------------
% in       |                  | 1  N double
% n        | , .    | 1 x 1 double
% Ad       | . .           | 1 x 1 double
%----------|----------------------------|----------------------------------
%     |                  |  
%----------|----------------------------|----------------------------------
% y        |   SMA        | 1  N double
%--------------------------------------------------------------------------
function y = NeoSMA(in, n, Ad)
MasSize = size(in);
MasSize = MasSize(1, 2);
y(1, MasSize) = 0;
%  n- 
ind = n;
while ind <= MasSize
     i = ind - n;
     sum = 0;
     while i < ind
      i = i + 1;
      sum = sum + in(1, i);
     end
     y(1, ind) = sum/n;
    ind = ind + 1;
end
% 
if Ad > 1
    y = GRNNFilter(y, Ad);
end
%--------------------------------------------------------------------------