//+------------------------------------------------------------------+
//|                                                 MatlabEngineLib  |
//|                                                 MatlabEngine.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                           http://www.mql5.com/ru |
//+------------------------------------------------------------------+
#property library
#property copyright "2010, MetaQuotes Software Corp."
#property link      "http://www.mql5.com/ru"
#property version   "1.00"
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
#import "LibMlEngine.dll"
void   mlxClose(void);
bool   mlxOpen(void);
bool   mlxInputChar(char &CharArray[]);
bool   mlxInputDouble(double &dArray[],
                      int sizeArray,
                      char &CharNameArray[]);
bool   mlxInputInt(double &dArray[],
                   int sizeArray,
                   char &CharNameArray[]);
bool   mlxInputLogical(double &dArray[],
                       int sizeArray,
                       char &CharNameArray[]);
int    mlxGetDouble(double &dArray[],
                    int sizeArray,
                    char &CharNameArray[]);
int    mlxGetInt(double &dArray[],
                 int sizeArray,
                 char &CharNameArray[]);
int    mlxGetLogical(double &dArray[],
                     int sizeArray,
                     char &CharNameArray[]);
int    mlxGetSizeOfName(char &CharNameArray[]);
#import
//+------------------------------------------------------------------+
//| Function for MATLAB Engine, MATLAB ver 7.4                       |
//+------------------------------------------------------------------+
bool mlOpen(void)export
  {//: 100%. : .
//+------------------------------------------------------------------+
//|     MATLAB                        |
//|                                                                  |
//|  : true -  ! false -               |
//+------------------------------------------------------------------+
   return(mlxOpen());
  }
//+------------------------------------------------------------------+
void mlClose(void)export
  {//: 100%. : .
//+------------------------------------------------------------------+
//|     MATLAB                       |
//|                                                                  |
//| / : !                                 |
//+------------------------------------------------------------------+
   mlxClose();
   return;
  }
//+------------------------------------------------------------------+
bool mlInputChar(string array)export
  {//: 100%. : .
//+------------------------------------------------------------------+
//|     string  .  MATLAB    |
//|                                                                  |
//|  :                                             |
//+------------+-----------------------------------------------------+
//| array[]    |   string    /. MATLAB |
//+------------+-----------------------------------------------------+
//|  : true -  ! false -        |
//+------------------------------------------------------------------+
//  
   char CharArray[];      //     
   int sizeCharArray = 0; //  .    
                          //  
//     
   sizeCharArray=StringToCharArray(array,CharArray,0,-1);
   if(sizeCharArray>0)
     {//      MATLAB:  false -  MATLAB
      return(mlxInputChar(CharArray));
     }
   else
      return false;       //   MT 5!
  }
//+------------------------------------------------------------------+
bool mlInputDouble(double &array[],int sizeArray,string NameArray)export
  {//: 100%. : .
//+------------------------------------------------------------------+
//|     double  .  MATLAB    |
//|                                                                  |
//|  :                                             |
//+------------+-----------------------------------------------------+
//| array[]    |   double                       |
//+------------+-----------------------------------------------------+
//| sizeArray  |  array[], .. - !  !    |
//+------------+-----------------------------------------------------+
//| NameArray  |     MATLAB                    |
//+------------+-----------------------------------------------------+
//|  : true -  ! false -        |
//+------------------------------------------------------------------+
//  
   double    TempArray[]; //    
   char  CharNameArray[]; //     
   int sizeCharArray = 0; //  .    
                          //  
//     
   sizeCharArray=StringToCharArray(NameArray,CharNameArray,0,-1);
   if(ArrayIsSeries(array)==true)
     { // -
      //    c
      if(ArrayResize(TempArray,sizeArray,0)==sizeArray)
        {
         int ind=0;       // .  
         while(ind<sizeArray)
           {//  
            TempArray[sizeArray-ind-1]=array[ind];
            ind++;//  
           }
        }
      else
         return false;    //   MT 5!
      //      MATLAB:  false -  MATLAB
      return(mlxInputDouble(TempArray,sizeArray,CharNameArray));
     }
//      MATLAB:  false -  MATLAB
   return(mlxInputDouble(array,sizeArray,CharNameArray));
  }
//+------------------------------------------------------------------+
int mlGetSizeOfName(string strName)export
  {//: 100%. : .
//+------------------------------------------------------------------+
//|    /                     |
//|                                                                  |
//|  : 0 - , >0                           |
//+------------------------------------------------------------------+
   char CharArray[];      //     
                          //     
   StringToCharArray(strName,CharArray,0,-1);
   return(mlxGetSizeOfName(CharArray));
  }
//+-------------------------------------------------------------------+
int mlGetDouble(double &array[],string NameArray)export
  {//: 100%. : .
//+-------------------------------------------------------------------+
//|     double  .  MATLAB      |
//|                                                                   |
//| !                                                         |
//|         MATLAB,|
//| ..   -.                                       |
//|                                                                   |
//|  :                                              |
//+------------+------------------------------------------------------+
//| array[]    | /  double      |
//+------------+------------------------------------------------------+
//| NameArray  |     MATLAB                     |
//+------------+------------------------------------------------------+
//|  :   array[] -  ,  0 - !   |
//+-------------------------------------------------------------------+
//  
   char CharNameArray[];  //     
   int  sizeArray = 0;    //   
                          //  
//     
   StringToCharArray(NameArray,CharNameArray,0,-1);
//    
   if((sizeArray=mlxGetSizeOfName(CharNameArray))<1)
     {
      return(0);          //  !
     }
   else
     {
      ArrayResize(array,sizeArray,0);
      return(mlxGetDouble(array,sizeArray,CharNameArray));
     }
  }
//+------------------------------------------------------------------+
bool mlInputInt(int &array[],int sizeArray,string NameArray)export
  {//: 100%. : .
//+------------------------------------------------------------------+
//|     int  .  MATLAB       |
//|                                                                  |
//|  :                                             |
//+------------+-----------------------------------------------------+
//| array[]    |   int                          |
//+------------+-----------------------------------------------------+
//| sizeArray  |  array[], .. - !  !    |
//+------------+-----------------------------------------------------+
//| NameArray  |     MATLAB                    |
//+------------+-----------------------------------------------------+
//|  : true -  ! false -        |
//+------------------------------------------------------------------+
//  
   double TempArray[];    //    
   char CharNameArray[];  //     
                          //     
   StringToCharArray(NameArray,CharNameArray,0,-1);
   if(ArrayResize(TempArray,sizeArray,0)!=sizeArray) return false;
//   ,   
   if(ArrayIsSeries(array)==true)
     {// -
      int ind=0;          // .  
      while(ind<sizeArray)
        {//  +  
         TempArray[sizeArray-ind-1]=array[ind];
         ind++;           //  
        }
      //      MATLAB:  false -  MATLAB
      return(mlxInputInt(TempArray,sizeArray,CharNameArray));
     }
   else
     {
      int ind=0;          // .        
      while(ind<sizeArray)
        {//  
         TempArray[ind]=array[ind];
         ind++;           //  
        }
      //      MATLAB:  false -  MATLAB
      return(mlxInputInt(TempArray,sizeArray,CharNameArray));
     }
  }
//+-------------------------------------------------------------------+
int mlGetInt(int &array[],string NameArray)export
  {//: 100%. : .
//+-------------------------------------------------------------------+
//|     int  .  MATLAB         |
//|                                                                   |
//| !                                                         |
//|         MATLAB,|
//| ..   -.                                       |
//|                                                                   |
//|  :                                              |
//+------------+------------------------------------------------------+
//| array[]    | /  int         |
//+------------+------------------------------------------------------+
//| NameArray  |     MATLAB                     |
//+------------+------------------------------------------------------+
//|  :   array[] -  ,  0 - !   |
//+-------------------------------------------------------------------+
//  
   double TempArray[];    //    
   char CharNameArray[];  //     
   int sizeArray = 0;     //   
                          //  
//     
   StringToCharArray(NameArray,CharNameArray,0,-1);
//   
   sizeArray=mlxGetSizeOfName(CharNameArray);
//    
   if(sizeArray<1)
     {
      return(0);          //  MATLAB!
     }
   else
     {
      //    c
      if(ArrayResize(TempArray,sizeArray,0)!=sizeArray)return 0;
      if(ArrayResize(array,sizeArray,0)!=sizeArray)return 0;
      if(mlxGetInt(TempArray,sizeArray,CharNameArray)<1) return 0;
      int ind=0;
      while(ind<sizeArray)
        {
         array[ind]=TempArray[ind];
         ind++;
        }
      return(sizeArray);
     }
  }
//+------------------------------------------------------------------+
bool mlInputLogical(bool &array[],int sizeArray,string NameArray)export
  {//: 100%. : .
//+------------------------------------------------------------------+
//|     bool  .  MATLAB      |
//|                                                                  |
//|  :                                             |
//+------------+-----------------------------------------------------+
//| array[]    |   bool                         |
//+------------+-----------------------------------------------------+
//| sizeArray  |  array[], .. - !  !    |
//+------------+-----------------------------------------------------+
//| NameArray  |     MATLAB                    |
//+------------+-----------------------------------------------------+
//|  : true -  ! false -        |
//+------------------------------------------------------------------+
//  
   double TempArray[];    //    
   char CharNameArray[];  //     
                          //  
//     
   StringToCharArray(NameArray,CharNameArray,0,-1);
   if(ArrayResize(TempArray,sizeArray,0)!=sizeArray) return false;
//   ,   
   if(ArrayIsSeries(array)==true)
     {// -
      int ind=0;          // .  
      while(ind<sizeArray)
        {//  +  
         TempArray[sizeArray-ind-1]=array[ind];
         ind++;           //  
        }
      //      MATLAB:  false -  MATLAB
      return(mlxInputLogical(TempArray,sizeArray,CharNameArray));
     }
   else
     {
      int ind=0;          // .        
      while(ind<sizeArray)
        {//  
         TempArray[ind]=array[ind];
         ind++;           //  
        }
      //      MATLAB:  false -  MATLAB
      return(mlxInputLogical(TempArray,sizeArray,CharNameArray));
     }
  }
//+-------------------------------------------------------------------+
int mlGetLogical(bool &array[],string NameArray)export
  {//: 100%. : .
//+-------------------------------------------------------------------+
//|     bool  .  MATLAB        |
//|                                                                   |
//| !                                                         |
//|         MATLAB,|
//| ..   -.                                       |
//|                                                                   |
//|  :                                              |
//+------------+------------------------------------------------------+
//| array[]    | /  bool        |
//+------------+------------------------------------------------------+
//| NameArray  |     MATLAB                     |
//+------------+------------------------------------------------------+
//|  :   array[] -  ,  0 - !   |
//+-------------------------------------------------------------------+
//  
   double TempArray[];    //    
   char CharNameArray[];  //     
   int sizeArray = 0;     //   
                          //  
//     
   StringToCharArray(NameArray,CharNameArray,0,-1);
//   
   sizeArray=mlxGetSizeOfName(CharNameArray);
//    
   if(sizeArray<1)
     {
      return(0);          //  MATLAB!
     }
   else
     {
      //    
      if(ArrayResize(TempArray,sizeArray,0)!=sizeArray) return(0);
      if(ArrayResize(array,sizeArray,0)!=sizeArray) return(0);
      if(mlxGetLogical(TempArray,sizeArray,CharNameArray)<1) return(0);
      int ind=0;
      while(ind<sizeArray)
        {
         array[ind]=TempArray[ind];
         ind++;
        }
      return(sizeArray);
     }
  }
//+------------------------------------------------------------------+
