//+------------------------------------------------------------------+
//|                                                 testEAbasket.mq5 |
//|                        Copyright 2017, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2017, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"

#include <Trade\\Trade.mqh>

#define LG 7
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum BSTATE
  {
   BCLOSE = 0,
   BBUY   = 1,
   BSELL  = 2
  };
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
input int    wpr        = 20;
input int    ma         = 10;
input double lt         = 0.01;
input double g_dMinSize = 5.0;
input double g_dMaxSize = 10.0;
input bool   bSecFilter = true;
input int    SecParam1  = 70;
input int    SecParam2  = -70;

string pair[]={"AUDJPY","CADJPY","CHFJPY","EURJPY","GBPJPY","NZDJPY","USDJPY"};
bool bDirect[]={false,false,false,false,false,false,false};

int h;
ulong  Ticket[LG];

double m[1],ml;
double w[1],wl;

BSTATE g_state;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnInit()
  {
   h=iCustom(NULL,0,"testWPR&MA",wpr,ma);
   if(h==INVALID_HANDLE) 
     {
      Print("Error while creating testWPReur");
      return (INIT_FAILED);
     }

   g_state=BCLOSE;

   EventSetTimer(1);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   IndicatorRelease(h);
   EventKillTimer();

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---

  }
//+------------------------------------------------------------------+
//| Timer function                                                   |
//+------------------------------------------------------------------+
void OnTimer()
  {
   if(IsNewCandle())
     {
      wl=w[0];
      CopyBuffer(h,0,1,1,w);
      ml=m[0];
      CopyBuffer(h,1,1,1,m);
      if(w[0]>m[0] && wl<ml) 
        {
         if(g_state!=BCLOSE) CloseAllPos();
         if(w[0]-m[0]>=g_dMinSize && ml-wl>=g_dMinSize && 
            w[0]-m[0]<=g_dMaxSize && ml-wl<=g_dMaxSize) 
           {
            if(bSecFilter)
              {
               if(w[0]<SecParam1) 
                 {
                  EnterBuy(lt);
                  g_state=BBUY;
                 }
              }
            else 
              {
               EnterBuy(lt);
               g_state=BBUY;
              }
            //               Print("BUY at : ",TimeToString(TimeCurrent()));
           }
        }
      if(w[0]<m[0] && wl>ml) 
        {
         if(g_state!=BCLOSE) CloseAllPos();
         if(m[0]-w[0]>=g_dMinSize && wl-ml>=g_dMinSize && 
            w[0]-m[0]<=g_dMaxSize && ml-wl<=g_dMaxSize) 
           {
            if(bSecFilter)
              {
               if(w[0]>SecParam2) 
                 {
                  EnterSell(lt);
                  g_state=BSELL;
                 }
              }
            else 
              {
               EnterSell(lt);
               g_state=BSELL;
              }

            //               Print("SELL at : ",TimeToString(TimeCurrent()));
           }
        }
     }
  }
//+------------------------------------------------------------------+

void CloseAllPos()
  {

   CTrade Trade;
   Trade.LogLevel(LOG_LEVEL_NO);
   for(int i=0; i<LG; i++)
     {
      Trade.PositionClose(Ticket[i]);
     }
   g_state=BCLOSE;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void EnterBuy(double lot)
  {

   CTrade Trade;
   Trade.LogLevel(LOG_LEVEL_NO);

   for(int i=0; i<LG; i++)
     {
      if(bDirect[i])
        { //send buy
         Trade.Buy(lot,pair[i]);
         Ticket[i]=Trade.ResultDeal();
        }
      else
        { //send sell
         Trade.Sell(lot,pair[i]);
         Ticket[i]=Trade.ResultDeal();
        }
     }
   g_state=BBUY;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void EnterSell(double lot)
  {

   CTrade Trade;
   Trade.LogLevel(LOG_LEVEL_NO);

   for(int i=0; i<LG; i++)
     {
      if(bDirect[i])
        { //send sell
         Trade.Sell(lot,pair[i]);
         Ticket[i]=Trade.ResultDeal();
        }
      else
        { //send buy
         Trade.Buy(lot,pair[i]);
         Ticket[i]=Trade.ResultDeal();
        }
     }
   g_state=BSELL;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool IsNewCandle()
  {

   static int candle=-1;

   int t1=0;
   switch(_Period)
     {
      case PERIOD_H1:  t1 = Hour();   break;
      case PERIOD_H4:  t1 = Hour4();  break;
      case PERIOD_D1:  t1 = Day();    break;
     }
   if(t1!=candle) {candle=t1; return(true);}
   return (false);
  }
int Hour4(){return((int)Hour()/4);}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Day()
  {
   MqlDateTime tm;
   TimeCurrent(tm);
   return(tm.day);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Hour()
  {
   MqlDateTime tm;
   TimeCurrent(tm);
   return(tm.hour);
  }  
//+------------------------------------------------------------------+
