//+------------------------------------------------------------------+
//|                                                         ATCF.mq5 |
//|                                              Copyright 2017, DNG |
//|                                      https://forex-start.ucoz.ua |
//+------------------------------------------------------------------+
#property copyright "Copyright 2017, DNG"
#property link      "https://forex-start.ucoz.ua"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Include                                                          |
//+------------------------------------------------------------------+
#include <Expert\Expert.mqh>
//--- available signals
#include <Expert\Signal\SignalATCF.mqh>
//--- available trailing
#include <Expert\Trailing\TrailingFixedPips.mqh>
//--- available money management
#include <Expert\Money\MoneyFixedLot.mqh>
//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
//--- inputs for expert
input string          Expert_Title                  ="ATCF";         // Document name
ulong                 Expert_MagicNumber            =24743;          // 
bool                  Expert_EveryTick              =false;          // 
//--- inputs for main signal
input int             Signal_ThresholdOpen          =70;             // Signal threshold value to open [0...100]
input int             Signal_ThresholdClose         =10;             // Signal threshold value to close [0...100]
input double          Signal_PriceLevel             =0.0;            // Price level to execute a deal
input double          Signal_StopLevel              =20.0;           // Stop Loss level (in points)
input double          Signal_TakeLevel              =100.0;          // Take Profit level (in points)
input int             Signal_Expiration             =4;              // Expiration of pending orders (in bars)
input ENUM_TIMEFRAMES Signal_ATCF_TimeFrame         =PERIOD_CURRENT; // Signals Adaptive Trend & Cycles Following Method Timeframe
input uint            Signal_ATCF_HistoryBars       =2880;           // Signals Adaptive Trend & Cycles Following Method Bars in history to analysis
input uint            Signal_ATCF_AveragePeriod     =1000;           // Signals Adaptive Trend & Cycles Following Method Period for RBCI and PCCI
input bool            Signal_ATCF_Pattern1          =true;           // Signals Adaptive Trend & Cycles Following Method Use pattern 1
input bool            Signal_ATCF_Pattern2          =true;           // Signals Adaptive Trend & Cycles Following Method Use pattern 2
input bool            Signal_ATCF_Pattern3          =true;           // Signals Adaptive Trend & Cycles Following Method Use pattern 3
input bool            Signal_ATCF_Pattern4          =true;           // Signals Adaptive Trend & Cycles Following Method Use pattern 4
input bool            Signal_ATCF_Pattern5          =true;           // Signals Adaptive Trend & Cycles Following Method Use pattern 5
input bool            Signal_ATCF_Pattern6          =true;           // Signals Adaptive Trend & Cycles Following Method Use pattern 6
input bool            Signal_ATCF_Pattern7          =true;           // Signals Adaptive Trend & Cycles Following Method Use pattern 7
input bool            Signal_ATCF_Pattern8          =true;           // Signals Adaptive Trend & Cycles Following Method Use pattern 8--------------------------------------------------
input double          Signal_ATCF_Weight            =1.0;            // Signals Adaptive Trend & Cycles Following Method Weight [0...1.0]
//--- inputs for trailing
input int             Trailing_FixedPips_StopLevel  =20;             // Stop Loss trailing level (in points)
input int             Trailing_FixedPips_ProfitLevel=50;             // Take Profit trailing level (in points)
//--- inputs for money
input double          Money_FixLot_Percent          =10.0;           // Percent
input double          Money_FixLot_Lots             =0.1;            // Fixed volume
//+------------------------------------------------------------------+
//| Global expert object                                             |
//+------------------------------------------------------------------+
CExpert ExtExpert;
//+------------------------------------------------------------------+
//| Initialization function of the expert                            |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- Initializing expert
   if(!ExtExpert.Init(Symbol(),Period(),Expert_EveryTick,Expert_MagicNumber))
     {
      //--- failed
      printf(__FUNCTION__+": error initializing expert");
      ExtExpert.Deinit();
      return(INIT_FAILED);
     }
//--- Creating signal
   CExpertSignal *signal=new CExpertSignal;
   if(signal==NULL)
     {
      //--- failed
      printf(__FUNCTION__+": error creating signal");
      ExtExpert.Deinit();
      return(INIT_FAILED);
     }
//---
   ExtExpert.InitSignal(signal);
   signal.ThresholdOpen(Signal_ThresholdOpen);
   signal.ThresholdClose(Signal_ThresholdClose);
   signal.PriceLevel(Signal_PriceLevel);
   signal.StopLevel(Signal_StopLevel);
   signal.TakeLevel(Signal_TakeLevel);
   signal.Expiration(Signal_Expiration);
//--- Creating filter CSignalATCF
   CSignalATCF *filter0=new CSignalATCF;
   if(filter0==NULL)
     {
      //--- failed
      printf(__FUNCTION__+": error creating filter0");
      ExtExpert.Deinit();
      return(INIT_FAILED);
     }
   signal.AddFilter(filter0);
//--- Set filter parameters
   filter0.TimeFrame(Signal_ATCF_TimeFrame);
   filter0.HistoryBars(Signal_ATCF_HistoryBars);
   filter0.AveragePeriod(Signal_ATCF_AveragePeriod);
   filter0.Pattern1(Signal_ATCF_Pattern1);
   filter0.Pattern2(Signal_ATCF_Pattern2);
   filter0.Pattern3(Signal_ATCF_Pattern3);
   filter0.Pattern4(Signal_ATCF_Pattern4);
   filter0.Pattern5(Signal_ATCF_Pattern5);
   filter0.Pattern6(Signal_ATCF_Pattern6);
   filter0.Pattern7(Signal_ATCF_Pattern7);
   filter0.Pattern8(Signal_ATCF_Pattern8);
   filter0.Weight(Signal_ATCF_Weight);
//--- Creation of trailing object
   CTrailingFixedPips *trailing=new CTrailingFixedPips;
   if(trailing==NULL)
     {
      //--- failed
      printf(__FUNCTION__+": error creating trailing");
      ExtExpert.Deinit();
      return(INIT_FAILED);
     }
//--- Add trailing to expert (will be deleted automatically))
   if(!ExtExpert.InitTrailing(trailing))
     {
      //--- failed
      printf(__FUNCTION__+": error initializing trailing");
      ExtExpert.Deinit();
      return(INIT_FAILED);
     }
//--- Set trailing parameters
   trailing.StopLevel(Trailing_FixedPips_StopLevel);
   trailing.ProfitLevel(Trailing_FixedPips_ProfitLevel);
//--- Creation of money object
   CMoneyFixedLot *money=new CMoneyFixedLot;
   if(money==NULL)
     {
      //--- failed
      printf(__FUNCTION__+": error creating money");
      ExtExpert.Deinit();
      return(INIT_FAILED);
     }
//--- Add money to expert (will be deleted automatically))
   if(!ExtExpert.InitMoney(money))
     {
      //--- failed
      printf(__FUNCTION__+": error initializing money");
      ExtExpert.Deinit();
      return(INIT_FAILED);
     }
//--- Set money parameters
   money.Percent(Money_FixLot_Percent);
   money.Lots(Money_FixLot_Lots);
//--- Check all trading objects parameters
   if(!ExtExpert.ValidationSettings())
     {
      //--- failed
      ExtExpert.Deinit();
      return(INIT_FAILED);
     }
//--- Tuning of all necessary indicators
   if(!ExtExpert.InitIndicators())
     {
      //--- failed
      printf(__FUNCTION__+": error initializing indicators");
      ExtExpert.Deinit();
      return(INIT_FAILED);
     }
//--- ok
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Deinitialization function of the expert                          |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   ExtExpert.Deinit();
  }
//+------------------------------------------------------------------+
//| "Tick" event handler function                                    |
//+------------------------------------------------------------------+
void OnTick()
  {
   ExtExpert.OnTick();
  }
//+------------------------------------------------------------------+
//| "Trade" event handler function                                   |
//+------------------------------------------------------------------+
void OnTrade()
  {
   ExtExpert.OnTrade();
  }
//+------------------------------------------------------------------+
//| "Timer" event handler function                                   |
//+------------------------------------------------------------------+
void OnTimer()
  {
   ExtExpert.OnTimer();
  }
//+------------------------------------------------------------------+
