//+------------------------------------------------------------------+
//|                                         eIncGUI_v3_Test_Form.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v3.mqh>

enum eColorScheme{
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
};

input eColorScheme ColorScheme=DefaultScheme;

class CForm: public CFormBase{
   public:
      // 1.      
      CHMenu m_hm;
      CVMenu m_vm1;
      CVMenu m_vm2;
      CVMenu m_vm3; 
      CFrame m_fr1;
      CFrame m_fr2;
      CInputBox m_ib;     
      CSpinInputBox m_sib; 
      CDialerInputBox m_dib;  
      CComBox m_cb; 
      CCheckBox m_chb;
      CRadioGroup m_rg1;
      CRadioGroup m_rg2;
      CListMS m_lms1;
      CListMS m_lms2;
      CButton m_but;
   protected: 
      // 2.          
      int m_EventsCounter;
         void MainProperties(){
            //   
            m_Name         =  "Form";        //  .          .
            m_Width        =  260;           //  
            m_Height       =  200;           //  
            m_Type         =  0;             //  : 0 -  , 1 -   "Apply"  "Cancel", 2 -   "Close"
            m_Caption      =  "FormCaption"; //  
            m_Movable      =  true;          //   (       )
            m_Resizable    =  true;          //  /  (       )
            m_CloseButton  =  false;         //    (       )
         }
         void OnInitEvent(){
            // 3.   Init()   
            // 4.  ,     
            // 5.   , ,    .
            //  
            //  
            m_hm.Init(m_Name+"_HM",m_Width,2);
            //    
            m_hm.AddItem(" ");
            m_hm.AddItem("Item-2");
            m_hm.AddItem("Item-3");
            //   1
            m_vm1.Init(m_Name+"_VM1",70,10); 
            //     1
            m_vm1.AddItem("-1");
            m_vm1.AddItem("-2");
            //   2
            m_vm2.Init(m_Name+"_VM2",70,3);
            //     2
            m_vm2.AddItem("Item-2-1");
            m_vm2.AddItem("Item-2-2");
            m_vm2.AddItem("Item-2-3");    
            m_vm2.AddItem("Item-2-4");
            m_vm2.AddItem("Item-2-5"); 
            //   3
            m_vm3.Init(m_Name+"_VM3",70,3);
            //     3
            m_vm3.AddItem("Item-3-1");
            m_vm3.AddItem("Item-3-2");
            m_vm3.AddItem("Item-3-3");    
            m_vm3.AddItem("Item-3-4");
            m_vm3.AddItem("Item-3-5");    
            //                       
            m_fr1.Init(m_Name+"_Frame1",120,155,"Frame-1",38);
            m_fr2.Init(m_Name+"_Frame2",120,155,"Frame-2",38);
            // 
            m_ib.Init(m_Name+"_IB",40,2);  
            m_sib.Init(m_Name+"_SIB",40,1);  
            m_dib.Init(m_Name+"_DIB",40,2);     
            m_cb.Init(m_Name,40);
            m_cb.AddItem("1");
            m_cb.AddItem("2");            
            m_cb.AddItem("3");            
            m_cb.AddItem("4");            
            m_cb.AddItem("5");                               
            m_cb.SetSelectedIndex(0);
            m_chb.Init(m_Name+"CB");
            m_rg1.Init(m_Name+"_RG1");
            m_rg1.AddButton("11",0,0);
            m_rg1.AddButton("12",0,20);
            m_rg1.AddButton("13",25,0);            
            m_rg1.AddButton("14",25,20);
            m_rg1.SetValue(0);
            m_rg2.Init(m_Name+"_RG2");
            m_rg2.AddButton("21",0,0);
            m_rg2.AddButton("22",0,20);
            m_rg2.AddButton("23",25,0);            
            m_rg2.AddButton("24",25,20);
            m_rg2.SetValue(0);
            m_lms1.Init(m_Name+"_ListMS1",105,4);
               for(int i=0;i<SymbolsTotal(true);i++){
                  m_lms1.AddItem(SymbolName(i,true));
               }
            m_but.Init(m_Name+"_But",50,15);  
            m_lms2.Init(m_Name+"_ListMS2",105,4);
         }   
         void OnShowEvent(int aLeft,int aTop){
            // 6.   Show(x,y)     
            // 
            m_hm.Show(aLeft,aTop);            
            //  1
            m_fr1.Show(aLeft+8,aTop+23);
            m_ib.Show(m_fr1.Left()+5,m_fr1.Top()+10);
            m_sib.Show(m_fr1.Left()+5,m_fr1.Top()+30);
            m_dib.Show(m_fr1.Left()+5,m_fr1.Top()+50);
            m_cb.Show(m_fr1.Left()+5,m_fr1.Top()+70); 
            m_chb.Show(m_fr1.Left()+5,m_fr1.Top()+90);
            m_rg1.Show(m_fr1.Left()+5,m_fr1.Top()+110);
            m_rg2.Show(m_fr1.Left()+5+55,m_fr1.Top()+110);
            m_fr2.Show(aLeft+8+120+5,aTop+23);
            m_lms1.Show(m_fr2.Left()+5,m_fr2.Top()+10);
            m_but.Show(m_fr2.Left()+5,m_lms1.Top()+m_lms1.Height()+5);
            m_lms2.Show(m_fr2.Left()+5,m_but.Top()+m_but.Height()+5);
         }
         void OnHideEvent(){
            // 7.   Hide()     
            m_hm.Hide(); 
            m_vm1.Hide(); 
            m_vm2.Hide(); 
            m_vm3.Hide();             
            m_fr1.Hide();
            m_fr2.Hide();               
            m_ib.Hide();
            m_sib.Hide();
            m_dib.Hide();
            m_cb.Hide();  
            m_chb.Hide();  
            m_rg1.Hide();  
            m_rg2.Hide();  
            m_lms1.Hide();
            m_lms2.Hide();
            m_but.Hide();
         }
         void OnWindowChangeEvent(int aSubWindow){
            // 8.   SetSubWindow()     .      aSubWindow.
            m_hm.SetSubWindow(aSubWindow);
            m_vm1.SetSubWindow(aSubWindow);
            m_vm2.SetSubWindow(aSubWindow);
            m_vm3.SetSubWindow(aSubWindow); 
            m_fr1.SetSubWindow(aSubWindow);
            m_fr2.SetSubWindow(aSubWindow);            
            m_ib.SetSubWindow(aSubWindow);
            m_sib.SetSubWindow(aSubWindow);
            m_dib.SetSubWindow(aSubWindow);
            m_cb.SetSubWindow(aSubWindow);
            m_chb.SetSubWindow(aSubWindow);
            m_rg1.SetSubWindow(aSubWindow);
            m_rg2.SetSubWindow(aSubWindow);
            m_lms1.SetSubWindow(aSubWindow);
            m_lms2.SetSubWindow(aSubWindow);
            m_but.SetSubWindow(aSubWindow);
            
         }
         void EventsHandler(const int id,const long& lparam,const double& dparam,const string& sparam){
            // 9.   Event()   . 
            // 10.      
            //  
            int m_event0=m_hm.Event(id,lparam,dparam,sparam);
            int m_event1=m_vm1.Event(id,lparam,dparam,sparam);
            int m_event2=m_vm2.Event(id,lparam,dparam,sparam);
            int m_event3=m_vm3.Event(id,lparam,dparam,sparam);  
            //    
               if(m_event0==0){ //    0
                  if(m_vm1.Visible()){
                     m_vm1.Hide(); //    ,   
                  }
                  else{ //    
                     m_vm1.ToggleNamesClear(); //   "" 
                     //        
                     //        
                     //                        
                     m_vm1.ToggleNameAdd(m_hm.LastClickedName1());
                     m_vm1.ToggleNameAdd(m_hm.LastClickedName2());
                     //   
                     m_vm1.Show(m_hm.SolvePosLeft(m_vm1.Width()),m_hm.SolvePosTop(m_vm1.Height()));                  
                  }
               }
               if(m_event0==1){ //    1
                  if(m_vm2.Visible()){
                     m_vm2.Hide();
                  }
                  else{
                     m_vm2.ToggleNamesClear();
                     m_vm2.ToggleNameAdd(m_hm.LastClickedName1());
                     m_vm2.ToggleNameAdd(m_hm.LastClickedName2());
                     m_vm2.Show(m_hm.SolvePosLeft(m_vm2.Width()),m_hm.SolvePosTop(m_vm2.Height()));                     
                  }
               }
               if(m_event0==2){ //    2
                  if(m_vm3.Visible()){
                     m_vm3.Hide();
                  }
                  else{
                     m_vm3.ToggleNamesClear();
                     m_vm3.ToggleNameAdd(m_hm.LastClickedName1());
                     m_vm3.ToggleNameAdd(m_hm.LastClickedName2());
                     m_vm3.Show(m_hm.SolvePosLeft(m_vm3.Width()),m_hm.SolvePosTop(m_vm3.Height()));                    
                  }
               }
            //   
               if(m_event1>=0){ //    1
                  m_vm1.Hide(); //  
                     if(m_event1==0){ //    0
                        frm2.Hide();
                        frm1.Show(frm.Left()+100,frm.Top()+100);
                     }
                     if(m_event1==1){ //    1
                        frm1.Hide();
                        frm2.Show(frm.Left()+100,frm.Top()+100);
                     }                  
               }
               if(m_event2>=0){
                  m_vm2.Hide();
                  Alert("   "+m_vm2.Text(m_event2));
               }
               if(m_event3>=0){
                  m_vm3.Hide();
                  Alert("   "+m_vm3.Text(m_event3));
               }
            //                   
               if(m_ib.Event(id,lparam,dparam,sparam)>0){
                  Alert(" Input");
               }
               if(m_sib.Event(id,lparam,dparam,sparam)>0){
                  Alert(" SpinInput");               
               }
               if(m_dib.Event(id,lparam,dparam,sparam)>0){
                  Alert(" DialerInput");      
               }
               if(m_cb.Event(id,lparam,dparam,sparam)>0){
                  Alert(" ComBox");
               } 
               if(m_rg1.Event(id,lparam,dparam,sparam)>0){
                  Alert(" RadioGroup-1");
               }  
               if(m_rg2.Event(id,lparam,dparam,sparam)>0){
                  Alert(" RadioGroup-2");
               }                 
               if(m_chb.Event(id,lparam,dparam,sparam)>0){
                  Alert(" CheckBox");
               }   
            m_lms1.Event(id,lparam,dparam,sparam);
            m_lms2.Event(id,lparam,dparam,sparam);
               if(m_but.Event(id,lparam,dparam,sparam)==1){
                  if(m_lms1.FirstSelected()==-1 && m_lms2.Count()==0){
                     Alert("     ");
                  }
                  else{
                     m_lms2.Clear();
                        for(int i=0;i<m_lms1.Count();i++){
                           if(m_lms1.Selected(i)){
                              m_lms2.AddItem(m_lms1.Text(i));
                           }
                        }
                     m_lms2.Refresh();                     
                  }
               }
         }
         bool OnApplyEvent(){
            // 11.        "Apply".    ,      false.
            // 12.  .
            return(true);
         }
         bool OnCancelEvent(){
            // 13.     "Cancel"  "Close".    ,      false.
            return(false);
         }
};

class CForm1: public CFormBase{
   public:
      // 1.      
      CInputBox m_ib;
   protected: 
      // 2.       
      string m_InputBoxValue;
         void MainProperties(){
            //   
            m_Name         =  "Form1";        //  .          .
            m_Width        =  200;           //  
            m_Height       =  150;           //  
            m_Type         =  1;             //  : 0 -  , 1 -   "Apply"  "Cancel", 2 -   "Close"
            m_Caption      =  "Form1Caption"; //  
            m_Movable      =  true;          //   (       )
            m_Resizable    =  true;          //  /  (       )
            m_CloseButton  =  true;          //    (       )
         }
         void OnInitEvent(){
            // 3.   Init()   
            // 4.  ,     
            // 5.   , ,    .
            m_ib.Init(m_Name,80,-1," -");
            m_InputBoxValue=""; //    ,   ,       
            m_ib.SetValue(m_InputBoxValue);
         }   
         void OnShowEvent(int aLeft,int aTop){
            // 6.   Show(x,y)     
            m_ib.Show(aLeft+10,aTop+10);
         }
         void OnHideEvent(){
            // 7.   Hide()     
            m_ib.Hide();
         }
         void OnWindowChangeEvent(int aSubWindow){
            // 8.   SetSubWindow()     .      aSubWindow.
            m_ib.SetSubWindow(aSubWindow);
         }
         void EventsHandler(const int id,const long& lparam,const double& dparam,const string& sparam){
            // 9.   Event()   . 
            // 10.      
            m_ib.Event(id,lparam,dparam,sparam);
         }
         bool OnApplyEvent(){
            // 11.        "Apply".    ,      false.
            // 12.  .
            string val=m_ib.ValueString();
            StringTrimLeft(val);
            StringTrimRight(val);
               if(val==""){
                  MessageBox("   !",m_Caption);
                  return(false);
               }
               else{
                  MessageBox(" : "+val,m_Caption);
                  m_InputBoxValue=m_ib.ValueString(); //     ,   ,        
                  return(true);
               }
         }
         bool OnCancelEvent(){
            // 13.     "Cancel"  "Close".    ,      false.
               if(MessageBox("?",Caption(),MB_YESNO)!=IDYES){
                  return(false);
               }
            m_ib.SetValue(m_InputBoxValue); //  ,  
            return(true);
         }
};

class CForm2: public CFormBase{
   public:
      // 1.      
      CLabel m_lbl;
      CButton m_but1;
      CButton m_but2;
      CButton m_but3;
      CButton m_but4;      
   protected: 
      // 2.          
         void MainProperties(){
            //   
            m_Name         =  "Form2";        //  .          .
            m_Width        =  200;            //  
            m_Height       =  150;            //  
            m_Type         =  2;              //  : 0 -  , 1 -   "Apply"  "Cancel", 2 -   "Close"
            m_Caption      =  "Form2Caption"; //  
            m_Movable      =  true;           //   (       )
            m_Resizable    =  true;           //  /  (       )
            m_CloseButton  =  true;           //    (       )
         }
         void OnInitEvent(){
            // 3.   Init()   
            // 4.  ,     
            // 5.   , ,    .
            m_lbl.Init(m_Name,"  \n \n.");
            m_but1.Init(m_Name+"_But1",100,18,"-1");
            m_but2.Init(m_Name+"_But2",100,18,"-2");
            m_but3.Init(m_Name+"_But3",100,18," ");
            m_but4.Init(m_Name+"_But4",100,18,"  ");            
         }   
         void OnShowEvent(int aLeft,int aTop){
            // 6.   Show(x,y)     
            m_lbl.Show(aLeft+10,aTop+10);
            
            m_but1.Show(aLeft+90,aTop+10);
            m_but2.Show(aLeft+90,aTop+35);
            m_but3.Show(aLeft+90,aTop+60);
            m_but4.Show(aLeft+90,aTop+85);            
         }
         void OnHideEvent(){
            // 7.   Hide()     
            m_lbl.Hide();
            m_but1.Hide();
            m_but2.Hide();
            m_but3.Hide();
            m_but4.Hide();            
         }
         void OnWindowChangeEvent(int aSubWindow){
            // 8.   SetSubWindow()     .      aSubWindow.
            m_lbl.SetSubWindow(aSubWindow);
            m_but1.SetSubWindow(aSubWindow);            
            m_but2.SetSubWindow(aSubWindow);     
            m_but3.SetSubWindow(aSubWindow);            
            m_but4.SetSubWindow(aSubWindow);                     
         }
         void EventsHandler(const int id,const long& lparam,const double& dparam,const string& sparam){
            // 9.   Event()   . 
            // 10.      
            if(m_but1.Event(id,lparam,dparam,sparam)==1){
               m_lbl.SetText("  \n ");
            }
            if(m_but2.Event(id,lparam,dparam,sparam)==1){
               m_lbl.SetText("  \n \n");
            }    
            if(m_but3.Event(id,lparam,dparam,sparam)==1){
               m_lbl.SetColor(clrRed);
            }
            if(m_but4.Event(id,lparam,dparam,sparam)==1){
               m_lbl.SetColor();
            }                      
         }
         bool OnApplyEvent(){
            // 11.        "Apply".    ,      false.
            // 12.  .
            return(true);
         }
         bool OnCancelEvent(){
            // 13.     "Cancel"  "Close".    ,      false.
               if(MessageBox("?",Caption(),MB_YESNO)==IDYES){
                  return(true);
               }
               else{
                  return(false);
               }                  
         }
};

CForm frm;
CForm1 frm1;
CForm2 frm2;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(){

   ClrScheme.SetScheme(ColorScheme); 

   //  
   frm.Init();
   frm.SetSubWindow("TestSubWindow");
   frm.Show(30,30);
   
   // -1,   
   frm1.Init();
   frm1.SetSubWindow("TestSubWindow");
   //   ,     
   
   // -2,   
   frm2.Init();
   frm2.SetSubWindow("TestSubWindow");
   //   ,     
   
   return(0);
}
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason){
   frm.Hide();
   frm1.Hide();  
   frm2.Hide();     
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick(){

   
}
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam
                  ){
   int ev=frm.Event(id,lparam,dparam,sparam);
      switch(ev){
         case 1:
            Alert(" "+frm.Name()+"("+frm.Caption()+").  Cancel");
         break;
         case 2:
            Alert(" "+frm.Name()+"("+frm.Caption()+").  Apply");  
         break;
         case 3:
            Alert(" "+frm.Name()+"("+frm.Caption()+").  Resize");  
         break;         
      }
   frm1.Event(id,lparam,dparam,sparam);  
   frm2.Event(id,lparam,dparam,sparam);     
      if(CHARTEVENT_CHART_CHANGE){
         frm.SetSubWindow("TestSubWindow");
         frm1.SetSubWindow("TestSubWindow");
         frm2.SetSubWindow("TestSubWindow");
      }     
}

