//+------------------------------------------------------------------+
//|                                                    IncGUI_v3.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "3.00"

/*
      :
   
   01.  CGraphicObjectShell.
   02.   CGraphicObjectShell   "g".
   03.  CWorkPiece.
   04.   CWorkPiece   "w".
   05.  CColorSchemes.
   06.   CColorSchemes   "ClrScheme".
   07.   .  
         07.01.  CInputBox ( ).
         07.02.  CSpinInputBox (    +/-). 
         07.03.  CCheckBox (). 
         07.04.  CRadioGroup ( ). 
         07.05.  CVScrollBar (  ).  
         07.06.  CHScrollBar (  ).    
         07.07.  CList (). 
         07.08.  CListMS (   ).  
         07.09.  CComBox ( ).  
         07.10.  CHMenu ( ). 
         07.11.  CVMenu ( ). 
         07.12.  CHProgress (  ). 
         07.13.  CDialer (). 
         07.14.  CDialerInputBox (   ).  
         07.15.  CTable (). 
         07.16.  CFrame ().    
         07.17.  CButton ().
         07.18.  CLabel ( ).
   8.    .
         08.1.  CFormBase ( ).
         08.2.  CFormTemplate: public CFormBase (    ).
*/

/*
     v3:
      
          :

         CFormBase ( ).
         CFormTemplate: public CFormBase (    ).       
         
         :
      
         CFrame (,     Frame  CWorkPiece).
         CButton ( ,  OBJ_BUTON)
         CLabel (,      ,    \n)

      * * *

        CColorSchemes    , , , .  
      
      * * *
      
          CWorkPiece   Frame().    
        .
      
      * * *
      
        CVMenu        "" 
          "",     
        LastClickedX(), LastClickedY(), LastClickedQuarter().
                  .
   
         CHMenu      LastClickedX(),
      LastClickedY(), LastClickedQuarter(), LastClickedW().
      
        CHMenu  CVMenu   LastClickedName1()  LastClickedName2() 
               
          . LastClickedName1() 
        , LastClickedName2()      "".
      
        CHMenu CVMenu   SolvePosX()  SolvePosY(), 
               .
        SlovePosX()    ,  SolvePosY() 
        .      LastClickedX(),
      LastClickedY(), LastClickedQuarter(), LastClickedW(). 
      
       CVMenu   ToggleNameAdd()  ToggleNamesClear().   
               
               ToggleNameAdd(). 
          ToggleNameAdd()    
          (  ).  ToggleNamesClear()  
         ,         . 
      
       ToggleNameAdd(), LastClickedName1()  LastClickedName2()  
       . ,        
       .        , 
      LastClickedName1()  LastClickedName2()     
      ,    ToggleNameAdd()  .   
                   
         ToggleNameAdd().       
              .  
                 .

      * * *
      
        CHMenu CVMenu    Event()  html .
      
      * * *
      
        CListMS   Selected()  SetSelected().   
         .        .

*/

/*
     v2:
   
       CGraphicObjectShell:
              ...Distance() ( ...Distanse())
          : SetXYDistance(), SetXYSize().
   
       CInputBox:
              ValueString() ( ValueStrind)).
          : SetReadOnly(), ReadOnly().
   
      CColorSchemes:
      
           Show()  .     ,   .
           : 
                                    GreenScheme,
                                    YellowBlackScheme,
                                    LimeBlackScheme,
                                    AquaBlackScheme.
      
         :
      
            CSpinInputBox (    +/-),
            CCheckBox (),
            CRadioGroup ( ),
            CVScrollBar (  ),
            CHScrollBar (  ),
            CList (),
            CListMS (   ),
            CComBox ( ),
            CHMenu ( ),
            CVMenu ( ),
            CHProgress (  ),
            CDialer (),
            CDialerInputBox (   ),
            CTable ().
*/      

//+------------------------------------------------------------------+
//|                                                                  |
//|          CGraphicObjectShell                                |
//|                                                                  |
//+------------------------------------------------------------------+

/*!
	\brief     ,   .
	
	\details       ,     
	             .      .
	         
	                 "Create",   
	             : , , . 
	         
	                "Set".     
	             : 1)  , 2)    
	         ( ), 3)    (, ).
	         
	          1         . 
	                    
	          Create...()    Attach().  2   
	               "" ,  3 -  
	            .
	         
   \remark	       "g".
*/

class CGraphicObjectShell{
   protected:
      string m_name;
      long m_id;
   public:   
      /*
           :
      
         1.  .
         2. .
         
         3.     .
         4.    .
         
         5.     .
         6.     .
         
         7.        .
         8.        .
         
         9.  .
      */
      
      //+------------------------------------------------------------------+
      //|                                                          |
      //+------------------------------------------------------------------+
   
		/*!	
			  .
		 	\param		string aName -    ,
		 	\param		long aChartID=0 -       .
		*/
      void Attach(string aName,long aChartID=0){
         m_name=aName;
         m_id=aChartID;
      }
      
		/*!	
			    .
         \return     .
		*/		
      string Name(){return(m_name);}   
      
		/*!	
			     .
         \return     .
		*/      
      long ChartID(){return(m_id);}
      
      //+------------------------------------------------------------------+
      //|                                                          |
      //+------------------------------------------------------------------+      
		
		/*!	
			  " " OBJ_VLINE.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateVLine           (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_VLINE,             aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_HLINE.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/        
      void CreateHLine           (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_HLINE,             aSubWindow,0,0);Attach(aName,aChartID);}

		/*!	
			  " " OBJ_TREND.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/       
      void CreateTrend           (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_TREND,             aSubWindow,0,0);Attach(aName,aChartID);}

		/*!	
			  "   " OBJ_TRENDBYANGLE.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/           
      void CreateTrendByAngle    (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_TRENDBYANGLE,      aSubWindow,0,0);Attach(aName,aChartID);}

		/*!	
			  " " OBJ_CHANNEL.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/        
      void CreateChannel         (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_CHANNEL,           aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "  " OBJ_STDDEVCHANNEL.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/        
      void CreateStdDevChannel   (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_STDDEVCHANNEL,     aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "  " OBJ_REGRESSION.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/        
      void CreateRegresion       (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_REGRESSION,        aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_PITCHFORK.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreatePitchFork       (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_PITCHFORK,         aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_GANNLINE.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateGannLine        (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_GANNLINE,          aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_GANNFAN.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateGannFan         (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_GANNFAN,           aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_GANNGRID.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateGannGrid        (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_GANNGRID,          aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_FIBO.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateFibo            (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_FIBO,              aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "  " OBJ_FIBOTIMES.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateFiboTimes       (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_FIBOTIMES,         aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_FIBOFAN.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateFiboFan         (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_FIBOFAN,           aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_FIBOARC.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateFiboArc         (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_FIBOARC,           aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_FIBOCHANNEL.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateFiboChannel     (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_FIBOCHANNEL,       aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_EXPANSION.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateExpansion       (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_EXPANSION,         aSubWindow,0,0);Attach(aName,aChartID);}	
		
		/*!	
			  "5-  " OBJ_ELLIOTWAVE5.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateElliotWave5     (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ELLIOTWAVE5,       aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "3-  " OBJ_ELLIOTWAVE3.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateElliotWave3     (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ELLIOTWAVE3,       aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" OBJ_RECTANGLE.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateRectangle       (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_RECTANGLE,         aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" OBJ_TRIANGLE.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateTriangle        (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_TRIANGLE,          aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" OBJ_ELLIPSE.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateEllipse         (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ELLIPSE,           aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_CYCLES.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateCycles          (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_CYCLES,            aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" (  ) OBJ_ARROW_THUMB_UP.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateThumbUp         (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW_THUMB_UP,    aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" (  ) OBJ_ARROW_THUMB_DOWN.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateTumbDn          (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW_THUMB_DOWN,  aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_ARROW_UP.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateArrowUp         (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW_UP,          aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_ARROW_DOWN.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateArrowDn         (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW_DOWN,        aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" OBJ_ARROW_STOP.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateArrowStop       (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW_STOP,        aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" () OBJ_ARROW_CHECK.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateArrowCheck      (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW_CHECK,       aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "  " OBJ_ARROW_LEFT_PRICE.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateArrowLeftPrice  (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW_LEFT_PRICE,  aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "  " OBJ_ARROW_RIGHT_PRICE.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateArrowRightPrice (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW_RIGHT_PRICE, aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "Buy" OBJ_ARROW_BUY.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateArrowBuy        (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW_BUY,         aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "Sell" OBJ_ARROW_SEL.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateArrowSell       (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW_SELL,        aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" OBJ_ARROW.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateArrow           (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROW,             aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" OBJ_TEXT.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateText            (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_TEXT,              aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_LABEL.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateLabel           (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_LABEL,             aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" OBJ_BUTTON.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateButton          (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_BUTTON,            aSubWindow,0,0);Attach(aName,aChartID);}	      
		
		/*!	
			  "" OBJ_CHART.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateChart           (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_CHART,             aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" OBJ_BITMAP.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateBitmap          (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_BITMAP,            aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_BITMAP_LABEL.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreatePitmapLabel     (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_BITMAP_LABEL,      aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_EDIT.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateEdit            (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_EDIT,              aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "  " OBJ_ARROWED_LINE.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateArrowedLine     (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_ARROWED_LINE,      aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  "" OBJ_EVENT.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateEvent           (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_EVENT,             aSubWindow,0,0);Attach(aName,aChartID);}
		
		/*!	
			  " " OBJ_RECTANGLE_LABEL.
		 	\param		string aName -    ,
		 	\param		int aSubWindow=0 -      ,
		 	\param		long aChartID=0 -       .			
		*/  
      void CreateRectangleLabel  (string aName,int aSubWindow=0,long aChartID=0){ObjectCreate(aChartID,aName,OBJ_RECTANGLE_LABEL,   aSubWindow,0,0);Attach(aName,aChartID);}

      //+------------------------------------------------------------------+
      //|                         |
      //+------------------------------------------------------------------+         

		/*!	
			 OBJPROP_COLOR.
		 	\return    ( color).		
		*/  
      color                   Color       ()             {return( (color)                    ObjectGetInteger(m_id,m_name,OBJPROP_COLOR));}

		/*!	
			 OBJPROP_STYLE.
		 	\return    ( ENUM_LINE_STYLE).		
		*/        
      ENUM_LINE_STYLE         Style       ()             {return( (ENUM_LINE_STYLE)          ObjectGetInteger(m_id,m_name,OBJPROP_STYLE));}

		/*!	
			 OBJPROP_WIDTH.
		 	\return    ( int).		
		*/         
      int                     Width       ()             {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_WIDTH));} 

		/*!	
			     OBJPROP_BACK.
		 	\return   bool. True -   , false -  .		
		*/        
      bool                    Back        ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_BACK));} 	

		/*!	
			   OBJPROP_FILL ( OBJ_RECTANGLE, OBJ_TRIANGLE, OBJ_ELLIPSE, OBJ_CHANNEL, OBJ_STDDEVCHANNEL, OBJ_REGRESSION)
		 	\return   bool. True - , false - .	
		*/       
      bool                    Fill        ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_FILL));} 		

		/*!	
			  OBJPROP_SELECTED.
		 	\return   bool. True - , false -  .	
		*/       
      bool                    Selected    ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_SELECTED));} 		

		/*!	
			     " " OBJPROP_SELECTED.
		 	\return   bool. True -  , false - .	
		*/  
      bool                    ReadOnly    ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_READONLY));} 		

		/*!	
			  OBJPROP_TYPE.
		 	\return   ENUM_OBJECT.	
		*/       
      ENUM_OBJECT             Type        ()             {return( (ENUM_OBJECT)              ObjectGetInteger(m_id,m_name,OBJPROP_TYPE));}

		/*!	
			      OBJPROP_TIME.
         \param   int aIndex -    ( ).
		 	\return    ( datetime).		
		*/       
      datetime                Time        (int aIndex)   {return( (datetime)                 ObjectGetInteger(m_id,m_name,OBJPROP_TIME,aIndex));}	

		/*!	
			   OBJPROP_SELECTABLE.
		 	\return   bool. True -  , false - .	
		*/         
      bool                    Selectable  ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_SELECTABLE));} 		

		/*!	
			   OBJPROP_CREATETIME.
		 	\return    ( datetime).		
		*/       
      datetime                CreateTime  ()             {return( (datetime)                 ObjectGetInteger(m_id,m_name,OBJPROP_CREATETIME));}	

		/*!	
			  OBJPROP_LEVELS).
		 	\return   ( int).		
		*/    
      int                     Levels      ()             {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_LEVELS));}	

		/*!	
			  OBJPROP_LEVELCOLOR.
         \param   int aIndex -   ( ).
		 	\return    ( color).		
		*/  
      color                   LevelColor  (int aIndex)   {return( (color)                    ObjectGetInteger(m_id,m_name,OBJPROP_LEVELCOLOR,aIndex));}		

		/*!	
			  OBJPROP_LEVELSTYLE.
         \param   int aIndex -   ( ).
		 	\return    ( ENUM_LINE_STYLE).		
		*/        
      ENUM_LINE_STYLE         LevelStyle  (int aIndex)   {return( (ENUM_LINE_STYLE)          ObjectGetInteger(m_id,m_name,OBJPROP_LEVELSTYLE,aIndex));}	

		/*!	
			  OBJPROP_LEVELWIDTH.
         \param   int aIndex -   ( ).
		 	\return    ( int).		
		*/  
      int                     LevelWidth  (int aIndex)   {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_LEVELWIDTH,aIndex));}		

		/*!	
			  OBJPROP_FONTSIZE.
		 	\return    ( int).		
		*/        
      int                     FontSize    ()             {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_FONTSIZE));}		   

		/*!	
			   OBJPROP_RAY_LEFT.
		 	\return   bool. True -   , false -  .		
		*/       
      bool                    RayLeft     ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_RAY_LEFT));} 	

		/*!	
			   OBJPROP_RAY_RIGHT.
		 	\return   bool. True -   , false -  .		
		*/         
      bool                    RayRight    ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_RAY_RIGHT));} 		

		/*!	
			       OBJPROP_RAY.
		 	\return   bool. True -     , false -   .		
		*/   
      bool                    Ray         ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_RAY));} 		

		/*!	
			    " " OBJPROP_ELLIPSE.
      	\return   bool. True -  , false - .		
		*/  
      bool                    Ellipse     ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_ELLIPSE));} 			   

		/*!	
			    "" OBJPROP_ARROWCODE.
      	\return    ( char).
		*/ 
      char                    ArrowCode   ()             {return( (char)                     ObjectGetInteger(m_id,m_name,OBJPROP_ARROWCODE));}

		/*!	
			    OBJPROP_TIMEFRAMES.
      	\return     ( long).
		*/ 
      long                    TimeFrames  ()             {return(                            ObjectGetInteger(m_id,m_name,OBJPROP_TIMEFRAMES));}

		/*!	
			   OBJPROP_ANCHOR.
      	\return     ( long).  OBJ_ARROW    ENUM_ARROW_ANCHOR,  OBJ_LABEL  OBJ_TEXT -    ENUM_ANCHORPOINT.
		*/       
      long                    Anchor      ()             {return(                            ObjectGetInteger(m_id,m_name,OBJPROP_ANCHOR));}

		/*!	
			     X    OBJPROP_XDISTANCE.
      	\return   ( int).
		*/      
      int                     XDistance   ()             {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_XDISTANCE));}	

		/*!	
			     Y    OBJPROP_YDISTANCE.
      	\return   ( int).
		*/        
      int                     YDistance   ()             {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_YDISTANCE));}	

		/*!	
			   OBJPROP_DIRECTION.
      	\return   ( ENUM_GANN_DIRECTION).
		*/   
      ENUM_GANN_DIRECTION     Direction   ()             {return( (ENUM_GANN_DIRECTION)      ObjectGetInteger(m_id,m_name,OBJPROP_DIRECTION));}

		/*!	
			    OBJPROP_DEGREE.
      	\return   ( ENUM_ELLIOT_WAVE_DEGREE).
		*/        
      ENUM_ELLIOT_WAVE_DEGREE Degree      ()             {return( (ENUM_ELLIOT_WAVE_DEGREE)  ObjectGetInteger(m_id,m_name,OBJPROP_DEGREE));}

		/*!	
			      OBJPROP_DRAWLINES.
      	\return   bool. True - , false - .		
		*/  
      bool                    DrawLines   ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_DRAWLINES));} 

		/*!	
			  (/) OBJPROP_STATE.
      	\return   bool. True - , false - .
		*/ 
      bool                    State       ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_STATE));} 

		/*!	
			  "" OBJPROP_CHART_ID.
      	\return    ( long).
		*/ 
      long                    ChartChartID()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_CHART_ID));}

		/*!	
			   OBJPROP_XSIZE.
      	\return    ( int).
		*/       
      int                     XSize       ()             {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_XSIZE));}	

		/*!	
			   OBJPROP_YSIZE.
      	\return    ( int).
		*/ 
      int                     YSize       ()             {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_YSIZE));}		

		/*!	
			 X     OBJPROP_XOFFSET.
      	\return   ( int).
		*/ 
      int                     XOffset     ()             {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_XOFFSET));}	

		/*!	
			 Y     OBJPROP_YOFFSET.
      	\return   ( int).
		*/ 
      int                     YOffset     ()             {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_YOFFSET));}	

		/*!	
			  "" OBJPROP_PERIOD.
      	\return   ( ENUM_TIMEFRAMES).
		*/       
      ENUM_TIMEFRAMES         Period      ()             {return( (ENUM_TIMEFRAMES)          ObjectGetInteger(m_id,m_name,OBJPROP_PERIOD));}

		/*!	
			      "" OBJPROP_DATE_SCALE.
      	\return   bool. True -  , false -  .
		*/ 
      bool                    DateScale   ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_DATE_SCALE));} 

		/*!	
			      "" OBJPROP_PRICE_SCALE.
      	\return   bool. True -  , false -  .
		*/       
      bool                    PriceScale  ()             {return( (bool)                     ObjectGetInteger(m_id,m_name,OBJPROP_PRICE_SCALE));} 

		/*!	
			   "" OBJPROP_CHART_SCALE.
      	\return   1-5 ( int).
		*/        
      int                     ChartScale  ()             {return( (int)                      ObjectGetInteger(m_id,m_name,OBJPROP_CHART_SCALE));}		

		/*!	
			  OBJPROP_BGCOLOR.
		 	\return    ( color).		
		*/  
      color                   BgColor     ()             {return( (color)                    ObjectGetInteger(m_id,m_name,OBJPROP_BGCOLOR));}

		/*!	
			      OBJPROP_CORNER.
		 	\return   ( ENUM_BASE_CORNER).
		*/  
      ENUM_BASE_CORNER        Corner      ()             {return( (ENUM_BASE_CORNER)         ObjectGetInteger(m_id,m_name,OBJPROP_CORNER));}

		/*!	
			    " " OBJPROP_BORDER_TYPE.
		 	\return   ( ENUM_BORDER_TYPE).
		*/        
      ENUM_BORDER_TYPE        BorderType  ()             {return( (ENUM_BORDER_TYPE)         ObjectGetInteger(m_id,m_name,OBJPROP_BORDER_TYPE));}

		/*!	
			  OBJPROP_PRICE.
         \param   int aIndex -   ( ).
		 	\return   ( double).
		*/    
      double                  Price       (int aIndex)   {return(                            ObjectGetDouble(m_id,m_name,OBJPROP_PRICE,aIndex));} 

		/*!	
			  OBJPROP_LEVELVALUE.
         \param   int aIndex -   ( ).
		 	\return   ( double).
		*/          
      double                  LevelValue  (int aIndex)   {return(                            ObjectGetDouble(m_id,m_name,OBJPROP_LEVELVALUE,aIndex));}  

		/*!	
			 (     " ") OBJPROP_SCALE.
		 	\return   ( double).
		*/        
      double                  Scale       ()             {return(                            ObjectGetDouble(m_id,m_name,OBJPROP_SCALE));}

		/*!	
			 OBJPROP_ANGLE.
		 	\return   ( double).
		*/ 
      double                  Angle       ()             {return(                            ObjectGetDouble(m_id,m_name,OBJPROP_ANGLE));}

		/*!	
			     OBJPROP_DEVIATION.
		 	\return   ( double).
		*/       
      double                  Deviation   ()             {return(                            ObjectGetDouble(m_id,m_name,OBJPROP_DEVIATION));}

		/*!	
			    OBJPROP_TEXT.
		 	\return  .
		*/  
      string                  Text        ()             {return(                            ObjectGetString(m_id,m_name,OBJPROP_TEXT));}

		/*!	
			  . OBJPROP_TOOLTIP.
		 	\return  .
		*/  
      string                  ToolTip     ()             {return(                            ObjectGetString(m_id,m_name,OBJPROP_TOOLTIP));}

		/*!	
			 . OBJPROP_LEVELTEXT.
         \param   int aIndex -   ( ).			
		 	\return  .
		*/        
      string                  LevelText   (int aIndex)   {return(                            ObjectGetString(m_id,m_name,OBJPROP_LEVELTEXT,aIndex));} 

		/*!	
			 . OBJPROP_FONT.
		 	\return   ( string).
		*/       
      string                  Font        ()             {return(                            ObjectGetString(m_id,m_name,OBJPROP_FONT));}

		/*!	
			     "" OBJPROP_BMPFILE,  0.
		 	\return    ( string).
		*/       
      string                  BmpFileOn   ()             {return(                            ObjectGetString(m_id,m_name,OBJPROP_BMPFILE,0));}

		/*!	
			     "" OBJPROP_BMPFILE,  1.
		 	\return    ( string).
		*/    
      string                  BmpFileOff  ()             {return(                            ObjectGetString(m_id,m_name,OBJPROP_BMPFILE,1));}       

		/*!	
			   "" OBJPROP_SYMBOL.
		 	\return   ( string).
		*/  
      string                  Symbol      ()             {return(                            ObjectGetString(m_id,m_name,OBJPROP_SYMBOL));}  
      
      //+------------------------------------------------------------------+
      //|                             |
      //+------------------------------------------------------------------+    

		/*!	
			  OBJPROP_COLOR.
         \param		color aValue -  .			
		*/  
      void SetColor        (color aValue)                      {ObjectSetInteger(m_id,m_name,OBJPROP_COLOR,             aValue);}

		/*!	
			  OBJPROP_STYLE.
         \param		ENUM_LINE_STYLE aValue -  .			
		*/
      void SetStyle        (ENUM_LINE_STYLE aValue)            {ObjectSetInteger(m_id,m_name,OBJPROP_STYLE,             aValue);}

		/*!	
			  OBJPROP_WIDTH.
         \param		int aValue -  .			
		*/  
      void SetWidth        (int aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_WIDTH,             aValue);} 

		/*!	
			   /  OBJPROP_BACK.
         \param		bool aValue - true/false (/ ).
		*/        
      void SetBack         (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_BACK,              aValue);} 	

		/*!	
			  OBJPROP_FILL.
         \param		bool aValue - true/false (/).
		*/       
      void SetFill         (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_FILL,              aValue);} 		

		/*!	
			  OBJPROP_SELECTED.
         \param		bool aValue - true/false (/ ).
		*/         
      void SetSelected     (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_SELECTED,          aValue);} 		

		/*!	
			      " " OBJPROP_READONLY.
         \param		bool aValue - true/false (/).
		*/         
      void SetReadOnly     (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_READONLY,          aValue);} 		

		/*!	
			      OBJPROP_TIME.
         \param		int aIndex -   ( ),
         \param		datetime aValue -  .
		*/    
      void SetTime         (int aIndex,datetime aValue)        {ObjectSetInteger(m_id,m_name,OBJPROP_TIME,              aIndex,aValue);}	

		/*!	
			    OBJPROP_SELECTABLE.
         \param		bool aValue - true/false (/).
		*/       
      void SetSelectable   (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_SELECTABLE,        aValue);} 		

		/*!	
			   OBJPROP_LEVELS.
         \param		int aValue -  .
		*/       
      void SetLevels       (int aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_LEVELS,            aValue);}	

		/*!	
			   OBJPROP_LEVELCOLOR.
         \param   int aIndex -   ( ),
         \param   color aValue -  .
		*/        
      void SetLevelColor   (int aIndex,color aValue)           {ObjectSetInteger(m_id,m_name,OBJPROP_LEVELCOLOR,        aIndex,aValue);}		

		/*!	
			   OBJPROP_LEVELSTYLE.
         \param   int aIndex -   ( ),
         \param   ENUM_LINE_STYLE aValue -  .
		*/  
      void SetLevelStyle   (int aIndex,ENUM_LINE_STYLE aValue) {ObjectSetInteger(m_id,m_name,OBJPROP_LEVELSTYLE,        aIndex,aValue);}

		/*!	
			   OBJPROP_LEVELWIDTH.
         \param   int aIndex -   ( ),
         \param   int aValue -  .
		*/  
      void SetLevelWidth   (int aIndex,int aValue)             {ObjectSetInteger(m_id,m_name,OBJPROP_LEVELWIDTH,        aIndex,aValue);}		

		/*!	
			   OBJPROP_FONTSIZE.
         \param   int aValue -  .
		*/  
      void SetFontSize     (int aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_FONTSIZE,          aValue);}		   

		/*!	
			   OBJPROP_RAY_LEFT.
         \param   bool aValue - true/false (/).
		*/  
      void SetRayLeft      (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_RAY_LEFT,          aValue);} 	

		/*!	
			   OBJPROP_RAY_RIGHT.
         \param   bool aValue - true/false (/).
		*/        
      void SetRayRight     (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_RAY_RIGHT,         aValue);} 		

		/*!	
			      OBJPROP_RAY.
         \param   bool aValue - true/false (/).
		*/   
      void SetRay          (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_RAY,               aValue);} 		

		/*!	
			   " "   OBJPROP_ELLIPSE.
         \param   bool aValue - true/false (/).
		*/        
      void SetEllipse      (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_ELLIPSE,           aValue);} 			   

		/*!	
			   OBJPROP_ARROWCODE.
         \param   char aValue -  .
		*/        
      void SetArrowCode    (char aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_ARROWCODE,         aValue);}

		/*!	
			     OBJPROP_TIMEFRAMES.
         \param   long aValue -   .
		*/           
      void SetTimeFrames   (long aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_TIMEFRAMES,        aValue);}

		/*!	
			   OBJPROP_ANCHOR.
         \param   long aValue -   (ENUM_ARROW_ANCHOR  ENUM_ANCHORPOINT).
		*/    
      void SetAnchor       (long aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_ANCHOR,            aValue);}

		/*!	
			    X    OBJPROP_XDISTANCE.
         \param   int aValue -  .
		*/    
      void SetXDistance    (int aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_XDISTANCE,         aValue);}	

		/*!	
			    Y    OBJPROP_YDISTANCE.
         \param   int aValue -  .
		*/          
      void SetYDistance    (int aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_YDISTANCE,         aValue);}	

		/*!	
			    OBJPROP_DIRECTION.
         \param   ENUM_GANN_DIRECTION aValue -  .
		*/ 
      void SetDirection    (ENUM_GANN_DIRECTION aValue)        {ObjectSetInteger(m_id,m_name,OBJPROP_DIRECTION,         aValue);}

		/*!	
			     OBJPROP_DEGREE.
         \param   ENUM_ELLIOT_WAVE_DEGREE aValue -  .
		*/ 
      void SetDegree       (ENUM_ELLIOT_WAVE_DEGREE aValue)    {ObjectSetInteger(m_id,m_name,OBJPROP_DEGREE,            aValue);}

		/*!	
			      OBJPROP_DRAWLINES.
         \param   bool aValue - true/false (/).
		*/       
      void SetDrawLines    (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_DRAWLINES,         aValue);} 

		/*!	
			  .
         \param   bool aValue - true/false (/).
		*/        
      void SetState        (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_STATE,             aValue);} 

		/*!	
			   OBJPROP_XSIZE.
         \param   int aValue -  .
		*/       
      void SetXSize        (int aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_XSIZE,             aValue);}	

		/*!	
			   OBJPROP_YSIZE.
         \param   int aValue -  .
		*/          
      void SetYSize        (int aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_YSIZE,             aValue);}		

		/*!	
			  X    OBJPROP_XOFFSET.
         \param   int aValue -  .
		*/ 
      void SetXOffset      (int aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_XOFFSET,           aValue);}	

		/*!	
			  Y    OBJPROP_YOFFSET.
         \param   int aValue -  .
		*/ 
      void SetYOffset      (int aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_YOFFSET,           aValue);}	

		/*!	
			   "" OBJPROP_PERIOD.
         \param   ENUM_TIMEFRAMES aValue -  .
		*/ 
      void SetPeriod       (ENUM_TIMEFRAMES aValue)            {ObjectSetInteger(m_id,m_name,OBJPROP_PERIOD,            aValue);}

		/*!	
			/     "" OBJPROP_DATE_SCALE.
         \param   bool aValue - true/false (/).
		*/ 
      void SetDateScale    (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_DATE_SCALE,        aValue);} 

		/*!	
			/     "" OBJPROP_PRICE_SCALE.
         \param   bool aValue - true/false (/).
		*/       
      void SetPriceScale   (bool aValue)                       {ObjectSetInteger(m_id,m_name,OBJPROP_PRICE_SCALE,       aValue);} 

		/*!	
			    "" OBJPROP_CHART_SCALE.
         \param   int aValue -  1-5.
		*/         
      void SetChartScale   (int aValue)                        {ObjectSetInteger(m_id,m_name,OBJPROP_CHART_SCALE,       aValue);}		

		/*!	
			   OBJPROP_BGCOLOR.
         \param   color aValue -  .
		*/        
      void SetBgColor      (color aValue)                      {ObjectSetInteger(m_id,m_name,OBJPROP_BGCOLOR,           aValue);}

		/*!	
			     OBJPROP_CORNER.
         \param   ENUM_BASE_CORNER aValue -  .
		*/       
      void SetCorner       (ENUM_BASE_CORNER aValue)           {ObjectSetInteger(m_id,m_name,OBJPROP_CORNER,            aValue);}

		/*!	
			     " " OBJPROP_BORDER_TYPE.
         \param   ENUM_BORDER_TYPE aValue -  .
		*/        
      void SetBorderType   (ENUM_BORDER_TYPE aValue)           {ObjectSetInteger(m_id,m_name,OBJPROP_BORDER_TYPE,       aValue);}      

		/*!	
			   OBJPROP_PRICE.
         \param   int aIndex -   ( ),
		 	\param  double aValue - .
		*/   
      void SetPrice        (int aIndex,double aValue)          {ObjectSetDouble(m_id,m_name,OBJPROP_PRICE,              aIndex,aValue);} 

		/*!	
			   OBJPROP_LEVELVALUE.
         \param   int aIndex -   ( ),
		 	\param  double aValue - .
		*/        
      void SetLevelValue   (int aIndex,double aValue)          {ObjectSetDouble(m_id,m_name,OBJPROP_LEVELVALUE,         aIndex,aValue);}  

		/*!	
			  (     " ") OBJPROP_SCALE.
		 	\param  double aValue -  .
		*/       
      void SetScale        (double aValue)                     {ObjectSetDouble(m_id,m_name,OBJPROP_SCALE,              aValue);}     

		/*!	
			  OBJPROP_ANGLE.
		 	\param  double aValue -   OBJPROP_ANGLE.
		*/       
      void SetAngle        (double aValue)                     {ObjectSetDouble(m_id,m_name,OBJPROP_ANGLE,              aValue);}

		/*!	
			     OBJPROP_DEVIATION.
		 	\param  double aValue -   (  ).
		*/         
      void SetDeviation    (double aValue)                     {ObjectSetDouble(m_id,m_name,OBJPROP_DEVIATION,          aValue);}

		/*!	
			  OBJPROP_TEXT.
		 	\param  string aValue - .
		*/   
      void SetText         (string aValue)                     {ObjectSetString(m_id,m_name,OBJPROP_TEXT,               aValue);}

		/*!	
			   OBJPROP_TOOLTIP.
		 	\param  string aValue - .
		 	\remark      "\n".		 	
		*/       
      void SetToolTip      (string aValue)                     {ObjectSetString(m_id,m_name,OBJPROP_TOOLTIP,            aValue);}

		/*!	
			   OBJPROP_LEVELTEXT.
         \param   int aIndex -   ( ),
		 	\param  string aValue - . 	
		*/       
      void SetLevelText    (int aIndex,string aValue)          {ObjectSetString(m_id,m_name,OBJPROP_LEVELTEXT,          aIndex,aValue);} 

		/*!	
			   OBJPROP_FONT.
		 	\param  string aValue -  . 	
		*/        
      void SetFont         (string aValue)                     {ObjectSetString(m_id,m_name,OBJPROP_FONT,               aValue);} 

		/*!	
			     "" OBJPROP_BMPFILE,  0.
		 	\param  string aValue -  . 	
		*/         
      void SetBmpFileOn    (string aValue)                     {ObjectSetString(m_id,m_name,OBJPROP_BMPFILE,            0,aValue);}       

		/*!	
			     "" OBJPROP_BMPFILE,  1.
		 	\param  string aValue -  . 	
		*/        
      void SetBmpFileOff   (string aValue)                     {ObjectSetString(m_id,m_name,OBJPROP_BMPFILE,            1,aValue);}       

		/*!	
			    "" OBJPROP_SYMBOL.
		 	\param  string aValue - . 	
		*/      
      void SetSymbol       (string aValue)                     {ObjectSetString(m_id,m_name,OBJPROP_SYMBOL,             aValue);}  
      
      //+------------------------------------------------------------------+
      //|                                    |
      //+------------------------------------------------------------------+         
   
		/*!	
			 OBJPROP_COLOR.
			\param  string aName -   . 
		 	\return    ( color).		
		*/     
      color                   Color       (string aName)             {return( (color)                    ObjectGetInteger(0,aName,OBJPROP_COLOR));}
		
		/*!	
			 OBJPROP_STYLE.
         \param  string aName -   . 			
		 	\return    ( ENUM_LINE_STYLE).		
		*/        
      ENUM_LINE_STYLE         Style       (string aName)             {return( (ENUM_LINE_STYLE)          ObjectGetInteger(0,aName,OBJPROP_STYLE));}
		
		/*!	
			 OBJPROP_WIDTH.
         \param  string aName -   . 						
		 	\return    ( int).		
		*/  
      int                     Width       (string aName)             {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_WIDTH));} 
		
		/*!	
			     OBJPROP_BACK.
         \param  string aName -   . 			
		 	\return   bool. True -   , false -  .		
		*/    
      bool                    Back        (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_BACK));} 	
		
		/*!	
			   OBJPROP_FILL ( OBJ_RECTANGLE, OBJ_TRIANGLE, OBJ_ELLIPSE, OBJ_CHANNEL, OBJ_STDDEVCHANNEL, OBJ_REGRESSION)
         \param  string aName -   . 			
		 	\return   bool. True - , false - .	
		*/  
      bool                    Fill        (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_FILL));} 		
		
		/*!	
			  OBJPROP_SELECTED.
         \param  string aName -   . 			
		 	\return   bool. True - , false -  .	
		*/  
      bool                    Selected    (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_SELECTED));} 		
		
		/*!	
			     " " OBJPROP_SELECTED.
         \param  string aName -   . 			
		 	\return   bool. True -  , false - .	
		*/  
      bool                    ReadOnly    (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_READONLY));} 		
		
		/*!	
			  OBJPROP_TYPE.
         \param  string aName -   . 			
		 	\return   ENUM_OBJECT.	
		*/  
      ENUM_OBJECT             Type        (string aName)             {return( (ENUM_OBJECT)              ObjectGetInteger(0,aName,OBJPROP_TYPE));}
		
		/*!	
			      OBJPROP_TIME.
         \param  string aName -   ,
         \param   int aIndex -    ( ).
		 	\return    ( datetime).		
		*/  
      datetime                Time        (string aName,int aIndex)  {return( (datetime)                 ObjectGetInteger(0,aName,OBJPROP_TIME,aIndex));}	
		
		/*!	
			   OBJPROP_SELECTABLE.
         \param  string aName -   . 			
		 	\return   bool. True -  , false - .	
		*/   
      bool                    Selectable  (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_SELECTABLE));} 		
		
		/*!	
			   OBJPROP_CREATETIME.
         \param  string aName -   . 						
		 	\return    ( datetime).		
		*/  
      datetime                CreateTime  (string aName)             {return( (datetime)                 ObjectGetInteger(0,aName,OBJPROP_CREATETIME));}	
		
		/*!	
			  OBJPROP_LEVELS).
         \param  string aName -   . 						
		 	\return   ( int).		
		*/   
      int                     Levels      (string aName)             {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_LEVELS));}	
		
		/*!	
			  OBJPROP_LEVELCOLOR.
         \param   int aIndex -   ( ).
         \param  string aName -   . 			         
		 	\return    ( color).		
		*/ 
      color                   LevelColor  (string aName,int aIndex)  {return( (color)                    ObjectGetInteger(0,aName,OBJPROP_LEVELCOLOR,aIndex));}		
		
		/*!	
			  OBJPROP_LEVELSTYLE.
         \param   int aIndex -   ( ).
         \param  string aName -   . 			         
		 	\return    ( ENUM_LINE_STYLE).		
		*/  
      ENUM_LINE_STYLE         LevelStyle  (string aName,int aIndex)  {return( (ENUM_LINE_STYLE)          ObjectGetInteger(0,aName,OBJPROP_LEVELSTYLE,aIndex));}	
		
		/*!	
			  OBJPROP_LEVELWIDTH.
         \param   int aIndex -   ( ).
         \param  string aName -   . 			         
		 	\return    ( int).		
		*/  
      int                     LevelWidth  (string aName,int aIndex)  {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_LEVELWIDTH,aIndex));}		
		
		/*!	
			  OBJPROP_FONTSIZE.
         \param  string aName -   . 						
		 	\return    ( int).		
		*/  
      int                     FontSize    (string aName)             {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_FONTSIZE));}		   
		
		/*!	
			   OBJPROP_RAY_LEFT.
         \param  string aName -   . 						
		 	\return   bool. True -   , false -  .		
		*/    
      bool                    RayLeft     (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_RAY_LEFT));} 	
		
		/*!	
			   OBJPROP_RAY_RIGHT.
         \param  string aName -   . 						
		 	\return   bool. True -   , false -  .		
		*/  
      bool                    RayRight    (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_RAY_RIGHT));} 		
		
		/*!	
			       OBJPROP_RAY.
         \param  string aName -   . 						
		 	\return   bool. True -     , false -   .		
		*/  
      bool                    Ray         (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_RAY));} 		
		
		/*!	
			    " " OBJPROP_ELLIPSE.
         \param  string aName -   . 						
      	\return   bool. True -  , false - .		
		*/ 
      bool                    Ellipse     (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_ELLIPSE));} 			   
		
		/*!	
			    "" OBJPROP_ARROWCODE.
         \param  string aName -   . 						
      	\return    ( char).
		*/ 
      char                    ArrowCode   (string aName)             {return( (char)                     ObjectGetInteger(0,aName,OBJPROP_ARROWCODE));}
		
		/*!	
			    OBJPROP_TIMEFRAMES.
         \param  string aName -   . 						
      	\return     ( long).
		*/ 
      long                    TimeFrames  (string aName)             {return(                            ObjectGetInteger(0,aName,OBJPROP_TIMEFRAMES));}
		
		/*!	
			   OBJPROP_ANCHOR.
         \param  string aName -   . 						
      	\return     ( long).  OBJ_ARROW    ENUM_ARROW_ANCHOR,  OBJ_LABEL  OBJ_TEXT -    ENUM_ANCHORPOINT.
		*/   
      long                    Anchor      (string aName)             {return(                            ObjectGetInteger(0,aName,OBJPROP_ANCHOR));}
		
		/*!	
			     X    OBJPROP_XDISTANCE.
         \param  string aName -   . 						
      	\return   ( int).
		*/ 
      int                     XDistance   (string aName)             {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_XDISTANCE));}	
		
		/*!	
			     Y    OBJPROP_YDISTANCE.
         \param  string aName -   . 						
      	\return   ( int).
		*/  
      int                     YDistance   (string aName)             {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_YDISTANCE));}	
		
		/*!	
			   OBJPROP_DIRECTION.
         \param  string aName -   . 						
      	\return   ( ENUM_GANN_DIRECTION).
		*/   
      ENUM_GANN_DIRECTION     Direction   (string aName)             {return( (ENUM_GANN_DIRECTION)      ObjectGetInteger(0,aName,OBJPROP_DIRECTION));}
		
		/*!	
			    OBJPROP_DEGREE.
         \param  string aName -   . 						
      	\return   ( ENUM_ELLIOT_WAVE_DEGREE).
		*/   
      ENUM_ELLIOT_WAVE_DEGREE Degree      (string aName)             {return( (ENUM_ELLIOT_WAVE_DEGREE)  ObjectGetInteger(0,aName,OBJPROP_DEGREE));}
		
		/*!	
			      OBJPROP_DRAWLINES.
         \param  string aName -   . 						
      	\return   bool. True - , false - .		
		*/  
      bool                    DrawLines   (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_DRAWLINES));} 
		
		/*!	
			  (/) OBJPROP_STATE.
         \param  string aName -   . 						
      	\return   bool. True - , false - .
		*/ 
      bool                    State       (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_STATE));} 
		
		/*!	
			  "" OBJPROP_CHART_ID.
         \param  string aName -   . 						
      	\return    ( long).
		*/ 
      long                    ChartChartID(string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_CHART_ID));}
		
		/*!	
			   OBJPROP_XSIZE.
         \param  string aName -   . 						
      	\return    ( int).
		*/   
      int                     XSize       (string aName)             {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_XSIZE));}	
		
		/*!	
			   OBJPROP_YSIZE.
         \param  string aName -   . 						
      	\return    ( int).
		*/ 
      int                     YSize       (string aName)             {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_YSIZE));}		
		
		/*!	
			 X     OBJPROP_XOFFSET.
         \param  string aName -   . 						
      	\return   ( int).
		*/ 
      int                     XOffset     (string aName)             {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_XOFFSET));}	
		
		/*!	
			 Y     OBJPROP_YOFFSET.
         \param  string aName -   . 						
      	\return   ( int).
		*/ 
      int                     YOffset     (string aName)             {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_YOFFSET));}	
		
		/*!	
			  "" OBJPROP_PERIOD.
         \param  string aName -   . 						
      	\return   ( ENUM_TIMEFRAMES).
		*/  
      ENUM_TIMEFRAMES         Period      (string aName)             {return( (ENUM_TIMEFRAMES)          ObjectGetInteger(0,aName,OBJPROP_PERIOD));}
		
		/*!	
			      "" OBJPROP_DATE_SCALE.
         \param  string aName -   . 						
      	\return   bool. True -  , false -  .
		*/ 
      bool                    DateScale   (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_DATE_SCALE));} 
		
		/*!	
			      "" OBJPROP_PRICE_SCALE.
         \param  string aName -   . 						
      	\return   bool. True -  , false -  .
		*/  
      bool                    PriceScale  (string aName)             {return( (bool)                     ObjectGetInteger(0,aName,OBJPROP_PRICE_SCALE));} 
		
		/*!	
			   "" OBJPROP_CHART_SCALE.
         \param  string aName -   . 						
      	\return   1-5 ( int).
		*/  
      int                     ChartScale  (string aName)             {return( (int)                      ObjectGetInteger(0,aName,OBJPROP_CHART_SCALE));}		
		
		/*!	
			  OBJPROP_BGCOLOR.
         \param  string aName -   . 						
		 	\return    ( color).		
		*/  
      color                   BgColor     (string aName)             {return( (color)                    ObjectGetInteger(0,aName,OBJPROP_BGCOLOR));}
		
		/*!	
			      OBJPROP_CORNER.
         \param  string aName -   . 						
		 	\return   ( ENUM_BASE_CORNER).
		*/  
      ENUM_BASE_CORNER        Corner      (string aName)             {return( (ENUM_BASE_CORNER)         ObjectGetInteger(0,aName,OBJPROP_CORNER));}
		
		/*!	
			    " " OBJPROP_BORDER_TYPE.
         \param  string aName -   . 						
		 	\return   ( ENUM_BORDER_TYPE).
		*/   
      ENUM_BORDER_TYPE        BorderType  (string aName)             {return( (ENUM_BORDER_TYPE)         ObjectGetInteger(0,aName,OBJPROP_BORDER_TYPE));}
		
		/*!	
			  OBJPROP_PRICE.
         \param  string aName -   ,			
         \param   int aIndex -   ( ).
		 	\return   ( double).
		*/   
      double                  Price       (string aName,int aIndex)  {return(                            ObjectGetDouble(0,aName,OBJPROP_PRICE,aIndex));} 
		
		/*!	
			  OBJPROP_LEVELVALUE.
         \param  string aName -   ,			
         \param   int aIndex -   ( ).
		 	\return   ( double).
		*/     
      double                  LevelValue  (string aName,int aIndex)  {return(                            ObjectGetDouble(0,aName,OBJPROP_LEVELVALUE,aIndex));}  
		
		/*!	
			 (     " ") OBJPROP_SCALE.
         \param  string aName -   . 						
		 	\return   ( double).
		*/   
      double                  Scale       (string aName)             {return(                            ObjectGetDouble(0,aName,OBJPROP_SCALE));}
		
		/*!	
			 OBJPROP_ANGLE.
         \param  string aName -   . 						
		 	\return   ( double).
		*/ 
      double                  Angle       (string aName)             {return(                            ObjectGetDouble(0,aName,OBJPROP_ANGLE));}
		
		/*!	
			     OBJPROP_DEVIATION.
         \param  string aName -   . 						
		 	\return   ( double).
		*/  
      double                  Deviation   (string aName)             {return(                            ObjectGetDouble(0,aName,OBJPROP_DEVIATION));}
		
		/*!	
			    OBJPROP_TEXT.
         \param  string aName -   . 						
		 	\return  .
		*/  
      string                  Text        (string aName)             {return(                            ObjectGetString(0,aName,OBJPROP_TEXT));}
		
		/*!	
			  . OBJPROP_TOOLTIP.
         \param  string aName -   . 						
		 	\return  .
		 	\remark      "\n".
		*/  
      string                  ToolTip     (string aName)             {return(                            ObjectGetString(0,aName,OBJPROP_TOOLTIP));}
		
		/*!	
			 . OBJPROP_LEVELTEXT.
         \param  string aName -   ,		
         \param   int aIndex -   ( ).			
		 	\return  .
		*/   
      string                  LevelText   (string aName,int aIndex)  {return(                            ObjectGetString(0,aName,OBJPROP_LEVELTEXT,aIndex));} 
		
		/*!	
			 . OBJPROP_FONT.
         \param  string aName -   . 						
		 	\return   ( string).
		*/   
      string                  Font        (string aName)             {return(                            ObjectGetString(0,aName,OBJPROP_FONT));}
		
		/*!	
			     "" OBJPROP_BMPFILE,  0.
         \param  string aName -   . 						
		 	\return    ( string).
		*/   
      string                  BmpFileOn   (string aName)             {return(                            ObjectGetString(0,aName,OBJPROP_BMPFILE,0));}
		
		/*!	
			     "" OBJPROP_BMPFILE,  1.
         \param  string aName -   . 						
		 	\return    ( string).
		*/    
      string                  BmpFileOff  (string aName)             {return(                            ObjectGetString(0,aName,OBJPROP_BMPFILE,1));}       
		
		/*!	
			   "" OBJPROP_SYMBOL.
         \param  string aName -   . 						
		 	\return   ( string).
		*/  
      string                  Symbol      (string aName)             {return(                            ObjectGetString(0,aName,OBJPROP_SYMBOL));}  

      //+------------------------------------------------------------------+
      //|       .                            |
      //+------------------------------------------------------------------+          
      
		/*!	
			  OBJPROP_COLOR.
			\param  string aName -   ,
         \param		color aValue -  .			
		*/  
      void SetColor        (string aName,color aValue)                        {ObjectSetInteger(0,aName,OBJPROP_COLOR,           aValue);}

		/*!	
			  OBJPROP_STYLE.
			\param  string aName -   ,
         \param		ENUM_LINE_STYLE aValue -  .			
		*/
      void SetStyle        (string aName,ENUM_LINE_STYLE aValue)              {ObjectSetInteger(0,aName,OBJPROP_STYLE,           aValue);}

		/*!	
			  OBJPROP_WIDTH.
			\param  string aName -   ,
         \param		int aValue -  .			
		*/ 
      void SetWidth        (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_WIDTH,           aValue);} 

		/*!	
			   /  OBJPROP_BACK.
			\param  string aName -   ,
         \param		bool aValue - true/false (/ ).
		*/   
      void SetBack         (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_BACK,            aValue);} 	

		/*!	
			  OBJPROP_FILL.
			\param  string aName -   ,
         \param		bool aValue - true/false (/).
		*/ 
      void SetFill         (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_FILL,            aValue);} 		

		/*!	
			  OBJPROP_SELECTED.
			\param  string aName -   ,
         \param		bool aValue - true/false (/ ).
		*/ 
      void SetSelected     (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_SELECTED,        aValue);} 		

		/*!	
			      " " OBJPROP_READONLY.
			\param  string aName -   ,
         \param		bool aValue - true/false (/).
		*/  
      void SetReadOnly     (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_READONLY,        aValue);} 		

		/*!	
			      OBJPROP_TIME.
         \param		int aIndex -   ( ),
         \param  string aName -   ,
         \param		datetime aValue -  .
		*/    
      void SetTime         (string aName,int aIndex,datetime aValue)          {ObjectSetInteger(0,aName,OBJPROP_TIME,            aIndex,aValue);}	

		/*!	
			    OBJPROP_SELECTABLE.
			\param  string aName -   ,
         \param		bool aValue - true/false (/).
		*/ 
      void SetSelectable   (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_SELECTABLE,      aValue);} 		

		/*!	
			   OBJPROP_LEVELS.
			\param  string aName -   ,
         \param		int aValue -  .
		*/  
      void SetLevels       (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_LEVELS,          aValue);}	

		/*!	
			   OBJPROP_LEVELCOLOR.
			\param  string aName -   ,
         \param   int aIndex -   ( ),
         \param   color aValue -  .
		*/   
      void SetLevelColor   (string aName,int aIndex,color aValue)             {ObjectSetInteger(0,aName,OBJPROP_LEVELCOLOR,      aIndex,aValue);}		

		/*!	
			   OBJPROP_LEVELSTYLE.
			\param  string aName -   ,
         \param   int aIndex -   ( ),
         \param   ENUM_LINE_STYLE aValue -  .
		*/  
      void SetLevelStyle   (string aName,int aIndex,ENUM_LINE_STYLE aValue)   {ObjectSetInteger(0,aName,OBJPROP_LEVELSTYLE,      aIndex,aValue);}

		/*!	
			   OBJPROP_LEVELWIDTH.
			\param  string aName -   ,
         \param   int aIndex -   ( ),
         \param   int aValue -  .
		*/  
      void SetLevelWidth   (string aName,int aIndex,int aValue)               {ObjectSetInteger(0,aName,OBJPROP_LEVELWIDTH,      aIndex,aValue);}		

		/*!	
			   OBJPROP_FONTSIZE.
			\param  string aName -   ,
         \param   int aValue -  .
		*/  
      void SetFontSize     (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_FONTSIZE,        aValue);}		   

		/*!	
			   OBJPROP_RAY_LEFT.
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/    
      void SetRayLeft      (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_RAY_LEFT,        aValue);} 	

		/*!	
			   OBJPROP_RAY_RIGHT.
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/  
      void SetRayRight     (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_RAY_RIGHT,       aValue);} 		

		/*!	
			      OBJPROP_RAY.
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/   
      void SetRay          (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_RAY,             aValue);} 		

		/*!	
			   " "   OBJPROP_ELLIPSE.
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/ 
      void SetEllipse      (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_ELLIPSE,         aValue);} 			   

		/*!	
			   OBJPROP_ARROWCODE.
			\param  string aName -   ,
         \param   char aValue -  .
		*/ 
      void SetArrowCode    (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_ARROWCODE,       aValue);}

		/*!	
			     OBJPROP_TIMEFRAMES.
			\param  string aName -   ,
         \param   long aValue -   .
		*/   
      void SetTimeFrames   (string aName,long aValue)                         {ObjectSetInteger(0,aName,OBJPROP_TIMEFRAMES,      aValue);}

		/*!	
			   OBJPROP_ANCHOR.
			\param  string aName -   ,
         \param   long aValue -   (ENUM_ARROW_ANCHOR  ENUM_ANCHORPOINT).
		*/   
      void SetAnchor       (string aName,long aValue)                         {ObjectSetInteger(0,aName,OBJPROP_ANCHOR,          aValue);}

		/*!	
			    X    OBJPROP_XDISTANCE.
			\param  string aName -   ,
         \param   int aValue -  .
		*/   
      void SetXDistance    (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_XDISTANCE,       aValue);}	

		/*!	
			    Y    OBJPROP_YDISTANCE.
			\param  string aName -   ,
         \param   int aValue -  .
		*/ 
      void SetYDistance    (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_YDISTANCE,       aValue);}	

		/*!	
			    OBJPROP_DIRECTION.
			\param  string aName -   ,
         \param   ENUM_GANN_DIRECTION aValue -  .
		*/ 
      void SetDirection    (string aName,ENUM_GANN_DIRECTION aValue)          {ObjectSetInteger(0,aName,OBJPROP_DIRECTION,       aValue);}

		/*!	
			     OBJPROP_DEGREE.
			\param  string aName -   ,
         \param   ENUM_ELLIOT_WAVE_DEGREE aValue -  .
		*/ 
      void SetDegree       (string aName,ENUM_ELLIOT_WAVE_DEGREE aValue)      {ObjectSetInteger(0,aName,OBJPROP_DEGREE,          aValue);}

		/*!	
			      OBJPROP_DRAWLINES.
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/ 
      void SetDrawLines    (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_DRAWLINES,       aValue);} 

		/*!	
			  .
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/  
      void SetState        (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_STATE,           aValue);} 

		/*!	
			   OBJPROP_XSIZE.
			\param  string aName -   ,
         \param   int aValue -  .
		*/   
      void SetXSize        (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_XSIZE,           aValue);}	

		/*!	
			   OBJPROP_YSIZE.
			\param  string aName -   ,
         \param   int aValue -  .
		*/  
      void SetYSize        (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_YSIZE,           aValue);}		

		/*!	
			  X    OBJPROP_XOFFSET.
			\param  string aName -   ,
         \param   int aValue -  .
		*/ 
      void SetXOffset      (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_XOFFSET,         aValue);}	

		/*!	
			  Y    OBJPROP_YOFFSET.
			\param  string aName -   ,
         \param   int aValue -  .
		*/ 
      void SetYOffset      (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_YOFFSET,         aValue);}	

		/*!	
			   "" OBJPROP_PERIOD.
			\param  string aName -   ,
         \param   ENUM_TIMEFRAMES aValue -  .
		*/ 
      void SetPeriod       (string aName,ENUM_TIMEFRAMES aValue)              {ObjectSetInteger(0,aName,OBJPROP_PERIOD,          aValue);}

		/*!	
			/     "" OBJPROP_DATE_SCALE.
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/ 
      void SetDateScale    (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_DATE_SCALE,      aValue);} 

		/*!	
			/     "" OBJPROP_PRICE_SCALE.
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/ 
      void SetPriceScale   (string aName,bool aValue)                         {ObjectSetInteger(0,aName,OBJPROP_PRICE_SCALE,     aValue);} 

		/*!	
			    "" OBJPROP_CHART_SCALE.
			\param  string aName -   ,
         \param   int aValue -  1-5.
		*/  
      void SetChartScale   (string aName,int aValue)                          {ObjectSetInteger(0,aName,OBJPROP_CHART_SCALE,     aValue);}		

		/*!	
			   OBJPROP_BGCOLOR.
			\param  string aName -   ,
         \param   color aValue -  .
		*/    
      void SetBgColor      (string aName,color aValue)                        {ObjectSetInteger(0,aName,OBJPROP_BGCOLOR,         aValue);}

		/*!	
			     OBJPROP_CORNER.
			\param  string aName -   ,
         \param   ENUM_BASE_CORNER aValue -  .
		*/  
      void SetCorner       (string aName,ENUM_BASE_CORNER aValue)             {ObjectSetInteger(0,aName,OBJPROP_CORNER,          aValue);}

		/*!	
			     " " OBJPROP_BORDER_TYPE.
			\param  string aName -   ,
         \param   ENUM_BORDER_TYPE aValue -  .
		*/   
      void SetBorderType   (string aName,ENUM_BORDER_TYPE aValue)             {ObjectSetInteger(0,aName,OBJPROP_BORDER_TYPE,     aValue);}      

		/*!	
			   OBJPROP_PRICE.
			\param  string aName -   ,
         \param   int aIndex -   ( ),
		 	\param  double aValue - .
		*/  
      void SetPrice        (string aName,int aIndex,double aValue)            {ObjectSetDouble(0,aName,OBJPROP_PRICE,            aIndex,aValue);} 

		/*!	
			   OBJPROP_LEVELVALUE.
			\param  string aName -   ,
         \param   int aIndex -   ( ),
		 	\param  double aValue - .
		*/  
      void SetLevelValue   (string aName,int aIndex,double aValue)            {ObjectSetDouble(0,aName,OBJPROP_LEVELVALUE,       aIndex,aValue);}  

		/*!	
			  (     " ") OBJPROP_SCALE.
			\param  string aName -   ,
		 	\param  double aValue -  .
		*/ 
      void SetScale        (string aName,double aValue)                       {ObjectSetDouble(0,aName,OBJPROP_SCALE,            aValue);}     

		/*!	
			  OBJPROP_ANGLE.
			\param  string aName -   ,
		 	\param  double aValue -   OBJPROP_ANGLE.
		*/    
      void SetAngle        (string aName,double aValue)                       {ObjectSetDouble(0,aName,OBJPROP_ANGLE,            aValue);}

		/*!	
			     OBJPROP_DEVIATION.
			\param  string aName -   ,
		 	\param  double aValue -   (  ).
		*/   
      void SetDeviation    (string aName,double aValue)                       {ObjectSetDouble(0,aName,OBJPROP_DEVIATION,        aValue);}

		/*!	
			  OBJPROP_TEXT.
			\param  string aName -   ,
		 	\param  string aValue - .
		*/  
      void SetText         (string aName,string aValue)                       {ObjectSetString(0,aName,OBJPROP_TEXT,             aValue);}

		/*!	
			   OBJPROP_TOOLTIP.
			\param  string aName -   ,
		 	\param  string aValue - .
		 	\remark      "\n".		 	
		*/
      void SetToolTip      (string aName,string aValue)                       {ObjectSetString(0,aName,OBJPROP_TOOLTIP,          aValue);}

		/*!	
			   OBJPROP_LEVELTEXT.
			\param  string aName -   ,
         \param   int aIndex -   ( ),
		 	\param  string aValue - . 	
		*/  
      void SetLevelText    (string aName,int aIndex,string aValue)            {ObjectSetString(0,aName,OBJPROP_LEVELTEXT,        aIndex,aValue);} 

		/*!	
			   OBJPROP_FONT.
			\param  string aName -   ,
		 	\param  string aValue -  . 	
		*/ 
      void SetFont         (string aName,string aValue)                       {ObjectSetString(0,aName,OBJPROP_FONT,             aValue);} 

		/*!	
			     "" OBJPROP_BMPFILE,  0.
			\param  string aName -   ,
		 	\param  string aValue -  . 	
		*/  
      void SetBmpFileOn    (string aName,string aValue)                       {ObjectSetString(0,aName,OBJPROP_BMPFILE,          0,aValue);}       

		/*!	
			     "" OBJPROP_BMPFILE,  1.
			\param  string aName -   ,
		 	\param  string aValue -  . 	
		*/  
      void SetBmpFileOff   (string aName,string aValue)                       {ObjectSetString(0,aName,OBJPROP_BMPFILE,          1,aValue);}       

		/*!	
			    "" OBJPROP_SYMBOL.
			\param  string aName -   ,
		 	\param  string aValue - . 	
		*/  
      void SetSymbol       (string aName,string aValue)                       {ObjectSetString(0,aName,OBJPROP_SYMBOL,           aValue);}  
   
      //+------------------------------------------------------------------+
      //|              |
      //+------------------------------------------------------------------+         
      
		/*!	
			 OBJPROP_COLOR.
			\param  long aChartID -  ,
			\param  string aName -   . 
		 	\return    ( color).		
		*/  
      color                   Color       (long aChartID,string aName)             {return( (color)                    ObjectGetInteger(aChartID,aName,OBJPROP_COLOR));}
		
		/*!	
			 OBJPROP_STYLE.
			\param  long aChartID -  ,
         \param  string aName -   . 			
		 	\return    ( ENUM_LINE_STYLE).		
		*/        
      ENUM_LINE_STYLE         Style       (long aChartID,string aName)             {return( (ENUM_LINE_STYLE)          ObjectGetInteger(aChartID,aName,OBJPROP_STYLE));}
		
		/*!	
			 OBJPROP_WIDTH.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return    ( int).		
		*/        
      int                     Width       (long aChartID,string aName)             {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_WIDTH));} 
		
		/*!	
			     OBJPROP_BACK.
			\param  long aChartID -  ,
         \param  string aName -   . 			
		 	\return   bool. True -   , false -  .		
		*/          
      bool                    Back        (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_BACK));} 	
		
		/*!	
			   OBJPROP_FILL ( OBJ_RECTANGLE, OBJ_TRIANGLE, OBJ_ELLIPSE, OBJ_CHANNEL, OBJ_STDDEVCHANNEL, OBJ_REGRESSION)
			\param  long aChartID -  ,
         \param  string aName -   . 			
		 	\return   bool. True - , false - .	
		*/  
      bool                    Fill        (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_FILL));} 		
		
		/*!	
			  OBJPROP_SELECTED.
			\param  long aChartID -  ,
         \param  string aName -   . 			
		 	\return   bool. True - , false -  .	
		*/  
      bool                    Selected    (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_SELECTED));} 		
		
		/*!	
			     " " OBJPROP_SELECTED.
			\param  long aChartID -  ,
         \param  string aName -   . 			
		 	\return   bool. True -  , false - .	
		*/  
      bool                    ReadOnly    (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_READONLY));} 		
		
		/*!	
			  OBJPROP_TYPE.
			\param  long aChartID -  ,
         \param  string aName -   . 			
		 	\return   ENUM_OBJECT.	
		*/  
      ENUM_OBJECT             Type        (long aChartID,string aName)             {return( (ENUM_OBJECT)              ObjectGetInteger(aChartID,aName,OBJPROP_TYPE));}
		
		/*!	
			      OBJPROP_TIME.
			\param   long aChartID -  ,
         \param   string aName -   ,
         \param   int aIndex -    ( ).
		 	\return    ( datetime).		
		*/  
      datetime                Time        (long aChartID,string aName,int aIndex)  {return( (datetime)                 ObjectGetInteger(aChartID,aName,OBJPROP_TIME,aIndex));}	
		
		/*!	
			   OBJPROP_SELECTABLE.
			\param  long aChartID -  ,
         \param  string aName -   . 			
		 	\return   bool. True -  , false - .	
		*/   
      bool                    Selectable  (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_SELECTABLE));} 		
		
		/*!	
			   OBJPROP_CREATETIME.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return    ( datetime).		
		*/  
      datetime                CreateTime  (long aChartID,string aName)             {return( (datetime)                 ObjectGetInteger(aChartID,aName,OBJPROP_CREATETIME));}	
		
		/*!	
			  OBJPROP_LEVELS).
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   ( int).		
		*/  
      int                     Levels      (long aChartID,string aName)             {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_LEVELS));}	
		
		/*!	
			  OBJPROP_LEVELCOLOR.
			\param  long aChartID -  ,
         \param   int aIndex -   ( ).
         \param  string aName -   . 			         
		 	\return    ( color).		
		*/ 
      color                   LevelColor  (long aChartID,string aName,int aIndex)  {return( (color)                    ObjectGetInteger(aChartID,aName,OBJPROP_LEVELCOLOR,aIndex));}		
		
		/*!	
			  OBJPROP_LEVELSTYLE.
			\param  long aChartID -  ,
         \param   int aIndex -   ( ).
         \param  string aName -   . 			         
		 	\return    ( ENUM_LINE_STYLE).		
		*/  
      ENUM_LINE_STYLE         LevelStyle  (long aChartID,string aName,int aIndex)  {return( (ENUM_LINE_STYLE)          ObjectGetInteger(aChartID,aName,OBJPROP_LEVELSTYLE,aIndex));}	
		
		/*!	
			  OBJPROP_LEVELWIDTH.
			\param  long aChartID -  ,
         \param   int aIndex -   ( ).
         \param  string aName -   . 			         
		 	\return    ( int).		
		*/  
      int                     LevelWidth  (long aChartID,string aName,int aIndex)  {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_LEVELWIDTH,aIndex));}		
		
		/*!	
			  OBJPROP_FONTSIZE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return    ( int).		
		*/  
      int                     FontSize    (long aChartID,string aName)             {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_FONTSIZE));}		   
		
		/*!	
			   OBJPROP_RAY_LEFT.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   bool. True -   , false -  .		
		*/  
      bool                    RayLeft     (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_RAY_LEFT));} 	
		
		/*!	
			   OBJPROP_RAY_RIGHT.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   bool. True -   , false -  .		
		*/ 
      bool                    RayRight    (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_RAY_RIGHT));} 		
		
		/*!	
			       OBJPROP_RAY.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   bool. True -     , false -   .		
		*/  
      bool                    Ray         (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_RAY));} 		
		
		/*!	
			    " " OBJPROP_ELLIPSE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   bool. True -  , false - .		
		*/ 
      bool                    Ellipse     (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_ELLIPSE));} 			   
		
		/*!	
			    "" OBJPROP_ARROWCODE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return    ( char).
		*/ 
      char                    ArrowCode   (long aChartID,string aName)             {return( (char)                     ObjectGetInteger(aChartID,aName,OBJPROP_ARROWCODE));}
		
		/*!	
			    OBJPROP_TIMEFRAMES.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return     ( long).
		*/ 
      long                    TimeFrames  (long aChartID,string aName)             {return(                            ObjectGetInteger(aChartID,aName,OBJPROP_TIMEFRAMES));}
		
		/*!	
			   OBJPROP_ANCHOR.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return     ( long).  OBJ_ARROW    ENUM_ARROW_ANCHOR,  OBJ_LABEL  OBJ_TEXT -    ENUM_ANCHORPOINT.
		*/ 
      long                    Anchor      (long aChartID,string aName)             {return(                            ObjectGetInteger(aChartID,aName,OBJPROP_ANCHOR));}
		
		/*!	
			     X    OBJPROP_XDISTANCE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   ( int).
		*/ 
      int                     XDistance   (long aChartID,string aName)             {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_XDISTANCE));}	
		
		/*!	
			     Y    OBJPROP_YDISTANCE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   ( int).
		*/  
      int                     YDistance   (long aChartID,string aName)             {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_YDISTANCE));}	
		
		/*!	
			   OBJPROP_DIRECTION.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   ( ENUM_GANN_DIRECTION).
		*/   
      ENUM_GANN_DIRECTION     Direction   (long aChartID,string aName)             {return( (ENUM_GANN_DIRECTION)      ObjectGetInteger(aChartID,aName,OBJPROP_DIRECTION));}
		
		/*!	
			    OBJPROP_DEGREE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   ( ENUM_ELLIOT_WAVE_DEGREE).
		*/ 
      ENUM_ELLIOT_WAVE_DEGREE Degree      (long aChartID,string aName)             {return( (ENUM_ELLIOT_WAVE_DEGREE)  ObjectGetInteger(aChartID,aName,OBJPROP_DEGREE));}
		
		/*!	
			      OBJPROP_DRAWLINES.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   bool. True - , false - .		
		*/  
      bool                    DrawLines   (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_DRAWLINES));} 
		
		/*!	
			  (/) OBJPROP_STATE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   bool. True - , false - .
		*/ 
      bool                    State       (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_STATE));} 
		
		/*!	
			  "" OBJPROP_CHART_ID.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return    ( long).
		*/ 
      long                    ChartChartID(long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_CHART_ID));}
		
		/*!	
			   OBJPROP_XSIZE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return    ( int).
		*/   
      int                     XSize       (long aChartID,string aName)             {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_XSIZE));}	
		
		/*!	
			   OBJPROP_YSIZE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return    ( int).
		*/ 
      int                     YSize       (long aChartID,string aName)             {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_YSIZE));}		
		
		/*!	
			 X     OBJPROP_XOFFSET.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   ( int).
		*/ 
      int                     XOffset     (long aChartID,string aName)             {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_XOFFSET));}	
		
		/*!	
			 Y     OBJPROP_YOFFSET.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   ( int).
		*/ 
      int                     YOffset     (long aChartID,string aName)             {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_YOFFSET));}	
		
		/*!	
			  "" OBJPROP_PERIOD.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   ( ENUM_TIMEFRAMES).
		*/ 
      ENUM_TIMEFRAMES         Period      (long aChartID,string aName)             {return( (ENUM_TIMEFRAMES)          ObjectGetInteger(aChartID,aName,OBJPROP_PERIOD));}
		
		/*!	
			      "" OBJPROP_DATE_SCALE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   bool. True -  , false -  .
		*/ 
      bool                    DateScale   (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_DATE_SCALE));} 
		
		/*!	
			      "" OBJPROP_PRICE_SCALE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   bool. True -  , false -  .
		*/  
      bool                    PriceScale  (long aChartID,string aName)             {return( (bool)                     ObjectGetInteger(aChartID,aName,OBJPROP_PRICE_SCALE));} 
		
		/*!	
			   "" OBJPROP_CHART_SCALE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
      	\return   1-5 ( int).
		*/  
      int                     ChartScale  (long aChartID,string aName)             {return( (int)                      ObjectGetInteger(aChartID,aName,OBJPROP_CHART_SCALE));}		
		
		/*!	
			  OBJPROP_BGCOLOR.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return    ( color).		
		*/  
      color                   BgColor     (long aChartID,string aName)             {return( (color)                    ObjectGetInteger(aChartID,aName,OBJPROP_BGCOLOR));}
		
		/*!	
			      OBJPROP_CORNER.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   ( ENUM_BASE_CORNER).
		*/  
      ENUM_BASE_CORNER        Corner      (long aChartID,string aName)             {return( (ENUM_BASE_CORNER)         ObjectGetInteger(aChartID,aName,OBJPROP_CORNER));}
		
		/*!	
			    " " OBJPROP_BORDER_TYPE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   ( ENUM_BORDER_TYPE).
		*/   
      ENUM_BORDER_TYPE        BorderType  (long aChartID,string aName)             {return( (ENUM_BORDER_TYPE)         ObjectGetInteger(aChartID,aName,OBJPROP_BORDER_TYPE));}
		
		/*!	
			  OBJPROP_PRICE.
			\param  long aChartID -  ,
         \param  string aName -   ,			
         \param   int aIndex -   ( ).
		 	\return   ( double).
		*/ 
      double                  Price       (long aChartID,string aName,int aIndex)  {return(                            ObjectGetDouble(aChartID,aName,OBJPROP_PRICE,aIndex));} 
		
		/*!	
			  OBJPROP_LEVELVALUE.
			\param  long aChartID -  ,
         \param  string aName -   ,			
         \param   int aIndex -   ( ).
		 	\return   ( double).
		*/ 
      double                  LevelValue  (long aChartID,string aName,int aIndex)  {return(                            ObjectGetDouble(aChartID,aName,OBJPROP_LEVELVALUE,aIndex));}  
		
		/*!	
			 (     " ") OBJPROP_SCALE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   ( double).
		*/ 
      double                  Scale       (long aChartID,string aName)             {return(                            ObjectGetDouble(aChartID,aName,OBJPROP_SCALE));}
		
		/*!	
			 OBJPROP_ANGLE.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   ( double).
		*/ 
      double                  Angle       (long aChartID,string aName)             {return(                            ObjectGetDouble(aChartID,aName,OBJPROP_ANGLE));}
		
		/*!	
			     OBJPROP_DEVIATION.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   ( double).
		*/ 
      double                  Deviation   (long aChartID,string aName)             {return(                            ObjectGetDouble(aChartID,aName,OBJPROP_DEVIATION));}
		
		/*!	
			    OBJPROP_TEXT.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return  .
		*/  
      string                  Text        (long aChartID,string aName)             {return(                            ObjectGetString(aChartID,aName,OBJPROP_TEXT));}
		
		/*!	
			  . OBJPROP_TOOLTIP.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return  .
		 	\remark      "\n".
		*/  
      string                  ToolTip     (long aChartID,string aName)             {return(                            ObjectGetString(aChartID,aName,OBJPROP_TOOLTIP));}
		
		/*!	
			 . OBJPROP_LEVELTEXT.
			\param  long aChartID -  ,
         \param  string aName -   ,		
         \param   int aIndex -   ( ).			
		 	\return  .
		*/ 
      string                  LevelText   (long aChartID,string aName,int aIndex)  {return(                            ObjectGetString(aChartID,aName,OBJPROP_LEVELTEXT,aIndex));} 
		
		/*!	
			 . OBJPROP_FONT.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   ( string).
		*/   
      string                  Font        (long aChartID,string aName)             {return(                            ObjectGetString(aChartID,aName,OBJPROP_FONT));}
		
		/*!	
			     "" OBJPROP_BMPFILE,  0.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return    ( string).
		*/  
      string                  BmpFileOn   (long aChartID,string aName)             {return(                            ObjectGetString(aChartID,aName,OBJPROP_BMPFILE,0));}
		
		/*!	
			     "" OBJPROP_BMPFILE,  1.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return    ( string).
		*/  
      string                  BmpFileOff  (long aChartID,string aName)             {return(                            ObjectGetString(aChartID,aName,OBJPROP_BMPFILE,1));}       
		
		/*!	
			   "" OBJPROP_SYMBOL.
			\param  long aChartID -  ,
         \param  string aName -   . 						
		 	\return   ( string).
		*/  
      string                  Symbol      (long aChartID,string aName)             {return(                            ObjectGetString(aChartID,aName,OBJPROP_SYMBOL));}  
      
      //+------------------------------------------------------------------+
      //|              |
      //+------------------------------------------------------------------+     

		/*!	
			  OBJPROP_COLOR.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param		color aValue -  .			
		*/  
      void SetColor        (long aChartID,string aName,color aValue)                        {ObjectSetInteger(aChartID,aName,OBJPROP_COLOR,           aValue);}
		/*!	
			  OBJPROP_STYLE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param		ENUM_LINE_STYLE aValue -  .			
		*/
      void SetStyle        (long aChartID,string aName,ENUM_LINE_STYLE aValue)              {ObjectSetInteger(aChartID,aName,OBJPROP_STYLE,           aValue);}
		
		/*!	
			  OBJPROP_WIDTH.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param		int aValue -  .			
		*/ 
      void SetWidth        (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_WIDTH,           aValue);} 
		
		/*!	
			   /  OBJPROP_BACK.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param		bool aValue - true/false (/ ).
		*/ 
      void SetBack         (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_BACK,            aValue);} 	
		
		/*!	
			  OBJPROP_FILL.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param		bool aValue - true/false (/).
		*/ 
      void SetFill         (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_FILL,            aValue);} 		
		
		/*!	
			  OBJPROP_SELECTED.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param		bool aValue - true/false (/ ).
		*/ 
      void SetSelected     (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_SELECTED,        aValue);} 		
		
		/*!	
			      " " OBJPROP_READONLY.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param		bool aValue - true/false (/).
		*/  
      void SetReadOnly     (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_READONLY,        aValue);} 		
		
		/*!	
			      OBJPROP_TIME.
			\param   long aChartID -  ,
         \param   int aIndex -   ( ),
         \param   string aName -   ,
         \param   datetime aValue -  .
		*/    
      void SetTime         (long aChartID,string aName,int aIndex,datetime aValue)          {ObjectSetInteger(aChartID,aName,OBJPROP_TIME,            aIndex,aValue);}	
		
		/*!	
			    OBJPROP_SELECTABLE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param		bool aValue - true/false (/).
		*/ 
      void SetSelectable   (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_SELECTABLE,      aValue);} 		
		
		/*!	
			   OBJPROP_LEVELS.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param		int aValue -  .
		*/  
      void SetLevels       (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_LEVELS,          aValue);}	
		
		/*!	
			   OBJPROP_LEVELCOLOR.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aIndex -   ( ),
         \param   color aValue -  .
		*/ 
      void SetLevelColor   (long aChartID,string aName,int aIndex,color aValue)             {ObjectSetInteger(aChartID,aName,OBJPROP_LEVELCOLOR,      aIndex,aValue);}		
		
		/*!	
			   OBJPROP_LEVELSTYLE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aIndex -   ( ),
         \param   ENUM_LINE_STYLE aValue -  .
		*/  
      void SetLevelStyle   (long aChartID,string aName,int aIndex,ENUM_LINE_STYLE aValue)   {ObjectSetInteger(aChartID,aName,OBJPROP_LEVELSTYLE,      aIndex,aValue);}
		
		/*!	
			   OBJPROP_LEVELWIDTH.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aIndex -   ( ),
         \param   int aValue -  .
		*/  
      void SetLevelWidth   (long aChartID,string aName,int aIndex,int aValue)               {ObjectSetInteger(aChartID,aName,OBJPROP_LEVELWIDTH,      aIndex,aValue);}		
		
		/*!	
			   OBJPROP_FONTSIZE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aValue -  .
		*/  
      void SetFontSize     (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_FONTSIZE,        aValue);}		   
		
		/*!	
			   OBJPROP_RAY_LEFT.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/   
      void SetRayLeft      (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_RAY_LEFT,        aValue);} 	
		
		/*!	
			   OBJPROP_RAY_RIGHT.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/  
      void SetRayRight     (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_RAY_RIGHT,       aValue);} 		
		
		/*!	
			      OBJPROP_RAY.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/ 
      void SetRay          (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_RAY,             aValue);} 		
		
		/*!	
			   " "   OBJPROP_ELLIPSE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/ 
      void SetEllipse      (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_ELLIPSE,         aValue);} 			   
		
		/*!	
			   OBJPROP_ARROWCODE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   char aValue -  .
		*/ 
      void SetArrowCode    (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_ARROWCODE,       aValue);}
		
		/*!	
			     OBJPROP_TIMEFRAMES.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   long aValue -   .
		*/   
      void SetTimeFrames   (long aChartID,string aName,long aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_TIMEFRAMES,      aValue);}
		
		/*!	
			   OBJPROP_ANCHOR.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   long aValue -   (ENUM_ARROW_ANCHOR  ENUM_ANCHORPOINT).
		*/   
      void SetAnchor       (long aChartID,string aName,long aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_ANCHOR,          aValue);}
		
		/*!	
			    X    OBJPROP_XDISTANCE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aValue -  .
		*/   
      void SetXDistance    (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_XDISTANCE,       aValue);}	
		
		/*!	
			    Y    OBJPROP_YDISTANCE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aValue -  .
		*/ 
      void SetYDistance    (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_YDISTANCE,       aValue);}	
		
		/*!	
			    OBJPROP_DIRECTION.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   ENUM_GANN_DIRECTION aValue -  .
		*/ 
      void SetDirection    (long aChartID,string aName,ENUM_GANN_DIRECTION aValue)          {ObjectSetInteger(aChartID,aName,OBJPROP_DIRECTION,       aValue);}
		
		/*!	
			     OBJPROP_DEGREE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   ENUM_ELLIOT_WAVE_DEGREE aValue -  .
		*/ 
      void SetDegree       (long aChartID,string aName,ENUM_ELLIOT_WAVE_DEGREE aValue)      {ObjectSetInteger(aChartID,aName,OBJPROP_DEGREE,          aValue);}
		
		/*!	
			      OBJPROP_DRAWLINES.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/ 
      void SetDrawLines    (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_DRAWLINES,       aValue);} 
		
		/*!	
			  .
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/ 
      void SetState        (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_STATE,           aValue);} 
		
		/*!	
			   OBJPROP_XSIZE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aValue -  .
		*/ 
      void SetXSize        (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_XSIZE,           aValue);}	
		
		/*!	
			   OBJPROP_YSIZE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aValue -  .
		*/  
      void SetYSize        (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_YSIZE,           aValue);}		
		
		/*!	
			  X    OBJPROP_XOFFSET.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aValue -  .
		*/ 
      void SetXOffset      (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_XOFFSET,         aValue);}	
		
		/*!	
			  Y    OBJPROP_YOFFSET.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aValue -  .
		*/ 
      void SetYOffset      (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_YOFFSET,         aValue);}	
		
		/*!	
			   "" OBJPROP_PERIOD.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   ENUM_TIMEFRAMES aValue -  .
		*/ 
      void SetPeriod       (long aChartID,string aName,ENUM_TIMEFRAMES aValue)              {ObjectSetInteger(aChartID,aName,OBJPROP_PERIOD,          aValue);}
		
		/*!	
			/     "" OBJPROP_DATE_SCALE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/ 
      void SetDateScale    (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_DATE_SCALE,      aValue);} 

		/*!	
			/     "" OBJPROP_PRICE_SCALE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   bool aValue - true/false (/).
		*/ 
      void SetPriceScale   (long aChartID,string aName,bool aValue)                         {ObjectSetInteger(aChartID,aName,OBJPROP_PRICE_SCALE,     aValue);} 

		/*!	
			    "" OBJPROP_CHART_SCALE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aValue -  1-5.
		*/  
      void SetChartScale   (long aChartID,string aName,int aValue)                          {ObjectSetInteger(aChartID,aName,OBJPROP_CHART_SCALE,     aValue);}		

		/*!	
			   OBJPROP_BGCOLOR.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   color aValue -  .
		*/    
      void SetBgColor      (long aChartID,string aName,color aValue)                        {ObjectSetInteger(aChartID,aName,OBJPROP_BGCOLOR,         aValue);}

		/*!	
			     OBJPROP_CORNER.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   ENUM_BASE_CORNER aValue -  .
		*/  
      void SetCorner       (long aChartID,string aName,ENUM_BASE_CORNER aValue)             {ObjectSetInteger(aChartID,aName,OBJPROP_CORNER,          aValue);}

		/*!	
			     " " OBJPROP_BORDER_TYPE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   ENUM_BORDER_TYPE aValue -  .
		*/  
      void SetBorderType   (long aChartID,string aName,ENUM_BORDER_TYPE aValue)             {ObjectSetInteger(aChartID,aName,OBJPROP_BORDER_TYPE,     aValue);}      

		/*!	
			   OBJPROP_PRICE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aIndex -   ( ),
		 	\param  double aValue - .
		*/  
      void SetPrice        (long aChartID,string aName,int aIndex,double aValue)            {ObjectSetDouble(aChartID,aName,OBJPROP_PRICE,            aIndex,aValue);} 

		/*!	
			   OBJPROP_LEVELVALUE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aIndex -   ( ),
		 	\param  double aValue - .
		*/  
      void SetLevelValue   (long aChartID,string aName,int aIndex,double aValue)            {ObjectSetDouble(aChartID,aName,OBJPROP_LEVELVALUE,       aIndex,aValue);}  

		/*!	
			  (     " ") OBJPROP_SCALE.
			\param  long aChartID -  ,
			\param  string aName -   ,
		 	\param  double aValue -  .
		*/ 
      void SetScale        (long aChartID,string aName,double aValue)                       {ObjectSetDouble(aChartID,aName,OBJPROP_SCALE,            aValue);}     

		/*!	
			  OBJPROP_ANGLE.
			\param  long aChartID -  ,
			\param  string aName -   ,
		 	\param  double aValue -   OBJPROP_ANGLE.
		*/   
      void SetAngle        (long aChartID,string aName,double aValue)                       {ObjectSetDouble(aChartID,aName,OBJPROP_ANGLE,            aValue);}

		/*!	
			     OBJPROP_DEVIATION.
			\param  long aChartID -  ,
			\param  string aName -   ,
		 	\param  double aValue -   (  ).
		*/ 
      void SetDeviation    (long aChartID,string aName,double aValue)                       {ObjectSetDouble(aChartID,aName,OBJPROP_DEVIATION,        aValue);}

		/*!	
			  OBJPROP_TEXT.
			\param  long aChartID -  ,
			\param  string aName -   ,
		 	\param  string aValue - .
		*/ 
      void SetText         (long aChartID,string aName,string aValue)                       {ObjectSetString(aChartID,aName,OBJPROP_TEXT,             aValue);}

		/*!	
			   OBJPROP_TOOLTIP.
			\param  long aChartID -  ,
			\param  string aName -   ,
		 	\param  string aValue - .
		 	\remark      "\n".		 	
		*/
      void SetToolTip      (long aChartID,string aName,string aValue)                       {ObjectSetString(aChartID,aName,OBJPROP_TOOLTIP,          aValue);}

		/*!	
			   OBJPROP_LEVELTEXT.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aIndex -   ( ),
		 	\param  string aValue - . 	
		*/  
      void SetLevelText    (long aChartID,string aName,int aIndex,string aValue)            {ObjectSetString(aChartID,aName,OBJPROP_LEVELTEXT,        aIndex,aValue);} 

		/*!	
			   OBJPROP_FONT.
			\param  long aChartID -  ,
			\param  string aName -   ,
		 	\param  string aValue -  . 	
		*/ 
      void SetFont         (long aChartID,string aName,string aValue)                       {ObjectSetString(aChartID,aName,OBJPROP_FONT,             aValue);} 

		/*!	
			     "" OBJPROP_BMPFILE,  0.
			\param  long aChartID -  ,
			\param  string aName -   ,
		 	\param  string aValue -  . 	
		*/  
      void SetBmpFileOn    (long aChartID,string aName,string aValue)                       {ObjectSetString(aChartID,aName,OBJPROP_BMPFILE,          0,aValue);}       

		/*!	
			     "" OBJPROP_BMPFILE,  1.
			\param  long aChartID -  ,
			\param  string aName -   ,
		 	\param  string aValue -  . 	
		*/  
      void SetBmpFileOff   (long aChartID,string aName,string aValue)                       {ObjectSetString(aChartID,aName,OBJPROP_BMPFILE,          1,aValue);}       

		/*!	
			    "" OBJPROP_SYMBOL.
			\param  long aChartID -  ,
			\param  string aName -   ,
		 	\param  string aValue - . 	
		*/  
      void SetSymbol       (long aChartID,string aName,string aValue)                       {ObjectSetString(aChartID,aName,OBJPROP_SYMBOL,           aValue);}  

      //+------------------------------------------------------------------+
      //|                                                      |
      //+------------------------------------------------------------------+         

      // ===  ===

		/*!	
			  .
		*/ 
      void Delete(){ObjectDelete(m_id,m_name);} 
		
		/*!	
			   .
			\param  string aName -   .
		*/       
      void Delete(string aName){ObjectDelete(0,aName);} 
		
		/*!	
			      .
			\param  long aChartID -  ,
			\param  string aName -   .
		*/       
      void Delete(long aChartID,string aName){ObjectDelete(aChartID,aName);} 

      // ===  ===

		/*!	
			  .
			\param   int aIndex -   ( ),
			\param   datetime aTime  -  ,
			\param   double aPrice -   .
		*/ 
      void Move(int aIndex,datetime aTime,double aPrice){
         ObjectMove(m_id,m_name,aIndex,aTime,aPrice);   
      }
      
		/*!	
			   .
			\param  string aName -   ,
			\param   int aIndex -   ( ),
			\param   datetime aTime  -  ,
			\param   double aPrice -   .			
		*/         
      void Move(string aName,int aIndex,datetime aTime,double aPrice){
         ObjectMove(0,aName,aIndex,aTime,aPrice);   
      }    
      
		/*!	
			     .
			\param  long aChartID -  ,
			\param  string aName -   ,
			\param   int aIndex -   ( ),
			\param   datetime aTime  -  ,
			\param   double aPrice -   .			
		*/           
      void Move(long aChartID,string aName,int aIndex,datetime aTime,double aPrice){
         ObjectMove(aChartID,aName,aIndex,aTime,aPrice);   
      }
      
      // ===  ===
           
		/*!	
			  .
			\return   , -1     ( int). 
		*/ 
      int Find(){
         return(ObjectFind(m_id,m_name));
      }  
      
		/*!	
			   .
			\param  string aName -   .
			\return   , -1     ( int). 
		*/              
      int Find(string aName){
         return(ObjectFind(0,aName));
      }    
      
		/*!	
			      .
			\param  long aChartID -  ,
			\param  string aName -   .
			\return   , -1     ( int). 
		*/         
      int Find(long aChartID,string aName){
         return(ObjectFind(aChartID,aName));
      }   
      
      // ===     ===
      
		/*!	
			      .
			\param  double aValue - ,
			\param  int aLineID -   ( ).
			\return   ( datetime). 
		*/ 
      datetime GetTimeByValue(double aValue,int aLineID=0){
         return(ObjectGetTimeByValue(m_id,m_name,aValue,aLineID));
      }         
      
		/*!	
			       .
			\param  string aName -   ,
			\param  double aValue - ,
			\param  int aLineID -   ( ).
			\return   ( datetime). 
		*/       
      datetime GetTimeByValue(string aName,double aValue,int aLineID=0){
         return(ObjectGetTimeByValue(0,aName,aValue,aLineID));
      }    

		/*!	
			          .
			\param  long aChartID -  ,
			\param  string aName -   ,			
			\param  double aValue - ,
			\param  int aLineID -   ( ).
			\return   ( datetime). 
		*/ 	      
      datetime GetTimeByValue(long aChartID,string aName,double aValue,int aLineID=0){
         return(ObjectGetTimeByValue(aChartID,aName,aValue,aLineID));
      }   

      // ===     ===
      
		/*!	
			      .
			\param  datetime aTime - ,
			\param  int aLineID -   ( ).
			\return  ( double). 
		*/ 
      double GetValueByTime(datetime aTime,int aLineID=0){
         return(ObjectGetValueByTime(m_id,m_name,aTime,aLineID));
      }   
      
		/*!	
			      .
			\param  string aName -   ,	
			\param  datetime aTime - ,
			\param  int aLineID -   ( ).
			\return  ( double). 
		*/             
      double GetValueByTime(string aName,datetime aTime,int aLineID=0){
         return(ObjectGetValueByTime(0,aName,aTime,aLineID));
      }
          
		/*!	
			          .
			\param  long aChartID -  ,
			\param  string aName -   ,	
			\param  datetime aTime - ,
			\param  int aLineID -   ( ).
			\return  ( double). 
		*/         
      double GetValueByTime(long aChartID,string aName,datetime aTime,int aLineID=0){
         return(ObjectGetValueByTime(aChartID,aName,aTime,aLineID));
      } 
      

      // === === === === ===
   
      /*!
            .   
         \param   aChartID=0 -  ,
         \param   int aSubWindow=-1 -  ,
         \param   int aType=-1 -  .
      */      
      int Total(int aChartID=0,int aSubWindow=-1,int aType=-1){
         return(ObjectsTotal(aChartID,aSubWindow,aType));
      }   
      
      /*!
              .   
      */ 
      void Redraw(){
         ChartRedraw(m_id);
      }  
      /*!
           .  
         \param long aChartID -  . 
      */              
      void Redraw(long aChartID){
         ChartRedraw(aChartID);
      }         
          
      // === v2 ===
        
		/*!	
			     X (OBJPROP_XDISTANCE)    Y (OBJPROP_YDISTANCE)   .
         \param   int aValueX -   X,
         \param   int aValueY -   Y.
		*/   
      void SetXYDistance(int aValueX,int aValueY){
         ObjectSetInteger(m_id,m_name,OBJPROP_XDISTANCE,aValueX);
         ObjectSetInteger(m_id,m_name,OBJPROP_YDISTANCE,aValueY);
      }

		/*!	
			     X (OBJPROP_XDISTANCE)    Y (OBJPROP_YDISTANCE)   .
			\param  string aName -   ,
         \param   int aValueX -   X,
         \param   int aValueY -   Y.
		*/  
      void SetXYDistance(string aName,int aValueX,int aValueY){
         ObjectSetInteger(0,aName,OBJPROP_XDISTANCE,aValueX);
         ObjectSetInteger(0,aName,OBJPROP_YDISTANCE,aValueY);
      }         	

		/*!	
			     X (OBJPROP_XDISTANCE)    Y (OBJPROP_YDISTANCE)   .
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aValueX -   X,
         \param   int aValueY -   Y.
		*/  
      void SetXYDistance(long aChartID,string aName,int aValueX,int aValueY){
         ObjectSetInteger(aChartID,aName,OBJPROP_XDISTANCE,aValueX);
         ObjectSetInteger(aChartID,aName,OBJPROP_YDISTANCE,aValueY);         
      }

       
		/*!	
			   OBJPROP_XSIZE  OBJPROP_YSIZE.
         \param   int aValueX -   X,
         \param   int aValueY -   Y.         
		*/       
      void SetXYSize(int aValueX,int aValueY){
         ObjectSetInteger(m_id,m_name,OBJPROP_XSIZE,aValueX);
         ObjectSetInteger(m_id,m_name,OBJPROP_YSIZE,aValueY);         
      }	
      
		/*!	
			   OBJPROP_XSIZE  OBJPROP_YSIZE.
			\param  string aName -   ,
         \param   int aValueX -   X,
         \param   int aValueY -   Y.         
		*/       
      void SetXYSize(string aName,int aValueX,int aValueY){
         ObjectSetInteger(0,aName,OBJPROP_XSIZE,aValueX);
         ObjectSetInteger(0,aName,OBJPROP_YSIZE,aValueY);         
      }	      
      
		/*!	
			   OBJPROP_XSIZE  OBJPROP_YSIZE.
			\param  long aChartID -  ,
			\param  string aName -   ,
         \param   int aValueX -   X,
         \param   int aValueY -   Y.         
		*/       
      void SetXYSize(long aChartID,string aName,int aValueX,int aValueY){
         ObjectSetInteger(aChartID,aName,OBJPROP_XSIZE,aValueX);
         ObjectSetInteger(aChartID,aName,OBJPROP_YSIZE,aValueY);         
      }	 
};

CGraphicObjectShell g;

//+------------------------------------------------------------------+
//|                                                                  |
//|          CWorkPiece                                         |
//|                                                                  |
//+------------------------------------------------------------------+

/*!
	\brief           .
	
	\details          
	            .     
	               .

   \remark	       "w".
*/  

class CWorkPiece{
   public:
		/*!	
			 .
            \param		string aName="Canvas" - ,
            \param		int aSubWindow=0 - ,
            \param		int aLeft=100 -     ,
            \param		int aTop=100 -     ,
            \param		int aWidth=300 - ,
            \param		int aHeight=150 - ,
            \param		color aColorBg=clrIvory -  ,
            \param		int aColorBorder=clrDimGray -  .
            \remark	     -   .
		*/
      void Canvas(string aName="Canvas",int aSubWindow=0,int aLeft=100,int aTop=100,int aWidth=300,int aHeight=150,color aColorBg=clrIvory,int aColorBorder=clrDimGray){
         g.CreateRectangleLabel(aName,aSubWindow); //   
         g.SetXDistance(aLeft); //   X
         g.SetYDistance(aTop); //   Y
         g.SetXSize(aWidth); //  
         g.SetYSize(aHeight); //  
         g.SetBgColor(aColorBg); //   
         g.SetColor(aColorBorder); //   
         g.SetCorner(CORNER_LEFT_UPPER); //   
         g.SetBorderType(BORDER_FLAT); //   
         g.SetTimeFrames(OBJ_ALL_PERIODS); //     
         g.SetSelected(false); //  
         g.SetSelectable(false); //    
         g.SetWidth(1); //   
         g.SetStyle(STYLE_SOLID); //   
      }

		/*!	
			.
            \param		string aName="Label" - ,
            \param		int aSubWindow=0 - ,
            \param		int aLeft=100 -     ,
            \param      int aTop=100 -     ,
            \param      string aText="Label" - ,
            \param      int aColor=clrDimGray - ,
            \param      int aFontSize=8 -  ,
            \param      string aFont="Arial" - .
            \remark	     -   .
		*/
      void Label(string aName="Label",int aSubWindow=0,int aLeft=100,int aTop=100,string aText="Label",int aColor=clrDimGray,int aFontSize=8,string aFont="Arial"){
         g.CreateLabel(aName,aSubWindow);
         g.SetXDistance(aLeft);
         g.SetYDistance(aTop);
         g.SetText(aText);
         g.SetColor(aColor);
         g.SetFontSize(aFontSize);
         g.SetFont(aFont);
         g.SetCorner(CORNER_LEFT_UPPER);
         g.SetAnchor(ANCHOR_LEFT_UPPER);         
         g.SetSelected(false);
         g.SetSelectable(false);
      }  
      
		/*!	
			.
            \param		string aName="Button" - ,
            \param		int aSubWindow=0 - ,
            \param		int aLeft=100 -     ,
            \param		int aTop=100 -     ,
            \param		int aWidth=40 - ,
            \param		int aHeight=15 - ,
            \param		string aText="Button" -  ,
            \param		color aColorBg=clrSilver -  ,
            \param		color aColorText=clrBlack -  ,
            \param		int aFontSize=7 -   ,
            \param		string aFont="Arial" -  .
            \remark	     -   .
 		*/
      void Button(string aName="Button",int aSubWindow=0,int aLeft=100,int aTop=100,int aWidth=40,int aHeight=15,string aText="Button",color aColorBg=clrSilver,color aColorText=clrBlack,int aFontSize=7,string aFont="Arial"){
         g.CreateButton(aName,aSubWindow);
         g.SetXDistance(aLeft);
         g.SetYDistance(aTop);
         g.SetXSize(aWidth);
         g.SetYSize(aHeight);
         g.SetText(aText);
         g.SetColor(aColorText);
         g.SetBgColor(aColorBg);
         g.SetFontSize(aFontSize);
         g.SetFont(aFont);
         g.SetCorner(CORNER_LEFT_UPPER);
         g.SetSelected(false);
         g.SetSelectable(false);
      } 
      
		/*!	
			 .
            \param		string aName="Edit" - ,
            \param		int aSubWindow=0 - ,
            \param		int aLeft=100 -     ,
            \param		int aTop=100 -     ,
            \param		int aWidth=40 - ,
            \param		int aHeight=15 - ,
            \param		string aText="Edit" - ,
            \param		color aColorBg=clrSnow -  ,
            \param		color aColorText=clrDimGray -    ,
            \param		int aFontSize=7 -  ,
            \param		string aFont="Arial" - .			
            \remark	     -   .
 		*/
      void Edit(string aName="Edit",int aSubWindow=0,int aLeft=100,int aTop=100,int aWidth=40,int aHeight=15,string aText="Edit",color aColorBg=clrSnow,color aColorText=clrDimGray,int aFontSize=7,string aFont="Arial"){
         g.CreateEdit(aName,aSubWindow);
         g.SetXDistance(aLeft);
         g.SetYDistance(aTop);
         g.SetXSize(aWidth);
         g.SetYSize(aHeight);
         g.SetText(aText);
         g.SetColor(aColorText);
         g.SetBgColor(aColorBg);
         g.SetFontSize(aFontSize);
         g.SetFont(aFont);
         g.SetCorner(CORNER_LEFT_UPPER);
         g.SetSelected(false);
         g.SetSelectable(false);
         g.SetReadOnly(false);
      } 
      
		/*!	
			  .
            \param		string aName="Frame" - ,
            \param		int aSubWindow=0 - ,
            \param		int aLeft=100 -     ,
            \param		int aTop=100 -     ,
            \param		int aWidth=50 - ,
            \param		int aHeight=50 - ,
            \param		string aCaption="Frame" -  ,
            \param		int aCaptionWidth=31 -    ,
            \param		color aColorBg=clrIvory -  ,
            \param		color aColorBorder=clrDimGray -  ,
            \param		color aColorCaption=clrDimGray -  .
            \remark	     -   .
            \remark	       :  OBJ_RECTANGLE_LABEL (2 .)  
                        OBJ_LABEL.    ,    
                         .     ,   aCaption 
                          "",        . 
                               aName.   
                             aName    "_Frame", 
                          - "_FrameL",       - "_FrameC". 
 		*/
      void Frame(string aName="Frame",int aSubWindow=0,int aLeft=100,int aTop=100,int aWidth=50,int aHeight=50,string aCaption="Frame",int aCaptionWidth=31,color aColorBg=clrIvory,color aColorBorder=clrDimGray,color aColorCaption=clrDimGray){
         Canvas(aName+"_Frame",aSubWindow,aLeft,aTop,aWidth,aHeight,aColorBg,aColorBorder);
            if(aCaption!=""){
               Canvas(aName+"_FrameC",aSubWindow,aLeft+4,aTop,aCaptionWidth,1,aColorBg,aColorBg);
               Label(aName+"_FrameL",aSubWindow,aLeft+6,aTop-5,aCaption,aColorCaption,7,"Arial");
            }               
      }
      
		/*!	
			   .
         \param   string aName="Frame" - .
 		*/
      void FrameDelete(string aName="Frame"){
         ObjectDelete(0,aName+"_Frame");
         ObjectDelete(0,aName+"_FrameC");
         ObjectDelete(0,aName+"_FrameL");         
      }  
           
		/*!	
			      "" .
         \param   string aName="Frame" - .
 		*/
      void Delete(string aName){
         ObjectDelete(0,aName);
      }   
         
		/*!	
			 "" .
 		*/
      void Redraw(){
         ChartRedraw(0);
      }         
};

CWorkPiece w;

//+------------------------------------------------------------------+
//|                                                                  |
//|          CColorSchemes                                      |
//|                                                                  |
//+------------------------------------------------------------------+

/*!
	\brief      .
	
	\details         
	          .

   \remark	       "ClrScheme".
*/   

class CColorSchemes{
   private:
      int m_ShemeIndex;
   public:
   		/*!	
   			  .
               \param		int aShemeIndex -   .
   		*/   
         void SetScheme(int aShemeIndex){ //    
            m_ShemeIndex=aShemeIndex;
         }
   		/*!	
   			    .
               \param		int aColorIndex -    .
               \return		 .
   		*/          
         color Color(int aColorIndex){ 
            color m_Color[7][45];  //   -   ,  -    
            // === default ===
               // CInputBox
               m_Color[0][0]=clrSnow;           //    
               m_Color[0][1]=clrDimGray;        //      
               m_Color[0][2]=clrDimGray;        //  
               m_Color[0][3]=clrPink;           //            
               // CSpinInputBox (,   CInputBox)
               m_Color[0][4]=clrSilver;         //  
               m_Color[0][5]=clrLightGray;      //  
               // CVScrollBar, CHScrollBar ( )
               m_Color[0][6]=clrDimGray;        //  
               m_Color[0][7]=clrLightGray;      //  
               m_Color[0][8]=clrSilver;         //  
               m_Color[0][9]=clrPink;           //  
               m_Color[0][10]=clrDimGray;       //   ()
               m_Color[0][11]=clrSnow;          //   
               m_Color[0][12]=clrLightGray;     //   
               m_Color[0][13]=clrGainsboro;     //   
               // CCheckBox, CRadioGroup    CInputBox (  ,     CCheckBox, CRadioGroup)
               // CList -      CInputBox,   
               m_Color[0][14]=clrPaleTurquoise; //   
               // CHMenu, CVMenu
               m_Color[0][15]=clrWhiteSmoke;    //     
               m_Color[0][16]=clrGainsboro;     //     
               m_Color[0][17]=clrRed;           //  
               // CHProgress
               m_Color[0][18]=clrLightGray;     //     
               m_Color[0][19]=clrDimGray;       //  
               m_Color[0][20]=clrLightSkyBlue;  //  
               m_Color[0][21]=clrDimGray;       //  
               // CDialer
               m_Color[0][22]=clrLightGray;     //  
               m_Color[0][23]=clrDimGray;       //  
               m_Color[0][24]=clrWhiteSmoke;    //    
               m_Color[0][25]=clrDimGray;       //  
               m_Color[0][26]=clrMistyRose;     //   
               m_Color[0][27]=clrPaleGreen;     //   
               m_Color[0][28]=clrPaleTurquoise; //   
               m_Color[0][29]=clrSnow;          //    
               m_Color[0][30]=clrDimGray;       //    
               m_Color[0][31]=clrPink;          //   
               // CForm
               m_Color[0][32]=clrWhiteSmoke;    //      
               m_Color[0][33]=clrDimGray;       //  
               m_Color[0][34]=clrSilver;        //  
               m_Color[0][35]=clrBlack;         //    
               m_Color[0][36]=C'27,63,169';     //   
               m_Color[0][37]=clrGray;          //   
               m_Color[0][38]=clrYellow;        //      
               // CFrame
               m_Color[0][39]=clrWhiteSmoke;    // 
               m_Color[0][40]=clrDimGray;       // 
               m_Color[0][41]=clrDimGray;       // 
               // CButtom
               m_Color[0][42]=clrSilver;        //  
               m_Color[0][43]=C'70,70,70';      //          
               // CLabel
               m_Color[0][44]=clrDimGray;        //                 
               
                        
            // === - ===
            
               m_Color[1][0]=clrLightYellow;    //    
               m_Color[1][1]=clrBrown;          //      
               m_Color[1][2]=clrBrown;          //  
               m_Color[1][3]=clrLightPink;      //            
               // CSpinInputBox (,   CInputBox)
               m_Color[1][4]=clrBurlyWood;      //  
               m_Color[1][5]=clrNavajoWhite;    //  
               // CVScrollBar, CHScrollBar ( )
               m_Color[1][6]=clrBrown;          //  
               m_Color[1][7]=clrNavajoWhite;    //  
               m_Color[1][8]=clrBurlyWood;      //  
               m_Color[1][9]=clrPink;           //  
               m_Color[1][10]=clrBrown;         //   ()
               m_Color[1][11]=clrLightYellow;   //   
               m_Color[1][12]=clrLightYellow;   //   
               m_Color[1][13]=clrLightYellow;   //   
               // CCheckBox, CRadioGroup    CInputBox (  ,     CCheckBox, CRadioGroup)
               // CList -      CInputBox,   
               m_Color[1][14]=clrBisque; //   
               // CHMenu, CVMenu
               m_Color[1][15]=clrLightYellow;   //     
               m_Color[1][16]=clrNavajoWhite;   //     
               m_Color[1][17]=clrRed;           //  
               // CHProgress
               m_Color[1][18]=clrNavajoWhite;   //     
               m_Color[1][19]=clrBrown;         //  
               m_Color[1][20]=clrOrange;        //  
               m_Color[1][21]=clrBrown;         //  
               // CDialer
               m_Color[1][22]=clrBurlyWood;     //  
               m_Color[1][23]=clrBrown;         //  
               m_Color[1][24]=clrBisque;        //    
               m_Color[1][25]=clrBrown;         //  
               m_Color[1][26]=clrLightPink;     //   
               m_Color[1][27]=clrLightGreen;    //   
               m_Color[1][28]=clrPaleTurquoise; //   
               m_Color[1][29]=clrLightYellow;   //    
               m_Color[1][30]=clrBrown;         //    
               m_Color[1][31]=clrPink;          //    
               // CForm
               m_Color[1][32]=C'255,245,205';   //      
               m_Color[1][33]=clrSienna;        //  
               m_Color[1][34]=C'240,214,151';   //  
               m_Color[1][35]=C'116,60,33';     //    
               m_Color[1][36]=C'116,60,33';     //   
               m_Color[1][37]=C'116,60,33';     //   
               m_Color[1][38]=C'250,241,220';   //      
               // CFrame
               m_Color[1][39]=C'255,245,205';   // 
               m_Color[1][40]=clrBrown;         // 
               m_Color[1][41]=clrBrown;         // 
               // CButtom
               m_Color[1][42]=clrBurlyWood;        //  
               m_Color[1][43]=clrMaroon;         //                       
               // CLabel
               m_Color[1][44]=clrBrown;        //  
               
               // ===  ===
               
               m_Color[2][0]=clrAliceBlue;      //    
               m_Color[2][1]=clrNavy;           //      
               m_Color[2][2]=clrNavy;           //  
               m_Color[2][3]=clrLightPink;      //            
               // CSpinInputBox (,   CInputBox)
               m_Color[2][4]=clrLightSteelBlue; //  
               m_Color[2][5]=clrAliceBlue;      //  
               // CVScrollBar, CHScrollBar ( )
               m_Color[2][6]=clrNavy;           //  
               m_Color[2][7]=clrLightBlue;      //  
               m_Color[2][8]=clrLightSteelBlue; //  
               m_Color[2][9]=clrLightPink;      //  
               m_Color[2][10]=clrNavy;          //   ()
               m_Color[2][11]=clrAliceBlue;     //   
               m_Color[2][12]=clrAliceBlue;     //   
               m_Color[2][13]=clrAliceBlue;     //   
               // CCheckBox, CRadioGroup    CInputBox (  ,     CCheckBox, CRadioGroup)
               // CList -      CInputBox,   
               m_Color[2][14]=clrPaleTurquoise; //   
               // CHMenu, CVMenu
               m_Color[2][15]=clrAliceBlue;     //     
               m_Color[2][16]=clrLightBlue;     //     
               m_Color[2][17]=clrRed;           //  
               // CHProgress
               m_Color[2][18]=clrLightBlue;     //     
               m_Color[2][19]=clrNavy;          //  
               m_Color[2][20]=clrDodgerBlue;    //  
               m_Color[2][21]=clrNavy;          //  
               // CDialer
               m_Color[2][22]=clrLightSteelBlue;//  
               m_Color[2][23]=clrNavy;          //  
               m_Color[2][24]=clrLightBlue;     //    
               m_Color[2][25]=clrNavy;          //  
               m_Color[2][26]=clrLightPink;     //   
               m_Color[2][27]=clrLightGreen;    //   
               m_Color[2][28]=clrPaleTurquoise; //   
               m_Color[2][29]=clrAliceBlue;     //    
               m_Color[2][30]=clrNavy;          //    
               m_Color[2][31]=clrPink;          //                   
               // CForm
               m_Color[2][32]=C'221,239,244';   //      
               m_Color[2][33]=clrSteelBlue;     //  
               m_Color[2][34]=C'134,202,238';   //  
               m_Color[2][35]=clrNavy;          //    
               m_Color[2][36]=clrNavy;          //   
               m_Color[2][37]=clrNavy;          //   
               m_Color[2][38]=C'191,227,247';   //      
               // CFrame
               m_Color[2][39]=C'221,239,244';   // 
               m_Color[2][40]=clrNavy;          // 
               m_Color[2][41]=clrNavy;          // 
               // CButtom
               m_Color[2][42]=clrLightSteelBlue;        //  
               m_Color[2][43]=clrNavy;         //        
               // CLabel
               m_Color[2][44]=clrNavy;        //                   
               
               // ===  ===

               m_Color[3][0]=clrHoneydew;       //    
               m_Color[3][1]=clrDarkSlateGray;  //      
               m_Color[3][2]=clrDarkSlateGray;  //  
               m_Color[3][3]=clrLightPink;      //            
               // CSpinInputBox (,   CInputBox)
               m_Color[3][4]=clrDarkSeaGreen;   //  
               m_Color[3][5]=clrHoneydew;       //  
               // CVScrollBar, CHScrollBar ( )
               m_Color[3][6]=clrDarkSlateGray;  //  
               m_Color[3][7]=C'162,199,158';    //  
               m_Color[3][8]=clrDarkSeaGreen;   //  
               m_Color[3][9]=clrLightPink;      //  
               m_Color[3][10]=clrDarkSlateGray; //   ()
               m_Color[3][11]=C'206,225,204';   //   
               m_Color[3][12]=C'188,216,186';   //   
               m_Color[3][13]=C'188,216,186';   //   
               // CCheckBox, CRadioGroup    CInputBox (  ,     CCheckBox, CRadioGroup)
               // CList -      CInputBox,   
               m_Color[3][14]=clrPaleTurquoise; //   
               // CHMenu, CVMenu
               m_Color[3][15]=clrHoneydew;      //     
               m_Color[3][16]=C'201,222,199';   //     
               m_Color[3][17]=clrRed;           //  
               // CHProgress
               m_Color[3][18]=C'201,222,199';   //     
               m_Color[3][19]=clrDarkSlateGray; //  
               m_Color[3][20]=clrYellowGreen;   //  
               m_Color[3][21]=clrDarkSlateGray; //  
               // CDialer
               m_Color[3][22]=C'166,201,163';   //  
               m_Color[3][23]=clrDarkSlateGray; //  
               m_Color[3][24]=C'201,222,199';   //    
               m_Color[3][25]=clrDarkSlateGray; //  
               m_Color[3][26]=clrLightPink;     //   
               m_Color[3][27]=clrLightGreen;    //   
               m_Color[3][28]=clrPaleTurquoise; //   
               m_Color[3][29]=clrHoneydew;      //    
               m_Color[3][30]=clrDarkSlateGray; //    
               m_Color[3][31]=clrPink;          //                       
               // CForm
               m_Color[3][32]=C'225,250,225';   //      
               m_Color[3][33]=C'70,117,117';    //  
               m_Color[3][34]=C'140,215,155';   //  
               m_Color[3][35]=clrDarkGreen;     //    
               m_Color[3][36]=clrDarkGreen;     //   
               m_Color[3][37]=clrDarkGreen;     //   
               m_Color[3][38]=C'180,255,180';   //      
               // CFrame
               m_Color[3][39]=C'225,250,225';   // 
               m_Color[3][40]=clrDarkSlateGray; // 
               m_Color[3][41]=clrDarkSlateGray; // 
               // CButtom
               m_Color[3][42]=C'172,209,168';   //  
               m_Color[3][43]=C'36,62,62';      //        
               // CLabel
               m_Color[3][44]=clrDarkSlateGray; //    
                              
               // === - ===

               m_Color[4][0]=clrBlack;          //    
               m_Color[4][1]=clrYellow;         //      
               m_Color[4][2]=clrYellow;         //  
               m_Color[4][3]=clrRed;            //            
               // CSpinInputBox (,   CInputBox)
               m_Color[4][4]=clrBlack;          //  
               m_Color[4][5]=clrSilver;         //  
               // CVScrollBar, CHScrollBar ( )
               m_Color[4][6]=clrYellow;         //  
               m_Color[4][7]=clrDimGray;        //  
               m_Color[4][8]=clrBlack;          //  
               m_Color[4][9]=clrRed;            //  
               m_Color[4][10]=clrYellow;        //   ()
               m_Color[4][11]=clrDarkKhaki;     //   
               m_Color[4][12]=clrGray;          //   
               m_Color[4][13]=clrGray;          //   
               // CCheckBox, CRadioGroup    CInputBox (  ,     CCheckBox, CRadioGroup)
               // CList -      CInputBox,   
               m_Color[4][14]=clrNavy;          //   
               // CHMenu, CVMenu
               m_Color[4][15]=clrDimGray;       //     
               m_Color[4][16]=clrBlack;         //     
               m_Color[4][17]=clrYellow;        //  
               // CHProgress
               m_Color[4][18]=clrDimGray;       //     
               m_Color[4][19]=clrYellow;        //  
               m_Color[4][20]=clrChocolate;     //  
               m_Color[4][21]=clrYellow;        //  
               // CDialer
               m_Color[4][22]=clrDimGray;       //  
               m_Color[4][23]=clrYellow;        //  
               m_Color[4][24]=clrBlack;         //    
               m_Color[4][25]=clrYellow;        //  
               m_Color[4][26]=clrBrown;         //   
               m_Color[4][27]=clrGreen;         //   
               m_Color[4][28]=clrNavy;          //   
               m_Color[4][29]=clrBlack;         //    
               m_Color[4][30]=clrYellow;        //    
               m_Color[4][31]=clrRed;           //                       
               // CForm
               m_Color[4][32]=C'45,45,0';       //      
               m_Color[4][33]=clrYellow;        //  
               m_Color[4][34]=clrKhaki;         //  
               m_Color[4][35]=C'45,45,0';       //    
               m_Color[4][36]=C'90,90,0';       //   
               m_Color[4][37]=C'90,90,0';       //   
               m_Color[4][38]=clrYellow;        //                      
               // CFrame
               m_Color[4][39]=C'45,45,0';       // 
               m_Color[4][40]=clrYellow;        // 
               m_Color[4][41]=clrYellow;        // 
               // CButtom
               m_Color[4][42]=C'120,120,80';        //  
               m_Color[4][43]=clrYellow;         //        
               // CLabel
               m_Color[4][44]=clrYellow;        //                   
               // === - ===

               m_Color[5][0]=clrBlack;          //    
               m_Color[5][1]=clrLime;           //      
               m_Color[5][2]=clrLime;           //  
               m_Color[5][3]=clrRed;            //            
               // CSpinInputBox (,   CInputBox)
               m_Color[5][4]=clrBlack;          //  
               m_Color[5][5]=clrSilver;         //  
               // CVScrollBar, CHScrollBar ( )
               m_Color[5][6]=clrLime;           //  
               m_Color[5][7]=clrDimGray;        //  
               m_Color[5][8]=clrBlack;          //  
               m_Color[5][9]=clrRed;            //  
               m_Color[5][10]=clrLime;          //   ()
               m_Color[5][11]=clrGreen;         //   
               m_Color[5][12]=clrGray;          //   
               m_Color[5][13]=clrGray;          //   
               // CCheckBox, CRadioGroup    CInputBox (  ,     CCheckBox, CRadioGroup)
               // CList -      CInputBox,   
               m_Color[5][14]=clrNavy;          //   
               // CHMenu, CVMenu
               m_Color[5][15]=clrDimGray;       //     
               m_Color[5][16]=clrBlack;         //     
               m_Color[5][17]=clrLime;          //  
               // CHProgress
               m_Color[5][18]=clrDimGray;       //     
               m_Color[5][19]=clrLime;          //  
               m_Color[5][20]=clrForestGreen;   //  
               m_Color[5][21]=clrLime;          //  
               // CDialer
               m_Color[5][22]=clrDimGray;       //  
               m_Color[5][23]=clrLime;          //  
               m_Color[5][24]=clrBlack;         //    
               m_Color[5][25]=clrLime;          //  
               m_Color[5][26]=clrBrown;         //   
               m_Color[5][27]=clrGreen;         //   
               m_Color[5][28]=clrNavy;          //   
               m_Color[5][29]=clrBlack;         //    
               m_Color[5][30]=clrLime;          //    
               m_Color[5][31]=clrRed;           //                       
               // CForm
               m_Color[5][32]=C'0,45,0';           //      
               m_Color[5][33]=clrLime;             //  
               m_Color[5][34]=clrPaleGreen;        //  
               m_Color[5][35]=C'0,45,0';           //    
               m_Color[5][36]=clrDarkSlateGray;    //   
               m_Color[5][37]=clrDarkSlateGray;    //   
               m_Color[5][38]=clrLime;             //      
               // CFrame
               m_Color[5][39]=C'0,45,0';           // 
               m_Color[5][40]=clrLime;             // 
               m_Color[5][41]=clrLime;             // 
               // CButtom
               m_Color[5][42]=C'80,120,80';        //  
               m_Color[5][43]=clrLime;         //        
               // CLabel
               m_Color[5][44]=clrLime;          //    
               // === - ===

               m_Color[6][0]=clrBlack;          //    
               m_Color[6][1]=clrAqua;           //      
               m_Color[6][2]=clrAqua;           //  
               m_Color[6][3]=clrRed;            //            
               // CSpinInputBox (,   CInputBox)
               m_Color[6][4]=clrBlack;          //  
               m_Color[6][5]=clrSilver;         //  
               // CVScrollBar, CHScrollBar ( )
               m_Color[6][6]=clrAqua;           //  
               m_Color[6][7]=clrDimGray;        //  
               m_Color[6][8]=clrBlack;          //  
               m_Color[6][9]=clrRed;            //  
               m_Color[6][10]=clrAqua;          //   ()
               m_Color[6][11]=clrLightSeaGreen; //   
               m_Color[6][12]=clrGray;          //   
               m_Color[6][13]=clrGray;          //   
               // CCheckBox, CRadioGroup    CInputBox (  ,     CCheckBox, CRadioGroup)
               // CList -      CInputBox,   
               m_Color[6][14]=clrNavy;          //   
               // CHMenu, CVMenu
               m_Color[6][15]=clrDimGray;       //     
               m_Color[6][16]=clrBlack;         //     
               m_Color[6][17]=clrAqua;          //  
               // CHProgress
               m_Color[6][18]=clrDimGray;       //     
               m_Color[6][19]=clrAqua;          //  
               m_Color[6][20]=clrLightSeaGreen; //  
               m_Color[6][21]=clrAqua;          //  
               // CDialer
               m_Color[6][22]=clrDimGray;       //  
               m_Color[6][23]=clrAqua;          //  
               m_Color[6][24]=clrBlack;         //    
               m_Color[6][25]=clrAqua;          //  
               m_Color[6][26]=clrBrown;         //   
               m_Color[6][27]=clrGreen;         //   
               m_Color[6][28]=clrNavy;          //   
               m_Color[6][29]=clrBlack;         //    
               m_Color[6][30]=clrAqua;          //    
               m_Color[6][31]=clrRed;           //                     
               // CForm
               m_Color[6][32]=C'0,45,45';             //      
               m_Color[6][33]=clrAqua;                //  
               m_Color[6][34]=clrMediumTurquoise;     //  
               m_Color[6][35]=C'0,45,45';             //    
               m_Color[6][36]=clrSlateGray;           //   
               m_Color[6][37]=clrSlateGray;           //   
               m_Color[6][38]=clrAqua;                //      
               // CFrame
               m_Color[6][39]=C'0,45,45';             // 
               m_Color[6][40]=clrAqua;                // 
               m_Color[6][41]=clrAqua;                // 
               // CButtom
               m_Color[6][42]=C'80,120,120';        //  
               m_Color[6][43]=clrAqua;         //        
               // CLabel
               m_Color[6][44]=clrAqua;        //    
            return(m_Color[m_ShemeIndex][aColorIndex]); //          
         }
   		/*!	
   			    .
             \remark	        ,   . 
                          ,   .
   		*/           
         void Show(){ //      
            int m_sc=7; //  
            int m_cc=45; //    
            color m_bcolor=Color(1);
            int m_RemScheme=m_ShemeIndex;
               for(int s=0;s<m_sc;s++){
                  w.Label("ColorSchemes_"+IntegerToString(s),0,10,20+s*20,IntegerToString(s),m_bcolor);
               }
               for(int s=0;s<m_sc;s++){
                  m_ShemeIndex=s;
                     for(int c=0;c<m_cc;c++){
                        w.Canvas("ColorSchemes_"+IntegerToString(s)+"_"+IntegerToString(c),0,10+c*20+15,20+s*20,19,19,Color(c),m_bcolor);
                     }
               }
            ChartRedraw(0);
            m_ShemeIndex=m_RemScheme;
         }
   		/*!	
   			     Show().
   		*/           
         void Hide(){ //      Show()
            int m_sc=7;
            int m_cc=45;         
               for(int s=0;s<m_sc;s++){
                  ObjectDelete(0,"ColorSchemes_"+IntegerToString(s));
                     for(int c=0;c<m_cc;c++){
                        ObjectDelete(0,"ColorSchemes_"+IntegerToString(s)+"_"+IntegerToString(c));
                     }
               }
            ChartRedraw(0);
         }
};

CColorSchemes ClrScheme;

//+------------------------------------------------------------------+
//|                                                                  |
//|                                         |
//|                                                                  |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|          CInputBox                                          |
//+------------------------------------------------------------------+

/*!
	\brief      " ".
	
	\details   :   ,   . 
	                  , 
	                 .
	                    
	            .    . 
   \remark	       " " (OBJ_EDIT) "" (OBJ_LABEL).
                   aName  "_E",   - "_L".
            
*/   

class CInputBox{
   private:
      string m_NameEdit;   //    Edit
      string m_NameLabel;  //    Label
      int m_Left;          //  
      int m_Top;           //  Y
      int m_Width;         // 
      int m_Height;        // 
      bool m_Visible;      //    
      int m_Digits;        //       double  -1     
      string m_Caption;    // 
      string m_Value;      // 
      double m_ValueMin;   //  
      double m_ValueMax;   //  
      color m_BgColor;     //   
      color m_TxtColor;    //  
      color m_LblColor;    //  
      color m_WarningColor;//   
      bool m_Warning;      //  
      int m_SubWindow;     // 
      string m_Tag;        // 
      bool m_ReadOnly;     //    
         void Create(){    //    
            color m_ctmp=m_BgColor; //   
               if(m_Warning){ //   
                  m_ctmp=m_WarningColor; //      
               }
            w.Edit(m_NameEdit,m_SubWindow,m_Left,m_Top,m_Width,m_Height,m_Value,m_ctmp,m_TxtColor,7,"Arial"); //   
            g.SetReadOnly(m_NameEdit,m_ReadOnly);
               if(m_Caption!=""){ //  
                  w.Label(m_NameLabel,m_SubWindow,m_Left+m_Width+1,m_Top+2,m_Caption,m_LblColor,7,"Arial"); //  
               } 
         }   
         void Delete(){ //    
            ObjectDelete(0,m_NameEdit); //   
            ObjectDelete(0,m_NameLabel); //  
         }    
   public:
		/*!	
			  .
            \param		string aName="CInputBox" - ,
            \param		int aWidth=50 - ,
            \param		int aDigits=-1 -     (   ), -1 -    ,
            \param		string aCaption="CInputBox" -   (  ""  ).
 		*/   
      void Init(string aName="CInputBox",int aWidth=50,int aDigits=-1,string aCaption="CInputBox"){ //  
         m_NameEdit=aName+"_E"; //    
         m_NameLabel=aName+"_L"; //   
         m_Left=0; //  
         m_Top=0; //  Y
         m_Width=aWidth; // 
         m_Height=15; // 
         m_Visible=false; // 
         m_Digits=aDigits; //        
         m_Caption=aCaption; //  
         m_Value=""; //    
         if(aDigits>=0)m_Value=DoubleToString(0,m_Digits); //    
         m_ValueMin=-DBL_MAX; //  
         m_ValueMax=DBL_MAX; //  
         m_BgColor=ClrScheme.Color(0); //    
         m_TxtColor=ClrScheme.Color(1); //      
         m_LblColor=ClrScheme.Color(2); //  
         m_WarningColor=ClrScheme.Color(3); //  
         m_Warning=false; // : , 
         m_SubWindow=0; //  
         m_Tag=""; // 
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPos(int aLeft,int aTop){ //   X  Y
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosLeft(int aLeft){ //   X 
         m_Left=aLeft;
      }   
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/             
      void SetPosTop(int aTop){ //   Y
         m_Top=aTop;
      }  
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/         
      void SetWidth(int aWidth){ //   
         m_Width=aWidth;
      }
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){ //   X
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/        
      int Top(){ //   Y
         return(m_Top);
      }
		/*!	
			 .
			\return   ( int).
			\remark         .
 		*/        
      int Width(){ //  
         return(m_Width);
      }
		/*!	
			 .
			\return   ( int).
 		*/        
      int Height(){
         return(m_Height); //  
      }
		/*!	
			 .
 		*/       
      void Show(){ //      
         m_Visible=true; //   
         Create(); //   
         ChartRedraw(); //  
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/        
      void Show(int aLeft,int aTop){ //     
         SetPos(aLeft,aTop); //  
         Show(); //  
      }
		/*!	
			   (  ).
 		*/   
      void Hide(){ //  (  )
         m_Visible=false; //   
         Delete(); //   
         ChartRedraw(); //  
      }  
		/*!	
			 (     ).
 		*/         
      void Refresh(){ //   (  )
         if(m_Visible){ //  
            Delete(); //   
            Create(); //   
            ChartRedraw(); //   
         }            
      }  
		/*!	
			   string.
			\param		string aValue - .	
 		*/         
      void SetValue(string aValue){ //   
         m_Value=aValue; //      
            if(m_Visible){ //    
               g.Attach(m_NameEdit); //         
               g.SetText(m_Value); //     
               ChartRedraw(); //   
            }
      }  
		/*!	
			   double.
			\param		double aValue - .	
 		*/         
      void SetValue(double aValue){ //   
         if(m_Digits>=0){ //   
            aValue=NormalizeDouble(aValue,m_Digits); //        
            aValue=MathMax(aValue,m_ValueMin); // ""     
            aValue=MathMin(aValue,m_ValueMax); // ""     
            SetValue(DoubleToString(aValue,m_Digits)); //      
         }
         else{ //   
            SetValue((string)aValue); //        
         }            
      }
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1     .
 		*/          
      int Event(const int id,const long & lparam,const double & dparam,const string & sparam){ //  
         bool m_event=0; //      
            if(id==CHARTEVENT_OBJECT_ENDEDIT){ //      
               if(sparam==m_NameEdit){ //       m_NameEdit
                  if(m_Digits<0){ //   
                     g.Attach(m_NameEdit); //     
                        if(g.Text()!=m_Value){ //     
                           m_Value=g.Text(); //      
                           m_event=1; //  
                        }
                  }
                  else{ //   
                     string m_OldValue=m_Value; //      
                     g.Attach(m_NameEdit); //     
                     string m_stmp=g.Text(); //     ,  
                     StringReplace(m_stmp,",","."); //    
                     double m_dtmp=StringToDouble(m_stmp); //   
                     SetValue(m_dtmp); //    
                        if(StringToDouble(m_Value)!=StringToDouble(m_OldValue)){ //     
                           m_event=1; //   
                        }
                  }
               }
            }               
         return(m_event); //  . 0 -  , 1 -  
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/       
      void SetSubWindow(int aNumber){ //    
         int m_itmp=(int)MathMax(aNumber,0); //    ,   0 -  
            if(m_itmp!=m_SubWindow){ //           
               m_SubWindow=m_itmp; //    
               Refresh(); //   
            }
      }  
		/*!	
			    .
			\param string aName -  .
 		*/              
      void SetSubWindow(string aName){ //     
         SetSubWindow(ChartWindowFind(0,aName)); //          
      }
		/*!	
			  .
			\return .
 		*/       
      string ValueString(){ //   
         return(m_Value);
      }
		/*!	
			  .
			\return  ( double).
 		*/         
      double ValueDouble(){ //   
         return(StringToDouble(m_Value));
      }
		/*!	
			/  .
			\param bool aValue - true/false (/). 
 		*/        
      void SetWarning(bool aValue){ //   
            if(m_Visible){ //  
               if(aValue){ //    
                  if(!m_Warning){ //     
                     g.Attach(m_NameEdit); //      
                     g.SetBgColor(m_WarningColor); //      
                  }
               }
               else{ //    
                  if(m_Warning){ //   
                     g.Attach(m_NameEdit); //      
                     g.SetBgColor(m_BgColor); //                    
                  }
               }
            }
         m_Warning=aValue; //   
      }
		/*!	
			  .
			\return  bool. True/false - /.
 		*/         
      bool Warning(){ //   
         return(m_Warning);
      }
		/*!	
			   .
			\param double aValue -   . 
 		*/        
      void SetMaxValue(double aValue){ //    
         m_ValueMax=aValue; //     
            if(m_Digits>=0){ //      
               if(StringToDouble(m_Value)>m_ValueMax){ //         
                  SetValue(m_ValueMax); //       
               }
            }         
      }
		/*!	
			   .
			\param double aValue -   . 
 		*/        
      void SetMinValue(double aValue){ //    
         m_ValueMin=aValue; //          
            if(m_Digits>=0){ //      
               if(StringToDouble(m_Value)<m_ValueMin){ //         
                  SetValue(m_ValueMin); //        
               }
            }
      }
		/*!	
			   .
			\return  ( double).
 		*/         
      double MaxValue(){ //    
         return(m_ValueMax); 
      }
		/*!	
			   .
			\return  ( double).
 		*/       
      double MinValue(){ //    
         return(m_ValueMin);
      }
		/*!	
			 .
			\param string aValue - .
 		*/       
      void SetTag(string aValue){ //  
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/        
      string Tag(){ //  
         return(m_Tag);
      }  
		/*!	
			       .
			\param int aValue -    .
 		*/          
      void SetDigits(int aValue){ //     
         m_Digits=aValue; //   
            if(m_Digits>=0){ //  
               SetValue(ValueDouble()); //   
            }
      }  
		/*!	
			    .
			\return  int.     -    . -1 -      .
 		*/       
      int Digits(){ //   m_Digits
         return(m_Digits);
      }   
		/*!	
			  .
			\return  bool. True/false - /.
 		*/           
      bool Visible(){
         return(m_Visible);
      }
		/*!	
			  "  ".
			\param int aValue - true/false -  / .
 		*/        
      void SetReadOnly(bool aValue){
         m_ReadOnly=aValue;
            if(m_Visible){
               g.SetReadOnly(m_NameEdit,m_ReadOnly);
            }
      }   
		/*!	
			  "  ".
			\return  bool. True/false -  / .
 		*/        
      bool ReadOnly(){
         return(m_ReadOnly);
      }      
};

//+------------------------------------------------------------------+
//|          CSpinInputBox                                      |
//+------------------------------------------------------------------+

/*!
   \brief      "   +/-".
   
   \details          
             "+"  "-".     .  
                   
               .    . 
   \remark	      CSpinInputBox  
             (OBJ_LABEL).    CSpinInputBox   aName 
             "_IB",   - "_L",   "+" - "_U",  
            "-" - "_D".
*/  

class CSpinInputBox{
   protected:
      CInputBox m_ib;
      string m_NameSU;
      string m_NameSD;
      string m_NameLabel;
      int m_Left;
      int m_Top;
      int m_Width;
      int m_Height;
      string m_Caption;
      int m_SubWindow;
      color m_LblColor;
      color m_SpBgColor;
      color m_SpTxtColor;
      color m_FlashColor;
      color m_WrongColor;
      bool m_Visible;
      double m_Change;
      int m_Digits;
         int DefineDigits(double aValue){ //          double
            int m_Digits=0;
               for(int i=8;i>=0;i--){
                  if(aValue>=NormalizeDouble(1.0/MathPow(10,i),8)){
                     m_Digits=i;
                  }
               }
            return(m_Digits);    
         }
         void Create(){
            w.Edit(m_NameSD,m_SubWindow,m_Left+m_Width-13,m_Top+7,13,8," -",m_SpBgColor,m_SpTxtColor,6,"Arial");
            w.Edit(m_NameSU,m_SubWindow,m_Left+m_Width-13,m_Top,13,8," +",m_SpBgColor,m_SpTxtColor,5,"Arial");
            g.SetReadOnly(m_NameSU,true);               
            g.SetReadOnly(m_NameSD,true);
               if(m_Caption!=""){ //  
                  w.Label(m_NameLabel,m_SubWindow,m_Left+m_Width+1,m_Top+2,m_Caption,m_LblColor,7,"Arial"); //  
               } 
         }
         void Delete(){
            ObjectDelete(0,m_NameSU); //  "" up
            ObjectDelete(0,m_NameSD); //  "" dn
            ObjectDelete(0,m_NameLabel); //           
         }
         void Flash(string aName,color aFlash,color aNormal){
            g.SetBgColor(aName,aFlash);
            g.Redraw();
            Sleep(100);
            g.SetBgColor(aName,aNormal);
            g.Redraw();      
         }         
   public:
		/*!	
			  .
            \param		string aName="CSpinInputBox" - ,
            \param		int aWidth=50 - ,
            \param		double aChange=0.1 -   ,
            \param		string aCaption="CSpinInputBox" -   (  ""  ).
 		*/     
      void Init(string aName="CSpinInputBox",int aWidth=50,double aChange=0.1,string aCaption="CSpinInputBox"){
         m_NameSU=aName+"_U";
         m_NameSD=aName+"_D";
         m_NameLabel=aName+"_L";
         m_SubWindow=0;
         m_Left=0;
         m_Top=0; 
         m_Width=aWidth;
         m_Height=15;
         m_Caption=aCaption;         
         m_SpTxtColor=ClrScheme.Color(1); //    ,      
         m_LblColor=ClrScheme.Color(2);   //                 
         m_WrongColor=ClrScheme.Color(3); //      
         m_SpBgColor=ClrScheme.Color(4);  //  , 
         m_FlashColor=ClrScheme.Color(5); //  , 
         m_Visible=false;
         m_Change=aChange;
         m_Digits=DefineDigits(m_Change);
         m_ib.Init(aName+"_IB",m_Width-12,m_Digits,""); //   
         m_ib.SetReadOnly(true);
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
         m_ib.SetPos(m_Left,m_Top);
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
         m_ib.SetPosLeft(m_Left);
      } 
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/    
      void SetPosTop(int aTop){
         m_Top=aTop;
         m_ib.SetPosTop(m_Top);
      }  
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/        
      void SetWidth(int aWidth){
         m_Width=aWidth;
         m_ib.SetWidth(m_Width-12);
      }
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/  
      int Top(){
         return(m_Top);
      }
		/*!	
			 .
			\return   ( int).
			\remark         .
 		*/         
      int Width(){
         return(m_Width);
      }
		/*!	
			 .
			\return   ( int).
 		*/ 
      int Height(){
         return(m_Height);
      }
		/*!	
			 .
 		*/        
      void Show(){
         m_Visible=true; 
         Create(); 
         m_ib.Show();
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/        
      void Show(int aLeft,int aTop){
         SetPos(aLeft,aTop);
         Show();
      }
		/*!	
			   (  ).
 		*/       
      void Hide(){
         m_Visible=false;
         Delete();
         m_ib.Hide();
      }   
		/*!	
			 (     ).
 		*/        
      void Refresh(){
         if(m_Visible){
            Delete();
            Create(); 
            m_ib.Refresh();
         }            
      } 
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0, 1  2. 0 -  . 1      , 2 -  +/-.
 		*/         
      int Event(const int id,const long & lparam,const double & dparam,const string & sparam){ //  
         int m_event=m_ib.Event(id,lparam,dparam,sparam);
            if(m_event==0){
               double m_OldValue;
                  if(id==CHARTEVENT_OBJECT_CLICK){
                     if(sparam==m_NameSU){
                        m_OldValue=m_ib.ValueDouble();
                        m_ib.SetValue(m_OldValue+m_Change);
                           if(m_OldValue!=m_ib.ValueDouble()){
                              Flash(m_NameSU,m_FlashColor,m_SpBgColor);
                              m_event=2;
                           }
                           else{
                              Flash(m_NameSU,m_WrongColor,m_SpBgColor);
                           }
                     }
                     if(sparam==m_NameSD){
                        m_OldValue=m_ib.ValueDouble();
                        m_ib.SetValue(m_OldValue-m_Change);
                           if(m_OldValue!=m_ib.ValueDouble()){
                              Flash(m_NameSD,m_FlashColor,m_SpBgColor);
                              m_event=2;
                           }
                           else{
                              Flash(m_NameSD,m_WrongColor,m_SpBgColor);
                           }
                     }               
                  }
            }
         return(m_event);
      }   
		/*!	
			   .
			\param double aValue -   . 
 		*/         
      void SetMaxValue(double aValue){
         m_ib.SetMaxValue(aValue);
      }
		/*!	
			   .
			\param double aValue -   . 
 		*/        
      void SetMinValue(double aValue){
         m_ib.SetMinValue(aValue);
      }
		/*!	
			   .
			\return  ( double).
 		*/        
      double MaxValue(){
         return(m_ib.MaxValue()); 
      }
		/*!	
			   .
			\return  ( double).
 		*/         
      double MinValue(){
         return(m_ib.MinValue());
      }
		/*!	
			 .
			\param string aValue - .
 		*/       
      void SetTag(string aValue){
         m_ib.SetTag(aValue);
      }
		/*!	
			 .
			\return  ( string).
 		*/   
      string Tag(){
         return(m_ib.Tag());
      } 
		/*!	
			 .
			\param		double aValue - .	
 		*/          
      void SetValue(double aValue){
         m_ib.SetValue(aValue);
      }
		/*!	
			 .
			\return  double.
 		*/         
      double Value(){
         return(m_ib.ValueDouble());
      }   
		/*!	
			  .
			\param		double aValue - .	
 		*/         
      void SetChange(double aValue){
         m_Change=aValue;
         m_Digits=DefineDigits(m_Change);
         m_ib.SetDigits(m_Digits);
      }  
		/*!	
			  .
			\return  double.
 		*/       
      double Change(){
         return(m_Change);
      }  
		/*!	
			    .
			\return  int.
			\remark    .
 		*/        
      int Digits(){
         return(m_Digits);
      }
		/*!	
			/  .
			\param bool aValue - true/false (/). 
 		*/        
      void SetWarning(bool aValue){
         m_ib.SetWarning(aValue);
      }
		/*!	
			  .
			\return  bool. True/false - /.
 		*/         
      bool Warning(){
         return(m_ib.Warning());
      }
		/*!	
			  "  ".
			\param int aValue - true/false -  / .
 		*/        
      void SetReadOnly(bool aValue){
         m_ib.SetReadOnly(aValue);
      }
		/*!	
			  "  ".
			\return  bool. True/false -  / .
 		*/        
      bool ReadOnly(){
         return(m_ib.ReadOnly());
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/          
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               m_ib.SetSubWindow(m_SubWindow);
               Refresh();
            }
      }    
		/*!	
			    .
			\param string aName -  .
 		*/             
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }  
};

//+------------------------------------------------------------------+
//|          CCheckBox                                          |
//+------------------------------------------------------------------+

/*!
   \brief      "".
   \details    . 
   \remark	    OBJ_RECTANGLE_LABEL   
            OBJ_LABEL:    .
                   aName 
             "_B",   - "_C",   - "_L".
            "-" - "_D".
*/  

class CCheckBox{
   protected:
      color m_BgColor;
      color m_CheckColor;
      color m_LabelColor;
      string m_Caption;
      string m_NameBox;
      string m_NameChecked;
      string m_NameLabel;
      int m_Left;
      int m_Top;
      int m_Width;
      int m_Height;
      bool m_Value;
      bool m_Visible;
      int m_SubWindow;
      string m_Tag;
         void Create(){
            w.Canvas(m_NameBox,m_SubWindow,m_Left,m_Top,m_Width,m_Height,m_BgColor,m_CheckColor);
            string m_str=" ";
               if(m_Value){
                  m_str=CharToString(252);
               }
            w.Label(m_NameChecked,m_SubWindow,m_Left+1,m_Top+1,m_str,m_CheckColor,12,"Wingdings");
            w.Label(m_NameLabel,m_SubWindow,m_Left+m_Width+1,m_Top+2,m_Caption,m_LabelColor,7);            
         }
         void Delete(){
            ObjectDelete(0,m_NameBox);
            ObjectDelete(0,m_NameChecked);
            ObjectDelete(0,m_NameLabel);
         }
   public:
		/*!	
			  .
         \param		string aName="CCheckBox" - ,
         \param		string aCaption="CCheckBox" -   (  ""  ).
 		*/   
      void Init(string aName="CCheckBox",string aCaption="CCheckBox"){
         m_NameBox=aName+"_B";
         m_NameChecked=aName+"_C";
         m_NameLabel=aName+"_L";
         m_Caption=aCaption;
         m_BgColor=ClrScheme.Color(0);
         m_CheckColor=ClrScheme.Color(1);
         m_LabelColor=ClrScheme.Color(2);
         m_Value=false;
         m_Visible=false;
         m_Width=15;
         m_Height=15;
         m_SubWindow=0;
         m_Tag="";
      }
		/*!	
			 .
 		*/       
      void Show(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
         Show();
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/      
      void Show(){
         m_Visible=true;
         Create();
         ChartRedraw(0);
      }
		/*!	
			   (  ).
 		*/       
      void Hide(){
         m_Visible=false;
         Delete();
         ChartRedraw(0);
      } 
		/*!	
			 (     ).
 		*/        
      void Refresh(){
         if(m_Visible){
            Delete();
            Create();
            ChartRedraw(0);
         }            
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }   
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/          
      void SetPosTop(int aTop){
         m_Top=aTop;
      }  
		/*!	
			  X.
			\return   ( int).
 		*/        
      int Left(){
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/         
      int Top(){
         return(m_Top);
      }
		/*!	
			 .
			\return   ( int).
			\remark     .
 		*/        
      int Width(){
         return(m_Width);
      }
		/*!	
			 .
			\return   ( int).
 		*/       
      int Height(){
         return(m_Height);
      }
		/*!	
			 .
			\param		bool aValue - true/false.	
 		*/         
      void SetValue(bool aValue){
         m_Value=aValue;
            if(m_Visible){
               string m_str=" ";
                  if(m_Value){
                     m_str=CharToString(252);
                  }
               g.SetText(m_NameChecked,m_str);
               g.Redraw();
            }
      }
		/*!	
			 .
			\return  bool.
 		*/        
      bool Value(){
         return(m_Value);
      }  
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1     .
 		*/          
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
         int m_event=0;
            if(id==CHARTEVENT_OBJECT_CLICK){
               if(sparam==m_NameBox || sparam==m_NameChecked || sparam==m_NameLabel){
                     if(m_Value){
                        SetValue(false);
                     }
                     else{
                        SetValue(true);
                     }
                  m_event=1;
               }
            }
         return(m_event);
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/         
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               Refresh();
            }
      }   
		/*!	
			    .
			\param string aName -  .
 		*/              
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }  
		/*!	
			 .
			\param string aValue - .
 		*/       
      void SetTag(string aValue){ //  
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/        
      string Tag(){ //  
         return(m_Tag);
      }               
};

//+------------------------------------------------------------------+
//|          CRadioGroup                                        |
//+------------------------------------------------------------------+

/*!
   \brief      "".
   \details   .   
              ,  
              .    . 
   \remark	      (OBJ_LABEL), 
             ,       , 
             .       aName 
             "_B", "_D", "_L".
*/

class CRadioGroup{
   protected:
      struct sRBut{
         string NameRound;
         string NameDot;
         string NameLabel;
         string Caption;
         int Left;
         int Top;
      };
      sRBut m_Button[];
      int m_Left;
      int m_Top;
      int m_Value;
      bool m_Visible;
      color m_RoundColor;
      color m_DotColor;
      color m_LabelColor;      
      string m_Name;
      int m_SubWindow;
      int m_Width;
      int m_Height;
      string m_Tag;
         void Create(){
            for(int i=0;i<ArraySize(m_Button);i++){
               w.Label(m_Button[i].NameRound,m_SubWindow,m_Left+m_Button[i].Left,m_Top+m_Button[i].Top,CharToString(108),m_RoundColor,12,"Wingdings");
               w.Label(m_Button[i].NameDot,m_SubWindow,m_Left+m_Button[i].Left,m_Top+m_Button[i].Top,CharToString(161),m_DotColor,12,"Wingdings");               
                  if(m_Button[i].Caption!=""){
                     w.Label(m_Button[i].NameLabel,m_SubWindow,m_Left+m_Button[i].Left+13,m_Top+m_Button[i].Top+3,m_Button[i].Caption,m_LabelColor,7,"Arial");
                  }  
                  if(m_Value>-1){
                     g.SetText(m_Button[m_Value].NameDot,CharToString(164));
                  }
            }
         }
         void Delete(){
            for(int i=0;i<ArraySize(m_Button);i++){
               ObjectDelete(0,m_Button[i].NameRound);
               ObjectDelete(0,m_Button[i].NameDot);
               ObjectDelete(0,m_Button[i].NameLabel);
            }
         }
   public:
		/*!	
			  .
            \param		string aName="CRadioGroup" - .
 		*/      
      void Init(string aName="CRadioGroup"){
         m_RoundColor=ClrScheme.Color(0);
         m_DotColor=ClrScheme.Color(1);
         m_LabelColor=ClrScheme.Color(2);
         m_Name=aName;
         ArrayResize(m_Button,0);
         m_Value=-1;
         m_Visible=false;
         m_SubWindow=0;
         m_Left=0;
         m_Top=0;
         m_Width=0;
         m_Height=0;         
         string m_Tag="";
      }
		/*!	
			 .
            \param		string aCaption="Radio" -   ,
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
 		*/         
      void AddButton(string aCaption="Radio",int aLeft=0,int aTop=0){
         int m_LastIndex=ArraySize(m_Button);
         ArrayResize(m_Button,m_LastIndex+1);
         m_Button[m_LastIndex].NameRound=m_Name+"_B("+IntegerToString(m_LastIndex)+")";
         m_Button[m_LastIndex].NameDot=m_Name+"_D("+IntegerToString(m_LastIndex)+")";
         m_Button[m_LastIndex].NameLabel=m_Name+"_L("+IntegerToString(m_LastIndex)+")";
         m_Button[m_LastIndex].Caption=aCaption;
         m_Button[m_LastIndex].Left=aLeft;
         m_Button[m_LastIndex].Top=aTop;
         m_Width=MathMax(m_Width,aLeft+14);
         m_Height=MathMax(m_Height,aTop+14);         
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/        
      void Show(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
         Show();
      }
		/*!	
			 .
 		*/         
      void Show(){
         m_Visible=true;
         Create();
         ChartRedraw(0);
      }
		/*!	
			   (  ).
 		*/       
      void Hide(){
         m_Visible=false;
         Delete();
         ChartRedraw(0);
      } 
		/*!	
			 (     ).
 		*/        
      void Refresh(){
         if(m_Visible){
            Delete();
            Create();
            ChartRedraw(0);
         }            
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/    
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/       
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      
      }  
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/           
      void SetPosTop(int aTop){
         m_Top=aTop;
      }  
		/*!	
			  X.
			\return   ( int).
 		*/ 
      int Left(){
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/   
      int Top(){
         return(m_Top);
      }
		/*!	
			 .
			\return   ( int).
			\remark     .
 		*/  
      int Width(){
         return(m_Width);
      }
		/*!	
			 .
			\return   ( int).
 		*/  
      int Height(){
         return(m_Height);
      }
		/*!	
			  ( ).
			\param		string aValue -  .	
 		*/         
      void SetValue(int aValue){
            if(m_Value>-1 && m_Visible){
               g.SetText(m_Button[m_Value].NameDot,CharToString(161));
               g.Redraw();
            }
         m_Value=aValue;
         m_Value=MathMin(m_Value,ArraySize(m_Button)-1);
            if(m_Value>-1 && m_Visible){
               g.SetText(m_Button[m_Value].NameDot,CharToString(164));
               g.Redraw();
            }    
                 
      }      
		/*!	
			  (  ).
			\return  int.
 		*/ 
      int Value(){
         return(m_Value);
      }
		/*!
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1     .
 		*/         
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
         int m_event=0;
            if(id==CHARTEVENT_OBJECT_CLICK){
               if(StringFind(sparam,m_Name,0)==0){
                  int m_pos1=StringFind(sparam,"(",0);
                  int m_pos2=StringFind(sparam,")",0);
                  int m_Index=(int)StringToInteger(StringSubstr(sparam,m_pos1+1,m_pos2-m_pos1-1));
                     if(m_Index!=m_Value){
                        SetValue(m_Index);
                        m_event=1;
                     }
               }
            }    
         return(m_event);
      }    
		/*!	
			   .
			\param int aNumber -  .
 		*/           
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               Refresh();
            }
      }   
		/*!	
			    .
			\param string aName -  .
 		*/              
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }  
		/*!	
			 .
			\param string aValue - .
 		*/        
      void SetTag(string aValue){ //  
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/        
      string Tag(){ //  
         return(m_Tag);
      }                   
};

//+------------------------------------------------------------------+
//|          CVScrollBar                                         |
//+------------------------------------------------------------------+

/*!
   \brief      "  ".
   \details    . 
   \remark	        
            " ":  "",  "", ,
               (  ""  ),
               (    "").
                 aName  "_UB"  
            "_LB" (""), "_UF"  "_LF" (), "_S" ().
*/

class CVScrollBar{
   protected:
      string m_NameUpperButton;
      string m_NameLowerButton;
      string m_NameUpperField;
      string m_NameLowerField;
      string m_NameSlider;
      int m_Left;
      int m_Top;      
      int m_Height;
      int m_Width;  
      int m_Min;
      int m_Max;
      int m_SmallChange;
      int m_LageChange;
      int m_Value;
      bool m_SliderSelected;
      int m_SliderHeight;
      int m_Range;
      int m_A;
      int m_D;
      int m_L;
      int m_G;
      int m_T;
      int m_E;
      int m_K;
      int m_N;
      color m_BorderColor;
      color m_BarColor;
      color m_ButtonColor;
      color m_WarningColor; 
      color m_TxtColor;
      color m_SliderSelectedColor;
      color m_ButtonFlashColor;
      color m_BarFlashColor;
      int m_FontSize;
      bool m_Visible;
      int m_SubWindow;
      string m_Tag;
         void SetWidthAndFontSize(int aValue){
            // 13 18 19 24 30
            // 6  7  8  10 14                   
            switch(aValue){
               case 1:
                  m_Width=13;
                  m_FontSize=6;               
               break;
               case 2:
                  m_Width=19;
                  m_FontSize=8;                
               break;
               case 3:
                  m_Width=24;
                  m_FontSize=10;   
               break;                
               case 4:
                  m_Width=30;
                  m_FontSize=14;                  
               break;
            }   
         }               
         void SolveMainPositions(){
               if(m_Max<m_Min){
                  int m_tmp=m_Max;
                  m_Max=m_Min;
                  m_Min=m_tmp;
               }
            if(m_Max==m_Min)m_Max=m_Min+1;
            m_Range=m_Max-m_Min;   
            m_LageChange=MathMin(m_LageChange,m_Range);
            m_SmallChange=MathMin(m_SmallChange,m_LageChange);
            m_LageChange=(int)MathMax(m_LageChange,1);
            m_SmallChange=(int)MathMax(m_SmallChange,1);            
            m_D=m_Height-2*m_Width;
            m_SliderHeight=m_D/(m_Range/m_LageChange+1); 
            m_SliderHeight=(int)MathMax(m_SliderHeight,3);
            m_L=m_D-m_SliderHeight;
            m_G=m_Top-m_Width+m_Height; 
            m_E=m_Top+m_Width;  
            m_T=m_E+m_SliderHeight;  
            m_K=m_D-m_SliderHeight;
            m_N=m_Top+m_Width+m_SliderHeight/2;
         }
         void SetObjectsPos(){  
            m_Value=MathMin(MathMax(m_Value,m_Min),m_Max); 
            m_A=m_K*(m_Value-m_Min)/m_Range;
            g.Attach(m_NameUpperField);   g.SetXYDistance(m_Left,m_E-1);      g.SetXYSize(m_Width,m_A+2);
            g.Attach(m_NameLowerField);   g.SetXYDistance(m_Left,m_T+m_A-1);  g.SetXYSize(m_Width,m_L-m_A+2);  
            g.Attach(m_NameSlider);       g.SetXYDistance(m_Left,m_E+m_A-1);  g.SetXYSize(m_Width,m_SliderHeight+2); 
            g.Attach(m_NameSlider);       g.SetBgColor(m_ButtonColor);        
            g.Attach(m_NameLowerButton);  g.SetXYDistance(m_Left,m_Top);      g.SetXYSize(m_Width,m_Width);
            g.Attach(m_NameUpperButton);  g.SetXYDistance(m_Left,m_G);        g.SetXYSize(m_Width,m_Width); 
            ChartRedraw(0);
         } 
         void Create(){
            m_Value=MathMin(MathMax(m_Value,m_Min),m_Max); 
            m_A=m_K*(m_Value-m_Min)/m_Range;
            w.Edit(m_NameUpperField,m_SubWindow,m_Left,m_E-1,m_Width,m_A+2,"",m_BarColor,m_BorderColor);
            g.SetReadOnly(m_NameUpperField,true);
            w.Edit(m_NameLowerField,m_SubWindow,m_Left,m_T+m_A-1,m_Width,m_L-m_A+2,"",m_BarColor,m_BorderColor);
            g.SetReadOnly(m_NameLowerField,true);
            w.Edit(m_NameSlider,m_SubWindow,m_Left,m_E+m_A-1,m_Width,m_SliderHeight+2,"",m_ButtonColor,m_BorderColor);
            g.SetReadOnly(m_NameSlider,true);
            w.Edit(m_NameLowerButton,m_SubWindow,m_Left,m_Top,m_Width,m_Width," /\\",m_ButtonColor,m_BorderColor,m_FontSize,"Arial");
            g.SetReadOnly(m_NameLowerButton,true);
            w.Edit(m_NameUpperButton,m_SubWindow,m_Left,m_G,m_Width,m_Width," \\/",m_ButtonColor,m_BorderColor,m_FontSize,"Arial");
            g.SetReadOnly(m_NameUpperButton,true);            
         }  
         void Delete(){
            ObjectDelete(0,m_NameUpperButton);
            ObjectDelete(0,m_NameLowerButton);
            ObjectDelete(0,m_NameUpperField);
            ObjectDelete(0,m_NameLowerField);
            ObjectDelete(0,m_NameSlider);
         }   
         void ChartClickY(double aDparam,int & aY){
            long hs=0;
            long ps=0;
               for(int i=0;i<ChartGetInteger(0,CHART_WINDOWS_TOTAL);i++){
                  hs+=3+ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,i);
                     if(hs>=aDparam){
                        aY=(int)(aDparam-ps-3); 
                        break;
                     }
                  ps=hs;
               } 
         }  
         void RePose(){
            if(m_Visible){
               SolveMainPositions(); 
               SetObjectsPos();
               ChartRedraw();
            }
         }  
         void Flash(string aName,color aFlash,color aNormal){
            g.SetBgColor(aName,aFlash);
            g.Redraw();
            Sleep(100);
            g.SetBgColor(aName,aNormal);
            g.Redraw();      
         }                           
   public: 
		/*!	
			  .
            \param		string aName="CVScrollBar" - ,
            \param		int aHeight=100 - ,
            \param		int aSizeType=1 -  (  1-4).
 		*/      
      void Init(string aName="CVScrollBar",int aHeight=100,int aSizeType=1){
         m_Visible=false;         
         m_NameUpperButton=aName+"_UB";
         m_NameLowerButton=aName+"_LB";
         m_NameUpperField=aName+"_UF";
         m_NameLowerField=aName+"_LF";
         m_NameSlider=aName+"_S";        
         //=============================
         m_BorderColor=ClrScheme.Color(6);
         m_BarColor=ClrScheme.Color(7);
         m_ButtonColor=ClrScheme.Color(8);
         m_WarningColor=ClrScheme.Color(9); 
         m_TxtColor=ClrScheme.Color(10);
         m_SliderSelectedColor=ClrScheme.Color(11);
         m_ButtonFlashColor=ClrScheme.Color(12);
         m_BarFlashColor=ClrScheme.Color(13);
         //=============================
         m_Min=0;
         m_Max=100;
         m_SmallChange=1;
         m_LageChange=10;
         m_Value=0;
         m_Height=aHeight;         
         m_SubWindow=0;
         SetWidthAndFontSize(aSizeType);
         string m_Tag="";
      }
		/*!	
			 .
 		*/         
      void Show(){
         m_Visible=true;
         SolveMainPositions();
         Create();
         ChartRedraw();
      }  
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/               
      void Show(int aLeft,int aTop){ 
         m_Left=aLeft;
         m_Top=aTop;
         Show();
      } 
		/*!	
			   (  ).
 		*/         
      void Hide(){
         m_Visible=false;
         Delete();
         ChartRedraw();
      } 
		/*!	
			 (     ).
 		*/               
      void Refresh(){
         if(m_Visible){
            Delete();
            SolveMainPositions();
            Create();
            ChartRedraw();
         }
      }
		/*!	
			  .
			\return  bool. True/false - /.
 		*/  
      bool Visible(){
         return(m_Visible);
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/       
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }   
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/   		             
      void SetPosTop(int aTop){
         m_Top=aTop;
      } 
		/*!	
			 .
            \param		int aValue -   1  4-.
            \remark	      ,    Refresh().
 		*/ 
      void SetSizeType(int aValue){
         SetWidthAndFontSize(aValue);
      }  
		/*!	
			  X.
			\return   ( int).
 		*/             
      int Left(){
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/    
      int Top(){
         return(m_Top);
      }
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/  
      void SetHeight(int aValue){
         m_Height=aValue;
      }
		/*!	
			 .
			\return   ( int).
 		*/         
      int Height(){
         return(m_Height);
      }   
		/*!	
			 .
			\return   ( int).
 		*/   
      int Width(){
         return(m_Width);
      }
		/*!	
			  .
			\param double aValue - . 
 		*/        
      void SetMin(int aValue){
         m_Min=aValue;
      }
		/*!	
			  .
			\param double aValue - . 
 		*/        
      void SetMax(int aValue){
         m_Max=aValue;
      }
		/*!	
			   (   ).
			\param double aValue - . 
 		*/         
      void SetSmallChange(int aValue){
         m_SmallChange=aValue;
      }
		/*!	
			   (   ).
			\param double aValue - . 
 		*/      
      void SetLageChange(int aValue){
         m_LageChange=aValue;
      }      
		/*!	
			  ( ).
			\param double aValue - . 
 		*/        
      void SetValue(int aValue){
         m_Value=aValue;
         RePose();
      }  
		/*!	
			  .
			\return  ( int).
 		*/         
      int Min(){
         return(m_Min);
      }
		/*!	
			  .
			\return  ( int).
 		*/        
      int Max(){
         return(m_Max);
      }
		/*!	
			  .
			\return  ( int).
 		*/       
      int SmallChange(){
         return(m_SmallChange);
      }
		/*!	
			  .
			\return  ( int).
 		*/        
      int LageChange(){
         return(m_LageChange);
      }  
		/*!	
			  ( ).
			\return  ( int).
 		*/           
      int Value(){
         return(m_Value);
      }  
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1     .
 		*/             
      int Event(const int id,const long & lparam,const double & dparam,const string & sparam){
         int m_old=m_Value;
            if(id==CHARTEVENT_OBJECT_CLICK){
               int m_Y;
               ChartClickY(dparam,m_Y);
                  if(sparam==m_NameLowerButton){
                        if(m_Value>m_Min){
                           Flash(m_NameLowerButton,m_ButtonFlashColor,m_ButtonColor);
                        }
                        else{
                           Flash(m_NameLowerButton,m_WarningColor,m_ButtonColor);
                        }                           
                        if(m_SliderSelected){
                           m_Value=m_Min;
                           m_SliderSelected=false;
                        }
                        else{   
                           m_Value-=m_SmallChange;
                           m_Value=MathMax(m_Value,m_Min);
                        }
                     RePose(); 
                  }
                  if(sparam==m_NameUpperButton){
                        if(m_Value<m_Max){
                           Flash(m_NameUpperButton,m_ButtonFlashColor,m_ButtonColor);
                        }
                        else{
                           Flash(m_NameUpperButton,m_WarningColor,m_ButtonColor);
                        }                    
                        if(m_SliderSelected){
                           m_Value=m_Max;
                           m_SliderSelected=false;
                        }
                        else{              
                           m_Value+=m_SmallChange;
                           m_Value=MathMin(m_Value,m_Max);
                        }                  
                     RePose();
                  }         
                  if(sparam==m_NameUpperField){
                     Flash(m_NameUpperField,m_BarFlashColor,m_BarColor);           
                        if(m_SliderSelected){
                           m_Value=m_Min+m_Range*(m_Y-m_N)/m_L;
                           m_Value=MathMin(MathMax(m_Value,m_Min),m_Max);
                           m_SliderSelected=false;
                        }
                        else{
                           m_Value-=m_LageChange;
                           m_Value=MathMin(MathMax(m_Value,m_Min),m_Max);
                        }                  
                     RePose();  
                  }
                  if(sparam==m_NameLowerField){
                     Flash(m_NameLowerField,m_BarFlashColor,m_BarColor);               
                        if(m_SliderSelected){
                           m_Value=m_Min+m_Range*(m_Y-m_N)/m_L;
                           m_Value=MathMin(MathMax(m_Value,m_Min),m_Max);
                           m_SliderSelected=false;
                        }
                        else{
                           m_Value+=m_LageChange;
                           m_Value=MathMin(MathMax(m_Value,m_Min),m_Max);
                        }                  
                     RePose();      
                  } 
                  if(sparam==m_NameSlider){                  
                     if(m_SliderSelected){   
                        g.Attach(m_NameSlider);       
                        m_SliderSelected=false;
                        g.SetBgColor(m_ButtonColor);
                        g.Redraw();
                     }
                     else{
                        m_SliderSelected=true;
                        g.Attach(m_NameSlider);
                        g.SetBgColor(m_SliderSelectedColor);
                        g.Redraw();
                     }
                  }       
            }
            if(m_old!=m_Value){
               return(1);
            }
         return(0);
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/        
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               Refresh();
            }
      }  
		/*!	
			    .
			\param string aName -  .
 		*/               
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }  
		/*!	
			 .
			\param string aValue - .
 		*/        
      void SetTag(string aValue){ //  
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/         
      string Tag(){ //  
         return(m_Tag);
      }         
};

//+------------------------------------------------------------------+
//|          CHScrollBar                                         |
//+------------------------------------------------------------------+

/*!
   \brief      "  ".
   \details    . 
   \remark	        
            " ":  "",  "", ,
               (  ""  ),
               (    "").
                 aName  "_UB"  
            "_LB" (""), "_UF"  "_LF" (), "_S" ().
*/

class CHScrollBar{
   protected:
      string m_NameUpperButton;
      string m_NameLowerButton;
      string m_NameUpperField;
      string m_NameLowerField;
      string m_NameSlider;
      int m_Left;
      int m_Top;      
      int m_Height;
      int m_Width;  
      int m_Min;
      int m_Max;
      int m_SmallChange;
      int m_LageChange;
      int m_Value;
      bool m_SliderSelected;
      int m_SliderWidth;
      int m_Range;
      int m_A;
      int m_D;
      int m_L;
      int m_G;
      int m_T;
      int m_E;
      int m_K;
      int m_N;
      color m_BorderColor;
      color m_BarColor;
      color m_ButtonColor;
      color m_WarningColor; 
      color m_TxtColor;
      color m_SliderSelectedColor;
      color m_ButtonFlashColor;
      color m_BarFlashColor;
      int m_FontSize;
      bool m_Visible;
      int m_SubWindow;
      string m_Tag;
         void SetWidthAndFontSize(int aValue){
            switch(aValue){
               case 1:
                  m_Height=13;
                  m_FontSize=8;               
               break;
               case 2:
                  m_Height=19;
                  m_FontSize=11;                
               break;
               case 3:
                  m_Height=24;
                  m_FontSize=15;   
               break;                
               case 4:
                  m_Height=30;
                  m_FontSize=19;                  
               break;
            }   
         }               
         void SolveMainPositions(){
               if(m_Max<m_Min){
                  int m_tmp=m_Max;
                  m_Max=m_Min;
                  m_Min=m_tmp;
               }
            if(m_Max==m_Min)m_Max=m_Min+1;
            m_Range=m_Max-m_Min;   
            m_LageChange=MathMin(m_LageChange,m_Range);
            m_SmallChange=MathMin(m_SmallChange,m_LageChange);
            m_LageChange=(int)MathMax(m_LageChange,1);
            m_SmallChange=(int)MathMax(m_SmallChange,1);            
            m_D=m_Width-2*m_Height;
            m_SliderWidth=m_D/(m_Range/m_LageChange+1); 
            m_SliderWidth=(int)MathMax(m_SliderWidth,3);
            m_L=m_D-m_SliderWidth;
            m_G=m_Left-m_Height+m_Width; 
            m_E=m_Left+m_Height;  
            m_T=m_E+m_SliderWidth;  
            m_K=m_D-m_SliderWidth;
            m_N=m_Left+m_Height+m_SliderWidth/2;
         }
         void SetObjectsPos(){  
            m_Value=MathMin(MathMax(m_Value,m_Min),m_Max); 
            m_A=m_K*(m_Value-m_Min)/m_Range;
            g.Attach(m_NameUpperField);   g.SetXYDistance(m_E-1,m_Top);      g.SetXYSize(m_A+2,m_Height);
            g.Attach(m_NameLowerField);   g.SetXYDistance(m_T+m_A-1,m_Top);  g.SetXYSize(m_L-m_A+2,m_Height);  
            g.Attach(m_NameSlider);       g.SetXYDistance(m_E+m_A-1,m_Top);  g.SetXYSize(m_SliderWidth+2,m_Height); 
            g.Attach(m_NameSlider);       g.SetBgColor(m_ButtonColor);        
            g.Attach(m_NameLowerButton);  g.SetXYDistance(m_Left,m_Top);     g.SetXYSize(m_Height,m_Height);
            g.Attach(m_NameUpperButton);  g.SetXYDistance(m_G,m_Top);        g.SetXYSize(m_Height,m_Height); 
            ChartRedraw(0);
         } 
         void Create(){
            m_Value=MathMin(MathMax(m_Value,m_Min),m_Max); 
            m_A=m_K*(m_Value-m_Min)/m_Range;
            w.Edit(m_NameUpperField,m_SubWindow,m_E-1,m_Top,m_A+2,m_Height,"",m_BarColor,m_BorderColor);
            g.SetReadOnly(m_NameUpperField,true);
            w.Edit(m_NameLowerField,m_SubWindow,m_T+m_A-1,m_Top,m_L-m_A+2,m_Height,"",m_BarColor,m_BorderColor);
            g.SetReadOnly(m_NameLowerField,true);
            w.Edit(m_NameSlider,m_SubWindow,m_E+m_A-1,m_Top,m_SliderWidth+2,m_Height,"",m_ButtonColor,m_BorderColor);
            g.SetReadOnly(m_NameSlider,true);
            w.Edit(m_NameLowerButton,m_SubWindow,m_Left,m_Top,m_Height,m_Height,"<",m_ButtonColor,m_BorderColor,m_FontSize,"Arial");
            g.SetReadOnly(m_NameLowerButton,true);
            w.Edit(m_NameUpperButton,m_SubWindow,m_G,m_Top,m_Height,m_Height,">",m_ButtonColor,m_BorderColor,m_FontSize,"Arial");
            g.SetReadOnly(m_NameUpperButton,true);            
         }  
         void Delete(){
            ObjectDelete(0,m_NameUpperButton);
            ObjectDelete(0,m_NameLowerButton);
            ObjectDelete(0,m_NameUpperField);
            ObjectDelete(0,m_NameLowerField);
            ObjectDelete(0,m_NameSlider);
         }   
         void RePose(){
            if(m_Visible){
               SolveMainPositions(); 
               SetObjectsPos();
               ChartRedraw();
            }
         }  
         void Flash(string aName,color aFlash,color aNormal){
            g.SetBgColor(aName,aFlash);
            g.Redraw();
            Sleep(100);
            g.SetBgColor(aName,aNormal);
            g.Redraw();      
         }                           
   public: 
		/*!	
			  .
            \param		string aName="CHScrollBar" - ,
            \param		int aHeight=100 - ,
            \param		int aSizeType=1 -  (  1-4).
 		*/
      void Init(string aName="CHScrollBar",int aWidth=100,int aSizeType=1){
         m_Visible=false;         
         m_NameUpperButton=aName+"_UB";
         m_NameLowerButton=aName+"_LB";
         m_NameUpperField=aName+"_UF";
         m_NameLowerField=aName+"_LF";
         m_NameSlider=aName+"_S";        
         //=============================
         m_BorderColor=ClrScheme.Color(6);
         m_BarColor=ClrScheme.Color(7);
         m_ButtonColor=ClrScheme.Color(8);
         m_WarningColor=ClrScheme.Color(9); 
         m_TxtColor=ClrScheme.Color(10);
         m_SliderSelectedColor=ClrScheme.Color(11);
         m_ButtonFlashColor=ClrScheme.Color(12);
         m_BarFlashColor=ClrScheme.Color(13);
         //=============================
         m_Min=0;
         m_Max=100;
         m_SmallChange=1;
         m_LageChange=10;
         m_Value=0;
         m_Width=aWidth;         
         m_SubWindow=0;
         SetWidthAndFontSize(aSizeType);
         m_Tag="";
      }
		/*!	
			 .
 		*/        
      void Show(){
         m_Visible=true;
         SolveMainPositions();
         Create();
         ChartRedraw();
      } 
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/               
      void Show(int aLeft,int aTop){ 
         m_Left=aLeft;
         m_Top=aTop;
         Show();
      }   
		/*!	
			   (  ).
 		*/         
      void Hide(){
         m_Visible=false;
         Delete();
         ChartRedraw();
      }     
		/*!	
			 (     ).
 		*/          
      void Refresh(){
         if(m_Visible){
            Delete();
            SolveMainPositions();
            Create();
            ChartRedraw();
         }
      }
		/*!	
			  .
			\return  bool. True/false - /.
 		*/ 
      bool Visible(){
         return(m_Visible);
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/  
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/  
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }    
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/  
      void SetPosTop(int aTop){
         m_Top=aTop;
      } 
		/*!	
			 .
            \param		int aValue -   1  4-.
            \remark	      ,    Refresh().
 		*/ 
      void SetSizeType(int aValue){
         SetWidthAndFontSize(aValue);
      }
		/*!	
			  X.
			\return   ( int).
 		*/         
      int Left(){
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/  
      int Top(){
         return(m_Top);
      }
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/        
      void SetWidth(int aValue){
         m_Width=aValue;
      }
		/*!	
			 .
			\return   ( int).
 		*/  
      int Height(){
         return(m_Height);
      }   
		/*!	
			 .
			\return   ( int).
 		*/       
      int Width(){
         return(m_Width);
      }
		/*!	
			  .
			\param double aValue - . 
 		*/  
      void SetMin(int aValue){
         m_Min=aValue;
      }
		/*!	
			  .
			\param double aValue - . 
 		*/         
      void SetMax(int aValue){
         m_Max=aValue;
      }
		/*!	
			   (   ).
			\param double aValue - . 
 		*/         
      void SetSmallChange(int aValue){
         m_SmallChange=aValue;
      }
		/*!	
			   (   ).
			\param double aValue - . 
 		*/         
      void SetLageChange(int aValue){
         m_LageChange=aValue;
      }     
		/*!	
			  ( ).
			\param double aValue - . 
 		*/  
      void SetValue(int aValue){
         m_Value=aValue;
         RePose();
      }  
		/*!	
			  .
			\return  ( int).
 		*/          
      int Min(){
         return(m_Min);
      }
		/*!	
			  .
			\return  ( int).
 		*/        
      int Max(){
         return(m_Max);
      }
		/*!	
			  .
			\return  ( int).
 		*/  
      int SmallChange(){
         return(m_SmallChange);
      }
		/*!	
			  .
			\return  ( int).
 		*/        
      int LageChange(){
         return(m_LageChange);
      }   
		/*!	
			  ( ).
			\return  ( int).
 		*/      
      int Value(){
         return(m_Value);
      }  
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1     .
 		*/              
      int Event(const int id,const long & lparam,const double & dparam,const string & sparam){
         int m_old=m_Value;
            if(id==CHARTEVENT_OBJECT_CLICK){
               int m_Y=(int)lparam-2;
                  if(sparam==m_NameLowerButton){
                        if(m_Value>m_Min){
                           Flash(m_NameLowerButton,m_ButtonFlashColor,m_ButtonColor);
                        }
                        else{
                           Flash(m_NameLowerButton,m_WarningColor,m_ButtonColor);
                        }                           
                        if(m_SliderSelected){
                           m_Value=m_Min;
                           m_SliderSelected=false;
                        }
                        else{   
                           m_Value-=m_SmallChange;
                           m_Value=MathMax(m_Value,m_Min);
                        }
                     RePose(); 
                  }
                  if(sparam==m_NameUpperButton){
                        if(m_Value<m_Max){
                           Flash(m_NameUpperButton,m_ButtonFlashColor,m_ButtonColor);
                        }
                        else{
                           Flash(m_NameUpperButton,m_WarningColor,m_ButtonColor);
                        }                    
                        if(m_SliderSelected){
                           m_Value=m_Max;
                           m_SliderSelected=false;
                        }
                        else{              
                           m_Value+=m_SmallChange;
                           m_Value=MathMin(m_Value,m_Max);
                        }                  
                     RePose();
                  }         
                  if(sparam==m_NameUpperField){
                     Flash(m_NameUpperField,m_BarFlashColor,m_BarColor);           
                        if(m_SliderSelected){
                           m_Value=m_Min+m_Range*(m_Y-m_N)/m_L;
                           m_Value=MathMin(MathMax(m_Value,m_Min),m_Max);
                           m_SliderSelected=false;
                        }
                        else{
                           m_Value-=m_LageChange;
                           m_Value=MathMin(MathMax(m_Value,m_Min),m_Max);
                        }                  
                     RePose();  
                  }
                  if(sparam==m_NameLowerField){
                     Flash(m_NameLowerField,m_BarFlashColor,m_BarColor);               
                        if(m_SliderSelected){
                           m_Value=m_Min+m_Range*(m_Y-m_N)/m_L;
                           m_Value=MathMin(MathMax(m_Value,m_Min),m_Max);
                           m_SliderSelected=false;
                        }
                        else{
                           m_Value+=m_LageChange;
                           m_Value=MathMin(MathMax(m_Value,m_Min),m_Max);
                        }                  
                     RePose();      
                  } 
                  if(sparam==m_NameSlider){                  
                     if(m_SliderSelected){   
                        g.Attach(m_NameSlider);       
                        m_SliderSelected=false;
                        g.SetBgColor(m_ButtonColor);
                        g.Redraw();
                     }
                     else{
                        m_SliderSelected=true;
                        g.Attach(m_NameSlider);
                        g.SetBgColor(m_SliderSelectedColor);
                        g.Redraw();
                     }
                  }       
            }
            if(m_old!=m_Value){
               return(1);
            }
         return(0);
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/        
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               Refresh();
            }
      }        
		/*!	
			    .
			\param string aName -  .
 		*/          
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }  
		/*!	
			 .
			\param string aValue - .
 		*/           
      void SetTag(string aValue){ //  
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/        
      string Tag(){ //  
         return(m_Tag);
      }         
};

//+------------------------------------------------------------------+
//|          CList                                              |
//+------------------------------------------------------------------+

/*!
   \brief      "".
   \details    . 
   \remark	        (OBJ_EDIT)
               .      
            aName  "_SB",      - "_IT" 
                 .
*/

class CList{
   protected:
      string m_Name;   
      int m_Left;
      int m_Top;
      int m_Width;
      int m_HeightInItems;      
      int m_Height;
      string m_ItemText[];
      int m_SubWindow;
      CVScrollBar m_sb;
      bool m_Visible;
      int m_Selected;
      color m_BgColor;
      color m_TxtColor;
      color m_SelColor;        
      int m_LastSelected;
      bool m_SbVisible;
      int m_FieldsCount;
      bool m_AllowDeselect;
      void Create(){
         int m_w=m_Width;
            if(ArraySize(m_ItemText)>m_HeightInItems){ //  
               m_SbVisible=true; //  
               m_w-=m_sb.Width(); //   
               m_sb.SetPos(m_Left+m_w,m_Top); //   
               m_sb.SetHeight(m_Height);
               m_sb.SetMax(ArraySize(m_ItemText)-m_HeightInItems); //    
               m_sb.SetLageChange(m_HeightInItems); //    
               m_sb.SetSubWindow(m_SubWindow);
                  if(m_sb.Value()>ArraySize(m_ItemText)-m_HeightInItems){ //    
                     m_sb.SetValue(ArraySize(m_ItemText)-m_HeightInItems); 
                  }
               m_w++; //        
            }
            else{ //  
               m_SbVisible=false; //   
               m_sb.SetValue(0); //   
            }
         int s=m_sb.Value(); //      
         int e=MathMin(s+m_HeightInItems,ArraySize(m_ItemText)); //     
         int i=0; //   
         string m_ItemName;
            for(;s<e;s++,i++){ //   
               m_ItemName=m_Name+"_IT("+IntegerToString(i)+")";
               w.Edit(m_ItemName,m_SubWindow,m_Left,m_Top+i*14,m_w,15,m_ItemText[s],m_BgColor,m_TxtColor);
               g.SetReadOnly(m_ItemName,true);
            }  
            for(;i<m_HeightInItems;i++){ //  
               m_ItemName=m_Name+"_IT("+IntegerToString(i)+")";
               w.Edit(m_ItemName,m_SubWindow,m_Left,m_Top+i*14,m_w,15,"",m_BgColor,m_TxtColor);
               g.SetReadOnly(m_ItemName,true);
            }
         m_FieldsCount=m_HeightInItems;
         SelectedON(); //    
      }
      void SelectedON(){
         if(m_Selected>=0){ //   
            m_LastSelected=-1; //  ,    
            int m_Index=m_Selected-m_sb.Value(); //      
               if(m_Index>=0 && m_Index<m_HeightInItems){ //   
                  m_LastSelected=m_Index; // ,    
                  g.SetBgColor(m_Name+"_IT("+IntegerToString(m_Index)+")",m_SelColor); //    
               }
         }      
      }
      void SelectedOFF(){
         if(m_LastSelected>=0){ //    
            g.SetBgColor(m_Name+"_IT("+IntegerToString(m_LastSelected)+")",m_BgColor); //    
            m_LastSelected=-1; // ,    
         }
      }
      void Delete(){
         for(int i=0;i<m_FieldsCount;i++){
            string m_ItemName=m_Name+"_IT("+IntegerToString(i)+")";
            ObjectDelete(0,m_ItemName);
         }  
      }
      void PutValues(){
         int s=m_sb.Value(); //      
         int e=MathMin(s+m_HeightInItems,ArraySize(m_ItemText)); //     
         int i=0; //   
         string m_ItemName;
            for(;s<e;s++,i++){ //   
               m_ItemName=m_Name+"_IT("+IntegerToString(i)+")";
               g.SetText(m_ItemName,m_ItemText[s]);
            }  
            for(;i<m_HeightInItems;i++){ //  
               m_ItemName=m_Name+"_IT("+IntegerToString(i)+")";
               g.SetText(m_ItemName," ");
            }      
      }
   public:
		/*!	
			  .
            \param		string aName="CList" - ,
            \param		int aWidth=100 - ,
            \param		int aHeightInItems=8 -   .
 		*/      
      void Init(string aName="CList",int aWidth=100,int aHeightInItems=8){
         m_Visible=false;
         m_Name=aName; 
         m_Width=aWidth;
         m_HeightInItems=aHeightInItems;         
         m_Left=0;
         m_Top=0;
         ArrayResize(m_ItemText,0);
         //==========================
         m_BgColor=ClrScheme.Color(0);
         m_TxtColor=ClrScheme.Color(1);
         m_SelColor=ClrScheme.Color(14);   
         //==========================      
         m_Height=m_HeightInItems*14+1;
         m_sb.Init(aName+"_SB",m_Height,1);
         m_sb.SetMin(0);
         m_sb.SetValue(0);
         m_sb.SetSmallChange(1);
         m_sb.SetLageChange(aHeightInItems);
         m_Selected=-1;
         m_LastSelected=-1;
         m_SbVisible=false;
         m_AllowDeselect=true;
      }
		/*!	
			     .
            \param		bool aValue - true/false - /.
 		*/       
      void SetAllowDeselect(bool aValue){
         m_AllowDeselect=aValue;
      }
		/*!	
			   .
			\return  bool. True/false - /.
 		*/    		      
      bool AllowDeselect(){
         return(m_AllowDeselect);
      }  
		/*!	
			   .
         \param		string aText - .			
			\remark	      ,    Refresh().
 		*/   
      void AddItem(string aText){
         ArrayResize(m_ItemText,ArraySize(m_ItemText)+1);
         m_ItemText[ArraySize(m_ItemText)-1]=aText;
      }
		/*!	
			   .
         \param		int aIndex -   .			
			\remark	      ,    Refresh().
 		*/        
      void DeleteItem(int aIndex){
         if(aIndex<ArraySize(m_ItemText)){
               for(int i=aIndex;i<ArraySize(m_ItemText)-1;i++){
                  m_ItemText[i]=m_ItemText[i+1];
               }
            ArrayResize(m_ItemText,ArraySize(m_ItemText)-1);
               if(aIndex<m_Selected){
                  m_Selected--;
               }
               else if(aIndex==m_Selected){
                  m_Selected=-1;               
               }
         }            
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/ 
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/       
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }   
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/           
      void SetPosTop(int aTop){
         m_Top=aTop;
      }
		/*!	
			 .
 		*/         
      void Show(){
         m_Visible=true;
         Create();
            if(m_SbVisible){
               m_sb.Show();
            }
            else{
               ChartRedraw(0);
            }               
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/  
      void Show(int aLeft,int aTop){
         SetPos(aLeft,aTop);
         Show();
      }
		/*!	
			   (  ).
 		*/       
      void Hide(){
         m_Visible=false;
         Delete();
            if(m_SbVisible){
               m_sb.Hide();
               m_SbVisible=false;
            }
            else{
               ChartRedraw(0);
            }               
      }
		/*!	
			  .
			\return  bool. True/false - /.
 		*/       
      bool Visible(){
         return(m_Visible);
      }    
		/*!	
			 (     ).
 		*/          
      void Refresh(){
         if(m_Visible){      
            Hide();
            Show();
            ChartRedraw(0);
         }            
      }
		/*!	
			  .
			\return   ( int).
 		*/        
      int Count(){
         return(ArraySize(m_ItemText));
      }
		/*!	
			  .
			\return    ( int),    ,  -1.
 		*/         
      int SelectedIndex(){
         return(m_Selected);
      }
		/*!	
			  .
			\return    ( string),    ,  "".
 		*/       
      string SelectedText(){
         if(m_Selected<0)return("");
         return(m_ItemText[m_Selected]);
      }
		/*!	
			     .
         \param		int aIndex -  .					
			\return   ( string).
 		*/       
      string Text(int aIndex){
         return(m_ItemText[aIndex]);
      }
		/*!	
			 .
         \param		int aIndex -  .					
 		*/        
      void SetSelectedIndex(int aIndex){
         if(aIndex>=-1 && aIndex<ArraySize(m_ItemText)){
            m_Selected=aIndex;
               if(m_Visible){
                  SelectedOFF();
                  SelectedON();
                  ChartRedraw();
               }
         }            
      }
		/*!	
			    .
         \param		int aIndex -  ,
         \param		int aText -  ,
 		*/        
      void SetText(int aIndex,string aText){
         m_ItemText[aIndex]=aText;
            if(m_Visible){
               if(aIndex>=m_sb.Value() && aIndex<m_sb.Value()+m_HeightInItems){
                  g.SetText(m_Name+"_IT("+IntegerToString(aIndex-m_sb.Value())+")",aText);
                  ChartRedraw();
               }
            }
      }
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/  
      void SetWidth(int aValue){
         m_Width=aValue;
      }
		/*!	
			   .
            \param		int aValue -   .
            \remark	      ,    Refresh().
 		*/        
      void SetHeightInItems(int aValue){
         m_HeightInItems=aValue;
         m_Height=m_HeightInItems*14+1;
      }
		/*!	
			 .
			\return   ( int).
 		*/  
      int Width(){
         return(m_Width);
      }  
		/*!	
			 .
			\return   ( int).
 		*/   
      int Height(){
         return(m_Height);
      }
		/*!	
			  X.
			\return   ( int).
 		*/      
      int Left(){
         return(m_Left);      
      }
		/*!	
			  Y.
			\return   ( int).
 		*/  
      int Top(){
         return(m_Top);        
      }
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1     .
 		*/        
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
         int m_event=0;
            if(m_sb.Event(id,lparam,dparam,sparam)==1){
               SelectedOFF();
               PutValues();
               SelectedON();
               ChartRedraw();
            }
            if(id==CHARTEVENT_OBJECT_CLICK){
               if(StringFind(sparam,m_Name+"_IT(",0)==0){
                  int m_Pos1=StringFind(sparam,"_IT(",0);
                  int m_Pos2=StringFind(sparam,")",m_Pos1);
                  int m_Index=m_sb.Value()+(int)StringToInteger(StringSubstr(sparam,m_Pos1+4,m_Pos2-m_Pos1-4));
                     if(m_Index<ArraySize(m_ItemText)){
                        if(m_Index==m_Selected){
                           if(m_AllowDeselect){
                              SetSelectedIndex(-1);
                              m_event=1;
                           }
                        }
                        else{
                           SetSelectedIndex(m_Index);
                           m_event=2;
                        }
                     }
               }
            }
         return(m_event);
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/ 
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               Refresh();
            }
      }   
		/*!	
			    .
			\param string aName -  .
 		*/          
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }    
		/*!	
			    .
			\param int aValue -  .
 		*/          
      void ScrollTo(int aValue){
         if(ArraySize(m_ItemText)>m_HeightInItems){
            aValue=(int)MathMin(ArraySize(m_ItemText)-m_HeightInItems,(int)MathMax(0,aValue));
            m_sb.SetValue(aValue);
               if(m_Visible){
                  SelectedOFF();
                  PutValues();
                  SelectedON();
                  ChartRedraw();
               }               
         }
      }
		/*!	
			    .
			\return   ( int).
 		*/         
      int FirstIndex(){
         return(m_sb.Value());
      }
		/*!	
			 .
         \remark	      ,    Refresh().
 		*/     
      void Clear(){
         ArrayResize(m_ItemText,0);
         m_Selected=-1;
         m_LastSelected=-1;         
      }
		/*!	
			 .
			\param string aValue - .
 		*/         
      void SetTag(string aValue){ //  
         m_sb.SetTag(aValue);
      }
		/*!	
			 .
			\return  ( string).
 		*/         
      string Tag(){ //  
         return(m_sb.Tag());
      }         
};

//+------------------------------------------------------------------+
//|          CListMS                                            |
//+------------------------------------------------------------------+

/*!
   \brief      "   ".
   \details     .    . 
   \remark	        (OBJ_EDIT)
               .      
            aName  "_SB",      - "_IT" 
                 .
*/

class CListMS{
   protected:
      string m_Name;   
      int m_Left;
      int m_Top;
      int m_Width;
      int m_HeightInItems;      
      int m_Height;
      string m_ItemText[];
      bool m_Itemselected[];
      int m_SubWindow;
      CVScrollBar m_sb;
      bool m_Visible;
      color m_BgColor;
      color m_TxtColor;
      color m_SelColor;        
      bool m_SbVisible;
      int m_FieldsCount;
      int m_LastChanged;
      int m_SearchFrom;
      void Create(){
         int m_w=m_Width;
            if(ArraySize(m_ItemText)>m_HeightInItems){ //  
               m_SbVisible=true; //  
               m_w-=m_sb.Width(); //   
               m_sb.SetPos(m_Left+m_w,m_Top); //   
               m_sb.SetHeight(m_Height);
               m_sb.SetMax(ArraySize(m_ItemText)-m_HeightInItems); //    
               m_sb.SetLageChange(m_HeightInItems); //    
               m_sb.SetSubWindow(m_SubWindow);
                  if(m_sb.Value()>ArraySize(m_ItemText)-m_HeightInItems){ //    
                     m_sb.SetValue(ArraySize(m_ItemText)-m_HeightInItems); 
                  }
               m_w++; //        
            }
            else{ //  
               m_SbVisible=false; //   
               m_sb.SetValue(0); //   
            }
         int s=m_sb.Value(); //      
         int e=MathMin(s+m_HeightInItems,ArraySize(m_ItemText)); //     
         int i=0; //   
         string m_ItemName;
            for(;s<e;s++,i++){ //   
               m_ItemName=m_Name+"_IT("+IntegerToString(i)+")";
               color m_Clr=m_BgColor;
               if(m_Itemselected[s])m_Clr=m_SelColor;
               w.Edit(m_ItemName,m_SubWindow,m_Left,m_Top+i*14,m_w,15,m_ItemText[s],m_Clr,m_TxtColor);
               g.SetReadOnly(m_ItemName,true);
            }  
            for(;i<m_HeightInItems;i++){ //  
               m_ItemName=m_Name+"_IT("+IntegerToString(i)+")";
               w.Edit(m_ItemName,m_SubWindow,m_Left,m_Top+i*14,m_w,15,"",m_BgColor,m_TxtColor);
               g.SetReadOnly(m_ItemName,true);
            }
         m_FieldsCount=m_HeightInItems;
      }

      void Delete(){
         for(int i=0;i<m_FieldsCount;i++){
            string m_ItemName=m_Name+"_IT("+IntegerToString(i)+")";
            ObjectDelete(0,m_ItemName);
         }  
      }
      void PutValues(){
         int s=m_sb.Value(); //      
         int e=MathMin(s+m_HeightInItems,ArraySize(m_ItemText)); //     
         int i=0; //   
         string m_ItemName;
            for(;s<e;s++,i++){ //   
               m_ItemName=m_Name+"_IT("+IntegerToString(i)+")";
               g.SetText(m_ItemName,m_ItemText[s]);
               color m_Clr=m_BgColor;
               if(m_Itemselected[s])m_Clr=m_SelColor;   
               g.SetBgColor(m_ItemName,m_Clr);
            }  
            for(;i<m_HeightInItems;i++){ //  
               m_ItemName=m_Name+"_IT("+IntegerToString(i)+")";
               g.SetText(m_ItemName," ");
            }      
      }
   public:
		/*!	
			  .
            \param		string aName="CListMS" - ,
            \param		int aWidth=100 - ,
            \param		int aHeightInItems=8 -   .
 		*/        
      void Init(string aName="CListMS",int aWidth=100,int aHeightInItems=8){
         m_Visible=false;
         m_Name=aName; 
         m_Width=aWidth;
         m_HeightInItems=aHeightInItems;         
         m_Left=0;
         m_Top=0;
         ArrayResize(m_ItemText,0);
         ArrayResize(m_Itemselected,0);
         //==========================
         m_BgColor=ClrScheme.Color(0);
         m_TxtColor=ClrScheme.Color(1);
         m_SelColor=ClrScheme.Color(14);   
         //==========================      
         m_Height=m_HeightInItems*14+1;
         m_sb.Init(aName+"_SB",m_Height,1);
         m_sb.SetMin(0);
         m_sb.SetValue(0);
         m_sb.SetSmallChange(1);
         m_sb.SetLageChange(aHeightInItems);
         m_SbVisible=false;
         m_LastChanged=-1;
         m_SearchFrom=0;
      }
		/*!	
			   .
         \param		string aText - .			
			\remark	      ,    Refresh().
 		*/        
      void AddItem(string aText){
         ArrayResize(m_ItemText,ArraySize(m_ItemText)+1);
         m_ItemText[ArraySize(m_ItemText)-1]=aText;
         ArrayResize(m_Itemselected,ArraySize(m_Itemselected)+1);
         m_Itemselected[ArraySize(m_Itemselected)-1]=false;         
      }
		/*!	
			   .
         \param		int aIndex -   .			
			\remark	      ,    Refresh().
 		*/       
      void DeleteItem(int aIndex){
         if(aIndex<ArraySize(m_ItemText)){
               for(int i=aIndex;i<ArraySize(m_ItemText)-1;i++){
                  m_ItemText[i]=m_ItemText[i+1];
                  m_Itemselected[i]=m_Itemselected[i+1];
               }
            ArrayResize(m_ItemText,ArraySize(m_ItemText)-1);
            ArrayResize(m_Itemselected,ArraySize(m_Itemselected)-1);
         }            
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/       
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/       
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }   
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/            
      void SetPosTop(int aTop){
         m_Top=aTop;
      }
		/*!	
			 .
 		*/        
      void Show(){
         m_Visible=true;
         Create();
            if(m_SbVisible){
               m_sb.Show();
            }
            else{
               ChartRedraw(0);
            }               
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/        
      void Show(int aLeft,int aTop){
         SetPos(aLeft,aTop);
         Show();
      }
		/*!	
			   (  ).
 		*/       
      void Hide(){
         m_Visible=false;
         Delete();
            if(m_SbVisible){
               m_sb.Hide();
               m_SbVisible=false;
            }
            else{
               ChartRedraw(0);
            }               
      }
		/*!	
			  .
			\return  bool. True/false - /.
 		*/        
      bool Visible(){
         return(m_Visible);
      }  
		/*!	
			 (     ).
 		*/            
      void Refresh(){
         if(m_Visible){      
            Hide();
            Show();
            ChartRedraw(0);
         }            
      }
		/*!	
			  .
			\return   ( int).
 		*/        
      int Count(){
         return(ArraySize(m_ItemText));
      }
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/  
      void SetWidth(int aValue){
         m_Width=aValue;
      }
		/*!	
			   .
            \param		int aValue -   .
            \remark	      ,    Refresh().
 		*/  
      void SetHeightInItems(int aValue){
         m_HeightInItems=aValue;
         m_Height=m_HeightInItems*14+1;
      }
		/*!	
			 .
			\return   ( int).
 		*/  
      int Width(){
         return(m_Width);
      }   
		/*!	
			 .
			\return   ( int).
 		*/ 
      int Height(){
         return(m_Height);
      }
		/*!	
			  X.
			\return   ( int).
 		*/ 
      int Left(){
         return(m_Left);      
      }
		/*!	
			  Y.
			\return   ( int).
 		*/ 
      int Top(){
         return(m_Top);        
      }
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1     .
 		*/   
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
         int m_event=0;
            if(m_sb.Event(id,lparam,dparam,sparam)==1){
               PutValues();
               ChartRedraw();
            }
            if(id==CHARTEVENT_OBJECT_CLICK){
               if(StringFind(sparam,m_Name+"_IT(",0)==0){
                  int m_Pos1=StringFind(sparam,"_IT(",0);
                  int m_Pos2=StringFind(sparam,")",m_Pos1);
                  int m_Index=m_sb.Value()+(int)StringToInteger(StringSubstr(sparam,m_Pos1+4,m_Pos2-m_Pos1-4));
                  SetSelected(m_Index,!Selected(m_Index));
                     if(Selected(m_Index)){
                        m_event=2;
                     }
                     else{
                        m_event=1;                     
                     }
               }
            }
         return(m_event);
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/       
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               Refresh();
            }
      }   
		/*!	
			    .
			\param string aName -  .
 		*/             
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }    
		/*!	
			    .
			\param int aValue -  .
 		*/         
      void ScrollTo(int aValue){
         if(ArraySize(m_ItemText)>m_HeightInItems){
            aValue=(int)MathMin(ArraySize(m_ItemText)-m_HeightInItems,(int)MathMax(0,aValue));
            m_sb.SetValue(aValue);
               if(m_Visible){
                  PutValues();
                  ChartRedraw();
               }               
         }
      }
		/*!	
			    .
			\return   ( int).
 		*/       
      int FirstIndex(){
         return(m_sb.Value());
      }
		/*!	
			 .
         \remark	      ,    Refresh().
 		*/        
      void Clear(){
         ArrayResize(m_ItemText,0);
         ArrayResize(m_Itemselected,0);
      }
		/*!	
			 .
			\param string aValue - .
 		*/         
      void SetTag(string aValue){ //  
         m_sb.SetTag(aValue);
      }
		/*!	
			 .
			\return  ( string).
 		*/   
      string Tag(){ //  
         return(m_sb.Tag());
      }   
		/*!	
			    .
         \param		int aIndex -  ,
         \param		int aText -  ,
 		*/                
      void SetText(int aIndex,string aText){
         m_ItemText[aIndex]=aText;
            if(m_Visible){
               if(aIndex>=m_sb.Value() && aIndex<m_sb.Value()+m_HeightInItems){
                  g.SetText(m_Name+"_IT("+IntegerToString(aIndex-m_sb.Value())+")",aText);
                  ChartRedraw();
               }
            }
      }
		/*!	
			     .
         \param		int aIndex -  .					
			\return   ( string).
 		*/         
      string Text(int aIndex){
         return(m_ItemText[aIndex]);
      }
		/*!	
			   .
         \param		int aIndex -  .					
 		*/        
      void SetSelected(int aIndex,bool aSelected){
            if(aIndex<0 || aIndex>=ArraySize(m_Itemselected)){
               return;
            }
         m_Itemselected[aIndex]=aSelected;
         m_LastChanged=aIndex;
            if(m_Visible){
               if(aIndex>=m_sb.Value() && aIndex<m_sb.Value()+m_HeightInItems){
                  color m_Clr=m_BgColor;
                  if(aSelected)m_Clr=m_SelColor;               
                  g.SetBgColor(m_Name+"_IT("+IntegerToString(aIndex-m_sb.Value())+")",m_Clr);
                  ChartRedraw();
               }
            }
      }
		/*!	
			 .
         \param		int aIndex -  .					
         \return  bool. True/false - / 
 		*/         
      bool Selected(int aIndex){
            if(aIndex>=0 && aIndex<ArraySize(m_Itemselected)){
               return(m_Itemselected[aIndex]);
            }
         return(false);            
      }
		/*!	
			  ,         .
         \return   ( int).
 		*/ 
      int LastChanged(){
         return(m_LastChanged);
      }
		/*!	
			   .
         \return   ( int).
 		*/       
      int FirstSelected(){
         m_SearchFrom=0;
         return(NextSelected());
      }
		/*!	
			    (       FirstSelected()  NextSelected()).
         \return   ( int).
 		*/       
      int NextSelected(){
            for(int i=m_SearchFrom;i<ArraySize(m_ItemText);i++){
               if(m_Itemselected[i]){
                  m_SearchFrom=i+1;
                  return(i);
               }
            }
         return(-1);
      }
      /*
         //      
         int Selected=lstm.FirstSelected();
            while(Selected!=-1){
               //=======================================
               // -    
               Alert(Selected);
               // ======================================
               Selected=lstm.NextSelected();
            }      
      */     
};

//+------------------------------------------------------------------+
//|          CComBox                                            |
//+------------------------------------------------------------------+

/*!
   \brief      "".
   \details    . 
   \remark	       "",
               OBJ_EDIT (  ,  
             ).       aName "_Lst",
              - "_E",  - "_B".
*/

class CComBox{
   protected:
      int m_Left;
      int m_Top;
      int m_Width;   
      bool m_Visible;
      string m_Value;
      int m_SubWindow;    
      int m_NpCnt;  
      bool m_ReadOnly;      
      string m_Name;
      string m_NameEdit;
      string m_NameButton;
      string m_NameList;
      string m_ExName[6];
      CList m_lst;
      color m_BgColor;
      color m_TxtColor;
      color m_ButTxtColor;
      color m_ButBgColor;
      color m_FlashColor;
      color m_WarningColor;
      bool m_Warning;
      string m_NameLbl;
      string m_Caption;
      color m_LblColor;
      void Flash(string aName,color aFlash,color aNormal){
         g.SetBgColor(aName,aFlash);
         g.Redraw();
         Sleep(100);
         g.SetBgColor(aName,aNormal);
         g.Redraw();      
      }     
      void Create(){
         color m_tcol=m_BgColor;
         if(m_Warning)m_tcol=m_WarningColor;
         w.Edit(m_NameEdit,m_SubWindow,m_Left,m_Top,m_Width-12,15,m_Value,m_tcol,m_TxtColor);
         g.Attach(m_NameEdit);
         g.SetReadOnly(m_ReadOnly);
         w.Edit(m_NameButton,m_SubWindow,m_Left+m_Width-13,m_Top,13,15," \/",m_ButBgColor,m_ButTxtColor,6);
         g.SetReadOnly(m_NameButton,true);
         m_lst.SetSubWindow(m_SubWindow);
         int m_center=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,m_SubWindow)/2;
            if(m_Top-7>m_center){
               m_lst.SetPos(m_Left,m_Top-m_lst.Height()+1); 
            }
            else{
                m_lst.SetPos(m_Left,m_Top+14);             
            }   
            if(m_Caption!=""){ //  
               w.Label(m_NameLbl,m_SubWindow,m_Left+m_Width+1,m_Top+2,m_Caption,m_LblColor,7,"Arial"); //  
            }
      }    
      void Delete(){
         ObjectDelete(0,m_NameEdit);
         ObjectDelete(0,m_NameButton);
         ObjectDelete(0,m_NameLbl);         
      }
   public:
		/*!	
			  .
            \param		string aName="CComBox" - ,
            \param		int aWidth=100 - ,
            \param		string aCaption="CComBox" -  .
 		*/      
      void Init(string aName="CComBox",int aWidth=100,string aCaption="CComBox"){
         m_Visible=false;
         m_Width=aWidth;
         m_Name=aName;
         m_ReadOnly=true;
         m_SubWindow=0;
         m_NpCnt=0;     
         m_Warning=false;    
         m_NameEdit=m_Name+"_E";
         m_NameButton=m_Name+"_B";
         m_NameList=aName+"_Lst";   
         m_NameLbl=aName+"_L";  
         m_ExName[0]=m_Name+"_Lst_SB_LB";
         m_ExName[1]=m_Name+"_Lst_SB_UB";
         m_ExName[2]=m_Name+"_Lst_SB_S";
         m_ExName[3]=m_Name+"_Lst_SB_LF";
         m_ExName[4]=m_Name+"_Lst_SB_UF";
         m_ExName[5]=m_Name+"_B";
         m_Caption=aCaption;
         m_lst.Init(m_NameList,aWidth,1);
         m_lst.SetAllowDeselect(false);
         m_BgColor=ClrScheme.Color(0);       //    
         m_TxtColor=ClrScheme.Color(1);      //    
         m_ButTxtColor=ClrScheme.Color(1);   //    ,      
         m_ButBgColor=ClrScheme.Color(4);    //  ,   
         m_FlashColor=ClrScheme.Color(5);    //  ,   
         m_WarningColor=ClrScheme.Color(3);  //  
         m_LblColor=ClrScheme.Color(2);      //  
      }
		/*!	
			 .
         \remark	      ,    Refresh().
 		*/         
      void Clear(){
         m_lst.Clear();
         m_lst.SetHeightInItems(1); 
         m_Value="";
      }   
		/*!	
			   .
         \param		string aText - .			
			\remark	      ,    Refresh().
 		*/            
      void AddItem(string aItem){
         m_lst.AddItem(aItem);
         m_lst.SetHeightInItems((int)MathMin(8,m_lst.Count()));           
      }
		/*!	
			   .
         \param		int aIndex -   .			
			\remark	      ,    Refresh().
 		*/       
      void DeleteItem(int aIndex){
         m_lst.DeleteItem(aIndex);
         m_lst.SetHeightInItems((int)MathMin(8,m_lst.Count()));           
      }   
		/*!	
			  .
			\return   ( int).
 		*/        
      int Count(){
         return(m_lst.Count());
      }
		/*!	
			 .
         \param		int aIndex -  .					
 		*/         
      void SetSelectedIndex(int aIndex){
         m_lst.SetSelectedIndex(aIndex);
         m_lst.ScrollTo(aIndex);
         m_Value=m_lst.SelectedText();
            if(m_Visible){
               g.SetText(m_NameEdit,m_Value);
               g.Redraw();
            }
      }
		/*!	
			 .
         \param		string aValue - .					
 		*/       
      void SetValue(string aValue){
            for(int i=0;i<m_lst.Count();i++){
               if(aValue==m_lst.Text(i)){
                  SetSelectedIndex(i);
                  return;
               }
            }
         m_lst.SetSelectedIndex(-1);
         m_lst.ScrollTo(0);
         m_Value=aValue;
            if(m_Visible){
               g.SetText(m_NameEdit,m_Value);
               g.Redraw();            
            }
      }
		/*!	
			    .
         \param		int aIndex -  ,
         \param		int aText -  ,
 		*/       
      void SetText(int aIndex,string aText){
         m_lst.SetText(aIndex,aText);
            if(aIndex==m_lst.SelectedIndex()){
               m_Value=aText;
                  if(m_Visible){
                     g.SetText(m_NameEdit,m_Value);
                     g.Redraw();            
                  }
            }
      }
		/*!	
			 .
 		*/        
      void Show(){
         m_Visible=true;
         Create();
         ChartRedraw();
      }  
		/*!	
			  .
			\return  bool. True/false - /.
 		*/        
      bool Visible(){
         return(m_Visible);
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/       
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }      
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosTop(int aTop){
         m_Top=aTop;
      }   
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/        
      void Show(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
         Show();
      }   
		/*!	
			   (  ).
 		*/          
      void Hide(){
         m_Visible=false;
         Delete();
            if(m_lst.Visible()){
               m_lst.Hide();
            }
            else{               
               ChartRedraw(); 
            }               
      }
		/*!	
			 (     ).
 		*/         
      void Refresh(){
         if(m_Visible){
            Delete();
            Create();
            m_lst.Hide();
            ChartRedraw();         
         }            
      }
		/*!	
			  "  ".
			\param int aValue - true/false -  / .
 		*/        
      void SetReadOnly(bool aValue){
         m_ReadOnly=aValue;
            if(m_Visible){
               g.Attach(m_NameEdit);
               g.SetReadOnly(m_ReadOnly);
               g.Redraw();
            }
      }
		/*!	
			  "  ".
			\return  bool. True/false -  / .
 		*/        
      bool ReadOnly(){
         return(m_ReadOnly);
      }
		/*!	
			  .
			\return    ( int),    ,  -1.
 		*/        
      int SelectedIndex(){
         return(m_lst.SelectedIndex());
      }
		/*!	
			  .
			\return    ( string),    ,  "".
 		*/        
      string SelectedText(){
         return(m_lst.SelectedText());
      }  
		/*!	
			   .
			\return  ( string).
 		*/         
      string Value(){
         return(m_Value);
      } 
		/*!	
			 .
			\return   ( int).
			\remark     .
 		*/        
      int Width(){
         return(m_Width);
      }  
		/*!	
			 .
			\return   ( int).
 		*/          
      int Height(){
         return(15);
      }
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){
         return(m_Left);      
      }
		/*!	
			  Y.
			\return   ( int).
 		*/       
      int Top(){
         return(m_Top);        
      }
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1     .
 		*/       
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
         int m_event=0;
            if(sparam==""){
               m_NpCnt++;
                  if(m_NpCnt>1){
                     m_lst.Hide();
                  }
            }
            else{
               m_NpCnt=0;
                  if(m_lst.Event(id,lparam,dparam,sparam)==2){
                     g.Attach(m_NameEdit);
                        if(m_lst.SelectedText()!=g.Text()){
                           m_event=1;
                           g.SetText(m_lst.SelectedText());
                           m_Value=g.Text();
                           g.Redraw();
                           
                           Sleep(100);
                        }
                  }
                  if(id==CHARTEVENT_OBJECT_ENDEDIT){
                     if(sparam==m_NameEdit){
                        g.Attach(m_NameEdit);
                           if(m_Value!=g.Text()){
                              m_event=1;
                              m_Value=g.Text();
                              m_lst.SetSelectedIndex(-1);
                                 for(int i=0;i<m_lst.Count();i++){
                                    if(m_Value==m_lst.Text(i)){
                                       m_lst.SetSelectedIndex(i);
                                       m_lst.ScrollTo(i);
                                       break;
                                    }
                                 }
                              
                           }
                     }                        
                  }
                  if(id==CHARTEVENT_OBJECT_CLICK){
                     if(sparam==m_NameButton){
                        Flash(m_NameButton,m_FlashColor,m_ButBgColor);
                           if(m_lst.Visible()){
                              m_lst.Hide();
                           }
                           else{
                              m_lst.Show();
                           }
                     }

                  } 
                  if(
                     !(sparam==m_ExName[0] ||
                     sparam==m_ExName[1] ||
                     sparam==m_ExName[2] ||
                     sparam==m_ExName[3] ||
                     sparam==m_ExName[4] ||
                     sparam==m_ExName[5])
                  ){
                     if(m_lst.Visible()){
                        m_lst.Hide();
                     }           
                  }                                            
            
            }
          return(m_event);
      } 
		/*!	
			   .
			\param int aNumber -  .
 		*/       
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               Refresh();
            }
      }    
		/*!	
			    .
			\param string aName -  .
 		*/              
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      } 
		/*!	
			 .
			\param string aValue - .
 		*/       
      void SetTag(string aValue){
         m_lst.SetTag(aValue);
      }
		/*!	
			 .
			\return  ( string).
 		*/       
      string Tag(){ 
         return(m_lst.Tag());
      }   
		/*!	
			/  .
			\param bool aValue - true/false (/). 
 		*/        
      void SetWarning(bool aValue){
            if(m_Visible){
               if(aValue){
                  if(!m_Warning){
                     g.Attach(m_NameEdit);
                     g.SetBgColor(m_WarningColor); 
                  }
               }
               else{
                  if(m_Warning){
                     g.Attach(m_NameEdit);
                     g.SetBgColor(m_BgColor);
                  }
               }
            }
         m_Warning=aValue;
      }
		/*!	
			  .
			\return  bool. True/false - /.
 		*/        
      bool Warning(){
         return(m_Warning);
      }                     
};

//+------------------------------------------------------------------+
//|          CHMenu                                             |
//+------------------------------------------------------------------+

/*!
   \brief      " ".
   \details    . 
   \remark	      
            " " (OBJ_EDIT),     :
              ,    "" ,   
             "" ,   .   
              .      aName :
            "_LBB", "_LBS", "_RBS", "_RBB",    - "_IC"  
               .
*/

class CHMenu{
   private:
      bool m_Visible;
      string m_Name;
      int m_Left;
      int m_Top;
      int m_Width;
      int m_VisItems;
      int m_DefVisItems;
      int m_Start;
      string m_Items[];
      bool m_Checked[];
      int m_SubWindow;
      string m_NameLBB;
      string m_NameLBS;      
      string m_NameRBB;
      string m_NameRBS;    
      string m_Tag;   
      color m_BgColorOn;
      color m_BgColorOf;
      color m_BgColor;
      color m_TxtColor;
      color m_ButTxtColor;
      color m_ButBgColor;
      color m_ButFlashColor;
      color m_ItemFlashColor;
      color m_WarningColor;
      color m_CheckColor;
      int m_CheckCnt;
      int m_LastClickedX;
      int m_LastClickedY;
      int m_LastClickedQuarter;   
      int m_LastClickedW; 
      string m_LastClickedName1;  
      string m_LastClickedName2; 
      void ScrollTo(){
         if(m_Visible){
            if(ArraySize(m_Items)>0){
               string m_stri;
                  for(int i=0;i<m_VisItems;i++){
                     m_stri=IntegerToString(i);
                     g.Attach(m_Name+"_IT("+m_stri+")");
                     int j=i+m_Start;
                        if(j<ArraySize(m_Items)){
                           g.SetText("    "+m_Items[j]);
                        }
                        else{
                           g.SetText("");
                        }
                     g.Attach(m_Name+"_IC("+m_stri+")");                     
                        if(m_Checked[j]){
                           g.SetText(CharToString(252));
                        }
                        else{
                           g.SetText(" ");
                        }
                  }
            }               
         }
      }
      void Delete(){
         string m_stri;
            for(int i=0;i<m_VisItems;i++){
               m_stri=IntegerToString(i);
               ObjectDelete(0,m_Name+"_IT("+m_stri+")");
               ObjectDelete(0,m_Name+"_IC("+m_stri+")");
            }
         ObjectDelete(0,m_NameLBB);
         ObjectDelete(0,m_NameLBS);
         ObjectDelete(0,m_NameRBS);
         ObjectDelete(0,m_NameRBB);
      }   
      void DefineBgColor(){
         if(m_CheckCnt>0){
            m_BgColor=m_BgColorOn;
            m_ItemFlashColor=m_BgColorOf;
         }
         else{
            m_BgColor=m_BgColorOf;            
            m_ItemFlashColor=m_BgColorOn;
         }        
      }
      void SetBgColor(){
         DefineBgColor();
            for(int i=0;i<m_VisItems;i++){
               string m_stri=IntegerToString(i);
               g.SetBgColor(m_Name+"_IT("+m_stri+")",m_BgColor);
            }
      }      
      void Create(){
         DefineBgColor();
         w.Edit(m_NameLBB,m_SubWindow,m_Left,m_Top,9,15,"I",m_ButBgColor,m_ButTxtColor,7,"Arial");
         g.SetReadOnly(m_NameLBB,true);
         w.Edit(m_NameLBS,m_SubWindow,m_Left+8,m_Top,11,15,"<",m_ButBgColor,m_ButTxtColor,7,"Arial");
         g.SetReadOnly(m_NameLBS,true);
         w.Edit(m_NameRBS,m_SubWindow,m_Left+m_Width-19,m_Top,11,15,">",m_ButBgColor,m_ButTxtColor,7,"Arial");
         g.SetReadOnly(m_NameRBS,true);
         w.Edit(m_NameRBB,m_SubWindow,m_Left+m_Width-9,m_Top,9,15,"I",m_ButBgColor,m_ButTxtColor,7,"Arial");
         g.SetReadOnly(m_NameRBB,true);
         int m_tw=(m_Width-40)/m_VisItems;   
         string m_stri;      
         int m_z3=0;
            for(int i=0;i<m_VisItems;i++){
               int m_z1=i*(m_Width-40+2)/m_VisItems;
               int m_z2=(i+1)*(m_Width-40+2)/m_VisItems;
               m_stri=IntegerToString(i);
               m_z3=m_Left+18+m_z1;
               w.Edit(m_Name+"_IT("+m_stri+")",m_SubWindow,m_z3,m_Top,(m_z2-m_z1+1),15,"",m_BgColor,m_TxtColor);
               g.SetReadOnly(m_Name+"_IT("+m_stri+")",true);
               w.Label(m_Name+"_IC("+m_stri+")",m_SubWindow,m_Left+18+m_z1+3,m_Top+2," ",m_CheckColor,9,"Wingdings"); 
            }
            if(m_VisItems>0){
               m_stri=IntegerToString(m_VisItems-1);
               g.Attach(m_Name+"_IT("+m_stri+")");
               g.SetXSize(m_Left+m_Width-18-m_z3);
            }
      }   
      void Flash(string aName,color aFlash,color aNormal){
         g.SetBgColor(aName,aFlash);
         g.Redraw();
         Sleep(100);
         g.SetBgColor(aName,aNormal);
         g.Redraw();      
      }        
   public:
		/*!	
			  .
            \param		string aName="CHMenu" - ,
            \param		int aWidth=100 - ,
            \param		int aVisibleItems=3 -   .
 		*/     
      void Init(string aName="CHMenu",int aWidth=300,int aVisibleItems=3){
         m_BgColorOn=ClrScheme.Color(15);
         m_BgColorOf=ClrScheme.Color(16);
         m_TxtColor=ClrScheme.Color(1);
         m_ButTxtColor=ClrScheme.Color(1);
         m_ButBgColor=ClrScheme.Color(4);
         m_ButFlashColor=ClrScheme.Color(5);
         m_WarningColor=ClrScheme.Color(3); 
         m_CheckColor=ClrScheme.Color(17);
         m_BgColor=m_BgColorOf;
         m_ItemFlashColor=m_BgColorOn;
         m_SubWindow=0;
         m_Visible=false;
         m_Name=aName;
         m_NameLBB=m_Name+"_LBB";
         m_NameLBS=m_Name+"_LBS";      
         m_NameRBB=m_Name+"_RBB";
         m_NameRBS=m_Name+"_RBS";              
         m_Width=aWidth;
         m_VisItems=aVisibleItems;
         m_DefVisItems=aVisibleItems;
         m_Start=0;
         ArrayResize(m_Items,0);
         ArrayResize(m_Checked,0);
         m_Tag="";
         m_CheckCnt=0;
         m_LastClickedX=-1;
         m_LastClickedY=-1;
         m_LastClickedQuarter=-1;
         m_LastClickedW=-1;
         m_LastClickedName1="";
         m_LastClickedName2="";
      }
		/*!	
			   .
         \param		string aText - .			
			\remark	      ,    Refresh().
 		*/      
      void AddItem(string aItem,bool aChecked=false){
         ArrayResize(m_Items,ArraySize(m_Items)+1);
         m_Items[ArraySize(m_Items)-1]=aItem;
         m_VisItems=MathMin(m_DefVisItems,ArraySize(m_Items));
         ArrayResize(m_Checked,ArraySize(m_Checked)+1);
         m_Checked[ArraySize(m_Checked)-1]=aChecked;  
         if(aChecked)m_CheckCnt++;       
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/  
      void Show(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
         Show();
      }
		/*!	
			 .
 		*/       
      void Show(){
         m_Visible=true;
         Create();
         ScrollTo();
         ChartRedraw();
      }
		/*!	
			   (  ).
 		*/         
      void Hide(){
         m_Visible=false;
         Delete();
         ChartRedraw();
      }
		/*!	
			 (     ).
 		*/  
      void Refresh(){
         if(m_Visible){
            Delete();
            Show();
         }            
      }   
		/*!	
			  .
			\return  bool. True/false - /.
 		*/       
      bool Visible(){
         return(m_Visible);
      }
		/*!	
			  .
         \param		int aIndex -  ,
         \param		bool aValue - true/false,    "",
 		*/  
      void SetChecked(int aIndex,bool aValue){
            if(m_Checked[aIndex] && !aValue){
               m_CheckCnt--; 
            }
            if(!m_Checked[aIndex] && aValue){
               m_CheckCnt++; 
            }            
         m_Checked[aIndex]=aValue;
            if(m_Visible){
               SetBgColor();
               int m_n=aIndex-m_Start;
                  if(m_n>=0 && m_n<m_VisItems){
                     g.Attach(m_Name+"_IC("+IntegerToString(m_n)+")");
                        if(aValue){
                           g.SetText(CharToString(252));   
                        }
                        else{
                           g.SetText(" ");   
                        }
                  }
               ChartRedraw();                  
            }
      }
		/*!	
			    .
         \param		int aIndex -  .	
         \return   bool. True/false - / .				
 		*/        
      bool Checked(int aIndex){
         return(m_Checked[aIndex]);
      }  
		/*!	
			   .
         \return   bool. True/false -   /.				
 		*/        
      bool CheckedExist(){
         return(m_CheckCnt>0);
      }
		/*!	
			     .
         \param		int aIndex -  .					
			\return   ( string).
 		*/   
      string Text(int aIndex){
         return(m_Items[aIndex]);
      }  
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/ 
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/  
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }  
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/    
      void SetPosTop(int aTop){
         m_Top=aTop;
      }   
		/*!	
			 .
			\return   ( int).
 		*/    
      int Width(){
         return(m_Width);
      }  
		/*!	
			 .
			\return   ( int).
 		*/  
      int Height(){
         return(15);
      }
		/*!	
			  X.
			\return   ( int).
 		*/ 
      int Left(){
         return(m_Left);      
      }
		/*!	
			  Y.
			\return   ( int).
 		*/ 
      int Top(){
         return(m_Top);        
      }
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  -1 -  .  0   -       .
 		*/         
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
         int m_rv=-1;
            if(id==CHARTEVENT_OBJECT_CLICK){
               if(sparam==m_NameLBB){
                  if(m_Start>0){
                     Flash(m_NameLBB,m_ButFlashColor,m_ButBgColor);
                     m_Start=0;
                     ScrollTo();
                     ChartRedraw();
                  }
                  else{
                     Flash(m_NameLBB,m_WarningColor,m_ButBgColor);
                  }
               }
               if(sparam==m_NameLBS){
                  if(m_Start>0){
                     Flash(m_NameLBS,m_ButFlashColor,m_ButBgColor);                
                     m_Start-=m_VisItems;
                     if(m_Start<0)m_Start=0;
                     ScrollTo();
                     ChartRedraw();
                  }
                  else{
                     Flash(m_NameLBS,m_WarningColor,m_ButBgColor);
                  }                  
               }               
               
               if(sparam==m_NameRBB){
                  if(m_Start<ArraySize(m_Items)-m_VisItems){
                     Flash(m_NameRBB,m_ButFlashColor,m_ButBgColor);                 
                     m_Start=ArraySize(m_Items)-m_VisItems;
                     ScrollTo();
                     ChartRedraw();
                  }
                  else{
                     Flash(m_NameRBB,m_WarningColor,m_ButBgColor);
                  }                  
               }

               if(sparam==m_NameRBS){
                  if(m_Start<ArraySize(m_Items)-m_VisItems){
                     Flash(m_NameRBS,m_ButFlashColor,m_ButBgColor);              
                     m_Start+=m_VisItems;
                     m_Start=MathMin(m_Start,ArraySize(m_Items)-m_VisItems);
                     ScrollTo();
                     ChartRedraw();
                  }
                  else{
                     Flash(m_NameRBS,m_WarningColor,m_ButBgColor);
                  }                  
               }               
               if(StringFind(sparam,m_Name+"_I",0)==0){
                  int m_pos=StringFind(sparam,"(",0);
                  string m_oi=StringSubstr(sparam,m_pos+1,StringLen(sparam)-m_pos-2);
                  m_LastClickedName1=m_Name+"_IT("+m_oi+")";
                  m_LastClickedName2=m_Name+"_IC("+m_oi+")";
                  int m_index=m_Start+(int)StringToInteger(m_oi);
              
                  g.Attach(m_LastClickedName1);
                  m_LastClickedX=g.XDistance();
                  m_LastClickedY=g.YDistance();
                  m_LastClickedW=g.XSize();
                  
                  int m_ocx=g.XDistance()+g.XSize()/2;
                  int m_ocy=g.YDistance()+g.YSize()/2;
                  int m_ccx=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,m_SubWindow)/2;
                  int m_ccy=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,m_SubWindow)/2;
                     if(m_ocy<m_ccy){
                        if(m_ocx<m_ccx){
                           m_LastClickedQuarter=1;
                        }
                        else{
                           m_LastClickedQuarter=2;
                        }
                     }
                     else{
                        if(m_ocx<m_ccx){
                           m_LastClickedQuarter=3;
                        }
                        else{
                           m_LastClickedQuarter=4;                        
                        }                     
                     }
                  Flash(m_LastClickedName1,m_ItemFlashColor,m_BgColor);
                  return(m_index);
               }
            }
         return(m_rv);
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/       
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               Refresh();
            }
      }      
		/*!	
			    .
			\param string aName -  .
 		*/   
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      } 
		/*!	
			 .
			\param string aValue - .
 		*/          
      void SetTag(string aValue){
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/       
      string Tag(){ 
         return(m_Tag);
      }  
		/*!	
			  ,     .
			\return  ( int).
 		*/  
      int LastClickedX(){
         return(m_LastClickedX);
      }  
		/*!	
			 Y ,     .
			\return  ( int).
 		*/           
      int LastClickedY(){
         return(m_LastClickedY);
      }
		/*!	
			     ,     .
			\return  ( int). 1 -  , 2 -  , 3 -  , 4 -  .
 		*/        
      int LastClickedQuarter(){
         return(m_LastClickedQuarter);
      }     
		/*!	
			 ,     .
			\return  ( int).
 		*/        
      int LastClickedW(){
         return(m_LastClickedW);
      }  
		/*!	
			   ,     .
			\return    ( string).
 		*/   
      string LastClickedName1(){
         return(m_LastClickedName1);
      }
		/*!	
			    ""      .
			\return   ( string).
 		*/       
      string LastClickedName2(){
         return(m_LastClickedName2);
      } 
		/*!	
			 X       .
			\param int aWidth -   .
			\return  X ( int).
 		*/   
      int SolvePosLeft(int aWidth){
            if(m_LastClickedQuarter==2 || m_LastClickedQuarter==4){
               return(m_LastClickedX+m_LastClickedW-aWidth);
            }
         return(m_LastClickedX);
      }
		/*!	
			 Y       .
			\param int aHeight -   .
			\return  Y ( int).
 		*/        
      int SolvePosTop(int aHeight){
            if(m_LastClickedQuarter==3 || m_LastClickedQuarter==4){
               return(m_LastClickedY-aHeight+1);
            }
         return(m_LastClickedY+Height()-1);            
      }
};

//+------------------------------------------------------------------+
//|          CVMenu                                             |
//+------------------------------------------------------------------+

/*!
   \brief      " ".
   \details    . 
   \remark	      
            " " (OBJ_EDIT)    " 
             ".       aName
             "_SB",    - "IT"     
             .
*/

class CVMenu{
   protected:
      string m_ItemText[];
      bool m_Checked[];
      string m_Name;
      int m_Left;
      int m_Top;
      int m_Width;
      int m_HeightInItems;
      int m_DefHeightInItems;
      int m_Start;
      CVScrollBar m_sb;
      bool m_Visible;
      color m_BgColorOn;
      color m_BgColorOf;
      color m_BgColor;
      color m_TxtColor;
      color m_ButTxtColor;
      color m_ButBgColor;
      color m_ButFlashColor;
      color m_ItemFlashColor;
      color m_WarningColor;
      color m_CheckColor;
      int m_SubWindow;
      int m_CheckCnt;
      string m_Tag;
      int m_LastClickedX;
      int m_LastClickedY;
      int m_LastClickedQuarter;   
      int m_NpCnt;   
      string m_ExName[]; 
      string m_LastClickedName1;
      string m_LastClickedName2;
      void ScrollTo(){
         for(int i=0;i<m_HeightInItems;i++){
            int j=m_Start+i;
               if(j<ArraySize(m_ItemText)){
                  g.Attach(m_Name+"_IT("+IntegerToString(i)+")");
                  g.SetText("    "+m_ItemText[j]);
                  string m_chtxt=" ";
                     if(m_Checked[j]){                     
                        m_chtxt=CharToString(252);
                     }
                  g.Attach(m_Name+"_IC("+IntegerToString(i)+")");
                  g.SetText(m_chtxt);
               }
               else{
                  g.Attach(m_Name+"_IT("+IntegerToString(i)+")");
                  g.SetText(" ");
                  g.Attach(m_Name+"_IC("+IntegerToString(i)+")");
                  g.SetText(" ");                  
               }
         }
      }   
      void DefineBgColor(){
         if(m_CheckCnt>0){
            m_BgColor=m_BgColorOn;
            m_ItemFlashColor=m_BgColorOf;
         }
         else{
            m_BgColor=m_BgColorOf;            
            m_ItemFlashColor=m_BgColorOn;
         }        
      }
      void SetBgColor(){
         DefineBgColor();
            for(int i=0;i<m_HeightInItems;i++){
               string m_stri=IntegerToString(i);
               g.SetBgColor(m_Name+"_IT("+m_stri+")",m_BgColor);
            }
      }  

      void Create(){
         m_NpCnt=0;
         DefineBgColor();
         int m_w=m_Width;
            if(ArraySize(m_ItemText)>m_HeightInItems){
               m_w=m_Width-m_sb.Width();
               m_sb.Show(m_Left+m_w,m_Top);
               m_w++;
            }      
            for(int i=0;i<m_HeightInItems;i++){
               w.Edit(m_Name+"_IT("+IntegerToString(i)+")",m_SubWindow,m_Left,m_Top+i*14,m_w,15," ",m_BgColor,m_TxtColor,7,"Arial");
               g.SetReadOnly(m_Name+"_IT("+IntegerToString(i)+")",true);
               w.Label(m_Name+"_IC("+IntegerToString(i)+")",m_SubWindow,m_Left+3,m_Top+i*14+2," ",m_CheckColor,9,"Wingdings");                     
            }
         m_sb.SetSubWindow(m_SubWindow);            
      }
      void Delete(){
         for(int i=0;i<m_HeightInItems;i++){
            ObjectDelete(0,m_Name+"_IT("+IntegerToString(i)+")");
            ObjectDelete(0,m_Name+"_IC("+IntegerToString(i)+")");               
         }
      }
      void Flash(string aName,color aFlash,color aNormal){
         g.SetBgColor(aName,aFlash);
         g.Redraw();
         Sleep(100);
         g.SetBgColor(aName,aNormal);
         g.Redraw();      
      }         
   public:
		/*!	
			  .
            \param		string aName="CVMenu" - ,
            \param		int aWidth=100 - ,
            \param		int aVisibleItems=10 -   .
 		*/      
      void Init(string aName="CVMenu",int aWidth=100,int aVisibleItems=10){
         m_BgColorOn=ClrScheme.Color(15);
         m_BgColorOf=ClrScheme.Color(16);
         m_TxtColor=ClrScheme.Color(1);
         m_ButTxtColor=ClrScheme.Color(1);
         m_ButBgColor=ClrScheme.Color(4);
         m_ButFlashColor=ClrScheme.Color(5);
         m_WarningColor=ClrScheme.Color(3); 
         m_CheckColor=ClrScheme.Color(17);
         m_SubWindow=0;
         m_CheckCnt=0;
         m_Visible=false;
         m_Name=aName;
         m_Width=aWidth;
         m_HeightInItems=aVisibleItems;
         m_DefHeightInItems=aVisibleItems;
         m_Left=0;
         m_Top=0;
         m_Start=0;
         ArrayResize(m_ItemText,0);
         ArrayResize(m_Checked,0);
         m_sb.Init(aName+"_SB",aVisibleItems*14+1,1);
         m_sb.SetMin(0);
         m_sb.SetValue(0);
         m_sb.SetSmallChange(1);
         m_sb.SetLageChange(aVisibleItems);
         m_Tag="";
         m_LastClickedX=-1;
         m_LastClickedY=-1;
         m_LastClickedQuarter=-1;  
         m_NpCnt=0;
         ArrayResize(m_ExName,0);
         m_LastClickedName1="";
         m_LastClickedName2="";
      }
		/*!	
			  .
         \param		string aValue -      /  .			
 		*/ 
      void ToggleNameAdd(string aValue){
         ArrayResize(m_ExName,ArraySize(m_ExName)+1);
         m_ExName[ArraySize(m_ExName)-1]=aValue;
      }
		/*!	
			   .
 		*/       
      void ToggleNamesClear(){
         ArrayResize(m_ExName,0);
      }
		/*!	
			   .
         \param		string aText - .			
			\remark	      ,    Refresh().
 		*/          
      void AddItem(string aText,bool aChecked=false){
         ArrayResize(m_ItemText,ArraySize(m_ItemText)+1);
         m_ItemText[ArraySize(m_ItemText)-1]=aText;
         ArrayResize(m_Checked,ArraySize(m_Checked)+1);
         m_Checked[ArraySize(m_Checked)-1]=aChecked;
         m_HeightInItems=MathMin(m_DefHeightInItems,ArraySize(m_ItemText));
            if(ArraySize(m_ItemText)>m_HeightInItems){
               m_sb.SetMax(ArraySize(m_ItemText)-m_HeightInItems);
            }
         if(aChecked)m_CheckCnt++;                
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/ 
      void Show(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
         Show();
      }
		/*!	
			 .
 		*/        
      void Show(){
         m_Visible=true;
         Create();
         ScrollTo();            
         ChartRedraw(0);
      }
		/*!	
			   (  ).
 		*/        
      void Hide(){
         m_Visible=false;
         Delete();
            if(m_sb.Visible()){
               m_sb.Hide();
            }
            else{
               ChartRedraw();
            }               
      }
		/*!	
			 (     ).
 		*/        
      void Refresh(){
         if(m_Visible){
            Delete();
               if(m_sb.Visible()){
                  m_sb.Hide();
               }
            Show();
         }            
      }
		/*!	
			  .
			\return  bool. True/false - /.
 		*/      
      bool Visible(){
         return(m_Visible);
      }
		/*!	
			  .
         \param		int aIndex -  ,
         \param		bool aValue - true/false,    "".
 		*/        
      void SetChecked(int aIndex,bool aValue){
            if(m_Checked[aIndex] && !aValue){
               m_CheckCnt--; 
            }
            if(!m_Checked[aIndex] && aValue){
               m_CheckCnt++; 
            }        
         m_Checked[aIndex]=aValue;
            if(m_Visible){
               SetBgColor();
               int m_n=aIndex-m_Start;
                  if(m_n>=0 && m_n<m_HeightInItems){
                     g.Attach(m_Name+"_IC("+IntegerToString(m_n)+")");
                        if(aValue){
                           g.SetText(CharToString(252));   
                        }
                        else{
                           g.SetText(" ");   
                        }
                  }
               ChartRedraw();
            }
      }
		/*!	
			    .
         \param		int aIndex -  .	
         \return   bool. True/false - / .				
 		*/        
      bool Checked(int aIndex){
         return(m_Checked[aIndex]);
      }  
		/*!	
			   .
         \return   bool. True/false -   /.				
 		*/ 
      bool CheckedExist(){
         return(m_CheckCnt>0);
      }
		/*!	
			     .
         \param		int aIndex -  .					
			\return   ( string).
 		*/   
      string Text(int aIndex){
         return(m_ItemText[aIndex]);
      } 
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/ 
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }  
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/            
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosTop(int aTop){
         m_Top=aTop;
      }
		/*!	
			 .
			\return   ( int).
 		*/       
      int Width(){
         return(m_Width);
      }   
		/*!	
			 .
			\return   ( int).
 		*/
      int Height(){
         return(m_HeightInItems*14+1);
      }
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){
         return(m_Left);      
      }
		/*!	
			  Y.
			\return   ( int).
 		*/       
      int Top(){
         return(m_Top);        
      }
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  -1 -  .  0   -       .
 		*/  
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
            if(m_sb.Event(id,lparam,dparam,sparam)==1){
               m_Start=m_sb.Value();
               ScrollTo();
               ChartRedraw();
               m_NpCnt=0;
               return(-1);
            }
            if(
               sparam==m_Name+"_SB_LB" ||
               sparam==m_Name+"_SB_UB" ||
               sparam==m_Name+"_SB_S" ||
               sparam==m_Name+"_SB_LF" ||
               sparam==m_Name+"_SB_UF"
            ){
               m_NpCnt=0;
               return(-1);
            }
            
            if(id==CHARTEVENT_OBJECT_CLICK){
               if(StringFind(sparam,m_Name+"_I",0)==0){
                  m_NpCnt=0;
                  
                  int m_pos=StringFind(sparam,"(",0);
                  string m_oi=StringSubstr(sparam,m_pos+1,StringLen(sparam)-m_pos-2);
                  int m_index=m_Start+(int)StringToInteger(m_oi);
                  m_LastClickedName1=m_Name+"_IT("+m_oi+")";
                  m_LastClickedName2=m_Name+"_IC("+m_oi+")";
                  
                  g.Attach(m_LastClickedName1);
                  m_LastClickedX=g.XDistance();
                  m_LastClickedY=g.YDistance();
                  
                  int m_ocx=g.XDistance()+g.XSize()/2;
                  int m_ocy=g.YDistance()+g.YSize()/2;
                  int m_ccx=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,m_SubWindow)/2;
                  int m_ccy=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,m_SubWindow)/2;
                     if(m_ocy<m_ccy){
                        if(m_ocx<m_ccx){
                           m_LastClickedQuarter=1;
                        }
                        else{
                           m_LastClickedQuarter=2;
                        }
                     }
                     else{
                        if(m_ocx<m_ccx){
                           m_LastClickedQuarter=3;
                        }
                        else{
                           m_LastClickedQuarter=4;                        
                        }                     
                     }               
                  Flash(m_LastClickedName1,m_ItemFlashColor,m_BgColor);
                  
                  return(m_index);
               }
            }
            
         m_NpCnt++;

            if(ArraySize(m_ExName)==0){
               m_NpCnt=0;
            }
            else{
               for(int i=0;i<ArraySize(m_ExName);i++){
                  if(sparam==m_ExName[i]){
                     m_NpCnt=0;
                     break;
                  }
               }
            }
            if(m_NpCnt>1){
               m_NpCnt=0;
               Hide();
            }
            
         return(-1);
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/         
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               m_sb.SetSubWindow(m_SubWindow);
               Refresh();
            }
      }  
		/*!	
			    .
			\param string aName -  .
 		*/                
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      } 
		/*!	
			 .
			\param string aValue - .
 		*/        
      void SetTag(string aValue){
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/        
      string Tag(){ 
         return(m_Tag);
      }    
		/*!	
			  ,     .
			\return  ( int).
 		*/  
      int LastClickedX(){
         return(m_LastClickedX);
      }  
		/*!	
			 Y ,     .
			\return  ( int).
 		*/           
      int LastClickedY(){
         return(m_LastClickedY);
      }
		/*!	
			     ,     .
			\return  ( int). 1 -  , 2 -  , 3 -  , 4 -  .
 		*/        
      int LastClickedQuarter(){
         return(m_LastClickedQuarter);
      }  
      /*!	
			   ,     .
			\return    ( string).
 		*/   
      string LastClickedName1(){
         return(m_LastClickedName1);
      } 
		/*!	
			    ""      .
			\return   ( string).
 		*/       
      string LastClickedName2(){
         return(m_LastClickedName2);
      }   	 		
		/*!	
			  .
			\return  ( int).
 		*/ 		     
      int ItemHeight(){
         return(15);
      }  
		/*!	
			 X       .
			\param int aWidth -   .
			\return  X ( int).
 		*/   
      int SolvePosLeft(int aWidth){
            if(m_LastClickedQuarter==2 || m_LastClickedQuarter==4){
               return(m_LastClickedX-aWidth+1);
            }
         return(m_LastClickedX+Width()-1);
      }
		/*!	
			 Y       .
			\param int aHeight -   .
			\return  Y ( int).
 		*/        
      int SolvePosTop(int aHeight){
            if(m_LastClickedQuarter==3 || m_LastClickedQuarter==4){
               return(m_LastClickedY+ItemHeight()-aHeight);
               
            }
         return(m_LastClickedY);            
      }      
};

//+------------------------------------------------------------------+
//|          CHProgress                                             |
//+------------------------------------------------------------------+

/*!
   \brief     "  ".
   \details    . 
   \remark	       
            " " (OBJ_EDIT) (  )    
            (OBJ_LABEL)      
            .      aName :
            "_C1", "_C2", "_L1", "_L2".
*/



class CHProgress{
   protected:
      bool m_Started;
      string m_Name;
      string m_NameC1;
      string m_NameC2;
      string m_NameL1;
      string m_NameL2;
      int m_Left;
      int m_Top;
      int m_Width;
      int m_Height;
      double m_Min;
      double m_Max;
      double m_Value;
      int m_Digits;
      bool m_Visible;
      int m_Len;
      uint m_St;
      ulong m_Add;
      int m_RefreshInterval;
      datetime m_LastTime;
      color m_BgColor;
      color m_BorderColor;
      color m_ProgrColor;
      color m_TxtColor;
      int m_SubWindow;
      string m_Tag;
      string FormatSec(long aSec){
         string m_rs="";
         long m_h=aSec/3600;
         aSec-=m_h*3600;
         long m_m=aSec/60;
         aSec-=m_m*60;
            if(m_h>0){
               if(m_h<10){
                  m_rs="0"+IntegerToString(m_h)+":";
               }
               else{
                  m_rs=IntegerToString(m_h)+":";
               }
            }
           
            if(m_m<10){
               m_rs=m_rs+"0"+IntegerToString(m_m)+":";
            }
            else{
               m_rs=m_rs+IntegerToString(m_m)+":";
            }
            if(aSec<10){
               m_rs=m_rs+"0"+IntegerToString(aSec);
            }
            else{
               m_rs=m_rs+IntegerToString(aSec);
            } 
         return(m_rs);                       
      }
      void Labels(){
         double m_done=(m_Value-m_Min)/(m_Max-m_Min);
         m_Len=(int)MathRound(m_done*(m_Width-2));
         g.Attach(m_NameC2);               
         g.SetXSize(m_Len);       
         g.Attach(m_NameL1);
         g.SetText(DoubleToString(m_done*100.0,2)+"%");                 
            if(m_Started){
               uint m_tcn=GetTickCount();
               ulong m_tms;
                  if(m_tcn<m_St){
                     m_Add=ULONG_MAX-m_St;
                     m_St=0;
                  }
               m_tms=m_Add+(m_tcn-m_St);
               long m_lt=0;
               if(m_done>0)m_lt=(int)MathRound(1.0+0.001*m_tms*(1.0-m_done)/m_done);
               g.Attach(m_NameL2);
               g.SetText(FormatSec(m_lt));               
            }                     
    
      }      
      void Create(){
         w.Edit(m_NameC1,m_SubWindow,m_Left,m_Top,m_Width,m_Height," ",m_BgColor,m_BorderColor);
         g.SetReadOnly(m_NameC1,true);
         w.Edit(m_NameC2,m_SubWindow,m_Left+1,m_Top+1,m_Len,m_Height-2," ",m_ProgrColor,m_ProgrColor);  
         g.SetReadOnly(m_NameC2,true);
         w.Label(m_NameL1,m_SubWindow,m_Left+4,m_Top+2," ",m_TxtColor,7);
         w.Label(m_NameL2,m_SubWindow,m_Left+m_Width-4,m_Top+2," ",m_TxtColor,7); 
         g.SetAnchor(m_NameL2,ANCHOR_RIGHT_UPPER);
         //Labels();
      }
      void Delete(){
         g.Delete(m_NameC1);
         g.Delete(m_NameC2); 
         g.Delete(m_NameL1);
         g.Delete(m_NameL2);  
      }
   public:
		/*!	
			  .
            \param		string aName="CHProgress" - ,
            \param		int aWidth=200 - .
 		*/    
      void Init(string aName="CHProgress",int aWidth=200){
         m_Name=aName;
         m_NameC1=m_Name+"_C1";
         m_NameC2=m_Name+"_C2";
         m_NameL1=m_Name+"_L1";
         m_NameL2=m_Name+"_L2";      
         m_Visible=false;
         m_Name=aName;
         m_Min=0;
         m_Max=100;
         m_Width=aWidth;
         m_Height=15;
         m_Value=0;
         m_Len=0;
         m_RefreshInterval=0;  
         m_BgColor=ClrScheme.Color(18);
         m_BorderColor=ClrScheme.Color(19);
         m_ProgrColor=ClrScheme.Color(20);
         m_TxtColor=ClrScheme.Color(21);
         m_SubWindow=0;
         m_Tag="";
      }
		/*!	
			  .
         \param		int aSeconds -    .
 		*/        
      void SetRefreshInterval(int aSeconds){
         m_RefreshInterval=aSeconds;
      }
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/        
      void SetWidth(int aWidth){
         m_Width=aWidth;
      }
		/*!	
			 (     ).
 		*/        
      void Refersh(){
         if(m_Visible){
            Hide();
            Show();
         }
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/       
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }   
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/           
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosTop(int aTop){
         m_Top=aTop;
      }   
		/*!	
			 .
			\return   ( int).
 		*/         
      int Width(){
         return(m_Width);
      }
		/*!	
			 .
			\return   ( int).
 		*/       
      int Height(){
         return(15);
      }
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/       
      int Top(){
         return(m_Top);
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/        
      void Show(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
         Show();
      }
		/*!	
			 .
 		*/   
      void Show(){
         m_Visible=true;
         Create();
         ChartRedraw();
      }
		/*!	
			   (  ).
 		*/         
      void Hide(){
         m_Visible=false;
         Delete();                
         ChartRedraw();
      }  
		/*!	
			 (     ).
 		*/        
      void Refresh(){
         if(m_Visible){
            Delete();
            Show();
         }            
      }    
		/*!	
			     .    , 
			   .
         \param		double aMin=0 -  ,
         \param		double aMax=100 -  .
 		*/        
      void Begin(double aMin=0,double aMax=100){
         Reset();  
         m_Started=true;
         m_Min=aMin;
         m_Max=aMax;
         m_St=GetTickCount();
         m_Add=0;
         m_Value=m_Min;
      }  
		/*!	
			    . 
 		*/         
      void Reset(){
         m_Started=false;
         m_Value=m_Min;
            if(m_Visible){
               g.SetXSize(m_NameC2,0);            
               g.SetText(m_NameL1," ");
               g.SetText(m_NameL2," ");
               g.Redraw();
            }
      }
		/*!	
			 .    . 
         \param		double aValue - .
 		*/       
      void SetValue(double aValue){
         m_Value=aValue;
         if(TimeLocal()<m_LastTime+m_RefreshInterval)return;
         m_LastTime=TimeLocal();
            if(m_Visible){
               Labels();
               ChartRedraw();
            }
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/         
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               Refresh();
            }
      }   
		/*!	
			    .
			\param string aName -  .
 		*/               
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      } 
		/*!	
			 .
			\param string aValue - .
 		*/         
      void SetTag(string aValue){
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/         
      string Tag(){ 
         return(m_Tag);
      } 
};

//+------------------------------------------------------------------+
//|          CDialer                                            |
//+------------------------------------------------------------------+

/*!
   \brief      "".
   \details      "  
             ".    . 
   \remark	       
            (OBJ_EDIT).      
            aName  , "_Frame",   :
            "_B1", "_B2", "_B3", "_B4", "_B5", "_B6", "_B7", "_B8",
            "_B9", "_B0" (), "_BD" (), "_BX" (),
            "_BC" (), "_BE" (), "_M" (), "_T" ( 
               ).
*/

class CDialer{
   private:
      string m_NameFrame;
      string m_Name1;
      string m_Name2;
      string m_Name3;
      string m_Name4;
      string m_Name5;
      string m_Name6;
      string m_Name7;
      string m_Name8;
      string m_Name9;
      string m_Name0; 
      string m_NameD;
      string m_NameX;
      string m_NameC;
      string m_NameE;
      string m_NameT;
      string m_NameM;      
      int m_ButtonSize;
      int m_TextSize; 
      int m_Left;
      int m_Top;
      color m_BGColor;
      color m_BorderColor;      
      color m_ButDigTxColor;      
      color m_ButDigBgColor;
      color m_ButDigCtrlBgColor;
      color m_ButDigOkBgColor;
      color m_ButDigClColor;      
      color m_TxBgColor;
      color m_TxTxColor;
      color m_WrongFlashColor;
      bool m_Visible;
      int m_Width;
      int m_Height;  
      double m_Value;   
      string m_Tag;
      int m_SubWindow;      
      void Flash(string aName,color aColor){
         g.Attach(aName);
         color restc=g.BgColor();
         g.SetBgColor(aColor);
         g.Redraw();
         Sleep(100);
         g.SetBgColor(restc);
         g.Redraw(); 
      }
      void Push(string aName){
         g.Attach(aName);
         int m_x=g.XDistance();
         int m_y=g.YDistance();
         g.SetXDistance(m_x+1);
         g.SetYDistance(m_y+1);   
         g.Redraw();
         Sleep(100);
         g.SetXDistance(m_x);
         g.SetYDistance(m_y);
         g.Redraw();                                
      }      
      void Create(){
         w.Edit(m_NameFrame,m_SubWindow,m_Left,m_Top,m_Width,m_Height," ",m_BGColor,m_BorderColor);
         w.Edit(m_Name7,m_SubWindow,m_Left+2,m_Top+2,m_ButtonSize,m_ButtonSize," 7",m_ButDigBgColor,m_ButDigTxColor,8);
         w.Edit(m_Name8,m_SubWindow,m_Left+m_ButtonSize+4,m_Top+2,m_ButtonSize,m_ButtonSize," 8",m_ButDigBgColor,m_ButDigTxColor,8);
         w.Edit(m_Name9,m_SubWindow,m_Left+6+m_ButtonSize*2,m_Top+2,m_ButtonSize,m_ButtonSize," 9",m_ButDigBgColor,m_ButDigTxColor,8);
         w.Edit(m_Name4,m_SubWindow,m_Left+2,m_Top+4+m_ButtonSize,m_ButtonSize,m_ButtonSize," 4",m_ButDigBgColor,m_ButDigTxColor,8);
         w.Edit(m_Name5,m_SubWindow,m_Left+4+m_ButtonSize,m_Top+4+m_ButtonSize,m_ButtonSize,m_ButtonSize," 5",m_ButDigBgColor,m_ButDigTxColor,8);
         w.Edit(m_Name6,m_SubWindow,m_Left+6+2*m_ButtonSize,m_Top+4+m_ButtonSize,m_ButtonSize,m_ButtonSize," 6",m_ButDigBgColor,m_ButDigTxColor,8);
         w.Edit(m_Name1,m_SubWindow,m_Left+2,m_Top+6+2*m_ButtonSize,m_ButtonSize,m_ButtonSize," 1",m_ButDigBgColor,m_ButDigTxColor,8);
         w.Edit(m_Name2,m_SubWindow,m_Left+4+m_ButtonSize,m_Top+6+2*m_ButtonSize,m_ButtonSize,m_ButtonSize," 2",m_ButDigBgColor,m_ButDigTxColor,8);
         w.Edit(m_Name3,m_SubWindow,m_Left+6+2*m_ButtonSize,m_Top+6+2*m_ButtonSize,m_ButtonSize,m_ButtonSize," 3",m_ButDigBgColor,m_ButDigTxColor,8);
         w.Edit(m_Name0,m_SubWindow,m_Left+2,m_Top+8+3*m_ButtonSize,2*m_ButtonSize+2,m_ButtonSize," 0",m_ButDigBgColor,m_ButDigTxColor,8);
         w.Edit(m_NameD,m_SubWindow,m_Left+6+2*m_ButtonSize,m_Top+8+3*m_ButtonSize,m_ButtonSize,m_ButtonSize,"    '",m_ButDigBgColor,m_ButDigTxColor,5);
         w.Edit(m_NameX,m_SubWindow,m_Left+8+3*m_ButtonSize,m_Top+2,m_ButtonSize,m_ButtonSize," X",m_ButDigClColor,m_ButDigTxColor,8);
         w.Edit(m_NameC,m_SubWindow,m_Left+8+3*m_ButtonSize,m_Top+4+m_ButtonSize,m_ButtonSize,m_ButtonSize," C",m_ButDigCtrlBgColor,m_ButDigTxColor,8);
         w.Edit(m_NameM,m_SubWindow,m_Left+8+3*m_ButtonSize,m_Top+6+2*m_ButtonSize,m_ButtonSize,m_ButtonSize," -",m_ButDigBgColor,m_ButDigTxColor,10);
         w.Edit(m_NameE,m_SubWindow,m_Left+8+3*m_ButtonSize,m_Top+8+3*m_ButtonSize,m_ButtonSize,m_ButtonSize,"OK",m_ButDigOkBgColor,m_ButDigTxColor,7);
         w.Edit(m_NameT,m_SubWindow,m_Left+2,m_Top+10+4*m_ButtonSize,4*m_ButtonSize+6,m_TextSize,"",m_TxBgColor,m_TxTxColor,7);
         g.SetReadOnly(m_NameFrame,true);
         g.SetReadOnly(m_Name7,true);
         g.SetReadOnly(m_Name8,true);
         g.SetReadOnly(m_Name9,true);
         g.SetReadOnly(m_Name4,true);
         g.SetReadOnly(m_Name5,true);
         g.SetReadOnly(m_Name6,true);
         g.SetReadOnly(m_Name1,true);
         g.SetReadOnly(m_Name2,true);
         g.SetReadOnly(m_Name3,true);
         g.SetReadOnly(m_Name0,true);
         g.SetReadOnly(m_NameD,true);
         g.SetReadOnly(m_NameX,true);
         g.SetReadOnly(m_NameC,true);
         g.SetReadOnly(m_NameM,true);
         g.SetReadOnly(m_NameE,true);
         g.SetReadOnly(m_NameT,true);      
      }  
      void Delete(){
         g.Delete(m_NameFrame);
         g.Delete(m_Name1);
         g.Delete(m_Name2);
         g.Delete(m_Name3);
         g.Delete(m_Name4);
         g.Delete(m_Name5);
         g.Delete(m_Name6);
         g.Delete(m_Name7);
         g.Delete(m_Name8);
         g.Delete(m_Name9);
         g.Delete(m_Name0);
         g.Delete(m_NameD);
         g.Delete(m_NameX);
         g.Delete(m_NameC);
         g.Delete(m_NameE);
         g.Delete(m_NameT);
         g.Delete(m_NameM);         
      }
   public:
		/*!	
			  .
            \param		string aName="CDialer" - .
 		*/     
      void Init(string aName="CDialer"){
         m_NameFrame=aName+"_Frame";
         m_Name1=aName+"_B1";
         m_Name2=aName+"_B2";
         m_Name3=aName+"_B3";
         m_Name4=aName+"_B4";
         m_Name5=aName+"_B5";
         m_Name6=aName+"_B6";
         m_Name7=aName+"_B7";
         m_Name8=aName+"_B8";
         m_Name9=aName+"_B9";
         m_Name0=aName+"_B0";      
         m_NameD=aName+"_BD";        
         m_NameX=aName+"_BX";       
         m_NameC=aName+"_BC";   
         m_NameE=aName+"_BE";  
         m_NameT=aName+"_T"; 
         m_NameM=aName+"_M";          
         m_ButtonSize=20;
         m_TextSize=15;   
         m_BGColor=ClrScheme.Color(22);
         m_BorderColor=ClrScheme.Color(23);
         m_ButDigBgColor=ClrScheme.Color(24);
         m_ButDigTxColor=ClrScheme.Color(25);
         m_ButDigCtrlBgColor=ClrScheme.Color(26);
         m_ButDigOkBgColor=ClrScheme.Color(27);
         m_ButDigClColor=ClrScheme.Color(28);
         m_TxBgColor=ClrScheme.Color(29);
         m_TxTxColor=ClrScheme.Color(30);
         m_WrongFlashColor=ClrScheme.Color(31);
         m_Width=4*m_ButtonSize+10;
         m_Height=4*m_ButtonSize+12+m_TextSize;         
         m_Visible=false;
         m_SubWindow=0;
      }  
		/*!	
			 .
			\param string aValue - .
 		*/       
      void SetTag(string aTag){
         m_Tag=aTag;
      }
		/*!	
			 .
			\return  ( string).
 		*/       
      string Tag(){
         return(m_Tag);
      }    
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/          
      void Show(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
         Show();
      }
		/*!	
			 .
 		*/         
      void Show(){
         m_Visible=true;       
         Create();
         ChartRedraw();
      }
		/*!	
			   (  ).
 		*/       
      void Hide(){
         m_Visible=false;
         Delete();
         ChartRedraw();
      }
		/*!	
			 (     ).
 		*/       
      void Refresh(){
         if(m_Visible){
            Delete();
            Show();
         }            
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/       
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;    
         m_Top=aTop;           
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosTop(int aTop){
         m_Top=aTop;
      }   
		/*!	
			 .
			\return   ( int).
 		*/          
      int Width(){
         return(m_Width);
      }
		/*!	
			 .
			\return   ( int).
 		*/        
      int Height(){
         return(m_Height);
      }
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/       
      int Top(){
         return(m_Top);
      }
		/*!	
			  .
			\return  bool. True/false - /.
 		*/          
      bool Visible(){
         return(m_Visible);
      }
		/*!	
			  .
			\return  ( double).
 		*/        
      double Value(){
         return(m_Value);
      }
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1    .
 		*/         
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
         int m_rv=0;
            if(id==CHARTEVENT_OBJECT_CLICK){
               if(sparam==m_Name1){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText(g.Text()+"1"); 
                  g.Redraw();   
                  m_rv=2;               
               }
               if(sparam==m_Name2){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText(g.Text()+"2"); 
                  g.Redraw();   
                  m_rv=2;                
               }  
               if(sparam==m_Name3){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText(g.Text()+"3"); 
                  g.Redraw();   
                  m_rv=2;                 
               }
               if(sparam==m_Name4){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText(g.Text()+"4"); 
                  g.Redraw(); 
                  m_rv=2;                  
               }              
               if(sparam==m_Name5){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText(g.Text()+"5"); 
                  g.Redraw(); 
                  m_rv=2;                 
               }
               if(sparam==m_Name6){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText(g.Text()+"6"); 
                  g.Redraw();  
                  m_rv=2;               
               }  
               if(sparam==m_Name7){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText(g.Text()+"7"); 
                  g.Redraw(); 
                  m_rv=2;                
               }
               if(sparam==m_Name8){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText(g.Text()+"8"); 
                  g.Redraw();
                  m_rv=2;                 
               }    
               if(sparam==m_Name9){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText(g.Text()+"9"); 
                  g.Redraw();   
                  m_rv=2;            
               }
               if(sparam==m_Name0){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText(g.Text()+"0"); 
                  g.Redraw();
                  m_rv=2;   
               }  
               if(sparam==m_NameD){
                  g.Attach(m_NameT);
                     if(StringFind(g.Text(),".",0)==-1){
                        Push(sparam);
                        g.Attach(m_NameT);
                        if(g.Text()=="" || g.Text()=="-")g.SetText(g.Text()+"0");
                        g.SetText(g.Text()+"."); 
                        g.Redraw();
                     }
                     else{
                        Flash(sparam,m_WrongFlashColor);
                     }
                  m_rv=2;                        
               }
               if(sparam==m_NameX){
                  Push(sparam);
                  Hide();
                  m_rv=2;   
               }
               if(sparam==m_NameC){
                  Push(sparam);
                  g.Attach(m_NameT);
                  g.SetText("");
                  g.Redraw();
                  m_rv=2;   
               }  
               if(sparam==m_NameE){
                  Push(sparam);
                  g.Attach(m_NameT);
                  string sVal=g.Text();
                  m_Value=StringToDouble(sVal);
                  Hide();
                  m_rv=1;
               }  
               if(sparam==m_NameM){
                  Push(sparam);
                  g.Attach(m_NameT);
                     if(StringSubstr(g.Text(),0,1)=="-"){
                        g.SetText(StringSubstr(g.Text(),1,StringLen(g.Text())-1));
                     }
                     else{
                        g.SetText("-"+g.Text());
                     }
                  g.Redraw();
                  m_rv=2;   
               }   
               if(sparam==m_NameFrame){
                  m_rv=2;
               }
               if(sparam==m_NameT){
                  m_rv=2;
               }  
            }             
         return(m_rv);      
      }
		/*!	
			   .
			\param int aNumber -  .
 		*/         
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               Refresh();
            }
      } 
		/*!	
			    .
			\param string aName -  .
 		*/               
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }      
};

//+------------------------------------------------------------------+
//|          CDialerInputBox                                    |
//+------------------------------------------------------------------+

/*!
   \brief      "   ".
   \details    . 
   \remark	     :
            " ", "",    
                 (OBJ_EDIT)   (OBJ_LABEL).
                  aName  "_D", 
              - "_I", "" - "_B",  - "_L".
*/

class CDialerInputBox{
   private:
      int m_SubWindow;
      int m_Left;
      int m_Top;
      int m_Width;
      int m_Height;
      string m_DName;
      string m_IName;
      string m_BName;
      string m_LName;
      string m_Caption;
      CDialer m_d;
      CInputBox m_ib;
      color m_ColDBg;
      color m_ColDTx;
      color m_ColL;
      int m_cc;
      bool m_Visible;
      string m_Tag;
         void Create(){
            w.Edit(m_BName,m_SubWindow,m_Left+m_Width-13,m_Top,13,m_Height,"d",m_ColDBg,m_ColDTx,7,"Arial");
            g.SetReadOnly(m_BName,true);               
               if(m_Caption!=""){ //  
                  w.Label(m_LName,m_SubWindow,m_Left+m_Width+1,m_Top+2,m_Caption,m_ColL,7,"Arial"); //  
               } 
         }      
         void Delete(){
            ObjectDelete(0,m_BName);
            ObjectDelete(0,m_LName);            
         }
   public:
		/*!	
			  .
            \param		string aName="CDialerInputBox" - ,
            \param		int aWidth=50 - ,
            \param		int aDigits=4 -    ,
            \param		string aCaption="CDialerInputBox" -  .
 		*/      
      void Init(string aName="CDialerInputBox",int aWidth=50,int aDigits=4,string aCaption="CDialerInputBox"){
         m_ColDBg=ClrScheme.Color(4);  //   
         m_ColDTx=ClrScheme.Color(1);
         m_ColL=ClrScheme.Color(2);
         m_Visible=false;
         m_Left=0;
         m_Top=0;
         m_Width=aWidth;
         m_Height=15;
         m_Caption=aCaption;
         m_DName=aName+"_D";
         m_IName=aName+"_I";
         m_BName=aName+"_B";
         m_LName=aName+"_L";
         m_ib.Init(m_IName,m_Width-12,aDigits,""); //   
         m_ib.SetReadOnly(true);
         m_d.Init(m_DName);
         m_cc=0;
         m_Tag="";
      }
		/*!	
			  "  ".
			\param int aValue - true/false -  / .
 		*/         
      void SetReadOnly(bool aValue){
         m_ib.SetReadOnly(aValue);
      }
		/*!	
			  "  ".
			\return  bool. True/false -  / .
 		*/       
      bool ReadOnly(){
         return(m_ib.ReadOnly());
      }
		/*!	
			    .
			\param int aValue -    .
 		*/         
      void SetDigits(int aValue){
         m_ib.SetDigits(aValue);
      }
		/*!	
			    .
			\return  int.
			\remark    .
 		*/         
      int Digits(){
         return(m_ib.Digits());
      }  
		/*!	
			   .
			\param double aValue -   . 
 		*/            
      void SetMinValue(double aValue){
         m_ib.SetMinValue(aValue);
      }
		/*!	
			   .
			\return  ( double).
 		*/        
      double MinValue(){
         return(m_ib.MinValue());
      }
		/*!	
			   .
			\param double aValue -   . 
 		*/        
      void SetMaxValue(double aValue){
         m_ib.SetMaxValue(aValue);      
      }
		/*!	
			   .
			\return  ( double).
 		*/        
      double MaxValue(){
         return(m_ib.MaxValue());
      }   
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/ 
      void SetWidth(int aValue){
         m_Width=aValue;
         m_ib.SetWidth(m_Width-12);
      }  
		/*!	
			 .
			\return   ( int).
			\remark         .
 		*/        
      int Width(){
         return(m_Width);
      }
		/*!	
			 .
			\return   ( int).
 		*/       
      int Height(){
         return(m_Height);
      }   
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/       
      int Top(){
         return(m_Top);
      }
		/*!	
			 (     ).
 		*/         
      void Refresh(){
         if(m_Visible){
            Delete();
            m_d.Hide();            
            m_ib.Hide();
            Show();
         }
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/       
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
         m_ib.SetPos(m_Left,m_Top);
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/  
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
         m_ib.SetPosLeft(m_Left);
      }  
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/   
      void SetPosTop(int aTop){
         m_Top=aTop;
         m_ib.SetPosTop(m_Top);
      }
		/*!	
			 .
 		*/         
      void Show(){
         m_Visible=true;
         Create();
         m_ib.Show();
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/       
      void Show(int aLeft,int aTop){
         SetPos(aLeft,aTop);
         Show();
      }
		/*!	
			   (  ).
 		*/        
      void Hide(){
         m_Visible=false;
         Delete();
         m_d.Hide();            
         m_ib.Hide();
      }
		/*!	
			 .
			\return  ( double).
 		*/ 
      double Value(){
         return(m_ib.ValueDouble());
      }
		/*!	
			 . 
         \param		double aValue - .
 		*/        
      void SetValue(double aValue){
         m_ib.SetValue(aValue);
      }
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1    .
 		*/        
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
         int m_event=0;
            if(sparam==""){
               if(id==CHARTEVENT_CLICK){
                  m_cc++;
                     if(m_cc>=2){
                        if(m_d.Visible()){
                           m_d.Hide();
                        }
                     }
               }                  
            }
            else{
               m_cc=0;
                  if(m_ib.Event(id,lparam,dparam,sparam)==1){
                     m_event=1;
                  }
               int m_dev=m_d.Event(id,lparam,dparam,sparam);
                  if(m_dev==1){
                     double m_oldvalue=m_ib.ValueDouble();
                     m_ib.SetValue(m_d.Value());
                        if(m_oldvalue!=m_d.Value()){
                           m_event=1;
                        }
                     ChartRedraw();
                  }
                  if(id==CHARTEVENT_OBJECT_CLICK){
                     if(sparam==m_BName){
                        if(m_d.Visible()){
                           m_d.Hide();
                        }  
                        else{
                           int m_w=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,m_SubWindow)/2;
                           int m_h=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,m_SubWindow)/2;
                           int m_x=m_Left+m_Width/2;
                           int m_y=m_Top+m_Height/2;
                           int m_cx;
                           int m_cy;
                              if(m_x<m_w){
                                 m_cx=m_Left;
                              }
                              else{
                                 m_cx=m_Left-m_d.Width()+m_Width;
                              }
                              if(m_y<m_h){
                                 m_cy=m_Top+m_ib.Height()-1;
                              }
                              else{
                                 m_cy=m_Top-m_d.Height()+1;
                              }                           
                           m_d.Show(m_cx,m_cy);
                        }                      
                     }
                     else{
                        if(m_dev!=2){
                           if(m_d.Visible()){
                              m_d.Hide();
                           } 
                        }
                     }
                  }
            }
         return(m_event);
      }
		/*!	
			 .
			\param string aValue - .
 		*/        
      void SetTag(string aTag){
         m_Tag=aTag;
      }
		/*!	
			 .
			\return  ( string).
 		*/       
      string Tag(){
         return(m_Tag);
      } 
		/*!	
			   .
			\param int aNumber -  .
 		*/          
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               m_ib.SetSubWindow(m_SubWindow);
               m_d.SetSubWindow(m_SubWindow);               
               Refresh();
            }
      }  
		/*!	
			    .
			\param string aName -  .
 		*/               
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }  
		/*!	
			  .
			\return  bool. True/false - /.
 		*/          
      bool Warning(){
         return(m_ib.Warning());
      }     
		/*!	
			/  .
			\param bool aValue - true/false (/). 
 		*/                    
      void SetWarning(bool aValue){
         m_ib.SetWarning(aValue);
      }
};

//+------------------------------------------------------------------+
//|          CTable                                             |
//+------------------------------------------------------------------+

/*!
   \brief      "".
   \details       
               ,    :  
            , ,    .   
                   .   
              HTML.    . 
   \remark	       ( 
            )   .       
             aName  "_VSB" ()  "_HSB" (). 
                 ()  "_Cell_R([R])_C([C])", 
             R -  ,  -  .
*/
class CTable{
   private:
      struct sRow{
         int RowHeight;
         string CellText[];
         color CellBGColor[];
         color CellTxtColor[];
         string CellFont[];
         int CellFontSize[];
         int CellCollSpan[];
         int CellRowSpan[];
         int CellExist[];
         int CellMergeWidth[];
         int CellMergeHeight[];
      };
      sRow m_row[];
      CVScrollBar m__vsb;
      CHScrollBar m__hsb;
      string m_Name;
      int m_CollsCount;    //  
      int m_CollWidth[];   //  
      int m_RowsCount;     //  
      int m_Width;         //   
      int m_Height;        //   
      int m_left;          //  
      int m_Top;           //  
      bool m_Visible;      //  
      int m_tWidth;        //  
      int m_tHeight;       //  
      bool m_vsb;          //   
      bool m_hsb;
      color m_DefBgColor;
      color m_DefTxColor;
      string m_DefFontFace;
      int m_DefFontSize;
      int m_SubWindow;
      int m_mrc;
      int m_mcc;
      color m_FlashColor;
      int m_PreSelectedR;
      int m_PreSelectedC;
      bool m_PreNorm;
      string m_Tag;
      int m_LastClickedRow;
      int m_LastClickedColl;
      bool m_AllowSelection;
      void SB(){
         CountTWidth();
         CountTHeight();
         m_hsb=false;
         m_vsb=false;
         int m_bheight=m_Height;
         int m_bwidth=m_Width;
         int m_tth=m_tHeight;
         int m_ttw=m_tWidth;
            if(m_tWidth>m_bwidth){
               m_tWidth=m_bwidth;
               m_hsb=true;
               m_bheight-=m__hsb.Height();
            }
            if(m_tHeight>m_bheight){
               m_tHeight=m_bheight;
               m_vsb=true;
               m_bwidth-=m__vsb.Width();
            }
            if(m_tWidth>m_bwidth){
               m_tWidth=m_bwidth;
                  if(!m_hsb){
                     m_hsb=true;
                     m_bheight-=m__hsb.Height();
                  }
            }
            if(m_tHeight>m_bheight){
               m_tHeight=m_bheight;
                  if(!m_vsb){
                     m_vsb=true;
                     m_bwidth-=m__vsb.Width();
                 }
            }
            if(m_vsb){
               m__vsb.SetMax(m_tth-m_bheight);
               m__vsb.SetSmallChange((int)MathMax(MathMin(25,m_bheight),1));
               m__vsb.SetLageChange((int)MathMax(m_bheight,1));
            }
            else{
               m__vsb.SetValue(0);
            }
            if(m_hsb){
               m__hsb.SetMax(m_ttw-m_bwidth);
               m__hsb.SetSmallChange((int)MathMax(MathMin(25,m_bwidth),1));
               m__hsb.SetLageChange((int)MathMax(m_bwidth,1));
            }
            else{
               m__hsb.SetValue(0);
            }
      }     
      void CountTWidth(){
         m_tWidth=0;
            for(int i=0;i<m_CollsCount;i++){
               m_tWidth+=m_CollWidth[i];
            }
      }
      void CountTHeight(){
         m_tHeight=0;
            for(int i=0;i<m_RowsCount;i++){
               m_tHeight+=m_row[i].RowHeight;
            }          
      }
      string iif(bool aBool,string aIfTrue,string aIfFalse){
            if(aBool){
               return(aIfTrue);
            }
         return(aIfFalse);
      }
      string its(int aValue){
         return(IntegerToString(aValue));
      }
      void GetRGB(color aColor,int & aR,int & aG, int & aB){
         aR=aColor;
         aB=aR/65536;
         aR-=aB*65536;
         aG=aR/256;
         aR-=aG*256;
      }   
      string WEBColor(color aColor){
         int ttr=0,ttg=0,ttb=0;   
         GetRGB(aColor,ttr,ttg,ttb);
         return("#"+StringFormat("%02x",ttr)+StringFormat("%02x",ttg)+StringFormat("%02x",ttb));
      }    
      void Create(){
         m_PreSelectedR=-1;
         m_PreSelectedC=-1;   
         m_PreNorm=false;      
         SB();         
         m_mrc=MathMax(m_mrc,m_RowsCount);   
         m_mcc=MathMax(m_mcc,m_CollsCount);       
         int m_xpos=0;
         int m_ypos=0;
            if(m_vsb){
               m__vsb.SetHeight(m_tHeight);
               m__vsb.Show(m_left+m_tWidth,m_Top);
            }  
            else{
               m__vsb.Hide();
            }          
            if(m_hsb){
               m__hsb.SetWidth(m_tWidth);
               m__hsb.Show(m_left,m_Top+m_tHeight);
            }         
            else{
               m__hsb.Hide();
            }          
         int m_xs=m__hsb.Value();
         int m_ys=m__vsb.Value();
         m_ypos=-m_ys;
            for(int i=0;i<m_RowsCount;i++){
               m_xpos=-m_xs;
               bool m_br=false;
                  for(int j=0;j<m_CollsCount;j++){
                        if(m_row[i].CellExist[j]){
                           int m_w=m_CollWidth[j];
                           int m_h=m_row[i].RowHeight;
                              if(m_row[i].CellCollSpan[j]>1 || m_row[i].CellRowSpan[j]>1){
                                 if(m_row[i].CellCollSpan[j]>1){
                                    for(int k=j+1;k<m_CollsCount;k++){
                                          if(m_row[i].CellExist[k]){
                                             break;
                                          }
                                       m_w+=m_CollWidth[k];
                                    }
                                 }
                                 if(m_row[i].CellRowSpan[j]>1){
                                    for(int k=i+1;k<m_RowsCount;k++){
                                          if(m_row[k].CellExist[j]){
                                             break;
                                          }
                                       m_h+=m_row[k].RowHeight;
                                    } 
                                 }
                              }
                              if(m_xpos>m_tWidth){
                                    for(;j<m_CollsCount;j++){
                                       ObjectDelete(0,m_Name+"_Cell_R("+IntegerToString(i)+")_C("+IntegerToString(j)+")");
                                    }                              
                                 break;
                              }
                              if(m_ypos>m_tHeight){
                                    for(;j<m_CollsCount;j++){
                                       ObjectDelete(0,m_Name+"_Cell_R("+IntegerToString(i)+")_C("+IntegerToString(j)+")");
                                    }
                                 break;
                              }
                              if(m_left+m_xpos+m_w>m_left+m_tWidth){
                                 m_w=m_tWidth-m_xpos;
                                 m_br=true;
                              }
                              
                              if(m_ypos+m_h>m_tHeight){
                                 m_h=m_tHeight-m_ypos;
                              }
                           int m_l2=m_left+m_xpos;
                           int m_t2=m_Top+m_ypos;
                              if(m_xpos+m_w>0 && m_ypos+m_h>0){
                                    if(m_xpos<0){
                                       m_l2=m_left;
                                       m_w=m_xpos+m_w;
                                    }
                                    if(m_ypos<0){
                                       m_t2=m_Top;
                                       m_h=m_ypos+m_h;
                                    }
                                 w.Edit(m_Name+"_Cell_R("+IntegerToString(i)+")_C("+IntegerToString(j)+")",m_SubWindow,m_l2,m_t2,m_w,m_h,m_row[i].CellText[j],m_row[i].CellBGColor[j],m_row[i].CellTxtColor[j],m_row[i].CellFontSize[j],m_row[i].CellFont[j]);
                                 g.SetReadOnly(m_Name+"_Cell_R("+IntegerToString(i)+")_C("+IntegerToString(j)+")",true);
                              }
                              else{
                                 ObjectDelete(0,m_Name+"_Cell_R("+IntegerToString(i)+")_C("+IntegerToString(j)+")");
                              }                              
                              if(m_br){
                                 j++;
                                    for(;j<m_CollsCount;j++){
                                       ObjectDelete(0,m_Name+"_Cell_R("+IntegerToString(i)+")_C("+IntegerToString(j)+")");
                                    }
                                 break;
                              }
                        }
                     m_xpos+=m_CollWidth[j];                     
                  }
               m_ypos+=m_row[i].RowHeight;
            }
            
      }       
      void Delete(){
            for(int i=0;i<m_mrc;i++){
               for(int j=0;j<m_mcc;j++){
                  ObjectDelete(0,m_Name+"_Cell_R("+IntegerToString(i)+")_C("+IntegerToString(j)+")");
               }
            }  
         m_mrc=0;
         m_mcc=0;
      }  
      void SetCrossColor(int aR,int aC,bool aNormal){
         if(aNormal){
            for(int i=0;i<m_RowsCount;i++){
               string m_tn=m_Name+"_Cell_R("+IntegerToString(i)+")_C("+IntegerToString(aC)+")";
                  if(ObjectFind(0,m_tn)==m_SubWindow){
                     g.Attach(m_tn);
                     g.SetBgColor(m_row[i].CellBGColor[aC]);
                  }
            }
            for(int i=0;i<m_CollsCount;i++){
               string m_tn=m_Name+"_Cell_R("+IntegerToString(aR)+")_C("+IntegerToString(i)+")";
                  if(ObjectFind(0,m_tn)==m_SubWindow){
                     g.Attach(m_tn);
                     g.SetBgColor(m_row[aR].CellBGColor[i]);
                  }
            }  
         }
         else{
            for(int i=0;i<m_RowsCount;i++){
               string m_tn=m_Name+"_Cell_R("+IntegerToString(i)+")_C("+IntegerToString(aC)+")";
                  if(ObjectFind(0,m_tn)==m_SubWindow){
                     g.Attach(m_tn);
                     g.SetBgColor(m_FlashColor);
                  }
            }
            for(int i=0;i<m_CollsCount;i++){
               string m_tn=m_Name+"_Cell_R("+IntegerToString(aR)+")_C("+IntegerToString(i)+")";
                  if(ObjectFind(0,m_tn)==m_SubWindow){
                     g.Attach(m_tn);
                     g.SetBgColor(m_FlashColor);
                  }
            }           }
      }                       
   public:
		/*!	
			  .
            \param		string aName="CTable" - ,
            \param		int aWidth=200 -  ,
            \param		int aHeight=200 -  .
            \remark           ,   .
 		*/      
      void Init(string aName="CTable",int aWidth=200,int aHeight=200){
         m_SubWindow=0;
         m_Visible=false;
         m_Name=aName;
         m_CollsCount=0;
         m_RowsCount=0;         
         ArrayResize(m_CollWidth,0);
         ArrayResize(m_row,0);
         m_Width=aWidth;
         m_Height=aHeight;
         m_left=0;
         m_Top=0;
         m_tWidth=0;
         m_tHeight=0;  
         m_DefBgColor=ClrScheme.Color(0);
         m_DefTxColor=ClrScheme.Color(1);
         m_FlashColor=ClrScheme.Color(14);
         m_DefFontFace="Arial";
         m_DefFontSize=7;
         m_PreSelectedR=-1;
         m_PreSelectedC=-1;   
         m_PreNorm=true;      
         m_Tag="";
         m__vsb.Init(m_Name+"_VSB",m_Height);      
         m__hsb.Init(m_Name+"_HSB",m_Width);
         m_LastClickedRow=-1;
         m_LastClickedColl=-1;
         m_AllowSelection=true;
      }
		/*!	
			 .
			\remark             .    ,    Refresh().
 		*/        
      void AddRow(){
         ArrayResize(m_row,m_RowsCount+1);
         ArrayResize(m_row[m_RowsCount].CellBGColor,m_CollsCount);
         ArrayResize(m_row[m_RowsCount].CellText,m_CollsCount);         
         ArrayResize(m_row[m_RowsCount].CellTxtColor,m_CollsCount);
         ArrayResize(m_row[m_RowsCount].CellFont,m_CollsCount);         
         ArrayResize(m_row[m_RowsCount].CellFontSize,m_CollsCount);   
         ArrayResize(m_row[m_RowsCount].CellCollSpan,m_CollsCount);         
         ArrayResize(m_row[m_RowsCount].CellRowSpan,m_CollsCount);  
         ArrayResize(m_row[m_RowsCount].CellExist,m_CollsCount);                
         m_row[m_RowsCount].RowHeight=15;
            for(int i=0;i<m_CollsCount;i++){
               m_row[m_RowsCount].CellBGColor[i]=m_DefBgColor;
               m_row[m_RowsCount].CellText[i]="";  
               m_row[m_RowsCount].CellTxtColor[i]=m_DefTxColor;
               m_row[m_RowsCount].CellFont[i]=m_DefFontFace;
               m_row[m_RowsCount].CellFontSize[i]=m_DefFontSize;
               m_row[m_RowsCount].CellCollSpan[i]=1;
               m_row[m_RowsCount].CellRowSpan[i]=1;
               m_row[m_RowsCount].CellExist[i]=true;
            }
         m_RowsCount++;
         CountTHeight();  
      }
		/*!	
			    .
			\param   int aIndex -   ,
			\remark     ,    Refresh().
 		*/        
      void DeleteRow(int aIndex){
         if(m_RowsCount>0){
               for(int i=aIndex;i<m_RowsCount-1;i++){
                  ArrayResize(m_row[i].CellBGColor,ArraySize(m_row[i+1].CellBGColor));
                  ArrayCopy(m_row[i].CellBGColor,m_row[i+1].CellBGColor);
                  ArrayResize(m_row[i].CellCollSpan,ArraySize(m_row[i+1].CellCollSpan));
                  ArrayCopy(m_row[i].CellCollSpan,m_row[i+1].CellCollSpan);  
                  ArrayResize(m_row[i].CellExist,ArraySize(m_row[i+1].CellExist));
                  ArrayCopy(m_row[i].CellExist,m_row[i+1].CellExist);                 
                  ArrayResize(m_row[i].CellFont,ArraySize(m_row[i+1].CellFont));
                  ArrayCopy(m_row[i].CellFont,m_row[i+1].CellFont);  
                  ArrayResize(m_row[i].CellFontSize,ArraySize(m_row[i+1].CellFontSize));
                  ArrayCopy(m_row[i].CellFontSize,m_row[i+1].CellFontSize);  
                  ArrayResize(m_row[i].CellMergeHeight,ArraySize(m_row[i+1].CellMergeHeight));
                  ArrayCopy(m_row[i].CellMergeHeight,m_row[i+1].CellMergeHeight);  
                  ArrayResize(m_row[i].CellMergeWidth,ArraySize(m_row[i+1].CellMergeWidth));
                  ArrayCopy(m_row[i].CellMergeWidth,m_row[i+1].CellMergeWidth);  
                  ArrayResize(m_row[i].CellRowSpan,ArraySize(m_row[i+1].CellRowSpan));
                  ArrayCopy(m_row[i].CellRowSpan,m_row[i+1].CellRowSpan);  
                  ArrayResize(m_row[i].CellText,ArraySize(m_row[i+1].CellText));
                  ArrayCopy(m_row[i].CellText,m_row[i+1].CellText); 
                  ArrayResize(m_row[i].CellTxtColor,ArraySize(m_row[i+1].CellTxtColor));
                  ArrayCopy(m_row[i].CellTxtColor,m_row[i+1].CellTxtColor); 
                  m_row[i].RowHeight=m_row[i+1].RowHeight;
               }
            m_RowsCount--;
            ArrayResize(m_row,m_RowsCount);
         }    
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/ 
      void Show(int aLeft,int aTop){
         m_left=aLeft;
         m_Top=aTop;
         Show();
      }
		/*!	
			 .
 		*/        
      void Show(){
         m_Visible=true;
         Create();
         ChartRedraw();
      }  
		/*!	
			   (  ).
 		*/             
      void Hide(){
         m_Visible=false;
         Delete();
            if(m__vsb.Visible() || m__hsb.Visible()){
               m__vsb.Hide();
               m__hsb.Hide();
            }
         ChartRedraw();
      }
		/*!	
			 (     ).
 		*/        
      void Refresh(){
            if(m_Visible){
               Delete();
            }
            if(m__hsb.Visible()){
               m__hsb.Hide();
            }
            if(m__vsb.Visible()){
               m__vsb.Hide();
            }
            if(m_Visible){
               Show();
            }               
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/       
      void SetPos(int aLeft,int aTop){
         m_left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosLeft(int aLeft){
         m_left=aLeft;
      } 
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/            
      void SetPosTop(int aTop){
         m_Top=aTop;
      }     
		/*!	
			  X.
			\return   ( int).
 		*/ 
      int Left(){
         return(m_left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/         
      int Top(){
         return(m_Top);
      }
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/ 
      void SetWidth(int aWidth){
         m_Width=aWidth;
      }
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/        
      void SetHeight(int aHeight){
         m_Height=aHeight;
      }
		/*!	
			 .
			\return   ( int).
 		*/         
      int Width(){
         return(m_Width);
      }
		/*!	
			 .
			\return   ( int).
 		*/        
      int Height(){
         return(m_Height);
      }   
		/*!	
			   .
            \param		int aCount -  .
            \remark	      ,    Refresh().
 		*/          
      void SetCollsCount(int aCount){
         int m_tmp=m_CollsCount;
         m_CollsCount=aCount;
         ArrayResize(m_CollWidth,m_CollsCount);
            for(int j=m_tmp;j<m_CollsCount;j++){
               m_CollWidth[j]=30;
            }
            for(int i=0;i<m_RowsCount;i++){
               ArrayResize(m_row[i].CellBGColor,m_CollsCount);
               ArrayResize(m_row[i].CellText,m_CollsCount);               
               ArrayResize(m_row[i].CellTxtColor,m_CollsCount);    
               ArrayResize(m_row[i].CellFont,m_CollsCount);               
               ArrayResize(m_row[i].CellFontSize,m_CollsCount); 
               ArrayResize(m_row[i].CellCollSpan,m_CollsCount);               
               ArrayResize(m_row[i].CellRowSpan,m_CollsCount);  
               ArrayResize(m_row[i].CellExist,m_CollsCount);                
                  for(int j=m_tmp;j<m_CollsCount;j++){
                     m_row[i].CellBGColor[j]=m_DefBgColor;
                     m_row[i].CellText[j]="";  
                     m_row[i].CellTxtColor[j]=m_DefTxColor;
                     m_row[i].CellFont[j]=m_DefFontFace;
                     m_row[i].CellFontSize[j]=m_DefFontSize;
                     m_row[i].CellCollSpan[j]=1;
                     m_row[i].CellRowSpan[j]=1;
                     m_row[i].CellExist[j]=true;
                  }
            }
         CountTWidth();
      }
		/*!	
			  .
            \param		int aCollIndex -  ,
            \param		int aWidth -  ,            
            \remark	      ,    Refresh().
 		*/       
      void SetCollWidth(int aCollIndex,int aWidth){
         m_CollWidth[aCollIndex]=aWidth;
         CountTWidth();
      }
		/*!	
			  .
            \param		int aRowsCount -  .
            \remark	      ,    Refresh().
 		*/        
      void SetRowsCount(int aRowsCount){
            if(aRowsCount<m_RowsCount){
               m_RowsCount=aRowsCount;
               ArrayResize(m_row,m_RowsCount); 
               CountTHeight();        
            }
            else{
               for(int i=m_RowsCount;i<aRowsCount;i++){
                  AddRow();
               }
            }
         
      }
		/*!	
			 .
            \remark	      ,    Refresh().
 		*/        
      void Clear(){
         ArrayResize(m_row,0);
         ArrayResize(m_CollWidth,0);
         m_CollsCount=0;
         m_RowsCount=0;
         m__hsb.SetValue(0);
         m__vsb.SetValue(0);
      }
		/*!	
			  .
            \param		int aRowIndex -  ,
            \param		int aHeight -  ,            
            \remark	      ,    Refresh().
 		*/        
      void SetRowHeight(int aRowIndex,int aHeight){
         m_row[aRowIndex].RowHeight=aHeight;
         CountTHeight();
      }
		/*!	
			  .
            \param		int aRowIndex -  ,
            \param		int aCollIndex -  ,            
            \param		string aText - .           
            \remark	      ,    Refresh().
 		*/        
      void SetCellText(int aRowIndex,int aCollIndex,string aText){
         m_row[aRowIndex].CellText[aCollIndex]=aText;
      }
		/*!	
			   .
            \param		int aRowIndex -  ,
            \param		int aCollIndex -  ,            
            \param		color aBGColor -  .           
            \remark	      ,    Refresh().
 		*/         
      void SetCellBGColor(int aRowIndex,int aCollIndex,color aBGColor){
         m_row[aRowIndex].CellBGColor[aCollIndex]=aBGColor;
      }
		/*!	
			   .
            \param		int aRowIndex -  ,
            \param		int aCollIndex -  ,            
            \param		color aTxtColor -  .           
            \remark	      ,    Refresh().
 		*/        
      void SetCellTxtColor(int aRowIndex,int aCollIndex,color aTxtColor){
         m_row[aRowIndex].CellTxtColor[aCollIndex]=aTxtColor;
      }
		/*!	
			  .
            \param		int aRowIndex -  ,
            \param		int aCollIndex -  ,            
            \param		string aFont -  .           
            \remark	      ,    Refresh().
 		*/        
      void SetCellFont(int aRowIndex,int aCollIndex,string aFont="Arial"){
         m_row[aRowIndex].CellFont[aCollIndex]=aFont;
      }
		/*!	
			   .
            \param		int aRowIndex -  ,
            \param		int aCollIndex -  ,            
            \param		aFontSize -  .           
            \remark	      ,    Refresh().
 		*/         
      void SetCellFontSize(int aRowIndex,int aCollIndex,int aFontSize){
         m_row[aRowIndex].CellFontSize[aCollIndex]=aFontSize;
      }
		/*!	
			 .
            \param		int aRowIndex -  ,
            \param		int aCollIndex -  ,            
            \param		int aRowSpan -    ,
            \param		int aCollSpan -    .
            \remark	      ,    Refresh().  1  aRowSpan  aCollSpan    .
 		*/       
      void SetCellsMerge(int aRowIndex,int aCollIndex,int aRowSpan,int aCollSpan){
         aRowSpan=(int)MathMax(aRowSpan,1);
         aCollSpan=(int)MathMax(aCollSpan,1);
         if(m_row[aRowIndex].CellExist[aCollIndex]){
            int m_rs=m_row[aRowIndex].CellRowSpan[aCollIndex];
            int m_cs=m_row[aRowIndex].CellCollSpan[aCollIndex];
               for(int i=aRowIndex;i<MathMin(m_RowsCount,aRowIndex+m_rs);i++){
                  for(int j=aCollIndex;j<MathMin(m_CollsCount,aCollIndex+m_cs);j++){
                     m_row[i].CellExist[j]=true;
                  }
               }
            m_rs=aRowSpan;
            m_cs=aCollSpan;    
               for(int i=aRowIndex;i<MathMin(m_RowsCount,aRowIndex+m_rs);i++){
                  for(int j=aCollIndex;j<MathMin(m_CollsCount,aCollIndex+m_cs);j++){
                     m_row[i].CellExist[j]=false;
                  }
               }
            m_row[aRowIndex].CellRowSpan[aCollIndex]=aRowSpan;
            m_cs=m_row[aRowIndex].CellCollSpan[aCollIndex]=aCollSpan;   
            m_row[aRowIndex].CellExist[aCollIndex]=true;
         }
      }
		/*!	
			 .
			\return   ( int).
 		*/       
      int CollsCount(){
         return(m_CollsCount);
      }    
		/*!	
			 .
			\param	int aCollIndex -  .
			\return   ( int).
 		*/         
      int CollWidth(int aCollIndex){
         return(m_CollWidth[aCollIndex]);
      }  
		/*!	
			 .
			\return   ( int).
 		*/         
      int RowsCount(){
         return(m_RowsCount);
      }  
		/*!	
			 .
			\param	int aRowIndex -  .
			\return   ( int).
 		*/        
      int RowHeight(int aRowIndex){
         return(m_row[aRowIndex].RowHeight);
      }
		/*!	
			 .
			\param	int aRowIndex -  ,
			\param	int aCollIndex -  .			
			\return   ( string).
 		*/       
      string CellText(int aRowIndex,int aCollIndex){
         return(m_row[aRowIndex].CellText[aCollIndex]);
      }
		/*!	
			  .
			\param	int aRowIndex -  ,
			\param	int aCollIndex -  .			
			\return   ( color).
 		*/         
      color CellBGColor(int aRowIndex,int aCollIndex){
         return(m_row[aRowIndex].CellBGColor[aCollIndex]);
      }
		/*!	
			  .
			\param	int aRowIndex -  ,
			\param	int aCollIndex -  .			
			\return   ( color).
 		*/         
      color CellTxtColor(int aRowIndex,int aCollIndex){
         return(m_row[aRowIndex].CellTxtColor[aCollIndex]);
      }
		/*!	
			 .
			\param	int aRowIndex -  ,
			\param	int aCollIndex -  .			
			\return   ( string).
 		*/                
      string CellFont(int aRowIndex,int aCollIndex){
         return(m_row[aRowIndex].CellFont[aCollIndex]);
      }
		/*!	
			  .
			\param	int aRowIndex -  ,
			\param	int aCollIndex -  .			
			\return   ( int).
 		*/         
      int CellFontSize(int aRowIndex,int aCollIndex){
         return(m_row[aRowIndex].CellFontSize[aCollIndex]);
      } 
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1     .
 		*/ 
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
         int m_rv=0;
               if(m__hsb.Event(id,lparam,dparam,sparam) || m__vsb.Event(id,lparam,dparam,sparam)){
                  Show();
               }
               if(id==CHARTEVENT_OBJECT_CLICK){
                  if(StringFind(sparam,m_Name+"_Cell",0)==0){
                     int m_p1=StringFind(sparam,"R(",0)+2;
                     int m_p2=StringFind(sparam,")",0);
                     m_LastClickedRow=(int)StringToInteger(StringSubstr(sparam,m_p1,m_p2-m_p1));
                     m_p1=StringFind(sparam,"C(",0)+2;
                     m_p2=StringFind(sparam,")",0);
                     m_LastClickedColl=(int)StringToInteger(StringSubstr(sparam,m_p1,m_p2-m_p1));
                     m_rv=1;
                     //string m_tn=m_Name+"_Cell_R("+IntegerToString(m_LastClickedRow)+")_C("+IntegerToString(m_LastClickedColl)+")";
                        if(m_AllowSelection){
                              if(m_LastClickedRow==m_PreSelectedR && m_LastClickedColl==m_PreSelectedC){
                                 if(!m_PreNorm){
                                    SetCrossColor(m_PreSelectedR,m_PreSelectedC,true);
                                    m_PreNorm=true;
                                 } 
                                 else{
                                    SetCrossColor(m_PreSelectedR,m_PreSelectedC,false);
                                    m_PreNorm=false;                           
                                 }
                              }
                              else{
                                    if(m_PreSelectedR!=-1){
                                       SetCrossColor(m_PreSelectedR,m_PreSelectedC,true); 
                                    }                              
                                 SetCrossColor(m_LastClickedRow,m_LastClickedColl,false); 
                                 m_PreNorm=false;
                              }
                           m_PreSelectedR=m_LastClickedRow;
                           m_PreSelectedC=m_LastClickedColl;
                        }
                     ChartRedraw(0);
                  }
               }
         return(m_rv);
      }     
		/*!	
			  HTML.
			\return   HTML ( string).
 		*/       
      string HTML(){
         string m_ms="style=\""+
            "border: 1px solid "+WEBColor(m_DefTxColor)+";"+
            "border-spacing: 0;"+
                                 "font-family: "+m_DefFontFace+";"+
                                 "font-size: "+its(m_DefFontSize)+"pt;"+
                                 "color: "+WEBColor(m_DefTxColor)+";"+    
                                 "background-color: "+WEBColor(m_DefBgColor)+";"+                             
            "\"";
         string m_str="<table "+m_ms+" cellspacing=0>\n";
            for(int i=0;i<ArraySize(m_row);i++){
               m_str=m_str+"<tr>\n";
                  for(int j=0;j<m_CollsCount;j++){
                     if(m_row[i].CellExist[j]){
                        string m_t1=iif(m_row[i].CellCollSpan[j]>1," colspan="+IntegerToString(m_row[i].CellCollSpan[j]),"");
                        string m_t2=iif(m_row[i].CellRowSpan[j]>1," rowspan="+IntegerToString(m_row[i].CellRowSpan[j]),"");
                        string m_t3="style=\"";
                           m_t3=m_t3+"border: 1px solid "+WEBColor(m_row[i].CellTxtColor[j])+";";
                           if(m_row[i].CellBGColor[j]!=m_DefBgColor)m_t3=m_t3+"background-color: "+WEBColor(m_row[i].CellBGColor[j])+";";
                           if(m_row[i].CellFont[j]!=m_DefFontFace)m_t3=m_t3+"font-family: "+m_row[i].CellFont[j]+";";
                           if(m_row[i].CellFontSize[j]!=m_DefFontSize)m_t3=m_t3+"font-size: "+its(m_row[i].CellFontSize[j])+"pt;";
                           if(m_row[i].CellTxtColor[j]!=m_DefTxColor)m_t3=m_t3+"color: "+WEBColor(m_row[i].CellTxtColor[j])+";";
                        m_t3=m_t3+"\"";
                        int m_w=0;
                           for(int k=j;k<j+m_row[i].CellCollSpan[j];k++){
                              if(k<m_CollsCount){
                                 m_w+=m_CollWidth[j];
                              }
                           }
                        int m_h=0;
                           for(int k=i;k<i+m_row[i].CellRowSpan[j];k++){
                              if(k<ArraySize(m_row)){
                                 m_h+=m_row[k].RowHeight;
                              }
                           } 
                        m_h-=2;
                        m_str=m_str+"<td "+m_t3+" width="+its(m_w)+" height="+its(m_h)+m_t1+m_t2+">"+ m_row[i].CellText[j]+"</td>\n";
                     }
                  }
               m_str=m_str+"</tr>\n";            
            }
         m_str=m_str+"</table>\n";     
         return(m_str);
      }   
		/*!	
			 .
			\param string aValue - .
 		*/         
      void SetTag(string aTag){
         m_Tag=aTag;
      }
		/*!	
			 .
			\return  ( string).
 		*/     
      string Tag(){
         return(m_Tag);
      } 
		/*!	
			   .
			\param int aNumber -  .
 		*/         
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               m__hsb.SetSubWindow(m_SubWindow);
               m__vsb.SetSubWindow(m_SubWindow);               
               Refresh();
            }
      } 
		/*!	
			    .
			\param string aName -  .
 		*/                
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }   
		/*!	
			      .
			\return  ( int).
 		*/        
      int LastClickedRaw(){
         return(m_LastClickedRow);
      }
		/*!	
			      .
			\return  ( int).
 		*/    
      int LastClickedColl(){
         return(m_LastClickedColl);
      }
		/*!	
			  .
			\param bool aValue - true/false - /.
 		*/       
      void SetAllowSelection(bool aValue){
         m_AllowSelection=aValue;
      }
		/*!	
			    .
			\return  bool. True - , false - .
 		*/        
      bool AllowSelection(){
         return(m_AllowSelection);
      }      
};

//+------------------------------------------------------------------+
//|          CFrame                                             |
//+------------------------------------------------------------------+

/*!
   \brief     .
   \details   Frame  CWorkPiece,    .
*/

class CFrame{
   private:
      int m_Left;
      int m_Top;
      int m_Width;
      int m_Height;
      int m_CaptionWidth;
      string m_Name;
      string m_Caption;
      int m_SubWindow;
      bool m_Visible;
      color m_BgColor;
      color m_BorderColor;
      color m_CaptionColor;
      string m_Tag;
   public:
		/*!	
			  .
            \param		string aName="CFrame" - ,
            \param		int aWidth=50 - ,
            \param		int aHeight=50 - ,
            \param		string aCaption="CFrame" - ,
            \param		int aCaptionWidth=35 -  .
 		*/     
      void Init(string aName="CFrame",int aWidth=50,int aHeight=50,string aCaption="CFrame",int aCaptionWidth=37){
         m_Left=0;
         m_Top=0;
         m_Width=aWidth;
         m_Height=aHeight;
         m_CaptionWidth=aCaptionWidth;
         m_Name=aName;
         m_Caption=aCaption;
         m_SubWindow=0;
         m_Visible=false;
         m_BgColor=ClrScheme.Color(39);
         m_BorderColor=ClrScheme.Color(40);
         m_CaptionColor=ClrScheme.Color(41);     
         m_Tag="";    
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/   
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/             
      void SetPosTop(int aTop){
         m_Top=aTop;
      }      
		/*!	
			 .
 		*/       
      void Show(){
         m_Visible=true;
         w.Frame(m_Name,m_SubWindow,m_Left,m_Top,m_Width,m_Height,m_Caption,m_CaptionWidth,m_BgColor,m_BorderColor,m_CaptionColor);
         w.Redraw();
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/        
      void Show(int aLeft,int aTop){
         SetPos(aLeft,aTop);
         Show();
      }   
		/*!	
			   (  ).
 		*/   
      void Hide(){
         m_Visible=false;
         w.FrameDelete(m_Name);
         w.Redraw();
      }   
		/*!	
			 (     ).
 		*/        
      void Refresh(){
         if(m_Visible){
            w.FrameDelete(m_Name);
            Show();
         }
      }
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){ //   X
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/        
      int Top(){ //   Y
         return(m_Top);
      }
		/*!	
			 .
			\return   ( int).
 		*/        
      int Width(){ //  
         return(m_Width);
      }
		/*!	
			 .
			\return   ( int).
 		*/        
      int Height(){
         return(m_Height); //  
      }      
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/         
      void SetWidth(int aWidth){ //   
         m_Width=aWidth;
      }
		/*!	
			 .
            \param		int aHeight - .
            \remark	      ,    Refresh().
 		*/         
      void SetHeight(int aHeight){ //   
         m_Height=aHeight;
      }
	
		/*!	
			  .
			\return   ( int).
 		*/        
      int CaptionWidth(){ //  
         return(m_CaptionWidth);
      }    
		/*!	
			  .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/         
      void SetCaptionWidth(int aCaptionWidth){ //   
         m_CaptionWidth=aCaptionWidth;
      }   
		/*!	
			  .
			\return   ( string).
 		*/
      string Caption(){
         return(m_Caption);
      }    
		/*!	
			  .
            \param		string aCaption -  .
            \remark	      ,    Refresh().
 		*/ 
      void SetCaption(string aCaption){
         m_Caption=aCaption;
      }         
		/*!	
			   .
			\param int aNumber -  .
 		*/       
      void SetSubWindow(int aNumber){ //    
         int m_itmp=(int)MathMax(aNumber,0); //    ,   0 -  
            if(m_itmp!=m_SubWindow){ //           
               m_SubWindow=m_itmp; //    
               Refresh(); //   
            }
      }  
		/*!	
			    .
			\param string aName -  .
 		*/              
      void SetSubWindow(string aName){ //     
         SetSubWindow(ChartWindowFind(0,aName)); //          
      }
		/*!	
			 .
			\param string aValue - .
 		*/       
      void SetTag(string aValue){ //  
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/        
      string Tag(){ //  
         return(m_Tag);
      }       
};


//+------------------------------------------------------------------+
//|          CButton                                             |
//+------------------------------------------------------------------+

/*!
   \brief   .
   \details   OBJ_BUTTON.
*/

class CButton{
   private:
      int m_Left;
      int m_Top;
      int m_Width;
      int m_Height;
      int m_CaptionWidth;
      string m_Name;
      string m_Caption;
      int m_SubWindow;
      bool m_Visible;
      color m_BgColor;
      color m_CaptionColor;
      string m_Tag;
   public:
		/*!	
			  .
            \param		string aName="CButtom" - ,
            \param		int aWidth=50 - ,
            \param		int aHeight=50 - ,
            \param		string aCaption="CButton" - ,
 		*/     
      void Init(string aName="CButton",int aWidth=80,int aHeight=30,string aCaption="CButton"){
         m_Left=0;
         m_Top=0;
         m_Width=aWidth;
         m_Height=aHeight;
         m_Name=aName;
         m_Caption=aCaption;
         m_SubWindow=0;
         m_Visible=false;
         m_BgColor=ClrScheme.Color(42);
         m_CaptionColor=ClrScheme.Color(43);     
         m_Tag="";    
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/   
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/             
      void SetPosTop(int aTop){
         m_Top=aTop;
      }      
		/*!	
			 .
 		*/       
      void Show(){
         m_Visible=true;
         w.Button(m_Name,m_SubWindow,m_Left,m_Top,m_Width,m_Height,m_Caption,m_BgColor,m_CaptionColor);
         w.Redraw();
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/        
      void Show(int aLeft,int aTop){
         SetPos(aLeft,aTop);
         Show();
      }   
		/*!	
			   (  ).
 		*/   
      void Hide(){
         m_Visible=false;
         w.Delete(m_Name);
         w.Redraw();
      }   
		/*!	
			 (     ).
 		*/        
      void Refresh(){
         if(m_Visible){
            w.Delete(m_Name);
            Show();
         }
      }
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){ //   X
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/        
      int Top(){ //   Y
         return(m_Top);
      }
		/*!	
			 .
			\return   ( int).
 		*/        
      int Width(){ //  
         return(m_Width);
      }
		/*!	
			 .
			\return   ( int).
 		*/        
      int Height(){
         return(m_Height); //  
      }      
		/*!	
			 .
            \param		int aWidth - .
            \remark	      ,    Refresh().
 		*/         
      void SetWidth(int aWidth){ //   
         m_Width=aWidth;
      }
		/*!	
			 .
            \param		int aHeight - .
            \remark	      ,    Refresh().
 		*/         
      void SetHeight(int aHeight){ //   
         m_Height=aHeight;
      }
		/*!	
			  .
			\return   ( string).
 		*/
      string Caption(){
         return(m_Caption);
      }    
		/*!	
			  .
            \param		string aCaption -  .
            \remark	      ,    Refresh().
 		*/ 
      void SetCaption(string aCaption){
         m_Caption=aCaption;
      }         
		/*!	
			   .
			\param int aNumber -  .
 		*/       
      void SetSubWindow(int aNumber){ //    
         int m_itmp=(int)MathMax(aNumber,0); //    ,   0 -  
            if(m_itmp!=m_SubWindow){ //           
               m_SubWindow=m_itmp; //    
               Refresh(); //   
            }
      }  
		/*!	
			    .
			\param string aName -  .
 		*/              
      void SetSubWindow(string aName){ //     
         SetSubWindow(ChartWindowFind(0,aName)); //          
      }
		/*!	
			 .
			\param string aValue - .
 		*/       
      void SetTag(string aValue){ //  
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/        
      string Tag(){ //  
         return(m_Tag);
      }
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0  1. 0 -  . 1     .
 		*/ 
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
            if(id==CHARTEVENT_OBJECT_CLICK){
               if(sparam==m_Name){
                  if(g.State(m_Name)){
                     Sleep(100);
                     g.SetState(m_Name,false);
                     g.Redraw();
                     return(1);
                  }
               }
            }
         return(0);
      }
};


//+------------------------------------------------------------------+
//|          CLabel                                             |
//+------------------------------------------------------------------+

/*!
   \brief   .
   \details   OBJ_LABEL.
*/

class CLabel{
   private:
      int m_Left;
      int m_Top;
      int m_Width;
      int m_Height;
      string m_Name;
      string m_Text;
      string m_TextArray[];
      int m_SubWindow;
      bool m_Visible;
      color m_Color;
      int m_FontSize;
      string m_Font;
      string m_Tag;
      void Create(){
         for(int i=0;i<ArraySize(m_TextArray);i++){
            w.Label(m_Name+"_Lbl("+IntegerToString(i)+")",m_SubWindow,m_Left,m_Top+int(i*m_FontSize*1.4),m_TextArray[i],m_Color,m_FontSize,m_Font);
         }      
      }
      void Delete(){
         for(int i=0;i<ArraySize(m_TextArray);i++){
            g.Delete(m_Name+"_Lbl("+IntegerToString(i)+")");
         }
      }
   public:
		/*!	
			  .
            \param		string aName="CLabel" - ,
            \param		string aText="CLabel" - ,
 		*/     
      void Init(string aName="CLabel",string aText="CLabel"){
         m_Left=0;
         m_Top=0;
         m_Name=aName;
         m_Text=aText;
         m_SubWindow=0;
         m_Visible=false;
         m_Color=ClrScheme.Color(44);
         m_FontSize=8;
         m_Font="Arial";         
         m_Tag="";  
         StringSplit(m_Text,'\n',m_TextArray);
         m_Visible=false;
      }
		/*!	
			  X  Y.
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/   
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
		/*!	
			  X.
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }
		/*!	
			  Y.
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/             
      void SetPosTop(int aTop){
         m_Top=aTop;
      }      
		/*!	
			 .
 		*/       
      void Show(){
         m_Visible=true;
         Create();
         ChartRedraw();
      }
		/*!	
			    .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).			
 		*/        
      void Show(int aLeft,int aTop){
         SetPos(aLeft,aTop);
         Show();
      }   
		/*!	
			   (  ).
 		*/   
      void Hide(){
         m_Visible=false;
         Delete();            
         ChartRedraw();
      }   
		/*!	
			 (     ).
 		*/        
      void Refresh(){
         if(m_Visible){
            Delete();
            Show();
         }
      }
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){ //   X
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/        
      int Top(){ //   Y
         return(m_Top);
      }
		/*!	
			  .
			\return   ( string).
 		*/
      string Text(){
         return(m_Text);
      }    
		/*!	
			  .
            \param		string aText="" -  .
 		*/ 
      void SetText(string aText=""){
            if(m_Visible){
               Delete();
            }
         m_Text=aText;
         StringSplit(m_Text,'\n',m_TextArray);
            if(m_Visible){
               Create();
               ChartRedraw();
            }
      }
		/*!	
			 .
			\return   ( string).
 		*/
      string Font(){
         return(m_Font);
      }    
		/*!	
			 .
            \param		string aFont="Arial" - .
 		*/ 
      void SetFont(string aFont="Arial"){
         m_Font=aFont;
         Refresh();
      }
		/*!	
			  .
			\return    ( int).
 		*/
      int FontSize(){
         return(m_FontSize);
      }    
		/*!	
			  .
            \param		string aFontSize=8 -  .
 		*/ 
      void SetFontSize(int aFontSize=8){
         m_FontSize=aFontSize;
         Refresh();
      }     
		/*!	
			 .
            \param		color aColor=16777216 - .   ,    ,        . 
 		*/ 
      void SetColor(color aColor=16777216){
            if(aColor==16777216){
               aColor=ClrScheme.Color(44);
            }
         m_Color=aColor;
         Refresh();
      }          
		/*!	
			   .
			\param int aNumber -  .
 		*/       
      void SetSubWindow(int aNumber){ //    
         int m_itmp=(int)MathMax(aNumber,0); //    ,   0 -  
            if(m_itmp!=m_SubWindow){ //           
               m_SubWindow=m_itmp; //    
               Refresh(); //   
            }
      }  
		/*!	
			    .
			\param string aName -  .
 		*/              
      void SetSubWindow(string aName){ //     
         SetSubWindow(ChartWindowFind(0,aName)); //          
      }
		/*!	
			 .
			\param string aValue - .
 		*/       
      void SetTag(string aValue){ //  
         m_Tag=aValue;
      }
		/*!	
			 .
			\return  ( string).
 		*/        
      string Tag(){ //  
         return(m_Tag);
      }
};

//+------------------------------------------------------------------+
//|          CFormBase                                          |
//+------------------------------------------------------------------+

/*!
   \brief     .       .
   \details           
             .       
            .    CFormTemplate.
   \remark	       
            " " (OBJ_RECTANGLE_LABEL)   
             (OBJ_BUTTON).    
                   .   
                ,    
                   "_Form",
                 - "_Upper",     - 
            "_Caption",      - "_Lower",   "Close"
             "Cancel" - "_Cancel",   "Apply" - "_Apply",  
               - "_Move",    
              - "_Min",     
               ( ) - "_Close".
*/

class CFormBase{
   protected:
      color m_MainColor; 
      color m_BorderColor;
      color m_TxtColor;
      color m_UpperColor;
      color m_LowerColor;
      color m_UpperTxtColor;
      color m_ButColor;
      int m_Type;   
      int m_SubWindow;
      string m_Name;
      int m_Width;
      int m_Height;
      int m_Left;
      int m_Top;      
      string m_Caption;
      bool m_MoveMode;
      long m_Tc;
      int m_State;
      string m_Tag;
      bool m_Movable;
      bool m_Resizable;
      bool m_CloseButton;
      int m_SpaceLeft;
      int m_SpaceTop;
      bool m_Visible;
         virtual void OnShowEvent(int aLeft,int aTop){
         }
         virtual void OnHideEvent(){
         }
         virtual void EventsHandler(const int id,const long& lparam,const double& dparam,const string& sparam){
         }
         virtual bool OnCancelEvent(){
            return(true);
         }
         virtual bool OnApplyEvent(){
            return(true);
         } 
         virtual void MainProperties(){
         }
         virtual void OnInitEvent(){
         }
         virtual void OnWindowChangeEvent(int aSubWindow){
         }
         bool PosCorrection(){
            int m_chw=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,m_SubWindow);
            int m_chh=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,m_SubWindow);
               if(m_chw<=0 || m_chh<=0){
                  return(false);
               }
            int m_mxleft=m_chw-Width();
            int m_mxtop=m_chh-Height();
            int m_oldleft=m_Left;
            int m_oldtop=m_Top;
            m_Left=(int)MathMin(m_Left,m_mxleft);
            m_Left=(int)MathMax(m_Left,0);
            m_Top=(int)MathMin(m_Top,m_mxtop);
            m_Top=(int)MathMax(m_Top,0);
            m_SpaceLeft=m_Left;
            m_SpaceTop=m_Top+16;
            return(m_oldleft!=m_Left || m_oldtop!=m_Top);
         }
         void CreateForm(){
            if(m_State==0)return;
            PosCorrection();          
            if(m_State!=2)w.Canvas(m_Name+"_Form",m_SubWindow,m_Left,m_Top,m_Width,m_Height,m_MainColor,m_BorderColor);
            w.Canvas(m_Name+"_Upper",m_SubWindow,m_Left,m_Top,m_Width,17,m_UpperColor,m_BorderColor);
            int m_xshift=15;
               if(m_CloseButton){
                  w.Button(m_Name+"_Close",m_SubWindow,m_Left+m_Width-15,m_Top+2,13,13,CharToString(251),m_ButColor,m_TxtColor,10,"Wingdings");
                  m_xshift=29;
               }                  
               if(m_Resizable){
                  w.Button(m_Name+"_Min",m_SubWindow,m_Left+m_Width-m_xshift,m_Top+2,13,13,CharToString(168),m_ButColor,m_TxtColor,7,"Wingdings");
               }                  
            m_xshift=4;
               if(m_Movable){
                  w.Button(m_Name+"_Move",m_SubWindow,m_Left+2,m_Top+2,13,13,CharToString(73),m_ButColor,m_TxtColor,8,"Wingdings");
                  m_xshift=16;
               }                  
            w.Label(m_Name+"_Caption",m_SubWindow,m_Left+m_xshift,m_Top+2,m_Caption,m_UpperTxtColor);
               if(m_State!=2){
                     switch(m_Type){
                        case 1:
                           w.Canvas(m_Name+"_Lower",m_SubWindow,m_Left,m_Top+m_Height-18,m_Width,18,m_LowerColor,m_BorderColor);
                           w.Button(m_Name+"_Apply",m_SubWindow,m_Left+m_Width-42,m_Top+m_Height-16,40,14,"Apply",m_ButColor,m_TxtColor);
                           w.Button(m_Name+"_Cancel",m_SubWindow,m_Left+2,m_Top+m_Height-16,40,14,"Cancel",m_ButColor,m_TxtColor);
                        break;
                        case 2:
                           w.Canvas(m_Name+"_Lower",m_SubWindow,m_Left,m_Top+m_Height-18,m_Width,18,m_LowerColor,m_BorderColor);
                           w.Button(m_Name+"_Cancel",m_SubWindow,m_Left+m_Width/2-20,m_Top+m_Height-16,40,14,"Close",m_ButColor,m_TxtColor);
                        break;
                     }
                  OnShowEvent(m_SpaceLeft,m_SpaceTop);
               }      
            
         }
         void DeleteForm(){
            OnHideEvent();
            ObjectDelete(0,m_Name+"_Form");
            ObjectDelete(0,m_Name+"_Upper");
            ObjectDelete(0,m_Name+"_Close");
            ObjectDelete(0,m_Name+"_Min");
            ObjectDelete(0,m_Name+"_Move");
            ObjectDelete(0,m_Name+"_Caption");
            ObjectDelete(0,m_Name+"_Lower");
            ObjectDelete(0,m_Name+"_Apply");
            ObjectDelete(0,m_Name+"_Cancel");      
         } 
         void ChartClickY(double aDparam,int & aY){
            long hs=0;
            long ps=0;
               for(int i=0;i<ChartGetInteger(0,CHART_WINDOWS_TOTAL);i++){
                  hs+=3+ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,i);
                     if(hs>=aDparam){
                        aY=(int)(aDparam-ps-3); 
                        break;
                     }
                  ps=hs;
               } 
         }  
         void WhenChartResize(){
            if(m_State!=0){
               if(PosCorrection()){
                  Refresh();
               }
            }
         }
   public:
		/*!	
			 .
			\param		int aState=1 - c     : 1 - , 2 - 
 		*/      
      void Init(int aState=1){
         m_Visible=false;
         m_SubWindow=0;
         m_MainColor=ClrScheme.Color(32);      //      
         m_BorderColor=ClrScheme.Color(33);    //  
         m_ButColor=ClrScheme.Color(34);       //  
         m_TxtColor=ClrScheme.Color(35);       //    
         m_UpperColor=ClrScheme.Color(36);     //   
         m_LowerColor=ClrScheme.Color(37);     //   
         m_UpperTxtColor=ClrScheme.Color(38);  //     
         m_Tag="";
         m_MoveMode=false;
         m_State=aState;
         m_SpaceLeft=0;
         m_SpaceTop=16;         
         MainProperties();
         OnInitEvent();
      }
		/*!	
			  X  Y .
            \param		int aLeft -  X (    ),
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/  
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;  
         m_SpaceLeft=m_Left;
         m_SpaceTop=m_Top+16;               
      }
		/*!	
			  X .
            \param		int aLeft -  X (    ).
            \remark	      ,    Refresh().
 		*/           
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
         m_SpaceLeft=m_Left;         
      }
		/*!	
			  Y .
            \param		int aTop -  Y (    ).
            \remark	      ,    Refresh().
 		*/        
      void SetPosTop(int aTop){
         m_Top=aTop;   
         m_SpaceTop=m_Top+16;       
      }  
		/*!	
			  .
 		*/  
      void Show(){
         m_Visible=true;
         CreateForm();  
         ChartRedraw();            
      } 
		/*!	
			     .
         \param		int aLeft -  X (    ),
         \param		int aTop -  Y (    ).
 		*/       
      void Show(int aLeft,int aTop){
         SetPos(aLeft,aTop);
         Show();
      } 
		/*!	
			  (    ).
 		*/        
      void Hide(){
         m_Visible=false;
         DeleteForm();
         ChartRedraw(0);
      }
		/*!	
			 (     ).
 		*/         
      void Refresh(){
         if(m_State!=0){
            DeleteForm();
            CreateForm();
            ChartRedraw();
         }            
      }
		/*!	
			  .
			\return   ( int).
 		*/        
      int Width(){
         return(m_Width);
      }     
		/*!	
			   .
			\return   ( int).
 		*/        
      int Height(){
            switch(m_State){
               case 1:
                  return(HeightMax());
               break;
               case 2:
                  return(HeightMin());
               break;
            }
         return(0);
      }   
		/*!	
			     .
			\return   ( int).
 		*/          
      int HeightMax(){
         return(m_Height);
      }    
		/*!	
			     .
			\return   ( int).
 		*/         
      int HeightMin(){
         return(17);
      }
		/*!	
			  X.
			\return   ( int).
 		*/       
      int Left(){ //   X
         return(m_Left);
      }
		/*!	
			  Y.
			\return   ( int).
 		*/        
      int Top(){ //   Y
         return(m_Top);
      }      
		/*!	
			  .
            \param		int aState - 1 - , 2 - .
 		*/         
      void SetState(int aState=1){
         if(aState>=1 && aState<=2){
            m_State=aState;
               if(m_Visible){
                  Refresh();
               }   
         }             
      } 
		/*!	
			  .
			\return   ( int). 0 - , 1 - , 2 - .
 		*/               
      int State(){
         return(m_State);
      } 
		/*!	
			  .
			\return   ( string).
 		*/                        
      string Name(){
         return(m_Name);
      }
		/*!	
			  .
			\return   ( string).
 		*/        
      string Caption(){
         return(m_Caption);
      }  
		/*!	
			 .
			\param string aValue - .
 		*/  
      void SetTag(string aTag){
         m_Tag=aTag;
      }
		/*!	
			 .
			\return  ( string).
 		*/       
      string Tag(string aTag){
         return(m_Tag);
      }      
		/*!	
			   .
			\param int aNumber -  .
 		*/         
      void SetSubWindow(int aNumber){
         int m_itmp=(int)MathMax(aNumber,0);
            if(m_itmp!=m_SubWindow){
               m_SubWindow=m_itmp;
               m_MoveMode=false;
                  if(m_Visible){
                     Hide();
                     OnWindowChangeEvent(m_itmp);
                     Show();                  
                      
                  }
                  else{
                     OnWindowChangeEvent(m_itmp);  
                  }                     
            }
      } 
		/*!	
			    .
			\param string aName -  .
 		*/                
      void SetSubWindow(string aName){
         SetSubWindow(ChartWindowFind(0,aName));
      }  
		/*!	
			  .
			\remark      OnChartEvent(),      OnChartEvent().
			\return  0, 1, 2  3. 0 -  . 1   "Cancel",      "Cancel", "Close"    , 2 -  "Apply",      "Apply", 3 -  "Resize",      , 4 -      .
 		*/       
      int Event(const int id,const long& lparam,const double& dparam,const string& sparam){
         int m_rv=0;   
            if(!m_MoveMode){
               EventsHandler(id,lparam,dparam,sparam);
                  if(id==CHARTEVENT_OBJECT_CLICK){
                     if(sparam==m_Name+"_Form"){
                        m_rv=4;   
                     }
                     if(sparam==m_Name+"_Close"){
                        Sleep(150);
                        g.Attach(m_Name+"_Close");
                        g.SetState(false);
                        g.Redraw();
                        Sleep(150);
                           if(OnCancelEvent()){
                              Hide();
                              m_rv=1;
                           }
                     }
                     if(sparam==m_Name+"_Cancel"){
                        Sleep(150);
                        g.Attach(m_Name+"_Cancel");
                        g.SetState(false);
                        g.Redraw();
                        Sleep(150);               
                           if(OnCancelEvent()){
                              Hide();
                              m_rv=1;
                           }
                     }
                     if(sparam==m_Name+"_Apply"){
                        Sleep(150);
                        g.Attach(m_Name+"_Apply");
                        g.SetState(false);
                        g.Redraw();
                        Sleep(150);               
                           if(OnApplyEvent()){
                              Hide();
                              m_rv=2;
                           }
                     }   
                     if(sparam==m_Name+"_Min"){
                        Sleep(150);
                        g.Attach(m_Name+"_Min");
                        g.SetState(false);
                        g.Redraw();
                        Sleep(150);
                           if(m_State==1){
                              SetState(2);
                           }
                           else if(m_State==2){
                              SetState(1);
                           }
                        m_rv=3;                   
                     }
                  }
            }
            if(sparam==m_Name+"_Move"){
               g.Attach(m_Name+"_Move");
               m_MoveMode=g.State();
               m_Tc=GetTickCount();
            }            
            if(id==CHARTEVENT_CLICK){
               if(m_MoveMode){
                  if(GetTickCount()>m_Tc+300){
                     m_MoveMode=false;
                     int m_Y;
                     ChartClickY(dparam,m_Y);
                     SetPos((int)lparam-3,m_Y);
                     Refresh();
                  }                  
               }
            }
            if(CHARTEVENT_CHART_CHANGE){
               WhenChartResize();
            }
         return(m_rv);            
      }
};

//+------------------------------------------------------------------+
//|          CFormTemplate: public CFormBase                 |
//+------------------------------------------------------------------+

/*!
   \brief     CFormBase      
            .
   \details       
              CFormTemplate: public CFormBase   , ..
                  , :
  
               CForm1: public CFormBase;
               
               ,       MainProperties().
            
             , :
            
               CForm1 frm;
         
               :      
            
               01.     .    public  .
         
               02.       .
         
               03.     Init()   .    OnInitEvent(). 
                              m_Name. 
         
               04.     OnInitEvent(),  ,     (,  ).
         
               05.     OnInitEvent(),  ,     .
         
               06.     Show(x,y)   .    OnShowEvent(). 
                       X  Y       m_SpaceLeft  m_SpaceTop.
         
               07.     Hide()   .    OnHideEvent().
         
               08.     SetSubWindow()   .    OnWindowChangeEvent().
         
               09.     Event()   .    EventsHandler(). 
         
               10.     EventsHandler()            .
         
               11.     OnApplyEvent(),  ,      .
         
               12.     OnApplyEvent(),  ,      (,  ).
         
               13.       OnCancelEvent(),  .
   
   \remark  -      .
*/

class CFormTemplate: public CFormBase{
   public:
      // 1.      
      
   protected: 
      // 2.       
         void MainProperties(){
            //   
            m_Name         =  "Form";        //  .          .
            m_Width        =  200;           //  
            m_Height       =  150;           //  
            m_Type         =  1;             //  : 0 -  , 1 -   "Apply"  "Cancel", 2 -   "Close"
            m_Caption      =  "FormCaption"; //  
            m_Movable      =  true;          //   (       )
            m_Resizable    =  true;          //  /  (       )
            m_CloseButton  =  true;          //    (       )
         }
         void OnInitEvent(){
            // 3.   Init()   
            // 4.  ,     
            // 5.   , ,    .

         }   
         void OnShowEvent(int aLeft, int aTop){
            // 6.   Show(x,y)     
      
         }
         void OnHideEvent(){
            // 7.   Hide()     

         }
         void OnWindowChangeEvent(int aSubWindow){
            // 8.   SetSubWindow()     .      aSubWindow.

         }
         void EventsHandler(const int id,const long& lparam,const double& dparam,const string& sparam){
            // 9.   Event()   . 
            // 10.      

         }
         bool OnApplyEvent(){
            // 11.        "Apply".    ,      false.
            // 12.  .
            
            return(true);
         }
         bool OnCancelEvent(){
            // 13.     "Cancel"  "Close".    ,      false.
            
            return(true);
         }
};